/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pepsoft.util.ProgressReceiver;

public class StreamUtils {
    private static final int BUFFER_SIZE = 32768;
    private static final ThreadLocal<byte[]> BUFFERS = ThreadLocal.withInitial(() -> new byte[32768]);

    private StreamUtils() {
    }

    public static byte[] load(InputStream in) throws IOException {
        try {
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] buffer = BUFFERS.get();
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                in.close();
                byArray = out.toByteArray();
            }
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException | Error | RuntimeException e) {
                System.err.println("StreamUtils.load(InputStream): secondary I/O error while closing input stream");
                e.printStackTrace();
            }
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            StreamUtils.copy(in, out, null, -1L);
        }
        catch (ProgressReceiver.OperationCancelled e) {
            throw new InternalError(e);
        }
    }

    public static void copy(InputStream in, OutputStream out, int maximumBytes) throws IOException {
        try {
            StreamUtils.copy(in, out, null, maximumBytes);
        }
        catch (ProgressReceiver.OperationCancelled e) {
            throw new InternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out, ProgressReceiver progressReceiver, long byteCount) throws IOException, ProgressReceiver.OperationCancelled {
        try {
            try {
                int bytesRead;
                byte[] buffer = BUFFERS.get();
                long bytesReadTotal = 0L;
                while ((bytesRead = in.read(buffer)) != -1) {
                    if (byteCount > 0L && bytesReadTotal + (long)bytesRead > byteCount) {
                        throw new IOException("Too many bytes in input stream (limit: " + byteCount + "; bytes read so far: " + (bytesReadTotal + (long)bytesRead) + ")");
                    }
                    out.write(buffer, 0, bytesRead);
                    bytesReadTotal += (long)bytesRead;
                    if (progressReceiver == null || byteCount <= 0L) continue;
                    progressReceiver.setProgress((float)bytesReadTotal / (float)byteCount);
                }
                in.close();
                out.close();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException | Error | RuntimeException e) {
                    System.err.println("StreamUtils.copy(InputStream, OutputStream, ProgressReceiver, long): secondary I/O error while closing input stream");
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException | Error | RuntimeException e) {
                System.err.println("StreamUtils.copy(InputStream, OutputStream, ProgressReceiver, long): secondary I/O error while closing output stream");
                e.printStackTrace();
            }
        }
    }
}

