/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.util.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File selectFileForOpen(Window parent, String title, File fileOrDir, FileFilter fileFilter) {
        Boolean old = UIManager.getBoolean("FileChooser.readOnly");
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        try {
            JFileChooser fileChooser;
            if (SystemUtils.isMac()) {
                File file = FileUtils.selectFileForOpenFallback(parent, title, fileOrDir, fileFilter);
                return file;
            }
            if (fileOrDir != null) {
                if (fileOrDir.isDirectory()) {
                    fileChooser = new JFileChooser(fileOrDir);
                } else {
                    fileChooser = new JFileChooser(fileOrDir.getParentFile());
                    fileChooser.setSelectedFile(fileOrDir);
                }
            } else {
                fileChooser = new JFileChooser();
            }
            fileChooser.setDialogTitle(title);
            fileChooser.setFileFilter(fileFilter);
            fileChooser.setFileSelectionMode(0);
            if (ExceptionHandler.doWithoutExceptionReporting(() -> fileChooser.showOpenDialog(parent)) == 0) {
                File file = fileChooser.getSelectedFile();
                return file;
            }
            File file = null;
            return file;
        }
        finally {
            UIManager.put("FileChooser.readOnly", old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File selectDirectoryForOpen(Window parent, String title, File dir, final String description, FileView fileView) {
        Boolean old = UIManager.getBoolean("FileChooser.readOnly");
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        try {
            JFileChooser fileChooser = dir != null ? new JFileChooser(dir) : new JFileChooser();
            fileChooser.setDialogTitle(title);
            fileChooser.setFileFilter(new javax.swing.filechooser.FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return description;
                }
            });
            fileChooser.setFileSelectionMode(2);
            if (fileView != null) {
                fileChooser.setFileView(fileView);
            }
            if (ExceptionHandler.doWithoutExceptionReporting(() -> fileChooser.showOpenDialog(parent)) == 0) {
                File file = fileChooser.getSelectedFile();
                return file;
            }
            File file = null;
            return file;
        }
        finally {
            UIManager.put("FileChooser.readOnly", old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] selectFilesForOpen(Window parent, String title, File fileOrDir, FileFilter fileFilter) {
        Boolean old = UIManager.getBoolean("FileChooser.readOnly");
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        try {
            JFileChooser fileChooser;
            if (SystemUtils.isMac()) {
                File[] fileArray = FileUtils.selectFilesForOpenFallback(parent, title, fileOrDir, fileFilter);
                return fileArray;
            }
            if (fileOrDir != null) {
                if (fileOrDir.isDirectory()) {
                    fileChooser = new JFileChooser(fileOrDir);
                } else {
                    fileChooser = new JFileChooser(fileOrDir.getParentFile());
                    fileChooser.setSelectedFile(fileOrDir);
                }
            } else {
                fileChooser = new JFileChooser();
            }
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle(title);
            fileChooser.setFileFilter(fileFilter);
            fileChooser.setFileSelectionMode(0);
            if (ExceptionHandler.doWithoutExceptionReporting(() -> fileChooser.showOpenDialog(parent)) == 0) {
                File[] fileArray = fileChooser.getSelectedFiles();
                return fileArray;
            }
            File[] fileArray = null;
            return fileArray;
        }
        finally {
            UIManager.put("FileChooser.readOnly", old);
        }
    }

    public static File selectFileForSave(Window parent, String title, File fileOrDir, FileFilter fileFilter) {
        if (SystemUtils.isMac()) {
            return FileUtils.selectFileForSaveFallback(parent, title, fileOrDir, fileFilter);
        }
        try {
            JFileChooser fileChooser;
            if (fileOrDir != null) {
                if (fileOrDir.isDirectory()) {
                    fileChooser = new JFileChooser(fileOrDir);
                } else {
                    fileChooser = new JFileChooser(fileOrDir.getParentFile());
                    fileChooser.setSelectedFile(fileOrDir);
                }
            } else {
                fileChooser = new JFileChooser();
            }
            fileChooser.setDialogTitle(title);
            fileChooser.setFileFilter(fileFilter);
            fileChooser.setFileSelectionMode(0);
            if (ExceptionHandler.doWithoutExceptionReporting(() -> fileChooser.showSaveDialog(parent)) == 0) {
                return fileChooser.getSelectedFile();
            }
            return null;
        }
        catch (RuntimeException e) {
            logger.error("{} while using JFileChooser; falling back to FileDialog (message: \"{}\")", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
            return FileUtils.selectFileForSaveFallback(parent, title, fileOrDir, fileFilter);
        }
    }

    private static File selectFileForOpenFallback(Window parent, String title, File fileOrDir, FileFilter fileFilter) {
        FileDialog fileDialog = parent instanceof Frame ? new FileDialog((Frame)parent, title, 0) : new FileDialog((Dialog)parent, title, 0);
        boolean fileSet = false;
        if (fileOrDir != null) {
            if (fileOrDir.isDirectory()) {
                fileDialog.setDirectory(fileOrDir.getPath());
            } else {
                fileDialog.setDirectory(fileOrDir.getParent());
                fileDialog.setFile(fileOrDir.getName());
                fileSet = true;
            }
        }
        if (fileFilter != null) {
            if (SystemUtils.isWindows() && !fileSet) {
                fileDialog.setFile(fileFilter.getExtensions());
            } else {
                fileDialog.setFilenameFilter((file, s) -> fileFilter.accept(new File(file, s)));
            }
        }
        fileDialog.setVisible(true);
        File[] files = fileDialog.getFiles();
        if (files.length == 1) {
            return files[0];
        }
        return null;
    }

    private static File[] selectFilesForOpenFallback(Window parent, String title, File fileOrDir, FileFilter fileFilter) {
        FileDialog fileDialog = parent instanceof Frame ? new FileDialog((Frame)parent, title, 0) : new FileDialog((Dialog)parent, title, 0);
        fileDialog.setMultipleMode(true);
        boolean fileSet = false;
        if (fileOrDir != null) {
            if (fileOrDir.isDirectory()) {
                fileDialog.setDirectory(fileOrDir.getPath());
            } else {
                fileDialog.setDirectory(fileOrDir.getParent());
                fileDialog.setFile(fileOrDir.getName());
                fileSet = true;
            }
        }
        if (SystemUtils.isWindows() && !fileSet) {
            fileDialog.setFile(fileFilter.getExtensions());
        } else {
            fileDialog.setFilenameFilter((file, s) -> fileFilter.accept(new File(file, s)));
        }
        fileDialog.setVisible(true);
        File[] files = fileDialog.getFiles();
        if (files.length > 0) {
            return files;
        }
        return null;
    }

    private static File selectFileForSaveFallback(Window parent, String title, File fileOrDir, FileFilter fileFilter) {
        FileDialog fileDialog = parent instanceof Frame ? new FileDialog((Frame)parent, title, 1) : new FileDialog((Dialog)parent, title, 1);
        boolean fileSet = false;
        if (fileOrDir != null) {
            if (fileOrDir.isDirectory()) {
                fileDialog.setDirectory(fileOrDir.getPath());
            } else {
                fileDialog.setDirectory(fileOrDir.getParent());
                fileDialog.setFile(fileOrDir.getName());
                fileSet = true;
            }
        }
        if (SystemUtils.isWindows() && !fileSet) {
            fileDialog.setFile(fileFilter.getExtensions());
        } else {
            fileDialog.setFilenameFilter((file, s) -> fileFilter.accept(new File(file, s)));
        }
        fileDialog.setVisible(true);
        File[] files = fileDialog.getFiles();
        if (files.length == 1) {
            return files[0];
        }
        return null;
    }
}

