/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.pepsoft.worldpainter.EventLogger;
import org.pepsoft.worldpainter.vo.EventVO;

public abstract class BetterAction
extends org.pepsoft.util.swing.BetterAction {
    private final String statisticsKey;
    private final boolean logEvent;
    private static final Map<String, Long> actionCounts = new HashMap<String, Long>();

    public BetterAction(@NonNls String id, String name, Icon icon) {
        this(id, name, icon, true);
    }

    public BetterAction(@NonNls String id, String name) {
        this(id, name, true);
    }

    public BetterAction(@NonNls String id, String name, Icon icon, boolean logEvent) {
        super(name, icon);
        this.statisticsKey = BetterAction.createStatisticsKey(id);
        this.logEvent = logEvent;
        this.putValue("org.pepsoft.worldpainter.helpKey", "Action/" + id);
    }

    public BetterAction(String id, String name, boolean logEvent) {
        super(name);
        this.statisticsKey = BetterAction.createStatisticsKey(id);
        this.logEvent = logEvent;
        this.putValue("org.pepsoft.worldpainter.helpKey", "Action/" + id);
    }

    public final String getStatisticsKey() {
        return this.statisticsKey;
    }

    public final boolean isLogEvent() {
        return this.logEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void actionPerformed(ActionEvent e) {
        this.performAction(e);
        if (this.logEvent) {
            Map<String, Long> map = actionCounts;
            synchronized (map) {
                if (actionCounts.containsKey(this.statisticsKey)) {
                    actionCounts.put(this.statisticsKey, actionCounts.get(this.statisticsKey) + 1L);
                } else {
                    actionCounts.put(this.statisticsKey, 1L);
                }
            }
        }
    }

    protected abstract void performAction(ActionEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushEvents(EventLogger eventLogger) {
        Map<String, Long> map = actionCounts;
        synchronized (map) {
            for (Map.Entry<String, Long> entry : actionCounts.entrySet()) {
                eventLogger.logEvent(new EventVO(entry.getKey()).count(entry.getValue().longValue()));
            }
            actionCounts.clear();
        }
    }

    private static String createStatisticsKey(String id) {
        return "action." + id.replaceAll("[ \\t\\n\\x0B\\f\\r.]", "");
    }
}

