/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;
import org.pepsoft.worldpainter.util.FileFilter;
import org.pepsoft.worldpainter.vo.EventVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner
extends WorldPainterDialog {
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JLabel labelName;
    private JPanel panelDescriptor;
    private final World2 world;
    private final Dimension dimension;
    private final ArrayList<File> recentScriptFiles;
    private final Collection<UndoManager> undoManagers;
    private ScriptDescriptor scriptDescriptor;
    private static final ScriptEngineManager SCRIPT_ENGINE_MANAGER = new ScriptEngineManager();
    private static final Pattern DESCRIPTOR_PATTERN = Pattern.compile("script\\.([.a-zA-Z_0-9]+)=(.+)$");
    private static final Map<String, ScriptEngine> SCRIPT_ENGINES = new HashMap<String, ScriptEngine>();
    private static final Map<String, CompiledScript> COMPILED_SCRIPTS = new HashMap<String, CompiledScript>();
    private static final Logger logger = LoggerFactory.getLogger(ScriptRunner.class);

    public ScriptRunner(Window parent, World2 world, Dimension dimension, Collection<UndoManager> undoManagers) {
        super(parent);
        this.world = world;
        this.dimension = dimension;
        this.undoManagers = undoManagers;
        this.initComponents();
        Configuration config = Configuration.getInstance();
        this.recentScriptFiles = config.getRecentScriptFiles() != null ? new ArrayList(config.getRecentScriptFiles()) : new ArrayList();
        this.recentScriptFiles.removeIf(file -> !file.isFile());
        this.jComboBox1.setModel(new DefaultComboBoxModel<File>(this.recentScriptFiles.toArray(new File[this.recentScriptFiles.size()])));
        if (this.jComboBox1.getSelectedItem() != null && ((File)this.jComboBox1.getSelectedItem()).isFile()) {
            this.setupScript((File)this.jComboBox1.getSelectedItem());
        }
        this.setControlStates();
        this.getRootPane().setDefaultButton(this.jButton2);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void setControlStates() {
        this.jButton2.setEnabled(this.jComboBox1.getSelectedItem() != null && ((File)this.jComboBox1.getSelectedItem()).isFile() && (this.scriptDescriptor == null || this.scriptDescriptor.isValid()));
    }

    private void selectFile() {
        final HashSet extensions = new HashSet();
        SCRIPT_ENGINE_MANAGER.getEngineFactories().forEach(factory -> extensions.addAll(factory.getExtensions()));
        File script = org.pepsoft.worldpainter.util.FileUtils.selectFileForOpen(this, "Select Script", (File)this.jComboBox1.getSelectedItem(), new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int p = name.lastIndexOf(46);
                if (p >= 0) {
                    return extensions.contains(name.substring(p + 1));
                }
                return false;
            }

            @Override
            public String getDescription() {
                StringBuilder sb = new StringBuilder();
                sb.append("Script files (");
                sb.append(extensions.stream().map(extension -> "*." + extension).collect(Collectors.joining(", ")));
                sb.append(')');
                return sb.toString();
            }

            @Override
            public String getExtensions() {
                return String.join((CharSequence)";", extensions);
            }
        });
        if (script != null && script.isFile()) {
            this.recentScriptFiles.remove(script);
            this.recentScriptFiles.add(0, script);
            this.jComboBox1.setModel(new DefaultComboBoxModel<File>(this.recentScriptFiles.toArray(new File[this.recentScriptFiles.size()])));
            this.jComboBox1.setSelectedItem(script);
            this.setupScript(script);
            this.setControlStates();
        }
    }

    private void setupScript(File script) {
        this.scriptDescriptor = this.analyseScript(script);
        while (this.panelDescriptor.getComponentCount() > 2) {
            this.panelDescriptor.remove(2);
        }
        if (this.scriptDescriptor != null) {
            if (this.scriptDescriptor.name != null) {
                this.labelName.setText(this.scriptDescriptor.name);
            } else {
                this.labelName.setText(script.getName());
            }
            if (this.scriptDescriptor.description != null) {
                this.addRegular(this.panelDescriptor, new JLabel("Description:"));
                JTextArea textArea = new JTextArea(this.scriptDescriptor.description);
                textArea.setEditable(false);
                textArea.setOpaque(false);
                this.addlastOnLine(this.panelDescriptor, textArea);
            }
            boolean allFieldsOptional = true;
            for (ParameterDescriptor paramDescriptor : this.scriptDescriptor.parameterDescriptors) {
                boolean showAsMandatory = !paramDescriptor.optional && (paramDescriptor instanceof FileParameterDescriptor || paramDescriptor instanceof FloatParameterDescriptor || paramDescriptor instanceof StringParameterDescriptor);
                JLabel label = new JLabel((paramDescriptor.displayName != null ? paramDescriptor.displayName : paramDescriptor.name) + (showAsMandatory ? "*:" : ":"));
                allFieldsOptional &= !showAsMandatory;
                Object editor = paramDescriptor.getEditor();
                label.setLabelFor((Component)editor);
                if (paramDescriptor.description != null) {
                    label.setToolTipText(paramDescriptor.description);
                }
                this.addRegular(this.panelDescriptor, label);
                if (paramDescriptor.description != null) {
                    ((JComponent)editor).setToolTipText(paramDescriptor.description);
                }
                this.addlastOnLine(this.panelDescriptor, (JComponent)editor);
                paramDescriptor.setChangeListener(e -> this.setControlStates());
            }
            if (!allFieldsOptional) {
                this.addlastOnLine(this.panelDescriptor, new JLabel("* mandatory parameter"));
            }
            this.jLabel2.setVisible(!this.scriptDescriptor.hideCmdLineParams);
            this.jLabel3.setVisible(!this.scriptDescriptor.hideCmdLineParams);
            this.jScrollPane1.setVisible(!this.scriptDescriptor.hideCmdLineParams);
        } else {
            this.labelName.setText(script.getName());
            this.jLabel2.setVisible(true);
            this.jLabel3.setVisible(true);
            this.jScrollPane1.setVisible(true);
        }
        this.pack();
    }

    private void addRegular(JPanel panel, JComponent component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 512;
        constraints.insets = new Insets(3, 0, 3, 3);
        panel.add((Component)component, constraints);
    }

    private void addlastOnLine(JPanel panel, JComponent component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 512;
        constraints.insets = new Insets(3, 3, 3, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        panel.add((Component)component, constraints);
    }

    private ScriptDescriptor analyseScript(File script) {
        if (!script.isFile()) {
            return null;
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        try (BufferedReader in = new BufferedReader(new FileReader(script));){
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith("#") || line.startsWith("//")) {
                    Matcher matcher;
                    if (line.startsWith("#") && line.substring(1).trim().startsWith("--") || line.startsWith("//") && line.substring(2).trim().startsWith("--") || !(matcher = DESCRIPTOR_PATTERN.matcher(line)).find()) continue;
                    properties.put(matcher.group(1), matcher.group(2));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error reading script " + script, e);
        }
        if (properties.isEmpty()) {
            return null;
        }
        ScriptDescriptor descriptor = new ScriptDescriptor();
        LinkedHashMap paramMap = new LinkedHashMap();
        properties.forEach((key, value) -> {
            if (key.equals("name")) {
                descriptor.name = value.trim();
            } else if (key.equals("description")) {
                descriptor.description = value.trim().replace("\\n", "\n");
            } else if (key.startsWith("param.")) {
                String[] parts = key.split("\\.");
                if (parts.length != 3) {
                    throw new IllegalArgumentException("Invalid key \"" + key + "\" in script descriptor");
                }
                ParameterDescriptor paramDescriptor = (ParameterDescriptor)paramMap.get(parts[1]);
                switch (parts[2]) {
                    case "type": {
                        if (paramDescriptor == null) {
                            switch (value.toLowerCase().trim()) {
                                case "string": {
                                    paramDescriptor = new StringParameterDescriptor();
                                    break;
                                }
                                case "integer": {
                                    paramDescriptor = new IntegerParameterDescriptor();
                                    break;
                                }
                                case "percentage": {
                                    paramDescriptor = new PercentageParameterDescriptor();
                                    break;
                                }
                                case "float": {
                                    paramDescriptor = new FloatParameterDescriptor();
                                    break;
                                }
                                case "file": {
                                    paramDescriptor = new FileParameterDescriptor();
                                    break;
                                }
                                case "boolean": {
                                    paramDescriptor = new BooleanParameterDescriptor();
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Invalid type \"" + value + "\" specified for parameter " + parts[1]);
                                }
                            }
                            paramDescriptor.name = parts[1];
                            paramMap.put(parts[1], paramDescriptor);
                            descriptor.parameterDescriptors.add(paramDescriptor);
                            break;
                        }
                        throw new IllegalArgumentException("Type specified more than once for parameter " + parts[1]);
                    }
                    case "description": {
                        paramDescriptor.description = value.replace("\\n", "\n");
                        break;
                    }
                    case "optional": {
                        paramDescriptor.optional = value.trim().isEmpty() || Boolean.parseBoolean(value.toLowerCase().trim());
                        break;
                    }
                    case "default": {
                        paramDescriptor.defaultValue = paramDescriptor.toObject(value.trim());
                        break;
                    }
                    case "displayName": {
                        paramDescriptor.displayName = value.trim();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid key \"" + key + "\" in script descriptor");
                    }
                }
            } else if (key.equals("hideCmdLineParams")) {
                descriptor.hideCmdLineParams = "true".equalsIgnoreCase(value.trim());
            } else {
                throw new IllegalArgumentException("Invalid key \"" + key + "\" in script descriptor");
            }
        });
        return descriptor;
    }

    private void run() {
        String scriptName;
        Map<String, Object> params;
        this.jComboBox1.setEnabled(false);
        this.jButton1.setEnabled(false);
        this.jTextArea1.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.jButton3.setEnabled(false);
        this.jTextArea2.setText(null);
        final File scriptFile = (File)this.jComboBox1.getSelectedItem();
        final String scriptFilePath = scriptFile.getParentFile().getAbsolutePath();
        final String scriptFileName = scriptFile.getName();
        if (this.scriptDescriptor != null) {
            params = this.scriptDescriptor.getValues();
            scriptName = this.scriptDescriptor.name != null ? this.scriptDescriptor.name : scriptFileName;
        } else {
            params = null;
            scriptName = scriptFileName;
        }
        new Thread(scriptFileName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block31: {
                    try {
                        ScriptEngine scriptEngine;
                        Configuration config;
                        block33: {
                            config = Configuration.getInstance();
                            int p = scriptFileName.lastIndexOf(46);
                            String extension = scriptFileName.substring(p + 1);
                            Map map = SCRIPT_ENGINES;
                            synchronized (map) {
                                block30: {
                                    block32: {
                                        if (!SCRIPT_ENGINES.containsKey(extension)) break block32;
                                        scriptEngine = (ScriptEngine)SCRIPT_ENGINES.get(extension);
                                        break block33;
                                    }
                                    scriptEngine = SCRIPT_ENGINE_MANAGER.getEngineByExtension(extension);
                                    if (scriptEngine != null) break block30;
                                    logger.error("No script engine found for extension \"" + extension + "\"");
                                    AwtUtils.doLaterOnEventThread(() -> MessageUtils.beepAndShowError((Component)ScriptRunner.this, (String)("No script engine installed for extension \"" + extension + "\""), (String)"Error"));
                                    return;
                                }
                                SCRIPT_ENGINES.put(extension, scriptEngine);
                                logger.info("Using script engine {} version {} for scripts of type {}", new Object[]{scriptEngine.getFactory().getEngineName(), scriptEngine.getFactory().getEngineVersion(), extension});
                            }
                        }
                        scriptEngine.put("javax.script.filename", scriptFileName);
                        config.setRecentScriptFiles(new ArrayList(ScriptRunner.this.recentScriptFiles));
                        Bindings bindings = scriptEngine.getBindings(100);
                        ScriptingContext context = new ScriptingContext(false);
                        bindings.put("wp", (Object)context);
                        String[] parameters = ScriptRunner.this.jTextArea1.getText().isEmpty() ? new String[]{} : ScriptRunner.this.jTextArea1.getText().split("\\R");
                        bindings.put("argc", (Object)(parameters.length + 1));
                        String[] argv = new String[parameters.length + 1];
                        argv[0] = scriptFileName;
                        System.arraycopy(parameters, 0, argv, 1, parameters.length);
                        bindings.put("argv", (Object)argv);
                        bindings.put("arguments", (Object)parameters);
                        if (params != null) {
                            bindings.put("params", (Object)params);
                        }
                        if (ScriptRunner.this.world != null) {
                            bindings.put("world", (Object)ScriptRunner.this.world);
                        }
                        if (ScriptRunner.this.dimension != null) {
                            bindings.put("dimension", (Object)ScriptRunner.this.dimension);
                        }
                        HashMap<String, Layer.DataSize> dataSizes = new HashMap<String, Layer.DataSize>();
                        for (Layer.DataSize dataSize : Layer.DataSize.values()) {
                            dataSizes.put(dataSize.name(), dataSize);
                        }
                        bindings.put("DataSize", (Object)dataSizes);
                        bindings.put("scriptDir", (Object)scriptFilePath);
                        final LinkedList textQueue = new LinkedList();
                        final boolean[] textUpdateScheduled = new boolean[]{false};
                        Writer writer = new Writer(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void write(char @NotNull [] cbuf, int off, int len) {
                                List list = textQueue;
                                synchronized (list) {
                                    textQueue.add(new String(cbuf, off, len));
                                    if (!textUpdateScheduled[0]) {
                                        AwtUtils.doLaterOnEventThread(() -> {
                                            List list = textQueue;
                                            synchronized (list) {
                                                ScriptRunner.this.jTextArea2.append(String.join((CharSequence)"", textQueue));
                                                textQueue.clear();
                                                textUpdateScheduled2[0] = false;
                                            }
                                        });
                                        textUpdateScheduled[0] = true;
                                    }
                                }
                            }

                            @Override
                            public void flush() {
                            }

                            @Override
                            public void close() {
                            }
                        };
                        scriptEngine.getContext().setWriter(writer);
                        scriptEngine.getContext().setErrorWriter(writer);
                        config.logEvent(new EventVO("script.execute").addTimestamp().setAttribute(Constants.ATTRIBUTE_KEY_SCRIPT_NAME, (Serializable)((Object)scriptName)).setAttribute(Constants.ATTRIBUTE_KEY_SCRIPT_FILENAME, (Serializable)((Object)scriptFileName)));
                        logger.info("Executing script {} from file {}", (Object)scriptName, (Object)scriptFileName);
                        if (ScriptRunner.this.dimension != null) {
                            ScriptRunner.this.dimension.setEventsInhibited(true);
                        }
                        try {
                            long start;
                            String script = FileUtils.load((File)scriptFile, (Charset)Charset.defaultCharset());
                            if (scriptEngine instanceof Compilable) {
                                CompiledScript compiledScript;
                                if (COMPILED_SCRIPTS.containsKey(script)) {
                                    compiledScript = (CompiledScript)COMPILED_SCRIPTS.get(script);
                                } else {
                                    logger.info("Compiling script {}", (Object)scriptName);
                                    compiledScript = ((Compilable)((Object)scriptEngine)).compile(new FileReader(scriptFile));
                                    COMPILED_SCRIPTS.put(script, compiledScript);
                                }
                                start = System.currentTimeMillis();
                                compiledScript.eval();
                            } else {
                                start = System.currentTimeMillis();
                                scriptEngine.eval(script);
                            }
                            logger.debug("Running script {} took {} ms", (Object)scriptName, (Object)(System.currentTimeMillis() - start));
                            context.checkGoCalled(null);
                        }
                        catch (RuntimeException e) {
                            logger.error(e.getClass().getSimpleName() + " occurred while executing " + scriptFileName, (Throwable)e);
                            AwtUtils.doLaterOnEventThread(() -> MessageUtils.beepAndShowError((Component)ScriptRunner.this, (String)(e.getClass().getSimpleName() + " occurred (message: " + e.getMessage() + ")"), (String)"Error"));
                        }
                        catch (ScriptException e) {
                            logger.error("ScriptException occurred while executing " + scriptFileName, (Throwable)e);
                            StringBuilder sb = new StringBuilder();
                            sb.append(e.getMessage());
                            if (e.getLineNumber() != -1) {
                                sb.append(" (");
                                sb.append(e.getLineNumber());
                                if (e.getColumnNumber() != -1) {
                                    sb.append(':');
                                    sb.append(e.getColumnNumber());
                                }
                                sb.append(')');
                            }
                            AwtUtils.doLaterOnEventThread(() -> MessageUtils.beepAndShowError((Component)ScriptRunner.this, (String)sb.toString(), (String)"Error"));
                        }
                        catch (IOException e2) {
                            logger.error("I/O error occurred while executing " + scriptFileName, (Throwable)e2);
                            AwtUtils.doLaterOnEventThread(() -> MessageUtils.beepAndShowError((Component)ScriptRunner.this, (String)("I/O error while executing " + scriptFileName), (String)"Error"));
                            break block31;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            if (ScriptRunner.this.dimension != null) {
                                ScriptRunner.this.dimension.setEventsInhibited(false);
                            }
                            if (ScriptRunner.this.undoManagers != null) {
                                ScriptRunner.this.undoManagers.forEach(UndoManager::armSavePoint);
                            }
                        }
                    }
                    finally {
                        AwtUtils.doLaterOnEventThread(() -> {
                            ScriptRunner.this.jComboBox1.setEnabled(true);
                            ScriptRunner.this.jButton1.setEnabled(true);
                            ScriptRunner.this.jTextArea1.setEnabled(true);
                            ScriptRunner.this.jButton2.setEnabled(true);
                            ScriptRunner.this.jButton3.setText("Close");
                            ScriptRunner.this.jButton3.setEnabled(true);
                        });
                    }
                }
            }
        }.start();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButton2 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jButton3 = new JButton();
        this.panelDescriptor = new JPanel();
        this.jLabel5 = new JLabel();
        this.labelName = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Run Script");
        this.jLabel1.setText("Script:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptRunner.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptRunner.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Parameters:");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jLabel3.setText("(one per line)");
        this.jLabel4.setText("Output:");
        this.jButton2.setText("Run");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptRunner.this.jButton2ActionPerformed(evt);
            }
        });
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setRows(5);
        this.jTextArea2.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.jTextArea2);
        this.jButton3.setText("Cancel");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptRunner.this.jButton3ActionPerformed(evt);
            }
        });
        this.panelDescriptor.setLayout(new GridBagLayout());
        this.jLabel5.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 1, 0, 2);
        this.panelDescriptor.add((Component)this.jLabel5, gridBagConstraints);
        this.labelName.setText("jLabel6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.panelDescriptor.add((Component)this.labelName, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 598, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.panelDescriptor, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jButton1)).addGap(18, 18, 18).addComponent(this.panelDescriptor, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)).addComponent(this.jScrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 243, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton3)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.selectFile();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.run();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.setupScript((File)this.jComboBox1.getSelectedItem());
        this.setControlStates();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    static class BooleanParameterDescriptor
    extends ParameterDescriptor<Boolean, JCheckBox> {
        BooleanParameterDescriptor() {
        }

        @Override
        protected JCheckBox createEditor() {
            JCheckBox checkBox = new JCheckBox(" ");
            checkBox.addChangeListener(e -> this.notifyChangeListener());
            return checkBox;
        }

        @Override
        Boolean toObject(String str) {
            return Boolean.valueOf(str);
        }

        @Override
        Boolean getValue() {
            return ((JCheckBox)this.editor).isSelected();
        }

        @Override
        void setValue(Boolean value) {
            ((JCheckBox)this.editor).setSelected(value);
        }
    }

    static class FileParameterDescriptor
    extends ParameterDescriptor<File, JPanel> {
        FileParameterDescriptor() {
        }

        @Override
        protected JPanel createEditor() {
            JPanel panel = new JPanel(new GridBagLayout()){

                @Override
                public int getBaseline(int width, int height) {
                    return this.getComponent(0).getBaseline(width, height);
                }
            };
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.fill = 2;
            JTextField field = new JTextField();
            field.setToolTipText(this.description);
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }
            });
            panel.add((Component)field, constraints);
            constraints.weightx = 0.0;
            constraints.gridwidth = 0;
            constraints.insets = new Insets(0, 3, 0, 0);
            JButton button = new JButton("...");
            button.setToolTipText(this.description);
            button.addActionListener(e -> {
                JFileChooser fileChooser = new JFileChooser();
                if (!field.getText().trim().isEmpty()) {
                    fileChooser.setSelectedFile(new File(field.getText().trim()));
                }
                if (ExceptionHandler.doWithoutExceptionReporting(() -> fileChooser.showOpenDialog(panel)) == 0) {
                    field.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            });
            panel.add((Component)button, constraints);
            return panel;
        }

        @Override
        File toObject(String str) {
            return new File(str);
        }

        @Override
        boolean isEditorValid() {
            if (this.optional) {
                return true;
            }
            String text = ((JTextField)((JPanel)this.editor).getComponent(0)).getText();
            return !text.trim().isEmpty() && new File(text.trim()).isFile();
        }

        @Override
        File getValue() {
            String text = ((JTextField)((JPanel)this.editor).getComponent(0)).getText();
            return text.trim().isEmpty() ? null : new File(text.trim());
        }

        @Override
        void setValue(File value) {
            ((JTextField)((JPanel)this.editor).getComponent(0)).setText(value.getAbsolutePath());
        }
    }

    static class FloatParameterDescriptor
    extends ParameterDescriptor<Float, JFormattedTextField> {
        FloatParameterDescriptor() {
        }

        @Override
        protected JFormattedTextField createEditor() {
            JFormattedTextField field = new JFormattedTextField(NumberFormat.getNumberInstance());
            field.setHorizontalAlignment(11);
            field.addPropertyChangeListener("value", e -> this.notifyChangeListener());
            return field;
        }

        @Override
        Float toObject(String str) {
            return Float.valueOf(str);
        }

        @Override
        boolean isEditorValid() {
            try {
                ((JFormattedTextField)this.editor).commitEdit();
                return this.optional || ((JFormattedTextField)this.editor).getValue() != null;
            }
            catch (ParseException e) {
                return this.optional;
            }
        }

        @Override
        Float getValue() {
            Number nr = (Number)((JFormattedTextField)this.editor).getValue();
            return nr != null ? Float.valueOf(nr.floatValue()) : null;
        }

        @Override
        void setValue(Float value) {
            ((JFormattedTextField)this.editor).setValue(value);
        }
    }

    static class PercentageParameterDescriptor
    extends ParameterDescriptor<Integer, JPanel> {
        PercentageParameterDescriptor() {
        }

        @Override
        protected JPanel createEditor() {
            JPanel panel = new JPanel(new GridBagLayout()){

                @Override
                public int getBaseline(int width, int height) {
                    return this.getComponent(0).getBaseline(width, height);
                }
            };
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.fill = 2;
            SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0, 0, 100, 1);
            JSpinner spinner = new JSpinner(spinnerModel);
            spinner.setToolTipText(this.description);
            spinner.addChangeListener(e -> this.notifyChangeListener());
            panel.add((Component)spinner, constraints);
            constraints.weightx = 0.0;
            constraints.gridwidth = 0;
            JLabel label = new JLabel("%");
            label.setToolTipText(this.description);
            panel.add((Component)label, constraints);
            return panel;
        }

        @Override
        Integer toObject(String str) {
            if (str.endsWith("%")) {
                return Integer.valueOf(str.substring(0, str.length() - 1).trim());
            }
            return Integer.valueOf(str.trim());
        }

        @Override
        Integer getValue() {
            return (Integer)((JSpinner)((JPanel)this.editor).getComponent(0)).getValue();
        }

        @Override
        void setValue(Integer value) {
            ((JSpinner)((JPanel)this.editor).getComponent(0)).setValue(value);
        }
    }

    static class IntegerParameterDescriptor
    extends ParameterDescriptor<Integer, JSpinner> {
        IntegerParameterDescriptor() {
        }

        @Override
        protected JSpinner createEditor() {
            JSpinner spinner = new JSpinner();
            spinner.addChangeListener(e -> this.notifyChangeListener());
            return spinner;
        }

        @Override
        Integer toObject(String str) {
            return Integer.valueOf(str);
        }

        @Override
        Integer getValue() {
            return (Integer)((JSpinner)this.editor).getValue();
        }

        @Override
        void setValue(Integer value) {
            ((JSpinner)this.editor).setValue(value);
        }
    }

    static class StringParameterDescriptor
    extends ParameterDescriptor<String, JTextField> {
        StringParameterDescriptor() {
        }

        @Override
        protected JTextField createEditor() {
            JTextField field = new JTextField((String)this.defaultValue);
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }
            });
            return field;
        }

        @Override
        String toObject(String str) {
            return str;
        }

        @Override
        boolean isEditorValid() {
            return this.optional || !((JTextField)this.editor).getText().trim().isEmpty();
        }

        @Override
        String getValue() {
            String text = ((JTextField)this.editor).getText();
            return text.trim().isEmpty() ? null : text.trim();
        }

        @Override
        void setValue(String value) {
            ((JTextField)this.editor).setText(value);
        }
    }

    static abstract class ParameterDescriptor<T, E extends JComponent> {
        String name;
        String description;
        String displayName;
        boolean optional;
        E editor;
        T defaultValue;
        private ChangeListener changeListener;

        ParameterDescriptor() {
        }

        E getEditor() {
            if (this.editor == null) {
                this.editor = this.createEditor();
            }
            if (this.defaultValue != null) {
                this.setValue(this.defaultValue);
            }
            return this.editor;
        }

        boolean isEditorValid() {
            return true;
        }

        abstract T getValue();

        abstract void setValue(T var1);

        abstract T toObject(String var1);

        ChangeListener getChangeListener() {
            return this.changeListener;
        }

        void setChangeListener(ChangeListener changeListener) {
            this.changeListener = changeListener;
        }

        protected abstract E createEditor();

        protected void notifyChangeListener() {
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    static class ScriptDescriptor {
        String name;
        String description;
        List<ParameterDescriptor> parameterDescriptors = new ArrayList<ParameterDescriptor>();
        boolean hideCmdLineParams;

        ScriptDescriptor() {
        }

        boolean isValid() {
            return this.parameterDescriptors.stream().allMatch(p -> p.isEditorValid());
        }

        Map<String, Object> getValues() {
            HashMap<String, Object> values = new HashMap<String, Object>();
            this.parameterDescriptors.forEach(p -> {
                Object value = p.getValue();
                if (value != null) {
                    values.put(p.name, value);
                }
            });
            return values;
        }
    }
}

