/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainter;

public class WorldMorph {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            WorldPainter view = new WorldPainter(WorldMorph.createNewWorld().getDimension(Dimension.Anchor.NORMAL_DETAIL), ColourScheme.DEFAULT, null);
            JFrame frame = new JFrame("WorldMorph");
            frame.getContentPane().add((Component)((Object)view), "Center");
            frame.setDefaultCloseOperation(3);
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            Timer timer = new Timer(2000, e -> view.setDimension(WorldMorph.createNewWorld().getDimension(Dimension.Anchor.NORMAL_DETAIL)));
            timer.start();
        });
    }

    private static World2 createNewWorld() {
        long seed = System.currentTimeMillis();
        HeightMapTileFactory tileFactory = TileFactoryFactory.createNoiseTileFactory((long)seed, (Terrain)Terrain.GRASS, (int)DefaultPlugin.JAVA_MCREGION.minZ, (int)DefaultPlugin.JAVA_MCREGION.standardMaxHeight, (int)16, (int)24, (boolean)false, (boolean)true, (float)20.0f, (double)1.0);
        World2 world = new World2(DefaultPlugin.JAVA_MCREGION, seed, (TileFactory)tileFactory);
        Dimension dim0 = world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                dim0.addTile(tileFactory.createTile(x, y));
            }
        }
        return world;
    }
}

