/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.swing.JFrame;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.swing.TiledImageViewer;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.WPTileProvider;
import org.pepsoft.worldpainter.layers.Biome;

public class TileFactoryPreviewer {
    public static void main(String[] args) {
        long seed = args.length > 0 ? Long.parseLong(args[0]) : new Random().nextLong();
        final HeightMapTileFactory tileFactory = TileFactoryFactory.createFancyTileFactory((long)seed, (Terrain)Terrain.GRASS, (int)0, (int)256, (int)58, (int)62, (boolean)false, (float)20.0f, (double)1.0);
        TileProvider tileProvider = new TileProvider(){
            private final Map<Point, Tile> cache = new HashMap<Point, Tile>();

            public Rectangle getExtent() {
                return null;
            }

            public boolean isTilePresent(int x, int y) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Tile getTile(int x, int y) {
                Point coords = new Point(x, y);
                Map<Point, Tile> map = this.cache;
                synchronized (map) {
                    Tile tile = this.cache.get(coords);
                    if (tile == null) {
                        tile = tileFactory.createTile(x, y);
                        this.cache.put(coords, tile);
                    }
                    return tile;
                }
            }
        };
        Terrain.setCustomMaterial((int)0, (MixedMaterial)new MixedMaterial("Dirt/Gravel", new MixedMaterial.Row[]{new MixedMaterial.Row(Material.DIRT, 750, 1.0f), new MixedMaterial.Row(Material.GRAVEL, 250, 1.0f)}, 1, null, 1.0f));
        Terrain.setCustomMaterial((int)1, (MixedMaterial)new MixedMaterial("Stone/Gravel", new MixedMaterial.Row[]{new MixedMaterial.Row(Material.STONE, 750, 1.0f), new MixedMaterial.Row(Material.GRAVEL, 250, 1.0f)}, 1, null, 1.0f));
        TiledImageViewer viewer = new TiledImageViewer();
        JFrame frame = new JFrame("TileFactory Previewer");
        viewer.setTileProvider((org.pepsoft.util.swing.TileProvider)new WPTileProvider(tileProvider, ColourScheme.DEFAULT, null, Collections.singleton(Biome.INSTANCE), true, 10, TileRenderer.LightOrigin.NORTHWEST, null));
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)viewer, "Center");
        frame.setSize(1000, 800);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

