/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.swing.ProgressDialog;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.NewWorldDialog;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_12LargeBiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_1BiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_3LargeBiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_7LargeBiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_8LargeBiomeScheme;
import org.pepsoft.worldpainter.tools.BiomesTileProvider;
import org.pepsoft.worldpainter.tools.BiomesViewer;
import org.pepsoft.worldpainter.tools.WPTileSelectionViewer;
import org.pepsoft.worldpainter.util.MinecraftUtil;

public class BiomesViewerFrame
extends JFrame {
    private final WPTileSelectionViewer imageViewer;
    private final SeedListener seedListener;
    private final JButton createWorldButton;
    private final JSpinner seedSpinner;
    private final JComboBox schemeChooser;
    private final ColourScheme colourScheme;
    private final boolean standAloneMode;
    private BiomeScheme biomeScheme;
    private static final long serialVersionUID = 1L;

    public BiomesViewerFrame(long seed, int preferredBiomeAlgorithm, ColourScheme colourScheme, SeedListener seedListener) throws HeadlessException {
        this(seed, null, preferredBiomeAlgorithm, colourScheme, seedListener);
    }

    public BiomesViewerFrame(long seed, Point marker, int preferredBiomeAlgorithm, ColourScheme colourScheme, SeedListener seedListener) throws HeadlessException {
        super("WorldPainter - Biomes Viewer");
        this.colourScheme = colourScheme;
        this.seedListener = seedListener;
        this.standAloneMode = App.getInstanceIfExists() == null;
        this.imageViewer = new BiomesViewer(this.standAloneMode, true);
        if (marker != null) {
            this.imageViewer.setMarkerCoords(marker);
            this.imageViewer.moveToMarker();
        }
        this.imageViewer.addMouseWheelListener(e -> {
            int rotation = e.getWheelRotation();
            int zoom = this.imageViewer.getZoom();
            zoom = rotation < 0 ? Math.min(zoom + -rotation, 0) : Math.max(zoom - rotation, -4);
            this.imageViewer.setZoom(zoom);
        });
        if (!this.standAloneMode) {
            Controller controller = new Controller();
            this.imageViewer.addMouseListener(controller);
            this.imageViewer.addMouseMotionListener(controller);
        }
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)((Object)this.imageViewer), "Center");
        JToolBar toolBar = new JToolBar();
        toolBar.add(new JLabel("Biome scheme:"));
        List availableAlgorithms = BiomeSchemeManager.getAvailableBiomeAlgorithms();
        this.schemeChooser = new JComboBox<Object>(availableAlgorithms.toArray());
        this.schemeChooser.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Integer) {
                    switch ((Integer)value) {
                        case 4: {
                            this.setText("Minecraft 1.1");
                            break;
                        }
                        case 5: {
                            this.setText("Minecraft 1.2 - 1.6 Default");
                            break;
                        }
                        case 8: {
                            this.setText("Minecraft 1.3 - 1.6 Large");
                            break;
                        }
                        case 9: {
                            this.setText("Minecraft 1.7 - 1.12 Default");
                            break;
                        }
                        case 10: {
                            this.setText("Minecraft 1.7 - 1.12 Large");
                        }
                    }
                }
                return this;
            }
        });
        this.seedSpinner = new JSpinner(new SpinnerNumberModel((Number)seed, Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE), (Number)1L));
        if (availableAlgorithms.contains(preferredBiomeAlgorithm)) {
            this.schemeChooser.setSelectedItem(preferredBiomeAlgorithm);
        } else {
            this.schemeChooser.setSelectedIndex(0);
        }
        BiomeScheme biomeScheme = BiomeSchemeManager.getNewBiomeScheme((int)((Integer)this.schemeChooser.getSelectedItem()));
        if (biomeScheme != null) {
            this.biomeScheme = biomeScheme;
            this.biomeScheme.setSeed(seed);
            this.imageViewer.setTileProvider(new BiomesTileProvider(this.biomeScheme, this.colourScheme, this.imageViewer.getZoom(), false));
        }
        this.schemeChooser.addItemListener(e -> {
            BiomeScheme biomeScheme1 = BiomeSchemeManager.getNewBiomeScheme((int)((Integer)this.schemeChooser.getSelectedItem()));
            if (biomeScheme1 != null) {
                this.biomeScheme = biomeScheme1;
                this.biomeScheme.setSeed(((Number)this.seedSpinner.getValue()).longValue());
                this.imageViewer.setTileProvider(new BiomesTileProvider(this.biomeScheme, this.colourScheme, this.imageViewer.getZoom(), false));
            }
        });
        toolBar.add(this.schemeChooser);
        toolBar.add(Box.createHorizontalStrut(5));
        toolBar.add(new JLabel("Seed:"));
        this.seedSpinner.setEditor(new JSpinner.NumberEditor(this.seedSpinner, "0"));
        this.seedSpinner.addChangeListener(e -> {
            if (this.biomeScheme != null) {
                this.biomeScheme.setSeed(((Number)this.seedSpinner.getValue()).longValue());
                this.imageViewer.setTileProvider(new BiomesTileProvider(this.biomeScheme, this.colourScheme, this.imageViewer.getZoom(), false));
            }
        });
        toolBar.add(this.seedSpinner);
        toolBar.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)toolBar, "North");
        toolBar = new JToolBar();
        JButton button = new JButton("-");
        button.addActionListener(e -> {
            int zoom = this.imageViewer.getZoom();
            zoom = Math.max(zoom - 1, -4);
            this.imageViewer.setZoom(zoom);
        });
        toolBar.add(button);
        button = new JButton("+");
        button.addActionListener(e -> {
            int zoom = this.imageViewer.getZoom();
            zoom = Math.min(zoom + 1, 0);
            this.imageViewer.setZoom(zoom);
        });
        toolBar.add(button);
        toolBar.add(Box.createHorizontalStrut(5));
        this.createWorldButton = new JButton("Create world");
        if (!this.standAloneMode) {
            this.createWorldButton.setToolTipText("Create a new WorldPainter world from the selected tiles");
            this.createWorldButton.addActionListener(e -> this.createWorld());
        }
        this.createWorldButton.setEnabled(false);
        toolBar.add(this.createWorldButton);
        toolBar.add(Box.createHorizontalStrut(5));
        button = new JButton("Reset");
        button.addActionListener(e -> {
            this.imageViewer.setZoom(-2);
            if (marker != null) {
                this.imageViewer.moveToMarker();
            } else {
                this.imageViewer.moveToOrigin();
            }
        });
        toolBar.add(button);
        if (seedListener != null) {
            toolBar.add(Box.createHorizontalStrut(5));
            button = new JButton("Copy seed to world");
            button.setToolTipText("Copy the current seed to the world currently being edited");
            button.addActionListener(e -> this.seedListener.setSeed(((Number)this.seedSpinner.getValue()).longValue(), this.schemeChooser.getSelectedIndex() == 1 || this.schemeChooser.getSelectedIndex() == 3 ? Generator.LARGE_BIOMES : Generator.DEFAULT));
            toolBar.add(button);
        }
        toolBar.add(Box.createHorizontalStrut(5));
        button = new JButton("Play here in Survival mode");
        button.setToolTipText("Create a Survival in Minecraft with this seed and at this location");
        button.addActionListener(event -> this.playHere(false));
        toolBar.add(button);
        toolBar.add(Box.createHorizontalStrut(5));
        button = new JButton("Play here in Creative mode");
        button.setToolTipText("Create a Creative in Minecraft with this seed and at this location");
        button.addActionListener(event -> this.playHere(true));
        toolBar.add(button);
        toolBar.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)toolBar, "South");
        GUIUtils.scaleToUI((Container)this);
        this.setSize(800, 600);
    }

    public void destroy() {
        this.imageViewer.removeAllTileProviders();
    }

    private void playHere(boolean creativeMode) {
        File savesDir;
        String name = JOptionPane.showInputDialog(this, "Type a name for the map:", "Map Name", 3);
        if (name == null || name.trim().length() == 0) {
            return;
        }
        name = name.trim();
        boolean minecraftDirUsed = false;
        File minecraftDir = MinecraftUtil.findMinecraftDir();
        if (minecraftDir != null) {
            savesDir = new File(minecraftDir, "saves");
            minecraftDirUsed = true;
        } else {
            savesDir = DesktopUtils.getDocumentsFolder();
        }
        File worldDir = new File(savesDir, name);
        int ordinal = 1;
        while (worldDir.isDirectory()) {
            worldDir = new File(savesDir, name + ordinal);
            ++ordinal;
        }
        if (!worldDir.mkdirs()) {
            throw new RuntimeException("Could not create " + worldDir);
        }
        BiomeScheme biomeScheme1 = this.biomeScheme;
        Platform platform = biomeScheme1 instanceof Minecraft1_1BiomeScheme ? DefaultPlugin.JAVA_MCREGION : DefaultPlugin.JAVA_ANVIL;
        JavaLevel level = JavaLevel.create((Platform)platform, (int)platform.minZ, (int)platform.standardMaxHeight);
        long seed = ((Number)this.seedSpinner.getValue()).longValue();
        if (!(biomeScheme1 instanceof Minecraft1_1BiomeScheme)) {
            Generator generatorType = biomeScheme1 instanceof Minecraft1_3LargeBiomeScheme || biomeScheme1 instanceof Minecraft1_7LargeBiomeScheme || biomeScheme1 instanceof Minecraft1_8LargeBiomeScheme || biomeScheme1 instanceof Minecraft1_12LargeBiomeScheme ? Generator.LARGE_BIOMES : Generator.DEFAULT;
            level.setGenerator(0, (MapGenerator)new SeededGenerator(generatorType, seed));
        }
        if (creativeMode) {
            level.setGameType(1);
        } else {
            level.setGameType(0);
        }
        level.setMapFeatures(true);
        level.setName(name);
        level.setSeed(seed);
        Point worldCoords = this.imageViewer.getViewLocation();
        level.setSpawnX(worldCoords.x);
        level.setSpawnZ(worldCoords.y);
        level.setSpawnY(64);
        try {
            level.save(worldDir);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error writing level.dat file", e);
        }
        if (minecraftDirUsed) {
            JOptionPane.showMessageDialog(this, "Map saved! You can find it in Minecraft under Singleplayer.");
        } else {
            JOptionPane.showMessageDialog(this, "Map saved as " + worldDir + ".\nMove it to your Minecraft saves directory to play.");
        }
    }

    private void createWorld() {
        App app = App.getInstanceIfExists();
        if (!app.saveIfNecessary()) {
            return;
        }
        final NewWorldDialog dialog = new NewWorldDialog(app, app.getColourScheme(), "Generated World", ((Number)this.seedSpinner.getValue()).longValue(), (Integer)this.schemeChooser.getSelectedItem() == 4 ? DefaultPlugin.JAVA_MCREGION : DefaultPlugin.JAVA_ANVIL, Dimension.Anchor.NORMAL_DETAIL, 0, Configuration.getInstance().getDefaultMaxHeight(), null, this.imageViewer.getSelectedTiles());
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            app.clearWorld();
            if (!dialog.checkMemoryRequirements(this)) {
                return;
            }
            World2 newWorld = (World2)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<World2>(){

                public String getName() {
                    return "Creating new world";
                }

                public World2 execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                    return dialog.getSelectedWorld(progressReceiver);
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
            if (newWorld != null) {
                Dimension dimension = newWorld.getDimension(Dimension.Anchor.NORMAL_DETAIL);
                switch ((Integer)this.schemeChooser.getSelectedItem()) {
                    case 4: 
                    case 5: 
                    case 9: {
                        dimension.setGenerator((MapGenerator)new SeededGenerator(Generator.DEFAULT, dimension.getMinecraftSeed()));
                        break;
                    }
                    case 8: 
                    case 10: {
                        dimension.setGenerator((MapGenerator)new SeededGenerator(Generator.LARGE_BIOMES, dimension.getMinecraftSeed()));
                    }
                }
                app.setWorld(newWorld, true);
            }
        }
    }

    private void setControlStates() {
        this.createWorldButton.setEnabled(!this.standAloneMode && !this.imageViewer.getSelectedTiles().isEmpty());
    }

    class Controller
    implements MouseListener,
    MouseMotionListener {
        private boolean selecting;
        private Point selectionCorner1;
        private Point selectionCorner2;

        Controller() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            Point tileLocation = this.getTileLocation(e.getX(), e.getY());
            if (BiomesViewerFrame.this.imageViewer.isSelectedTile(tileLocation)) {
                BiomesViewerFrame.this.imageViewer.removeSelectedTile(tileLocation);
            } else {
                BiomesViewerFrame.this.imageViewer.addSelectedTile(tileLocation);
            }
            BiomesViewerFrame.this.imageViewer.setSelectedRectangleCorner1(null);
            BiomesViewerFrame.this.imageViewer.setSelectedRectangleCorner2(null);
            BiomesViewerFrame.this.setControlStates();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            this.selecting = true;
            this.selectionCorner1 = this.getTileLocation(e.getX(), e.getY());
            this.selectionCorner2 = null;
            BiomesViewerFrame.this.imageViewer.setSelectedRectangleCorner1(null);
            BiomesViewerFrame.this.imageViewer.setSelectedRectangleCorner2(null);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (this.selectionCorner1 != null && this.selectionCorner2 != null) {
                int tileX1 = Math.min(this.selectionCorner1.x, this.selectionCorner2.x);
                int tileX2 = Math.max(this.selectionCorner1.x, this.selectionCorner2.x);
                int tileY1 = Math.min(this.selectionCorner1.y, this.selectionCorner2.y);
                int tileY2 = Math.max(this.selectionCorner1.y, this.selectionCorner2.y);
                for (int x = tileX1; x <= tileX2; ++x) {
                    for (int y = tileY1; y <= tileY2; ++y) {
                        Point tileLocation = new Point(x, y);
                        if (BiomesViewerFrame.this.imageViewer.isSelectedTile(tileLocation)) {
                            BiomesViewerFrame.this.imageViewer.removeSelectedTile(tileLocation);
                            continue;
                        }
                        BiomesViewerFrame.this.imageViewer.addSelectedTile(tileLocation);
                    }
                }
                BiomesViewerFrame.this.setControlStates();
            }
            BiomesViewerFrame.this.imageViewer.setSelectedRectangleCorner1(null);
            BiomesViewerFrame.this.imageViewer.setSelectedRectangleCorner2(null);
            this.selecting = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BiomesViewerFrame.this.imageViewer.setHighlightedTileLocation(this.getTileLocation(e.getX(), e.getY()));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BiomesViewerFrame.this.imageViewer.setHighlightedTileLocation(null);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BiomesViewerFrame.this.imageViewer.setHighlightedTileLocation(this.getTileLocation(e.getX(), e.getY()));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            BiomesViewerFrame.this.imageViewer.setHighlightedTileLocation(this.getTileLocation(e.getX(), e.getY()));
            if (this.selecting) {
                this.selectionCorner2 = this.getTileLocation(e.getX(), e.getY());
                BiomesViewerFrame.this.imageViewer.setSelectedRectangleCorner1(this.selectionCorner1);
                BiomesViewerFrame.this.imageViewer.setSelectedRectangleCorner2(this.selectionCorner2);
            }
        }

        private Point getTileLocation(int x, int y) {
            Point coords = BiomesViewerFrame.this.imageViewer.viewToWorld(x, y);
            return new Point(coords.x >> 7, coords.y >> 7);
        }
    }

    public static interface SeedListener {
        public void setSeed(long var1, Generator var3);
    }
}

