/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.threedeeview;

import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.util.swing.ProgressDialog;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.threedeeview.GlassPane;
import org.pepsoft.worldpainter.threedeeview.ThreeDeeView;
import org.pepsoft.worldpainter.util.BetterAction;
import org.pepsoft.worldpainter.util.ImageUtils;
import org.pepsoft.worldpainter.util.LayoutUtils;

public class ThreeDeeFrame
extends JFrame
implements WindowListener {
    private final Action ROTATE_LEFT_ACTION = new BetterAction("rotate3DViewLeft", "Rotate left", ICON_ROTATE_LEFT){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription("Rotate the view 90 degrees anticlockwise (l)");
        }

        @Override
        public void performAction(ActionEvent e) {
            Tile centreMostTile;
            ThreeDeeFrame.this.rotation--;
            if (ThreeDeeFrame.this.rotation < 0) {
                ThreeDeeFrame.this.rotation = 3;
            }
            if ((centreMostTile = ThreeDeeFrame.this.threeDeeView.getCentreMostTile()) != null) {
                ThreeDeeFrame.this.threeDeeView = new ThreeDeeView(ThreeDeeFrame.this.dimension, ThreeDeeFrame.this.colourScheme, ThreeDeeFrame.this.customBiomeManager, ThreeDeeFrame.this.rotation, ThreeDeeFrame.this.zoom);
                ThreeDeeFrame.this.scrollPane.setViewportView(ThreeDeeFrame.this.threeDeeView);
                ThreeDeeFrame.this.threeDeeView.moveToTile(centreMostTile);
                ThreeDeeFrame.this.glassPane.setRotation(DIRECTIONS[ThreeDeeFrame.this.rotation], ((ThreeDeeFrame)ThreeDeeFrame.this).dimension.getAnchor().invert);
            }
        }
    };
    private final Action ROTATE_RIGHT_ACTION = new BetterAction("rotate3DViewRight", "Rotate right", ICON_ROTATE_RIGHT){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription("Rotate the view 90 degrees clockwise (r)");
        }

        @Override
        public void performAction(ActionEvent e) {
            Tile centreMostTile;
            ThreeDeeFrame.this.rotation++;
            if (ThreeDeeFrame.this.rotation > 3) {
                ThreeDeeFrame.this.rotation = 0;
            }
            if ((centreMostTile = ThreeDeeFrame.this.threeDeeView.getCentreMostTile()) != null) {
                ThreeDeeFrame.this.threeDeeView = new ThreeDeeView(ThreeDeeFrame.this.dimension, ThreeDeeFrame.this.colourScheme, ThreeDeeFrame.this.customBiomeManager, ThreeDeeFrame.this.rotation, ThreeDeeFrame.this.zoom);
                ThreeDeeFrame.this.scrollPane.setViewportView(ThreeDeeFrame.this.threeDeeView);
                ThreeDeeFrame.this.threeDeeView.moveToTile(centreMostTile);
                ThreeDeeFrame.this.glassPane.setRotation(DIRECTIONS[ThreeDeeFrame.this.rotation], ((ThreeDeeFrame)ThreeDeeFrame.this).dimension.getAnchor().invert);
            }
        }
    };
    private final Action EXPORT_IMAGE_ACTION = new BetterAction("export3DViewImage", "Export image", ICON_EXPORT_IMAGE){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription("Export to an image file");
        }

        @Override
        public void performAction(ActionEvent e) {
            final Rectangle imageBounds = ThreeDeeFrame.this.threeDeeView.getImageBounds();
            if (!ThreeDeeFrame.this.imageFitsInJavaArray(imageBounds)) {
                MessageUtils.beepAndShowError((Component)ThreeDeeFrame.this, (String)("The 3D image is too large to export to an image.\nThe area (width x height) may not be more than " + App.INT_NUMBER_FORMAT.format(Integer.MAX_VALUE)), (String)"3D Image Too Large");
                return;
            }
            String defaultname = ThreeDeeFrame.this.dimension.getWorld().getName().replaceAll("\\s", "").toLowerCase() + (((ThreeDeeFrame)ThreeDeeFrame.this).dimension.getAnchor().dim == 0 ? "" : "_" + ThreeDeeFrame.this.dimension.getName().toLowerCase()) + "_3d.png";
            File selectedFile = ImageUtils.selectImageForSave(ThreeDeeFrame.this, "image file", new File(defaultname));
            if (selectedFile != null) {
                String type;
                int p = selectedFile.getName().lastIndexOf(46);
                if (p != -1) {
                    type = selectedFile.getName().substring(p + 1).toUpperCase();
                } else {
                    type = "PNG";
                    selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName() + ".png");
                }
                if (selectedFile.exists() && JOptionPane.showConfirmDialog(ThreeDeeFrame.this, "The file already exists!\nDo you want to overwrite it?", "Overwrite File?", 0) != 0) {
                    return;
                }
                final File file = selectedFile;
                Boolean result = (Boolean)ProgressDialog.executeTask((Window)ThreeDeeFrame.this, (ProgressTask)new ProgressTask<Boolean>(){

                    public String getName() {
                        return "Exporting image...";
                    }

                    public Boolean execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                        try {
                            return ImageIO.write((RenderedImage)ThreeDeeFrame.this.threeDeeView.getImage(imageBounds, progressReceiver), type, file);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("I/O error while exporting image", e);
                        }
                    }
                }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
                if (result != null && result.equals(Boolean.FALSE)) {
                    JOptionPane.showMessageDialog(ThreeDeeFrame.this, "Format " + type + " not supported!");
                }
            }
        }
    };
    private final Action MOVE_TO_SPAWN_ACTION = new BetterAction("move3DViewToSpawn", "Move to spawn", ICON_MOVE_TO_SPAWN){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription("Move the view to the spawn location");
        }

        @Override
        public void performAction(ActionEvent e) {
            if (((ThreeDeeFrame)ThreeDeeFrame.this).dimension.getAnchor().dim == 0) {
                Point spawn = ThreeDeeFrame.this.dimension.getWorld().getSpawnPoint();
                ThreeDeeFrame.this.threeDeeView.moveTo(spawn.x, spawn.y);
            }
        }
    };
    private final Action MOVE_TO_ORIGIN_ACTION = new BetterAction("move3DViewToOrigin", "Move to origin", ICON_MOVE_TO_ORIGIN){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription("Move the view to the origin (coordinates 0,0)");
        }

        @Override
        public void performAction(ActionEvent e) {
            ThreeDeeFrame.this.threeDeeView.moveTo(0, 0);
        }
    };
    private final Action ZOOM_IN_ACTION = new BetterAction("zoom3DViewIn", "Zoom in", ICON_ZOOM_IN){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription("Zoom in");
        }

        @Override
        public void performAction(ActionEvent e) {
            final Rectangle visibleRect = ThreeDeeFrame.this.threeDeeView.getVisibleRect();
            ThreeDeeFrame.this.zoom++;
            ThreeDeeFrame.this.threeDeeView.setZoom(ThreeDeeFrame.this.zoom);
            visibleRect.x *= 2;
            visibleRect.y *= 2;
            visibleRect.x += visibleRect.width / 2;
            visibleRect.y += visibleRect.height / 2;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ThreeDeeFrame.this.threeDeeView.scrollRectToVisible(visibleRect);
                }
            });
            if (ThreeDeeFrame.this.zoom >= 4) {
                this.setEnabled(false);
            }
            ThreeDeeFrame.this.ZOOM_OUT_ACTION.setEnabled(true);
            ThreeDeeFrame.this.RESET_ZOOM_ACTION.setEnabled(ThreeDeeFrame.this.zoom != 1);
        }
    };
    private final Action RESET_ZOOM_ACTION = new BetterAction("reset3DViewZoom", "Reset zoom", ICON_RESET_ZOOM){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription("Reset the zoom level to 1:1");
            this.setEnabled(false);
        }

        @Override
        public void performAction(ActionEvent e) {
            final Rectangle visibleRect = ThreeDeeFrame.this.threeDeeView.getVisibleRect();
            if (ThreeDeeFrame.this.zoom < 1) {
                while (ThreeDeeFrame.this.zoom < 1) {
                    ThreeDeeFrame.this.zoom++;
                    visibleRect.x *= 2;
                    visibleRect.y *= 2;
                    visibleRect.x += visibleRect.width / 2;
                    visibleRect.y += visibleRect.height / 2;
                }
                ThreeDeeFrame.this.threeDeeView.setZoom(ThreeDeeFrame.this.zoom);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThreeDeeFrame.this.threeDeeView.scrollRectToVisible(visibleRect);
                    }
                });
            } else if (ThreeDeeFrame.this.zoom > 1) {
                while (ThreeDeeFrame.this.zoom > 1) {
                    ThreeDeeFrame.this.zoom--;
                    visibleRect.x /= 2;
                    visibleRect.y /= 2;
                    visibleRect.x -= visibleRect.width / 4;
                    visibleRect.y -= visibleRect.height / 4;
                }
                ThreeDeeFrame.this.threeDeeView.setZoom(ThreeDeeFrame.this.zoom);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThreeDeeFrame.this.threeDeeView.scrollRectToVisible(visibleRect);
                    }
                });
            }
            ThreeDeeFrame.this.ZOOM_IN_ACTION.setEnabled(true);
            ThreeDeeFrame.this.ZOOM_OUT_ACTION.setEnabled(true);
            this.setEnabled(false);
        }
    };
    private final Action ZOOM_OUT_ACTION = new BetterAction("zoom3DViewOut", "Zoom out", ICON_ZOOM_OUT){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription("Zoom out");
        }

        @Override
        public void performAction(ActionEvent e) {
            final Rectangle visibleRect = ThreeDeeFrame.this.threeDeeView.getVisibleRect();
            ThreeDeeFrame.this.zoom--;
            ThreeDeeFrame.this.threeDeeView.setZoom(ThreeDeeFrame.this.zoom);
            visibleRect.x /= 2;
            visibleRect.y /= 2;
            visibleRect.x -= visibleRect.width / 4;
            visibleRect.y -= visibleRect.height / 4;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ThreeDeeFrame.this.threeDeeView.scrollRectToVisible(visibleRect);
                }
            });
            if (ThreeDeeFrame.this.zoom <= -2) {
                this.setEnabled(false);
            }
            ThreeDeeFrame.this.ZOOM_IN_ACTION.setEnabled(true);
            ThreeDeeFrame.this.RESET_ZOOM_ACTION.setEnabled(ThreeDeeFrame.this.zoom != 1);
        }
    };
    private final JScrollPane scrollPane;
    private final GlassPane glassPane;
    private final CustomBiomeManager customBiomeManager;
    private Dimension dimension;
    private ThreeDeeView threeDeeView;
    private ColourScheme colourScheme;
    private int rotation = 3;
    private int zoom = 1;
    private Point coords;
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
    private static final Icon ICON_ROTATE_LEFT = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_rotate_anticlockwise.png");
    private static final Icon ICON_ROTATE_RIGHT = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_rotate_clockwise.png");
    private static final Icon ICON_EXPORT_IMAGE = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/picture_save.png");
    private static final Icon ICON_MOVE_TO_SPAWN = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/spawn_red.png");
    private static final Icon ICON_MOVE_TO_ORIGIN = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_in.png");
    private static final Icon ICON_ALWAYS_ON_TOP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/lock.png");
    private static final Icon ICON_ZOOM_IN = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/magnifier_zoom_in.png");
    private static final Icon ICON_RESET_ZOOM = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/magnifier.png");
    private static final Icon ICON_ZOOM_OUT = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/magnifier_zoom_out.png");
    private static final int MIN_ZOOM = -2;
    private static final int MAX_ZOOM = 4;
    private static final long serialVersionUID = 1L;

    public ThreeDeeFrame(Dimension dimension, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, Point initialCoords) throws HeadlessException {
        super("WorldPainter - 3D View");
        this.setIconImage(App.ICON);
        this.colourScheme = colourScheme;
        this.customBiomeManager = customBiomeManager;
        this.coords = initialCoords;
        this.scrollPane = new JScrollPane();
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private int previousX;
            private int previousY;

            @Override
            public void mousePressed(MouseEvent e) {
                this.previousX = e.getX();
                this.previousY = e.getY();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int dx = e.getX() - this.previousX;
                int dy = e.getY() - this.previousY;
                this.previousX = e.getX();
                this.previousY = e.getY();
                JScrollBar scrollBar = ThreeDeeFrame.this.scrollPane.getHorizontalScrollBar();
                scrollBar.setValue(scrollBar.getValue() - dx);
                scrollBar = ThreeDeeFrame.this.scrollPane.getVerticalScrollBar();
                scrollBar.setValue(scrollBar.getValue() - dy);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        };
        this.scrollPane.addMouseListener(mouseAdapter);
        this.scrollPane.addMouseMotionListener(mouseAdapter);
        this.scrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    if (ThreeDeeFrame.this.zoom < 4) {
                        ThreeDeeFrame.this.ZOOM_IN_ACTION.actionPerformed(new ActionEvent(e.getSource(), 1001, null, e.getWhen(), e.getModifiers()));
                    }
                } else if (ThreeDeeFrame.this.zoom > -2) {
                    ThreeDeeFrame.this.ZOOM_OUT_ACTION.actionPerformed(new ActionEvent(e.getSource(), 1001, null, e.getWhen(), e.getModifiers()));
                }
            }
        });
        this.getContentPane().add((Component)this.scrollPane, "Center");
        JToggleButton alwaysOnTopButton = new JToggleButton(ICON_ALWAYS_ON_TOP);
        alwaysOnTopButton.setToolTipText("Set the 3D view window to be always on top");
        alwaysOnTopButton.addActionListener(e -> {
            if (alwaysOnTopButton.isSelected()) {
                this.setAlwaysOnTop(true);
            } else {
                this.setAlwaysOnTop(false);
            }
        });
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(alwaysOnTopButton);
        toolBar.addSeparator();
        toolBar.add(this.ROTATE_LEFT_ACTION);
        toolBar.add(this.ROTATE_RIGHT_ACTION);
        toolBar.addSeparator();
        toolBar.add(this.ZOOM_OUT_ACTION);
        toolBar.add(this.RESET_ZOOM_ACTION);
        toolBar.add(this.ZOOM_IN_ACTION);
        toolBar.addSeparator();
        toolBar.add(this.EXPORT_IMAGE_ACTION);
        toolBar.addSeparator();
        toolBar.add(this.MOVE_TO_SPAWN_ACTION);
        toolBar.add(this.MOVE_TO_ORIGIN_ACTION);
        this.getContentPane().add((Component)toolBar, "North");
        this.glassPane = new GlassPane();
        this.setGlassPane(this.glassPane);
        this.getGlassPane().setVisible(true);
        ActionMap actionMap = this.rootPane.getActionMap();
        actionMap.put("rotateLeft", this.ROTATE_LEFT_ACTION);
        actionMap.put("rotateRight", this.ROTATE_RIGHT_ACTION);
        actionMap.put("zoomIn", this.ZOOM_IN_ACTION);
        actionMap.put("resetZoom", this.RESET_ZOOM_ACTION);
        actionMap.put("zoomOut", this.ZOOM_OUT_ACTION);
        InputMap inputMap = this.rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke('l'), "rotateLeft");
        inputMap.put(KeyStroke.getKeyStroke('r'), "rotateRight");
        inputMap.put(KeyStroke.getKeyStroke('-'), "zoomOut");
        inputMap.put(KeyStroke.getKeyStroke('0'), "resetZoom");
        inputMap.put(KeyStroke.getKeyStroke('+'), "zoomIn");
        this.setSize(800, 600);
        GUIUtils.scaleToUI((Container)this);
        LayoutUtils.setDefaultSizeAndLocation(this, 60);
        this.setDimension(dimension);
        this.addWindowListener(this);
    }

    public final Dimension getDimension() {
        return this.dimension;
    }

    public final void setDimension(Dimension dimension) {
        this.dimension = dimension;
        if (dimension != null) {
            this.threeDeeView = new ThreeDeeView(dimension, this.colourScheme, this.customBiomeManager, this.rotation, this.zoom);
            this.scrollPane.setViewportView(this.threeDeeView);
            this.MOVE_TO_SPAWN_ACTION.setEnabled(dimension.getAnchor().dim == 0);
            this.glassPane.setRotation(DIRECTIONS[this.rotation], dimension.getAnchor().invert);
        }
    }

    public void moveTo(Point coords) {
        this.coords = coords;
        this.threeDeeView.moveTo(coords.x, coords.y);
    }

    public void refresh() {
        if (this.threeDeeView != null) {
            this.threeDeeView.refresh();
        }
    }

    private boolean imageFitsInJavaArray(Rectangle imageBounds) {
        long area = (long)imageBounds.width * (long)imageBounds.height;
        return area >= 0L && area <= Integer.MAX_VALUE;
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.moveTo(this.coords);
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

