/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes.impl.simple;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerManager;
import org.pepsoft.worldpainter.layers.LayerTableCellRenderer;
import org.pepsoft.worldpainter.themes.ButtonPressListener;
import org.pepsoft.worldpainter.themes.JButtonTableCellEditor;
import org.pepsoft.worldpainter.themes.JButtonTableCellRenderer;
import org.pepsoft.worldpainter.themes.JSpinnerTableCellEditor;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;
import org.pepsoft.worldpainter.themes.TerrainTableCellRenderer;
import org.pepsoft.worldpainter.themes.impl.simple.AddLayerDialog;
import org.pepsoft.worldpainter.themes.impl.simple.AddTerrainRangeDialog;
import org.pepsoft.worldpainter.themes.impl.simple.LayerRangesTableModel;
import org.pepsoft.worldpainter.themes.impl.simple.TerrainRangesTableModel;

public class SimpleThemeEditor
extends JPanel
implements ButtonPressListener,
TerrainRangesTableModel.ChangeListener {
    private JButton buttonAddLayer;
    private JButton buttonAddTerrain;
    private JCheckBox checkBoxBeaches;
    private JCheckBox checkBoxRandomise;
    private JButton jButton1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JSpinner spinnerWaterLevel;
    private JTable tableLayers;
    private JTable tableTerrain;
    private SimpleTheme theme;
    private TerrainRangesTableModel terrainTableModel;
    private ColourScheme colourScheme;
    private ChangeListener changeListener;
    private LayerRangesTableModel layerTableModel;
    private boolean programmaticChange;
    private boolean allowCustomItems = true;
    private static final long serialVersionUID = 1L;

    public SimpleThemeEditor() {
        this.initComponents();
    }

    public boolean save() {
        if (this.terrainTableModel == null) {
            return true;
        }
        if (!this.programmaticChange) {
            if (this.tableTerrain.isEditing()) {
                this.tableTerrain.getCellEditor().stopCellEditing();
            }
            if (!this.terrainTableModel.isValid()) {
                MessageUtils.showWarning((Component)this, (String)"You have configured multiple terrain types with the same levels!\nRemove, or change the level of, one of the duplicates.", (String)"Duplicate Levels");
                return false;
            }
            if (this.tableLayers.isEditing()) {
                this.tableLayers.getCellEditor().stopCellEditing();
            }
        }
        this.theme.setTerrainRanges(this.terrainTableModel.getTerrainRanges());
        this.theme.setRandomise(this.checkBoxRandomise.isSelected());
        boolean beaches = this.checkBoxBeaches.isSelected();
        this.theme.setBeaches(beaches);
        this.theme.setWaterHeight(((Number)this.spinnerWaterLevel.getValue()).intValue());
        this.theme.setLayerMap(this.layerTableModel.getLayerMap());
        return true;
    }

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    public void setColourScheme(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
    }

    public boolean isAllowCustomItems() {
        return this.allowCustomItems;
    }

    public void setAllowCustomItems(boolean allowCustomItems) {
        if (this.theme != null) {
            throw new IllegalStateException("allowCustomItems must be set before theme");
        }
        this.allowCustomItems = allowCustomItems;
    }

    public SimpleTheme getTheme() {
        return this.theme;
    }

    public void setTheme(SimpleTheme theme) {
        this.theme = theme;
        if (theme != null) {
            int minHeight = theme.getMinHeight();
            int maxHeight = theme.getMaxHeight();
            this.terrainTableModel = new TerrainRangesTableModel(theme.getTerrainRanges());
            this.terrainTableModel.setChangeListener(this);
            this.tableTerrain.setModel(this.terrainTableModel);
            this.tableTerrain.setDefaultRenderer(Integer.class, new DefaultTableCellRenderer());
            this.tableTerrain.setDefaultRenderer(Terrain.class, new TerrainTableCellRenderer(this.colourScheme));
            this.tableTerrain.setDefaultRenderer(JButton.class, new JButtonTableCellRenderer());
            this.tableTerrain.setDefaultEditor(Integer.class, new JSpinnerTableCellEditor(new SpinnerNumberModel(minHeight + 1, minHeight + 1, maxHeight - 1, 1)));
            JComboBox<Terrain> terrainEditor = new JComboBox<Terrain>(this.allowCustomItems ? Terrain.getConfiguredValues() : Terrain.PICK_LIST);
            terrainEditor.setRenderer(new TerrainListCellRenderer(this.colourScheme));
            this.tableTerrain.setDefaultEditor(Terrain.class, new DefaultCellEditor(terrainEditor));
            this.tableTerrain.setDefaultEditor(JButton.class, new JButtonTableCellEditor(this));
            this.checkBoxBeaches.setSelected(theme.isBeaches());
            this.spinnerWaterLevel.setModel(new SpinnerNumberModel(theme.getWaterHeight(), minHeight, maxHeight - 1, 1));
            this.checkBoxRandomise.setSelected(theme.isRandomise());
            this.layerTableModel = new LayerRangesTableModel(minHeight, maxHeight, theme.getLayerMap());
            this.tableLayers.setModel(this.layerTableModel);
            this.tableLayers.setDefaultRenderer(Layer.class, new LayerTableCellRenderer());
            this.tableLayers.setDefaultRenderer(JButton.class, new JButtonTableCellRenderer());
            this.tableLayers.setDefaultEditor(Integer.class, new JSpinnerTableCellEditor(new SpinnerNumberModel(minHeight + 1, minHeight + 1, maxHeight - 1, 1)));
            this.tableLayers.setDefaultEditor(JButton.class, new JButtonTableCellEditor(this));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tableTerrain.setEnabled(enabled);
        this.checkBoxBeaches.setEnabled(enabled);
        this.spinnerWaterLevel.setEnabled(enabled);
        this.buttonAddTerrain.setEnabled(enabled);
        this.checkBoxRandomise.setEnabled(enabled);
    }

    public ChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void setWaterHeight(int waterHeight) {
        this.spinnerWaterLevel.setValue(waterHeight);
    }

    @Override
    public void buttonPressed(JTable source, int row, int column) {
        if (source == this.tableTerrain) {
            this.terrainTableModel.deleteRow(row);
        } else if (source == this.tableLayers) {
            this.layerTableModel.deleteRow(row);
        } else {
            throw new IllegalArgumentException("Unknown source " + source);
        }
    }

    @Override
    public void dataChanged(TerrainRangesTableModel model) {
        this.notifyChangeListener();
    }

    private void addTerrain() {
        AddTerrainRangeDialog dialog = new AddTerrainRangeDialog(SwingUtilities.getWindowAncestor(this), this.theme.getMinHeight(), this.theme.getMaxHeight(), this.colourScheme, this.allowCustomItems);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.terrainTableModel.addRow(dialog.getSelectedLevel(), dialog.getSelectedTerrain());
        }
    }

    private void addLayer() {
        Window window = SwingUtilities.getWindowAncestor(this);
        AddLayerDialog dialog = new AddLayerDialog(window, new ArrayList<Layer>(this.allowCustomItems ? App.getInstance().getAllLayers() : LayerManager.getInstance().getLayers()), this.theme.getMinHeight(), this.theme.getMaxHeight());
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.layerTableModel.addRow(dialog.getSelectedFilter(), dialog.getSelectedLayer());
        }
    }

    private void notifyChangeListener() {
        if (this.changeListener != null) {
            this.programmaticChange = true;
            try {
                this.changeListener.settingsModified(this);
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.checkBoxBeaches = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.tableTerrain = new JTable();
        this.buttonAddTerrain = new JButton();
        this.spinnerWaterLevel = new JSpinner();
        this.checkBoxRandomise = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.buttonAddLayer = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tableLayers = new JTable();
        this.jButton1.setText("jButton1");
        this.checkBoxBeaches.setText("beaches");
        this.checkBoxBeaches.setToolTipText("Whether to add beaches from two levels below the water level to two levels above.");
        this.checkBoxBeaches.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleThemeEditor.this.checkBoxBeachesActionPerformed(evt);
            }
        });
        this.tableTerrain.setRowHeight(25);
        this.jScrollPane1.setViewportView(this.tableTerrain);
        this.buttonAddTerrain.setText("Add...");
        this.buttonAddTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleThemeEditor.this.buttonAddTerrainActionPerformed(evt);
            }
        });
        this.spinnerWaterLevel.addChangeListener(new javax.swing.event.ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimpleThemeEditor.this.spinnerWaterLevelStateChanged(evt);
            }
        });
        this.checkBoxRandomise.setText("noisy edges");
        this.checkBoxRandomise.setToolTipText("Whether to randomise the edges of the terrain types (except beaches).");
        this.checkBoxRandomise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleThemeEditor.this.checkBoxRandomiseActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Default water level:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerWaterLevel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkBoxBeaches).addGap(18, 18, 18).addComponent(this.checkBoxRandomise).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addComponent(this.buttonAddTerrain)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 167, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonAddTerrain).addComponent(this.checkBoxBeaches).addComponent(this.spinnerWaterLevel, -2, -1, -2).addComponent(this.checkBoxRandomise).addComponent(this.jLabel1)).addGap(0, 0, 0)));
        this.jTabbedPane1.addTab("Terrain", this.jPanel1);
        this.buttonAddLayer.setText("Add...");
        this.buttonAddLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleThemeEditor.this.buttonAddLayerActionPerformed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tableLayers);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 383, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.buttonAddLayer))).addGap(0, 0, 0)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 167, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAddLayer).addGap(0, 0, 0)));
        this.jTabbedPane1.addTab("Layers", this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING));
    }

    private void checkBoxRandomiseActionPerformed(ActionEvent evt) {
        this.notifyChangeListener();
    }

    private void spinnerWaterLevelStateChanged(ChangeEvent evt) {
        this.notifyChangeListener();
    }

    private void buttonAddTerrainActionPerformed(ActionEvent evt) {
        this.addTerrain();
    }

    private void checkBoxBeachesActionPerformed(ActionEvent evt) {
        this.notifyChangeListener();
    }

    private void buttonAddLayerActionPerformed(ActionEvent evt) {
        this.addLayer();
    }

    public static interface ChangeListener {
        public void settingsModified(SimpleThemeEditor var1);
    }
}

