/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes.impl.fancy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.themes.Filter;
import org.pepsoft.worldpainter.themes.HeightFilter;

public class LayerMapTableModel
implements TableModel {
    private final int minHeight;
    private final int maxHeight;
    private final List<HeightFilter> filters;
    private final List<Layer> layers;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private static final String[] COLUMN_NAMES = new String[]{"Layer", "From", "To", "Feather"};
    private static final Class[] COLUMN_TYPES = new Class[]{Layer.class, Integer.class, Integer.class, Boolean.class};
    private static final int COLUMN_LAYER = 0;
    private static final int COLUMN_FROM = 1;
    private static final int COLUMN_TO = 2;
    private static final int COLUMN_FEATHER = 3;

    public LayerMapTableModel(int minHeight, int maxHeight, Map<Filter, Layer> layerMap) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.filters = new ArrayList<HeightFilter>(layerMap.size());
        this.layers = new ArrayList<Layer>(layerMap.size());
        for (Map.Entry<Filter, Layer> entry : layerMap.entrySet()) {
            this.filters.add((HeightFilter)entry.getKey());
            this.layers.add(entry.getValue());
        }
    }

    @Override
    public int getRowCount() {
        return this.layers.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.layers.get(rowIndex);
            }
            case 1: {
                return this.filters.get(rowIndex).getStartHeight();
            }
            case 2: {
                return this.filters.get(rowIndex).getStopHeight();
            }
            case 3: {
                return this.filters.get(rowIndex).isFeather();
            }
        }
        throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.layers.set(rowIndex, (Layer)aValue);
                break;
            }
            case 1: {
                HeightFilter oldFilter = this.filters.get(rowIndex);
                this.filters.set(rowIndex, new HeightFilter(this.minHeight, this.maxHeight, ((Integer)aValue).intValue(), oldFilter.getStopHeight(), oldFilter.isFeather()));
                break;
            }
            case 2: {
                HeightFilter oldFilter = this.filters.get(rowIndex);
                this.filters.set(rowIndex, new HeightFilter(this.minHeight, this.maxHeight, oldFilter.getStartHeight(), ((Integer)aValue).intValue(), oldFilter.isFeather()));
                break;
            }
            case 3: {
                HeightFilter oldFilter = this.filters.get(rowIndex);
                this.filters.set(rowIndex, new HeightFilter(this.minHeight, this.maxHeight, oldFilter.getStartHeight(), oldFilter.getStopHeight(), ((Boolean)aValue).booleanValue()));
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
            }
        }
        TableModelEvent event = new TableModelEvent(this, rowIndex, rowIndex, columnIndex);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }
}

