/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonOK;
    private JComboBox<String> comboBoxAngle;
    private JComboBox<String> comboBoxFont;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSpinner spinnerSize;
    private JTextArea textArea;
    private JToggleButton toggleButtonBold;
    private JToggleButton toggleButtonItalic;
    private final int previewSize = (int)(18.0f * GUIUtils.SYSTEM_UI_SCALE_FLOAT);
    private static final Logger logger = LoggerFactory.getLogger(TextDialog.class);

    public TextDialog(Window parent, String defaultFont, int defaultSize, String text) {
        super(parent);
        this.initComponents();
        String[] fontFamilyNames = (String[])Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()).filter(name -> {
            Font font = new Font((String)name, 0, this.previewSize);
            if (font.canDisplay('A')) {
                logger.debug("Including font: {}", name);
                return true;
            }
            logger.debug("Excluding font because it cannot display 'A': {}", name);
            return false;
        }).toArray(String[]::new);
        this.comboBoxFont.setModel(new DefaultComboBoxModel<String>(fontFamilyNames));
        this.comboBoxFont.setSelectedItem(defaultFont);
        this.spinnerSize.setValue(defaultSize);
        if (text != null) {
            this.textArea.setText(text);
            this.textArea.selectAll();
        }
        this.textArea.requestFocusInWindow();
        this.rootPane.setDefaultButton(this.buttonOK);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.fontSelected();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public Font getSelectedFont() {
        return new Font((String)this.comboBoxFont.getSelectedItem(), (this.toggleButtonBold.isSelected() ? 1 : 0) | (this.toggleButtonItalic.isSelected() ? 2 : 0), (Integer)this.spinnerSize.getValue());
    }

    public int getSelectedAngle() {
        return this.comboBoxAngle.getSelectedIndex();
    }

    private void fontSelected() {
        this.textArea.setFont(new Font((String)this.comboBoxFont.getSelectedItem(), (this.toggleButtonBold.isSelected() ? 1 : 0) | (this.toggleButtonItalic.isSelected() ? 2 : 0), this.previewSize));
    }

    private void initComponents() {
        this.comboBoxFont = new JComboBox();
        this.spinnerSize = new JSpinner();
        this.toggleButtonBold = new JToggleButton();
        this.toggleButtonItalic = new JToggleButton();
        this.jScrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.comboBoxAngle = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Enter Text");
        this.comboBoxFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextDialog.this.comboBoxFontActionPerformed(evt);
            }
        });
        this.spinnerSize.setModel(new SpinnerNumberModel(18, 1, 999, 1));
        this.toggleButtonBold.setFont(this.toggleButtonBold.getFont().deriveFont(this.toggleButtonBold.getFont().getStyle() | 1));
        this.toggleButtonBold.setText("B");
        this.toggleButtonBold.setToolTipText("Bold");
        this.toggleButtonBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextDialog.this.toggleButtonBoldActionPerformed(evt);
            }
        });
        this.toggleButtonItalic.setFont(this.toggleButtonItalic.getFont().deriveFont(this.toggleButtonItalic.getFont().getStyle() | 2));
        this.toggleButtonItalic.setText("I");
        this.toggleButtonItalic.setToolTipText("Italic");
        this.toggleButtonItalic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextDialog.this.toggleButtonItalicActionPerformed(evt);
            }
        });
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.jScrollPane1.setViewportView(this.textArea);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Font:");
        this.jLabel2.setText("Size:");
        this.jLabel3.setText("Angle:");
        this.comboBoxAngle.setModel(new DefaultComboBoxModel<String>(new String[]{"0 \u00b0", "-90 \u00b0", "180 \u00b0", "90 \u00b0"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxFont, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toggleButtonBold).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toggleButtonItalic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxAngle, -2, -1, -2).addGap(0, 107, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboBoxFont, -2, -1, -2).addComponent(this.spinnerSize, -2, -1, -2).addComponent(this.toggleButtonBold).addComponent(this.toggleButtonItalic).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.comboBoxAngle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 304, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void comboBoxFontActionPerformed(ActionEvent evt) {
        this.fontSelected();
    }

    private void toggleButtonBoldActionPerformed(ActionEvent evt) {
        this.fontSelected();
    }

    private void toggleButtonItalicActionPerformed(ActionEvent evt) {
        this.fontSelected();
    }
}

