/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.operations.Operation;

public abstract class AbstractOperation
implements Operation {
    private final String name;
    private final String description;
    private final BufferedImage icon;
    private boolean active;

    protected AbstractOperation(String name, String description) {
        this(name, description, name.toLowerCase().replaceAll("\\s", ""));
    }

    protected AbstractOperation(String name, String description, String iconName) {
        if (name == null || description == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.description = description;
        this.icon = IconUtils.loadScaledImage((ClassLoader)this.getClass().getClassLoader(), (String)("org/pepsoft/worldpainter/icons/" + iconName + ".png"));
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final void setActive(boolean active) throws PropertyVetoException {
        if (active != this.active) {
            this.active = active;
            if (active) {
                try {
                    this.activate();
                }
                catch (PropertyVetoException e) {
                    this.active = false;
                    throw e;
                }
            } else {
                this.deactivate();
            }
        }
    }

    public final BufferedImage getIcon() {
        return this.icon;
    }

    public JPanel getOptionsPanel() {
        return null;
    }

    public String toString() {
        return this.name;
    }

    protected abstract void activate() throws PropertyVetoException;

    protected abstract void deactivate();
}

