/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.tunnel;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.pepsoft.util.CollectionUtils;
import org.pepsoft.worldpainter.BiomeListCellRenderer;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.NoiseSettingsEditor;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;
import org.pepsoft.worldpainter.util.BiomeUtils;

public class FloorDimensionSettingsDialog
extends WorldPainterDialog {
    private JCheckBox checkBoxFloodWithLava;
    private JComboBox<Integer> comboBoxBiome;
    private JComboBox<Terrain> comboBoxTerrain;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel23;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private NoiseSettingsEditor noiseSettingsEditorFloor;
    private JSpinner spinnerFloodLevel;
    private JSpinner spinnerFloorLevel;

    public FloorDimensionSettingsDialog(Window parent, ColourScheme colourScheme, Platform platform, int minHeight, int maxHeight, int level, NoiseSettings variation, int waterLevel, boolean floodWithLava, Terrain terrain) {
        super(parent);
        this.initComponents();
        ((SpinnerNumberModel)this.spinnerFloorLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerFloorLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        ((SpinnerNumberModel)this.spinnerFloodLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerFloodLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        this.comboBoxTerrain.setRenderer(new TerrainListCellRenderer(colourScheme));
        this.comboBoxTerrain.setModel(new DefaultComboBoxModel<Terrain>(Terrain.getConfiguredValues()));
        this.comboBoxBiome.setRenderer(new BiomeListCellRenderer(colourScheme, null, platform));
        this.comboBoxBiome.setModel(new DefaultComboBoxModel<Integer>(CollectionUtils.nullAnd((Collection)BiomeUtils.getAllBiomes((Platform)platform, null)).toArray(new Integer[0])));
        this.spinnerFloorLevel.setValue(level);
        this.noiseSettingsEditorFloor.setNoiseSettings(variation);
        this.comboBoxTerrain.setSelectedItem(terrain);
        this.spinnerFloodLevel.setValue(waterLevel);
        this.checkBoxFloodWithLava.setSelected(floodWithLava);
        this.setLocationRelativeTo(parent);
    }

    public int getLevel() {
        return (Integer)this.spinnerFloorLevel.getValue();
    }

    public NoiseSettings getVariation() {
        return this.noiseSettingsEditorFloor.getNoiseSettings();
    }

    public int getWaterLevel() {
        return (Integer)this.spinnerFloodLevel.getValue();
    }

    public boolean isFloodWithLava() {
        return this.checkBoxFloodWithLava.isSelected();
    }

    public Terrain getTerrain() {
        return (Terrain)this.comboBoxTerrain.getSelectedItem();
    }

    public Integer getBiome() {
        return (Integer)this.comboBoxBiome.getSelectedItem();
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.spinnerFloorLevel = new JSpinner();
        this.jLabel5 = new JLabel();
        this.noiseSettingsEditorFloor = new NoiseSettingsEditor();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.comboBoxTerrain = new JComboBox();
        this.jLabel23 = new JLabel();
        this.comboBoxBiome = new JComboBox();
        this.jLabel21 = new JLabel();
        this.spinnerFloodLevel = new JSpinner();
        this.checkBoxFloodWithLava = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Floor Dimension Defaults [ALPHA]");
        this.setResizable(false);
        this.jLabel3.setText("Level:");
        this.spinnerFloorLevel.setModel(new SpinnerNumberModel(32, -64, 319, 1));
        this.jLabel5.setText("Variation:");
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloorDimensionSettingsDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Create");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloorDimensionSettingsDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Configure the default settings for the new floor dimension here:");
        this.jLabel2.setText("Terrain:");
        this.jLabel23.setText("Biome:");
        this.jLabel21.setText("Water level:");
        this.spinnerFloodLevel.setModel(new SpinnerNumberModel(62, -64, 319, 1));
        this.checkBoxFloodWithLava.setText("lava instead of water:");
        this.checkBoxFloodWithLava.setHorizontalTextPosition(10);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerFloorLevel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noiseSettingsEditorFloor, -2, -1, -2)).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxTerrain, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxBiome, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerFloodLevel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkBoxFloodWithLava))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.spinnerFloorLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.noiseSettingsEditorFloor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboBoxTerrain, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel23).addComponent(this.comboBoxBiome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel21).addComponent(this.spinnerFloodLevel, -2, -1, -2).addComponent(this.checkBoxFloodWithLava)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.ok();
    }
}

