/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.layers.AbstractLayerEditor;
import org.pepsoft.worldpainter.layers.Bo2Layer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerEditor;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectProvider;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectTube;
import org.pepsoft.worldpainter.layers.bo2.EditObjectAttributes;
import org.pepsoft.worldpainter.layers.bo2.WPObjectListCellRenderer;
import org.pepsoft.worldpainter.layers.bo2.WPObjectPreviewer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.objects.WPObject;
import org.pepsoft.worldpainter.plugins.CustomObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bo2LayerEditor
extends AbstractLayerEditor<Bo2Layer>
implements ListSelectionListener,
DocumentListener {
    private JButton buttonAddFile;
    private JButton buttonEdit;
    private JButton buttonPickColour;
    private JButton buttonReloadAll;
    private JButton buttonRemoveFile;
    private JButton buttonReset;
    private JButton buttonSetDecay;
    private JButton buttonSetNoDecay;
    private JTextField fieldName;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JLabel labelBlocksPerAttempt;
    private JLabel labelEffectiveLeafDecaySetting;
    private JLabel labelLeafDecayTitle;
    private JList<WPObject> listObjects;
    private JSpinner spinnerBlocksPerAttempt;
    private final DefaultListModel<WPObject> listModel;
    private final NumberFormat numberFormat = NumberFormat.getInstance();
    private ColourScheme colourScheme;
    private int selectedColour = Color.ORANGE.getRGB();
    private static final Logger logger = LoggerFactory.getLogger(Bo2LayerEditor.class);
    private static final long serialVersionUID = 1L;

    public Bo2LayerEditor() {
        this.initComponents();
        this.listModel = new DefaultListModel();
        this.listObjects.setModel(this.listModel);
        this.listObjects.setCellRenderer(new WPObjectListCellRenderer());
        this.listObjects.getSelectionModel().addListSelectionListener(this);
        this.fieldName.getDocument().addDocumentListener(this);
        this.updateBlocksPerAttempt();
    }

    public Bo2Layer createLayer() {
        return new Bo2Layer((Bo2ObjectProvider)new Bo2ObjectTube("My Custom Objects", Collections.emptyList()), "Custom (e.g. bo2, bo3, nbt, schem and/or schematic) objects", Color.ORANGE.getRGB());
    }

    public void setLayer(Bo2Layer layer) {
        super.setLayer((Layer)layer);
        this.reset();
    }

    public void commit() {
        if (!this.isCommitAvailable()) {
            throw new IllegalStateException("Settings invalid or incomplete");
        }
        this.saveSettings((Bo2Layer)this.layer);
    }

    public void reset() {
        ArrayList<WPObject> objects = new ArrayList<WPObject>();
        this.fieldName.setText(((Bo2Layer)this.layer).getName());
        this.selectedColour = ((Bo2Layer)this.layer).getColour();
        List files = ((Bo2Layer)this.layer).getFiles();
        if (files != null) {
            if (files.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Existing layer contains new style objects");
                }
                objects.addAll(((Bo2Layer)this.layer).getObjectProvider().getAllObjects());
            } else {
                int missingFiles = 0;
                CustomObjectManager customObjectManager = CustomObjectManager.getInstance();
                if (files.size() == 1 && ((File)files.get(0)).isDirectory()) {
                    File[] filesInDir;
                    logger.info("Existing custom object layer contains old style directory; migrating to new style");
                    for (File file : filesInDir = ((File)files.get(0)).listFiles((FilenameFilter)CustomObjectManager.getInstance().getFileFilter())) {
                        try {
                            objects.add(customObjectManager.loadObject(file));
                        }
                        catch (IOException e) {
                            logger.error("I/O error while trying to load custom object " + file, (Throwable)e);
                            ++missingFiles;
                        }
                    }
                } else {
                    logger.info("Existing custom object layer contains old style file list; migrating to new style");
                    for (File file : files) {
                        if (file.exists()) {
                            try {
                                objects.add(customObjectManager.loadObject(file));
                            }
                            catch (IOException e) {
                                logger.error("I/O error while trying to load custom object " + file, (Throwable)e);
                                ++missingFiles;
                            }
                            continue;
                        }
                        ++missingFiles;
                    }
                }
                if (missingFiles > 0) {
                    MessageUtils.showWarning((Component)((Object)this), (String)("This is an old custom object layer and " + missingFiles + " objects\ncould NOT be restored because they were missing or\nreading them resulted in an I/O error.\n\nYou will have to re-add these objects before\nsaving the settings, otherwise the existing object\ndata will be gone. You may also cancel the dialog\nwithout affecting the object data."), (String)"Missing Files");
                }
            }
        } else {
            logger.info("Existing custom object layer contains very old style objects with no file information; migrating to new style");
            objects.addAll(((Bo2Layer)this.layer).getObjectProvider().getAllObjects());
        }
        this.listModel.clear();
        for (WPObject object : objects) {
            this.listModel.addElement(object.clone());
        }
        this.spinnerBlocksPerAttempt.setValue(((Bo2Layer)this.layer).getDensity());
        this.setLabelColour();
        this.refreshLeafDecaySettings();
        this.settingsChanged();
    }

    public ExporterSettings getSettings() {
        if (!this.isCommitAvailable()) {
            throw new IllegalStateException("Settings invalid or incomplete");
        }
        final Bo2Layer previewLayer = this.saveSettings(null);
        return new ExporterSettings(){

            public boolean isApplyEverywhere() {
                return false;
            }

            public Bo2Layer getLayer() {
                return previewLayer;
            }

            public ExporterSettings clone() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }

    public boolean isCommitAvailable() {
        boolean filesSelected = this.listModel.getSize() > 0;
        boolean nameSpecified = this.fieldName.getText().trim().length() > 0;
        return filesSelected && nameSpecified;
    }

    public void setContext(LayerEditor.LayerEditorContext context) {
        super.setContext(context);
        this.colourScheme = context.getColourScheme();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.settingsChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.settingsChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.settingsChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.settingsChanged();
    }

    private Bo2Layer saveSettings(Bo2Layer layer) {
        String name = this.fieldName.getText();
        ArrayList<WPObject> objects = new ArrayList<WPObject>(this.listModel.getSize());
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            objects.add(this.listModel.getElementAt(i));
        }
        Bo2ObjectTube objectProvider = new Bo2ObjectTube(name, objects);
        if (layer == null) {
            layer = new Bo2Layer((Bo2ObjectProvider)objectProvider, "Custom (e.g. bo2, bo3 and/or schematic) objects", this.selectedColour);
        } else {
            layer.setObjectProvider((Bo2ObjectProvider)objectProvider);
            layer.setColour(this.selectedColour);
        }
        layer.setDensity(((Integer)this.spinnerBlocksPerAttempt.getValue()).intValue());
        return layer;
    }

    private void pickColour() {
        Color pick = JColorChooser.showDialog((Component)((Object)this), "Select Colour", new Color(this.selectedColour));
        if (pick != null) {
            this.selectedColour = pick.getRGB();
            this.setLabelColour();
        }
    }

    private void setLabelColour() {
        this.jLabel5.setBackground(new Color(this.selectedColour));
    }

    private void settingsChanged() {
        this.setControlStates();
        this.context.settingsChanged();
    }

    private void setControlStates() {
        boolean filesSelected = this.listModel.getSize() > 0;
        boolean objectsSelected = this.listObjects.getSelectedIndex() != -1;
        this.buttonRemoveFile.setEnabled(objectsSelected);
        this.buttonReloadAll.setEnabled(filesSelected);
        this.buttonEdit.setEnabled(objectsSelected);
    }

    private void addFilesOrDirectory() {
        File[] selectedFiles;
        JFileChooser fileChooser = new JFileChooser();
        Configuration config = Configuration.getInstance();
        if (config.getCustomObjectsDirectory() != null && config.getCustomObjectsDirectory().isDirectory()) {
            fileChooser.setCurrentDirectory(config.getCustomObjectsDirectory());
        }
        fileChooser.setDialogTitle("Select File(s) or Directory");
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileSelectionMode(2);
        CustomObjectManager.UniversalFileFilter fileFilter = CustomObjectManager.getInstance().getFileFilter();
        fileChooser.setFileFilter((FileFilter)fileFilter);
        WPObjectPreviewer previewer = new WPObjectPreviewer();
        previewer.setDimension(App.getInstance().getDimension());
        fileChooser.addPropertyChangeListener("SelectedFileChangedProperty", previewer);
        fileChooser.setAccessory(previewer);
        if (ExceptionHandler.doWithoutExceptionReporting(() -> fileChooser.showOpenDialog((Component)((Object)this))) == 0 && (selectedFiles = fileChooser.getSelectedFiles()).length > 0) {
            Platform platform = this.context.getDimension().getWorld().getPlatform();
            boolean checkForNameOnlyMaterials = !platform.capabilities.contains(Platform.Capability.NAME_BASED);
            HashSet<String> nameOnlyMaterialsNames = checkForNameOnlyMaterials ? new HashSet<String>() : null;
            config.setCustomObjectsDirectory(selectedFiles[0].getParentFile());
            for (File selectedFile : selectedFiles) {
                String name;
                if (selectedFile.isDirectory()) {
                    File[] files;
                    if (this.fieldName.getText().isEmpty()) {
                        name = selectedFiles[0].getName();
                        if (name.length() > 12) {
                            name = "..." + name.substring(name.length() - 10);
                        }
                        this.fieldName.setText(name);
                    }
                    if ((files = selectedFile.listFiles((FilenameFilter)fileFilter)) == null) {
                        MessageUtils.beepAndShowError((Component)((Object)this), (String)(selectedFile.getName() + " is not a directory or it cannot be read."), (String)"Not A Valid Directory");
                        continue;
                    }
                    if (files.length == 0) {
                        MessageUtils.beepAndShowError((Component)((Object)this), (String)("Directory " + selectedFile.getName() + " does not contain any supported custom object files."), (String)"No Custom Object Files");
                        continue;
                    }
                    for (File file : files) {
                        this.addFile(checkForNameOnlyMaterials, nameOnlyMaterialsNames, file);
                    }
                    continue;
                }
                if (this.fieldName.getText().isEmpty()) {
                    name = selectedFile.getName();
                    int p = name.lastIndexOf(46);
                    if (p != -1) {
                        name = name.substring(0, p);
                    }
                    if (name.length() > 12) {
                        name = "..." + name.substring(name.length() - 10);
                    }
                    this.fieldName.setText(name);
                }
                this.addFile(checkForNameOnlyMaterials, nameOnlyMaterialsNames, selectedFile);
            }
            this.settingsChanged();
            this.refreshLeafDecaySettings();
            if (checkForNameOnlyMaterials && !nameOnlyMaterialsNames.isEmpty()) {
                String message = nameOnlyMaterialsNames.size() > 4 ? String.format("One or more added objects contain block types that are\nincompatible with the current map format (%s):\n%s and %d more\nYou will not be able to export this world in this format if you use this layer.", platform.displayName, String.join((CharSequence)", ", new ArrayList<String>(nameOnlyMaterialsNames).subList(0, 3)), nameOnlyMaterialsNames.size() - 3) : String.format("One or more added objects contain block types that are\nincompatible with the current map format (%s):\n%s\nYou will not be able to export this world in this format if you use this layer.", platform.displayName, String.join((CharSequence)", ", nameOnlyMaterialsNames));
                MessageUtils.beepAndShowWarning((Component)((Object)this), (String)message, (String)"Map Format Not Compatible");
            }
        }
    }

    private void addFile(boolean checkForNameOnlyMaterials, Set<String> nameOnlyMaterialsNames, File file) {
        try {
            WPObject object = CustomObjectManager.getInstance().loadObject(file);
            if (checkForNameOnlyMaterials) {
                HashSet materialNamesEncountered = new HashSet();
                object.visitBlocks((o, x, y, z, material) -> {
                    if (!materialNamesEncountered.contains(material.name)) {
                        materialNamesEncountered.add(material.name);
                        if (material.blockType == -1) {
                            nameOnlyMaterialsNames.add(material.name);
                        }
                    }
                    return true;
                });
            }
            this.listModel.addElement(object);
        }
        catch (IllegalArgumentException e) {
            logger.error("IllegalArgumentException while trying to load custom object " + file, (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage() + " while loading " + file.getName() + "; it was not added", "Illegal Argument", 0);
        }
        catch (IOException e) {
            logger.error("I/O error while trying to load custom object " + file, (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this), "I/O error while loading " + file.getName() + "; it was not added", "I/O Error", 0);
        }
    }

    private void removeFiles() {
        int[] selectedIndices = this.listObjects.getSelectedIndices();
        for (int i = selectedIndices.length - 1; i >= 0; --i) {
            this.listModel.removeElementAt(selectedIndices[i]);
        }
        this.settingsChanged();
        this.refreshLeafDecaySettings();
    }

    private void reloadObjects() {
        int[] indices;
        StringBuilder noFiles = new StringBuilder();
        StringBuilder notFound = new StringBuilder();
        StringBuilder errors = new StringBuilder();
        if (this.listObjects.getSelectedIndex() != -1) {
            indices = this.listObjects.getSelectedIndices();
        } else {
            indices = new int[this.listModel.getSize()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
        }
        CustomObjectManager customObjectManager = CustomObjectManager.getInstance();
        for (int index : indices) {
            WPObject object = this.listModel.getElementAt(index);
            File file = (File)object.getAttribute(WPObject.ATTRIBUTE_FILE);
            if (file != null) {
                if (file.isFile() && file.canRead()) {
                    try {
                        Map existingAttributes = object.getAttributes();
                        object = customObjectManager.loadObject(file);
                        if (existingAttributes != null) {
                            HashMap attributes = object.getAttributes();
                            if (attributes == null) {
                                attributes = new HashMap();
                            }
                            attributes.putAll(existingAttributes);
                            object.setAttributes(attributes);
                        }
                        this.listModel.setElementAt(object, index);
                    }
                    catch (IOException e) {
                        logger.error("I/O error while reloading " + file, (Throwable)e);
                        errors.append(file.getPath()).append('\n');
                    }
                    continue;
                }
                notFound.append(file.getPath()).append('\n');
                continue;
            }
            noFiles.append(object.getName()).append('\n');
        }
        if (noFiles.length() > 0 || notFound.length() > 0 || errors.length() > 0) {
            StringBuilder message = new StringBuilder();
            message.append("Not all files could be reloaded!\n");
            if (noFiles.length() > 0) {
                message.append("\nThe following objects came from an old layer and have no filename stored:\n");
                message.append((CharSequence)noFiles);
            }
            if (notFound.length() > 0) {
                message.append("\nThe following files were missing or not accessible:\n");
                message.append((CharSequence)notFound);
            }
            if (errors.length() > 0) {
                message.append("\nThe following files experienced I/O errors while loading:\n");
                message.append((CharSequence)errors);
            }
            JOptionPane.showMessageDialog((Component)((Object)this), message, "Not All Files Reloaded", 0);
        } else {
            MessageUtils.showInfo((Component)((Object)this), (String)(indices.length + " objects successfully reloaded"), (String)"Success");
        }
        this.refreshLeafDecaySettings();
    }

    private void editObjects() {
        ArrayList<WPObject> selectedObjects = new ArrayList<WPObject>(this.listObjects.getSelectedIndices().length);
        int[] selectedIndices = this.listObjects.getSelectedIndices();
        for (int i = selectedIndices.length - 1; i >= 0; --i) {
            selectedObjects.add(this.listModel.getElementAt(selectedIndices[i]));
        }
        EditObjectAttributes dialog = new EditObjectAttributes(SwingUtilities.getWindowAncestor((Component)((Object)this)), selectedObjects, this.colourScheme);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.settingsChanged();
            this.refreshLeafDecaySettings();
        }
    }

    private void refreshLeafDecaySettings() {
        if (this.listModel.isEmpty()) {
            this.labelLeafDecayTitle.setEnabled(false);
            this.labelEffectiveLeafDecaySetting.setEnabled(false);
            this.labelEffectiveLeafDecaySetting.setText("N/A");
            this.buttonSetDecay.setEnabled(false);
            this.buttonSetNoDecay.setEnabled(false);
            this.buttonReset.setEnabled(false);
            return;
        }
        boolean decayingLeavesFound = false;
        boolean nonDecayingLeavesFound = false;
        Enumeration<WPObject> e = this.listModel.elements();
        block5: while (e.hasMoreElements()) {
            WPObject object = e.nextElement();
            int leafDecayMode = (Integer)object.getAttribute(WPObject.ATTRIBUTE_LEAF_DECAY_MODE);
            switch (leafDecayMode) {
                case 1: {
                    object.prepareForExport(this.context.getDimension());
                    Point3i dim = object.getDimensions();
                    for (int x = 0; x < dim.x; ++x) {
                        for (int y = 0; y < dim.y; ++y) {
                            for (int z = 0; z < dim.z; ++z) {
                                if (!object.getMask(x, y, z)) continue;
                                Material material = object.getMaterial(x, y, z);
                                if (!material.leafBlock) continue;
                                if (material.is(Material.PERSISTENT)) {
                                    nonDecayingLeavesFound = true;
                                    if (!decayingLeavesFound) continue;
                                    break block5;
                                }
                                decayingLeavesFound = true;
                                if (nonDecayingLeavesFound) break block5;
                            }
                        }
                    }
                    continue block5;
                }
                case 3: {
                    nonDecayingLeavesFound = true;
                    if (!decayingLeavesFound) continue block5;
                    break block5;
                }
                case 2: {
                    decayingLeavesFound = true;
                    if (!nonDecayingLeavesFound) continue block5;
                    break block5;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        if (decayingLeavesFound) {
            this.labelLeafDecayTitle.setEnabled(true);
            this.labelEffectiveLeafDecaySetting.setEnabled(true);
            this.buttonSetNoDecay.setEnabled(true);
            this.buttonReset.setEnabled(true);
            if (nonDecayingLeavesFound) {
                this.labelEffectiveLeafDecaySetting.setText("<html>Decaying <i>and</i> non decaying leaves.</html>");
                this.buttonSetDecay.setEnabled(true);
            } else {
                this.labelEffectiveLeafDecaySetting.setText("<html>Leaves <b>do</b> decay.</html>");
                this.buttonSetDecay.setEnabled(false);
            }
        } else if (nonDecayingLeavesFound) {
            this.labelLeafDecayTitle.setEnabled(true);
            this.labelEffectiveLeafDecaySetting.setEnabled(true);
            this.labelEffectiveLeafDecaySetting.setText("<html>Leaves do <b>not</b> decay.</html>");
            this.buttonSetDecay.setEnabled(true);
            this.buttonSetNoDecay.setEnabled(false);
            this.buttonReset.setEnabled(true);
        } else {
            this.labelLeafDecayTitle.setEnabled(false);
            this.labelEffectiveLeafDecaySetting.setEnabled(false);
            this.labelEffectiveLeafDecaySetting.setText("N/A");
            this.buttonSetDecay.setEnabled(false);
            this.buttonSetNoDecay.setEnabled(false);
            this.buttonReset.setEnabled(false);
        }
    }

    private void setLeavesDecay() {
        Enumeration<WPObject> e = this.listModel.elements();
        while (e.hasMoreElements()) {
            WPObject object = e.nextElement();
            object.setAttribute(WPObject.ATTRIBUTE_LEAF_DECAY_MODE, (Serializable)Integer.valueOf(2));
        }
        this.refreshLeafDecaySettings();
    }

    private void setLeavesNoDecay() {
        Enumeration<WPObject> e = this.listModel.elements();
        while (e.hasMoreElements()) {
            WPObject object = e.nextElement();
            object.setAttribute(WPObject.ATTRIBUTE_LEAF_DECAY_MODE, (Serializable)Integer.valueOf(3));
        }
        this.refreshLeafDecaySettings();
    }

    private void resetLeafDecay() {
        Enumeration<WPObject> e = this.listModel.elements();
        while (e.hasMoreElements()) {
            WPObject object = e.nextElement();
            object.getAttributes().remove(WPObject.ATTRIBUTE_LEAF_DECAY_MODE.key);
        }
        this.refreshLeafDecaySettings();
    }

    private void updateBlocksPerAttempt() {
        int blocksAt50 = (Integer)this.spinnerBlocksPerAttempt.getValue();
        int blocksAt1 = blocksAt50 * 64;
        int blocksAt100 = Math.round((float)blocksAt50 / 3.515625f);
        StringBuilder sb = new StringBuilder();
        sb.append("one per ").append(this.numberFormat.format(blocksAt1)).append(" blocks at 1%");
        if (blocksAt100 <= 1) {
            sb.append("; one every block at 100%)");
        } else {
            sb.append("; one per ").append(this.numberFormat.format(blocksAt100)).append(" blocks at 100%)");
        }
        this.labelBlocksPerAttempt.setText(sb.toString());
    }

    private void initComponents() {
        this.buttonReloadAll = new JButton();
        this.jSeparator2 = new JSeparator();
        this.buttonEdit = new JButton();
        this.jPanel3 = new JPanel();
        this.labelLeafDecayTitle = new JLabel();
        this.labelEffectiveLeafDecaySetting = new JLabel();
        this.buttonSetDecay = new JButton();
        this.buttonSetNoDecay = new JButton();
        this.buttonReset = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.listObjects = new JList();
        this.jLabel6 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.fieldName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.buttonPickColour = new JButton();
        this.jLabel2 = new JLabel();
        this.buttonAddFile = new JButton();
        this.buttonRemoveFile = new JButton();
        this.jLabel7 = new JLabel();
        this.spinnerBlocksPerAttempt = new JSpinner();
        this.jLabel9 = new JLabel();
        this.labelBlocksPerAttempt = new JLabel();
        this.jLabel10 = new JLabel();
        this.buttonReloadAll.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/arrow_rotate_clockwise.png")));
        this.buttonReloadAll.setToolTipText("Reload all or selected objects from disk");
        this.buttonReloadAll.setEnabled(false);
        this.buttonReloadAll.setMargin(new Insets(2, 2, 2, 2));
        this.buttonReloadAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Bo2LayerEditor.this.buttonReloadAllActionPerformed(evt);
            }
        });
        this.jSeparator2.setOrientation(1);
        this.buttonEdit.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_edit.png")));
        this.buttonEdit.setToolTipText("Edit selected object(s) options");
        this.buttonEdit.setEnabled(false);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Bo2LayerEditor.this.buttonEditActionPerformed(evt);
            }
        });
        this.labelLeafDecayTitle.setText("Leaf decay settings for these objects:");
        this.labelEffectiveLeafDecaySetting.setText("<html>Leaves do <b>not</b> decay.</html>");
        this.labelEffectiveLeafDecaySetting.setEnabled(false);
        this.buttonSetDecay.setText("Set all to decay");
        this.buttonSetDecay.setToolTipText("Set all objects to decaying leaves");
        this.buttonSetDecay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Bo2LayerEditor.this.buttonSetDecayActionPerformed(evt);
            }
        });
        this.buttonSetNoDecay.setText("<html>Set all to <b>not</b> decay</html>");
        this.buttonSetNoDecay.setToolTipText("Set all objects to non decaying leaves");
        this.buttonSetNoDecay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Bo2LayerEditor.this.buttonSetNoDecayActionPerformed(evt);
            }
        });
        this.buttonReset.setText("Reset");
        this.buttonReset.setToolTipText("Reset leaf decay to object defaults");
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Bo2LayerEditor.this.buttonResetActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.labelEffectiveLeafDecaySetting, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelLeafDecayTitle).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.buttonSetDecay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSetNoDecay, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonReset))).addGap(0, 0, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.labelLeafDecayTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelEffectiveLeafDecaySetting, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonSetDecay).addComponent(this.buttonSetNoDecay, -2, -1, -2).addComponent(this.buttonReset))));
        this.listObjects.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Bo2LayerEditor.this.listObjectsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listObjects);
        this.jLabel6.setForeground(new Color(0, 0, 255));
        this.jLabel6.setText("<html><u>Get custom objects</u></html>");
        this.jLabel6.setCursor(new Cursor(12));
        this.jLabel6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Bo2LayerEditor.this.jLabel6MouseClicked(evt);
            }
        });
        this.jLabel1.setText("Define your custom object layer on this screen.");
        this.jLabel3.setText("Name:");
        this.fieldName.setColumns(10);
        this.jLabel4.setText("Colour:");
        this.jLabel5.setBackground(Color.orange);
        this.jLabel5.setText("                 ");
        this.jLabel5.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel5.setOpaque(true);
        this.buttonPickColour.setText("...");
        this.buttonPickColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Bo2LayerEditor.this.buttonPickColourActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldName, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPickColour))).addGap(0, 0, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.fieldName, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.buttonPickColour))));
        this.jLabel2.setText("Object(s):");
        this.buttonAddFile.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_add.png")));
        this.buttonAddFile.setToolTipText("Add one or more objects");
        this.buttonAddFile.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAddFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Bo2LayerEditor.this.buttonAddFileActionPerformed(evt);
            }
        });
        this.buttonRemoveFile.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_delete.png")));
        this.buttonRemoveFile.setToolTipText("Remove selected object(s)");
        this.buttonRemoveFile.setEnabled(false);
        this.buttonRemoveFile.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Bo2LayerEditor.this.buttonRemoveFileActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Sparseness:");
        this.spinnerBlocksPerAttempt.setModel(new SpinnerNumberModel(20, 1, 100000, 1));
        this.spinnerBlocksPerAttempt.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Bo2LayerEditor.this.spinnerBlocksPerAttemptStateChanged(evt);
            }
        });
        this.jLabel9.setText(" blocks (at 50% intensity;");
        this.labelBlocksPerAttempt.setText("one per x blocks at 1%; one per y blocks at 100%)");
        this.jLabel10.setText("one object per ");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonAddFile, GroupLayout.Alignment.TRAILING).addComponent(this.buttonRemoveFile, GroupLayout.Alignment.TRAILING).addComponent(this.buttonEdit, GroupLayout.Alignment.TRAILING).addComponent(this.buttonReloadAll, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel6, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelBlocksPerAttempt).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addGap(0, 0, 0).addComponent(this.spinnerBlocksPerAttempt, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel9))))).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonAddFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonReloadAll).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.spinnerBlocksPerAttempt, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelBlocksPerAttempt).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSeparator2).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2))));
    }

    private void buttonReloadAllActionPerformed(ActionEvent evt) {
        this.reloadObjects();
    }

    private void buttonEditActionPerformed(ActionEvent evt) {
        this.editObjects();
    }

    private void buttonSetDecayActionPerformed(ActionEvent evt) {
        this.setLeavesDecay();
    }

    private void buttonSetNoDecayActionPerformed(ActionEvent evt) {
        this.setLeavesNoDecay();
    }

    private void buttonResetActionPerformed(ActionEvent evt) {
        this.resetLeafDecay();
    }

    private void listObjectsMouseClicked(MouseEvent evt) {
        int row;
        if (evt.getClickCount() == 2 && (row = this.listObjects.getSelectedIndex()) != -1) {
            WPObject object = this.listModel.getElementAt(row);
            EditObjectAttributes dialog = new EditObjectAttributes(SwingUtilities.getWindowAncestor((Component)((Object)this)), object, this.colourScheme);
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                this.refreshLeafDecaySettings();
            }
        }
    }

    private void jLabel6MouseClicked(MouseEvent evt) {
        try {
            DesktopUtils.open((URL)new URL("https://www.worldpainter.net/doc/legacy/customobjects"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL exception while trying to open https://www.worldpainter.net/doc/legacy/customobjects", e);
        }
    }

    private void buttonPickColourActionPerformed(ActionEvent evt) {
        this.pickColour();
    }

    private void buttonAddFileActionPerformed(ActionEvent evt) {
        this.addFilesOrDirectory();
    }

    private void buttonRemoveFileActionPerformed(ActionEvent evt) {
        this.removeFiles();
    }

    private void spinnerBlocksPerAttemptStateChanged(ChangeEvent evt) {
        this.updateBlocksPerAttempt();
        this.settingsChanged();
    }
}

