/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import org.pepsoft.worldpainter.layers.LayerPreviewCreator;

public class PatternListCellRenderer
extends DefaultListCellRenderer {
    private final Map<LayerPreviewCreator.Pattern, Icon> iconCache = new HashMap<LayerPreviewCreator.Pattern, Icon>();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof LayerPreviewCreator.Pattern) {
            LayerPreviewCreator.Pattern pattern = (LayerPreviewCreator.Pattern)value;
            Icon icon = this.iconCache.get(pattern);
            if (icon == null) {
                icon = new ImageIcon(pattern.getIcon());
                this.iconCache.put(pattern, icon);
            }
            this.setIcon(icon);
            this.setText(pattern.getDescription());
        }
        return this;
    }
}

