/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.BandedHeightMap;
import org.pepsoft.worldpainter.heightMaps.BitmapHeightMap;
import org.pepsoft.worldpainter.heightMaps.ConstantHeightMap;
import org.pepsoft.worldpainter.heightMaps.NinePatchHeightMap;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.heightMaps.ShelvingHeightMap;
import org.pepsoft.worldpainter.heightMaps.TransformingHeightMap;

public class HeightMapPropertiesPanel
extends JPanel {
    private HeightMap heightMap;
    private HeightMapListener listener;

    public HeightMapPropertiesPanel() {
        this.setLayout(new GridBagLayout());
    }

    public HeightMap getHeightMap() {
        return this.heightMap;
    }

    public void setHeightMap(HeightMap heightMap) {
        this.heightMap = heightMap;
        this.removeAll();
        this.addField("Type:", heightMap.getClass().getSimpleName());
        this.addField("Name:", heightMap, "name");
        if (heightMap instanceof ConstantHeightMap) {
            this.addField("Height: ", heightMap, "height");
        } else if (heightMap instanceof NinePatchHeightMap) {
            this.addField("Height:", heightMap, "height");
            this.addField("Inner size X:", heightMap, "innerSizeX", 0, null);
            this.addField("Inner size Y:", heightMap, "innerSizeY", 0, null);
            this.addField("Border size:", heightMap, "borderSize", 0, null);
            this.addField("Coast size:", heightMap, "coastSize", 0, null);
        } else if (heightMap instanceof NoiseHeightMap) {
            this.addField("Height:", heightMap, "height", Float.valueOf(0.0f), null);
            this.addField("Scale:", heightMap, "scale", 0.0, null);
            this.addField("Octaves:", heightMap, "octaves", 1, 8);
        } else if (heightMap instanceof TransformingHeightMap) {
            this.addField("X scale:", heightMap, "scaleX", 0, null);
            this.addField("Y scale:", heightMap, "scaleY", 0, null);
            this.addField("X offset:", heightMap, "offsetX");
            this.addField("Y offset:", heightMap, "offsetY");
            this.addField("Rotation:", heightMap, "rotation");
        } else if (heightMap instanceof BitmapHeightMap) {
            BufferedImage image = ((BitmapHeightMap)heightMap).getImage();
            int noOfChannels = image.getColorModel().getNumComponents();
            this.addField("Channel:", heightMap, "channel", 0, noOfChannels - 1);
            this.addField("Repeat:", heightMap, "repeat");
            this.addField("Bicubic scaling:", heightMap, "smoothScaling");
        } else if (heightMap instanceof BandedHeightMap) {
            this.addField("Segment 1 length:", heightMap, "segment1Length");
            this.addField("Segment 1 end height:", heightMap, "segment1EndHeight");
            this.addField("Segment 2 length:", heightMap, "segment2Length");
            this.addField("Segment 2 end height:", heightMap, "segment2EndHeight");
            this.addField("Smooth:", heightMap, "smooth");
        } else if (heightMap instanceof ShelvingHeightMap) {
            this.addField("Shelve height:", heightMap, "shelveHeight");
            this.addField("Shelve strength:", heightMap, "shelveStrength");
        }
        double[] range = heightMap.getRange();
        this.addField("Range:", "[" + range[0] + ", " + range[1] + "]");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weighty = 1.0;
        this.add(Box.createGlue(), constraints);
        this.validate();
        this.repaint();
    }

    public HeightMapListener getListener() {
        return this.listener;
    }

    public void setListener(HeightMapListener listener) {
        this.listener = listener;
    }

    private void addField(String name, String text) {
        this.addField(name, null, null, null, null, text);
    }

    private void addField(String name, Object bean, String propertyName) {
        this.addField(name, bean, propertyName, null, null, null);
    }

    private void addField(String name, Object bean, String propertyName, Number min, Number max) {
        this.addField(name, bean, propertyName, min, max, null);
    }

    private void addField(String name, final Object bean, final String propertyName, Number min, Number max, String text) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.fill = 2;
        constraints.anchor = 512;
        JLabel label = new JLabel(name);
        this.add((Component)label, constraints);
        if (text != null) {
            constraints.gridwidth = 0;
            constraints.weightx = 1.0;
            JLabel valueLabel = new JLabel();
            valueLabel.setText(text);
            this.add((Component)valueLabel, constraints);
            return;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (final PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equalsIgnoreCase(propertyName)) continue;
                constraints.gridwidth = 0;
                constraints.weightx = 1.0;
                if (propertyDescriptor.getWriteMethod() == null) {
                    JLabel valueLabel = new JLabel();
                    Object value = propertyDescriptor.getReadMethod().invoke(bean, new Object[0]);
                    if (value != null) {
                        valueLabel.setText(value.toString());
                    }
                    this.add((Component)valueLabel, constraints);
                    return;
                }
                Class<?> propertyType = propertyDescriptor.getPropertyType();
                if (propertyType == String.class) {
                    final JTextField field = new JTextField();
                    field.setText((String)propertyDescriptor.getReadMethod().invoke(bean, new Object[0]));
                    field.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void insertUpdate(DocumentEvent event) {
                            this.updateProperty();
                        }

                        @Override
                        public void removeUpdate(DocumentEvent event) {
                            this.updateProperty();
                        }

                        @Override
                        public void changedUpdate(DocumentEvent event) {
                            this.updateProperty();
                        }

                        private void updateProperty() {
                            try {
                                propertyDescriptor.getWriteMethod().invoke(bean, field.getText());
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                            HeightMapPropertiesPanel.this.updateListener(propertyName);
                        }
                    });
                    this.add((Component)field, constraints);
                } else if (propertyType == Boolean.TYPE || propertyType == Boolean.class) {
                    JCheckBox checkBox = new JCheckBox(" ");
                    checkBox.setSelected(Boolean.TRUE.equals(propertyDescriptor.getReadMethod().invoke(bean, new Object[0])));
                    checkBox.addActionListener(event -> {
                        try {
                            propertyDescriptor.getWriteMethod().invoke(bean, checkBox.isSelected());
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                        this.updateListener(propertyName);
                    });
                    this.add((Component)checkBox, constraints);
                } else if (Number.class.isAssignableFrom(propertyType) || propertyType.isPrimitive() && propertyType != Boolean.TYPE && propertyType != Character.TYPE) {
                    JSpinner spinner = new JSpinner(new SpinnerNumberModel((Number)propertyDescriptor.getReadMethod().invoke(bean, new Object[0]), (Comparable)((Object)min), (Comparable)((Object)max), (Number)1));
                    spinner.addChangeListener(event -> {
                        try {
                            propertyDescriptor.getWriteMethod().invoke(bean, spinner.getValue());
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                        this.updateListener(propertyName);
                    });
                    this.add((Component)spinner, constraints);
                } else {
                    throw new IllegalArgumentException("Property " + propertyName + " of type " + propertyType.getSimpleName() + " not supported");
                }
                return;
            }
            throw new IllegalArgumentException("Bean of type " + bean.getClass().getSimpleName() + " has no property named " + propertyName);
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateListener(String propertyName) {
        if (this.listener != null) {
            this.listener.heightMapChanged(this.heightMap, propertyName);
        }
    }

    public static interface HeightMapListener {
        public void heightMapChanged(HeightMap var1, String var2);
    }
}

