/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.brushes;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RescaleOp;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import javax.imageio.ImageIO;
import org.pepsoft.worldpainter.brushes.AbstractBrush;
import org.pepsoft.worldpainter.brushes.BrushShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitmapBrush
extends AbstractBrush {
    private final File imageFile;
    private final BufferedImage image;
    private Reference<BufferedImage> imageReference;
    private Reference<Data> dataReference;
    private int radius;
    private int diameter = 1;
    private float level = 1.0f;
    private RescaleOp rescaleOp = new RescaleOp(1.0f, 0.0f, null);
    private static final Logger logger = LoggerFactory.getLogger(BitmapBrush.class);

    public BitmapBrush(InputStream in, String name) {
        super(name);
        this.imageFile = null;
        this.image = this.loadImage(in);
        this.imageReference = null;
    }

    public BitmapBrush(File imageFile) {
        super(imageFile.getName());
        if (!imageFile.isFile()) {
            throw new IllegalArgumentException(imageFile + " is not a file or does not exist");
        }
        if (!imageFile.canRead()) {
            throw new IllegalArgumentException(imageFile + " is not readable");
        }
        this.imageFile = imageFile;
        this.image = null;
    }

    public float getStrength(int dx, int dy) {
        return (float)this.getData().buffer.getElem(0, dx + this.radius + (dy + this.radius) * this.diameter) / 255.0f;
    }

    public float getFullStrength(int dx, int dy) {
        return (float)this.getData().fullStrengthBuffer.getElem(0, dx + this.radius + (dy + this.radius) * this.diameter) / 255.0f;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        if (radius != this.radius) {
            logger.debug("{{}} radius going from {} to {}", new Object[]{this.getName(), this.radius, radius});
            this.radius = radius;
            this.diameter = radius * 2 + 1;
            this.dataReference = null;
        }
    }

    public float getLevel() {
        return this.level;
    }

    public void setLevel(float level) {
        if (level != this.level) {
            logger.debug("{{}} level going from {} to {}", new Object[]{this.getName(), Float.valueOf(this.level), Float.valueOf(level)});
            this.level = level;
            this.rescaleOp = new RescaleOp(level, 0.0f, null);
            this.dataReference = null;
        }
    }

    public BrushShape getBrushShape() {
        return BrushShape.BITMAP;
    }

    private Data getData() {
        Data data;
        Data data2 = data = this.dataReference != null ? this.dataReference.get() : null;
        if (data == null) {
            logger.debug("{{}} data not present; (re)creating data", (Object)this.getName());
            data = this.createData();
            this.dataReference = new SoftReference<Data>(data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Data createData() {
        BufferedImage image = this.image;
        if (image == null) {
            BufferedImage bufferedImage = image = this.imageReference != null ? this.imageReference.get() : null;
            if (image == null) {
                logger.debug("{{}} image not present; (re)loading image {}", (Object)this.getName(), (Object)this.imageFile);
                image = this.loadImage(this.imageFile);
                this.imageReference = new SoftReference<BufferedImage>(image);
            }
        }
        BufferedImage fullStrengthMask = new BufferedImage(this.diameter, this.diameter, 10);
        Graphics2D g2 = fullStrengthMask.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(image, 0, 0, this.diameter, this.diameter, null);
        }
        finally {
            g2.dispose();
        }
        Data data = new Data();
        data.fullStrengthBuffer = (DataBufferByte)fullStrengthMask.getRaster().getDataBuffer();
        if (this.level < 1.0f) {
            BufferedImage mask = this.rescaleOp.filter(fullStrengthMask, null);
            data.buffer = (DataBufferByte)mask.getRaster().getDataBuffer();
        } else {
            data.buffer = data.fullStrengthBuffer;
        }
        return data;
    }

    private BufferedImage loadImage(File imageFile) {
        try {
            return ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error reading image file " + imageFile, e);
        }
    }

    private BufferedImage loadImage(InputStream in) {
        try {
            return ImageIO.read(in);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error reading image from classpath", e);
        }
    }

    static class Data {
        DataBufferByte fullStrengthBuffer;
        DataBufferByte buffer;

        Data() {
        }
    }
}

