/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.worldpainter.NoiseSettings;

public class NoiseSettingsEditor
extends JPanel {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner spinnerOctaves;
    private JSpinner spinnerRange;
    private JSpinner spinnerScale;
    private long seed;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final long serialVersionUID = 1L;

    public NoiseSettingsEditor() {
        this.initComponents();
        JSpinner.NumberEditor scaleEditor = new JSpinner.NumberEditor(this.spinnerScale, "0");
        scaleEditor.getTextField().setColumns(3);
        this.spinnerScale.setEditor(scaleEditor);
    }

    public NoiseSettings getNoiseSettings() {
        NoiseSettings noiseSettings = new NoiseSettings();
        noiseSettings.setRange(((Integer)this.spinnerRange.getValue()).intValue());
        noiseSettings.setRoughness(((Integer)this.spinnerOctaves.getValue()).intValue());
        noiseSettings.setScale((float)((Integer)this.spinnerScale.getValue()).intValue() / 100.0f);
        noiseSettings.setSeed(this.seed);
        return noiseSettings;
    }

    public void setNoiseSettings(NoiseSettings noiseSettings) {
        this.spinnerRange.setValue(noiseSettings.getRange());
        this.spinnerOctaves.setValue(noiseSettings.getRoughness());
        this.spinnerScale.setValue((int)(noiseSettings.getScale() * 100.0f));
        this.seed = noiseSettings.getSeed();
        this.setControlStates();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setControlStates();
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.spinnerRange.getBaseline(width, height);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void setControlStates() {
        boolean enabled = this.isEnabled();
        boolean flat = (Integer)this.spinnerRange.getValue() == 0;
        this.spinnerRange.setEnabled(enabled);
        this.spinnerScale.setEnabled(enabled && !flat);
        this.spinnerOctaves.setEnabled(enabled && !flat);
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.spinnerRange = new JSpinner();
        this.jLabel2 = new JLabel();
        this.spinnerScale = new JSpinner();
        this.jLabel3 = new JLabel();
        this.spinnerOctaves = new JSpinner();
        this.jLabel1.setLabelFor(this.spinnerRange);
        this.jLabel1.setText("range:");
        this.jLabel1.setToolTipText("The vertical height difference, 0 being perfectly smooth");
        this.spinnerRange.setModel(new SpinnerNumberModel(0, 0, 256, 1));
        this.spinnerRange.setToolTipText("The vertical height difference, 0 being perfectly smooth");
        this.spinnerRange.addChangeListener(this::spinnerRangeStateChanged);
        this.jLabel2.setLabelFor(this.spinnerScale);
        this.jLabel2.setText(", scale:");
        this.jLabel2.setToolTipText("The horizontal scale, lower percentages creating thinner peaks and troughs");
        this.spinnerScale.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(1), null, (Number)1));
        this.spinnerScale.setToolTipText("The horizontal scale, lower percentages creating thinner peaks and troughs");
        this.spinnerScale.setEnabled(false);
        this.spinnerScale.addChangeListener(this::spinnerScaleStateChanged);
        this.jLabel3.setLabelFor(this.spinnerOctaves);
        this.jLabel3.setText("%, roughness:");
        this.jLabel3.setToolTipText("How random or chaotic the variations are, 0 being the smoothest");
        this.spinnerOctaves.setModel(new SpinnerNumberModel(0, 0, 3, 1));
        this.spinnerOctaves.setToolTipText("How random or chaotic the variations are, 0 being the smoothest");
        this.spinnerOctaves.setEnabled(false);
        this.spinnerOctaves.addChangeListener(this::spinnerOctavesStateChanged);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerRange, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerScale, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerOctaves, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.spinnerRange, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.spinnerScale, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.spinnerOctaves, -2, -1, -2)));
    }

    private void spinnerRangeStateChanged(ChangeEvent evt) {
        this.setControlStates();
        this.fireChangeEvent();
    }

    private void spinnerScaleStateChanged(ChangeEvent evt) {
        this.fireChangeEvent();
    }

    private void spinnerOctavesStateChanged(ChangeEvent evt) {
        this.fireChangeEvent();
    }
}

