/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.MixedMaterial;

public final class MixedMaterialTableModel
implements TableModel,
Cloneable {
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private MixedMaterial.Row[] rows;
    private MixedMaterial.Mode mode;
    public static final int COLUMN_MATERIAL = 0;
    public static final int COLUMN_COUNT = 1;
    public static final int COLUMN_SCALE = 2;
    private static final String[] COLUMN_NAMES = new String[]{"Material", "Count", "Scale (in %)"};
    private static final Class<?>[] COLUMN_TYPES = new Class[]{Material.class, Integer.class, Integer.class};

    public MixedMaterialTableModel(MixedMaterial material) {
        this.rows = (MixedMaterial.Row[])material.getRows().clone();
        this.mode = material.getMode();
    }

    public MixedMaterialTableModel() {
        this.rows = new MixedMaterial.Row[]{new MixedMaterial.Row(Material.DIRT, 3, 1.0f)};
        this.mode = MixedMaterial.Mode.NOISE;
    }

    public void addMaterial(MixedMaterial.Row row) {
        this.rows = Arrays.copyOf(this.rows, this.rows.length + 1);
        this.rows[this.rows.length - 1] = row;
        TableModelEvent event = new TableModelEvent(this, 0, 0, 1);
        this.fireEvent(event);
        event = new TableModelEvent(this, this.rows.length - 1, this.rows.length - 1, -1, 1);
        this.fireEvent(event);
    }

    public void removeMaterial(int rowIndex) {
        if (this.rows.length == 1) {
            throw new IllegalArgumentException("Can't remove last row");
        }
        MixedMaterial.Row[] oldRows = this.rows;
        this.rows = new MixedMaterial.Row[this.rows.length - 1];
        System.arraycopy(oldRows, 0, this.rows, 0, rowIndex);
        System.arraycopy(oldRows, rowIndex + 1, this.rows, rowIndex, this.rows.length - rowIndex);
        TableModelEvent event = new TableModelEvent(this);
        this.fireEvent(event);
    }

    public MixedMaterial.Row[] getRows() {
        return this.rows;
    }

    public void setMode(MixedMaterial.Mode mode) {
        if (mode != this.mode) {
            this.mode = mode;
            TableModelEvent event = new TableModelEvent(this, -1);
            this.fireEvent(event);
        }
    }

    public MixedMaterial.Mode getMode() {
        return this.mode;
    }

    public int getAverageCount() {
        return (int)Math.round(Arrays.stream(this.rows).mapToInt(row -> row.occurrence).average().orElse(0.0));
    }

    @Override
    public int getRowCount() {
        return this.rows.length;
    }

    @Override
    public int getColumnCount() {
        return this.mode == MixedMaterial.Mode.BLOBS ? COLUMN_NAMES.length : COLUMN_NAMES.length - 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0 && (this.rows.length > 1 || columnIndex != 1 || this.mode == MixedMaterial.Mode.LAYERED);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MixedMaterial.Row row = this.rows[rowIndex];
        switch (columnIndex) {
            case 0: {
                return row.material;
            }
            case 1: {
                return row.occurrence;
            }
            case 2: {
                return Math.round(row.scale * 100.0f);
            }
        }
        throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.rows.length == 1 && columnIndex == 1 && this.mode != MixedMaterial.Mode.LAYERED) {
            throw new IllegalArgumentException("Uneditable cell");
        }
        MixedMaterial.Row row = this.rows[rowIndex];
        switch (columnIndex) {
            case 0: {
                row = new MixedMaterial.Row((Material)aValue, row.occurrence, row.scale);
                break;
            }
            case 1: {
                row = new MixedMaterial.Row(row.material, ((Integer)aValue).intValue(), row.scale);
                break;
            }
            case 2: {
                row = new MixedMaterial.Row(row.material, row.occurrence, (float)((Integer)aValue).intValue() / 100.0f);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
            }
        }
        this.rows[rowIndex] = row;
        TableModelEvent event = new TableModelEvent(this, rowIndex, rowIndex, columnIndex);
        this.fireEvent(event);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public MixedMaterialTableModel clone() {
        MixedMaterialTableModel clone = new MixedMaterialTableModel();
        clone.mode = this.mode;
        clone.rows = (MixedMaterial.Row[])this.rows.clone();
        return clone;
    }

    private void fireEvent(TableModelEvent event) {
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }
}

