/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import org.pepsoft.util.ObservableBoolean;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.swing.ProgressDialog;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.BiomeListCellRenderer;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.LayerListCellRenderer;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.WPDialogWithPaintSelection;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.biomeschemes.BiomeHelper;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.NotPresentBlock;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.panels.BrushOptions;
import org.pepsoft.worldpainter.selection.SelectionBlock;
import org.pepsoft.worldpainter.selection.SelectionChunk;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;
import org.pepsoft.worldpainter.tools.Eyedropper;

public class FillDialog
extends WPDialogWithPaintSelection
implements BrushOptions.Listener,
BrushOptions.MapSelectionListener {
    private BrushOptions brushOptions1;
    private JButton buttonCancel;
    private JButton buttonFill;
    private JButton buttonFillBiomeSelectOnMap;
    private JButton buttonFillLayerSelectOnMap;
    private JButton buttonFillTerrainSelectOnMap;
    private ButtonGroup buttonGroup1;
    private JButton buttonInvertLayerSelectOnMap;
    private JButton buttonRemoveLayerSelectOnMap;
    private JCheckBox checkBoxKeepOpen;
    private JComboBox comboBoxBiome;
    private JComboBox comboBoxClearLayer;
    private JComboBox comboBoxInvertLayer;
    private JComboBox comboBoxSetLayer;
    private JComboBox comboBoxTerrain;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JRadioButton radioButtonAddToSelection;
    private JRadioButton radioButtonBiome;
    private JRadioButton radioButtonClearLayer;
    private JRadioButton radioButtonInvertLayer;
    private JRadioButton radioButtonMakeBiomesPermanent;
    private JRadioButton radioButtonRemoveFromSelection;
    private JRadioButton radioButtonResetBiomes;
    private JRadioButton radioButtonResetTerrain;
    private JRadioButton radioButtonResetWater;
    private JRadioButton radioButtonSetLayer;
    private JRadioButton radioButtonTerrain;
    private JSlider sliderLayerValue;
    private final ColourScheme colourScheme;
    private final Dimension dimension;
    private final BiomeHelper biomeHelper;
    private final WorldPainterView view;
    private Filter filter;
    private static final long serialVersionUID = 1L;

    public FillDialog(App app, Dimension dimension, Layer[] layers, ColourScheme colourScheme, Integer[] biomes, CustomBiomeManager customBiomeManager, WorldPainterView view, ObservableBoolean selectionState) {
        super((Window)app);
        this.dimension = dimension;
        this.colourScheme = colourScheme;
        this.view = view;
        Platform platform = dimension.getWorld().getPlatform();
        this.biomeHelper = new BiomeHelper(colourScheme, customBiomeManager, platform);
        this.initComponents();
        this.brushOptions1.setColourScheme(colourScheme);
        this.brushOptions1.setCustomBiomeManager(customBiomeManager);
        this.brushOptions1.setPlatform(platform);
        this.brushOptions1.setMinHeight(dimension.getMinHeight());
        this.brushOptions1.setMaxHeight(dimension.getMaxHeight());
        this.brushOptions1.setSelectionState(selectionState);
        this.comboBoxBiome.setModel(new DefaultComboBoxModel<Integer>(biomes));
        this.comboBoxBiome.setRenderer(new BiomeListCellRenderer(colourScheme, customBiomeManager, platform));
        this.comboBoxSetLayer.setModel(new DefaultComboBoxModel<Layer>(layers));
        this.comboBoxSetLayer.setRenderer(new LayerListCellRenderer());
        Set layersInUse = dimension.getAllLayers(false);
        layersInUse.removeAll(Arrays.asList(Biome.INSTANCE, FloodWithLava.INSTANCE, SelectionBlock.INSTANCE, SelectionChunk.INSTANCE, NotPresent.INSTANCE, NotPresentBlock.INSTANCE));
        if (!layersInUse.isEmpty()) {
            this.comboBoxClearLayer.setModel(new DefaultComboBoxModel<Layer>(layersInUse.toArray(new Layer[layersInUse.size()])));
            this.comboBoxClearLayer.setRenderer(new LayerListCellRenderer());
        } else {
            this.comboBoxClearLayer.setEnabled(false);
            this.radioButtonClearLayer.setEnabled(false);
        }
        this.comboBoxInvertLayer.setModel(new DefaultComboBoxModel<Layer>(layers));
        this.comboBoxInvertLayer.setRenderer(new LayerListCellRenderer());
        this.brushOptions1.setListener(this);
        this.brushOptions1.setMapSelectionListener(this);
        this.getRootPane().setDefaultButton(this.buttonFill);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(app);
        this.setControlStates();
    }

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    @Override
    public void filterChanged(Filter newFilter) {
        this.filter = newFilter;
        this.pack();
    }

    @Override
    public void mapSelectionRequested(final String descriptor) {
        this.selectFromMap(null, new Eyedropper.SelectionListener(){

            @Override
            public void terrainSelected(Terrain terrain) {
                switch (descriptor) {
                    case "onlyOn": {
                        FillDialog.this.brushOptions1.setOnlyOn(terrain);
                        break;
                    }
                    case "exceptOn": {
                        FillDialog.this.brushOptions1.setExceptOn(terrain);
                    }
                }
            }

            @Override
            public void layerSelected(Layer layer, int value) {
                switch (descriptor) {
                    case "onlyOn": {
                        FillDialog.this.brushOptions1.setOnlyOn(layer, value);
                        break;
                    }
                    case "exceptOn": {
                        FillDialog.this.brushOptions1.setExceptOn(layer, value);
                    }
                }
            }

            @Override
            public void selectionCancelled(boolean byUser) {
            }
        });
    }

    private void setControlStates() {
        this.comboBoxTerrain.setEnabled(this.radioButtonTerrain.isSelected());
        this.buttonFillTerrainSelectOnMap.setEnabled(this.radioButtonTerrain.isSelected());
        this.comboBoxSetLayer.setEnabled(this.radioButtonSetLayer.isSelected());
        this.buttonFillLayerSelectOnMap.setEnabled(this.radioButtonSetLayer.isSelected());
        this.sliderLayerValue.setEnabled(this.radioButtonSetLayer.isSelected() && (((Layer)this.comboBoxSetLayer.getSelectedItem()).getDataSize() == Layer.DataSize.BYTE || ((Layer)this.comboBoxSetLayer.getSelectedItem()).getDataSize() == Layer.DataSize.NIBBLE));
        this.comboBoxClearLayer.setEnabled(this.radioButtonClearLayer.isSelected());
        this.buttonRemoveLayerSelectOnMap.setEnabled(this.radioButtonClearLayer.isSelected());
        this.comboBoxInvertLayer.setEnabled(this.radioButtonInvertLayer.isSelected());
        this.buttonInvertLayerSelectOnMap.setEnabled(this.radioButtonInvertLayer.isSelected());
        this.comboBoxBiome.setEnabled(this.radioButtonBiome.isSelected());
        this.buttonFillBiomeSelectOnMap.setEnabled(this.radioButtonBiome.isSelected());
        this.buttonFill.setEnabled(this.radioButtonTerrain.isSelected() || this.radioButtonSetLayer.isSelected() || this.radioButtonClearLayer.isSelected() || this.radioButtonInvertLayer.isSelected() || this.radioButtonBiome.isSelected() || this.radioButtonResetBiomes.isSelected() || this.radioButtonResetWater.isSelected() || this.radioButtonResetTerrain.isSelected() || this.radioButtonMakeBiomesPermanent.isSelected() || this.radioButtonAddToSelection.isSelected() || this.radioButtonRemoveFromSelection.isSelected());
    }

    private void fill() {
        this.dimension.setEventsInhibited(true);
        this.dimension.rememberChanges();
        this.view.setInhibitUpdates(true);
        try {
            Dimension result = (Dimension)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Dimension>(){

                public String getName() {
                    if (FillDialog.this.radioButtonTerrain.isSelected()) {
                        return "Filling with " + ((Terrain)FillDialog.this.comboBoxTerrain.getSelectedItem()).getName();
                    }
                    if (FillDialog.this.radioButtonSetLayer.isSelected()) {
                        return "Filling with " + ((Layer)FillDialog.this.comboBoxSetLayer.getSelectedItem()).getName();
                    }
                    if (FillDialog.this.radioButtonClearLayer.isSelected()) {
                        return "Clearing " + ((Layer)FillDialog.this.comboBoxClearLayer.getSelectedItem()).getName();
                    }
                    if (FillDialog.this.radioButtonInvertLayer.isSelected()) {
                        return "Inverting " + ((Layer)FillDialog.this.comboBoxInvertLayer.getSelectedItem()).getName();
                    }
                    if (FillDialog.this.radioButtonBiome.isSelected()) {
                        return "Filling with " + FillDialog.this.biomeHelper.getBiomeName((Integer)FillDialog.this.comboBoxBiome.getSelectedItem());
                    }
                    if (FillDialog.this.radioButtonResetBiomes.isSelected()) {
                        return "Resetting biomes to automatic";
                    }
                    if (FillDialog.this.radioButtonResetWater.isSelected()) {
                        return "Resetting water or lava";
                    }
                    if (FillDialog.this.radioButtonResetTerrain.isSelected()) {
                        return "Resetting terrain types";
                    }
                    if (FillDialog.this.radioButtonMakeBiomesPermanent.isSelected()) {
                        return "Making automatic biomes permanent";
                    }
                    if (FillDialog.this.radioButtonAddToSelection.isSelected()) {
                        return "Adding to selection";
                    }
                    if (FillDialog.this.radioButtonRemoveFromSelection.isSelected()) {
                        return "Removing from selection";
                    }
                    throw new InternalError();
                }

                public Dimension execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                    if (FillDialog.this.radioButtonTerrain.isSelected()) {
                        FillDialog.this.fillWithTerrain(progressReceiver);
                    } else if (FillDialog.this.radioButtonSetLayer.isSelected()) {
                        FillDialog.this.fillWithLayer(progressReceiver);
                    } else if (FillDialog.this.radioButtonClearLayer.isSelected()) {
                        FillDialog.this.clearLayer(progressReceiver);
                    } else if (FillDialog.this.radioButtonInvertLayer.isSelected()) {
                        FillDialog.this.invertLayer(progressReceiver);
                    } else if (FillDialog.this.radioButtonBiome.isSelected()) {
                        FillDialog.this.fillWithBiome(progressReceiver);
                    } else if (FillDialog.this.radioButtonResetBiomes.isSelected()) {
                        FillDialog.this.resetBiomes(progressReceiver);
                    } else if (FillDialog.this.radioButtonResetWater.isSelected()) {
                        FillDialog.this.resetWater(progressReceiver);
                    } else if (FillDialog.this.radioButtonResetTerrain.isSelected()) {
                        FillDialog.this.resetTerrain(progressReceiver);
                    } else if (FillDialog.this.radioButtonMakeBiomesPermanent.isSelected()) {
                        FillDialog.this.makeAutoBiomesPermanent(progressReceiver);
                    } else if (FillDialog.this.radioButtonAddToSelection.isSelected()) {
                        FillDialog.this.addToSelection(progressReceiver);
                    } else if (FillDialog.this.radioButtonRemoveFromSelection.isSelected()) {
                        FillDialog.this.removeFromSelection(progressReceiver);
                    }
                    return FillDialog.this.dimension;
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
            if (result == null) {
                if (this.dimension.undoChanges()) {
                    this.dimension.clearRedo();
                }
                if (!this.checkBoxKeepOpen.isSelected()) {
                    this.cancel();
                }
            } else {
                this.dimension.armSavePoint();
                if (!this.checkBoxKeepOpen.isSelected()) {
                    this.ok();
                } else {
                    this.buttonCancel.setText("Close");
                }
            }
        }
        finally {
            this.view.setInhibitUpdates(false);
            this.dimension.setEventsInhibited(false);
        }
    }

    private void fillWithTerrain(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        Terrain terrain = (Terrain)this.comboBoxTerrain.getSelectedItem();
        this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
            int worldTileX = tile.getX() << 7;
            int worldTileY = tile.getY() << 7;
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    boolean set;
                    if (this.filter == null) {
                        set = true;
                    } else {
                        float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                        boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                    }
                    if (!set || tile.getTerrain(x, y) == terrain) continue;
                    tile.setTerrain(x, y, terrain);
                }
            }
        }, progressReceiver);
    }

    private void fillWithLayer(ProgressReceiver progressReceiver) throws UnsupportedOperationException, ProgressReceiver.OperationCancelled {
        Layer layer = (Layer)this.comboBoxSetLayer.getSelectedItem();
        if (layer.getDataSize() == Layer.DataSize.NIBBLE) {
            int baseLayerValue = Math.round((float)(this.sliderLayerValue.getValue() + 2) / 6.667f);
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        int layerValue = this.filter == null ? baseLayerValue : (int)(this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f) * (float)baseLayerValue);
                        if (tile.getLayerValue(layer, x, y) >= layerValue) continue;
                        tile.setLayerValue(layer, x, y, layerValue);
                    }
                }
            }, progressReceiver);
        } else if (layer.getDataSize() == Layer.DataSize.BIT) {
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        boolean set;
                        if (this.filter == null) {
                            set = true;
                        } else {
                            float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                            boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                        }
                        if (!set || tile.getBitLayerValue(layer, x, y)) continue;
                        tile.setBitLayerValue(layer, x, y, true);
                    }
                }
            }, progressReceiver);
        } else if (layer.getDataSize() == Layer.DataSize.BIT_PER_CHUNK) {
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; x += 16) {
                    for (int y = 0; y < 128; y += 16) {
                        boolean set;
                        if (this.filter == null) {
                            set = true;
                        } else {
                            float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                            boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                        }
                        if (!set || tile.getBitLayerValue(layer, x, y)) continue;
                        tile.setBitLayerValue(layer, x, y, true);
                    }
                }
            }, progressReceiver);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void clearLayer(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        Layer layer = (Layer)this.comboBoxClearLayer.getSelectedItem();
        if (this.filter == null) {
            this.dimension.clearLayerData(layer);
        } else if (layer.getDataSize() == Layer.DataSize.NIBBLE) {
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        int layerValue;
                        int oldLayervalue = tile.getLayerValue(layer, x, y);
                        if (oldLayervalue == (layerValue = this.filter == null ? 0 : Math.min(oldLayervalue, 15 - (int)(this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f) * 15.0f)))) continue;
                        tile.setLayerValue(layer, x, y, layerValue);
                    }
                }
            }, progressReceiver);
        } else if (layer.getDataSize() == Layer.DataSize.BIT) {
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        boolean set;
                        if (this.filter == null) {
                            set = true;
                        } else {
                            float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                            boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                        }
                        if (!set || !tile.getBitLayerValue(layer, x, y)) continue;
                        tile.setBitLayerValue(layer, x, y, false);
                    }
                }
            }, progressReceiver);
        } else if (layer.getDataSize() == Layer.DataSize.BIT_PER_CHUNK) {
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; x += 16) {
                    for (int y = 0; y < 128; y += 16) {
                        boolean set;
                        if (this.filter == null) {
                            set = true;
                        } else {
                            float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                            boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                        }
                        if (!set || !tile.getBitLayerValue(layer, x, y)) continue;
                        tile.setBitLayerValue(layer, x, y, false);
                    }
                }
            }, progressReceiver);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void invertLayer(ProgressReceiver progressReceiver) throws UnsupportedOperationException, ProgressReceiver.OperationCancelled {
        Layer layer = (Layer)this.comboBoxInvertLayer.getSelectedItem();
        if (layer.getDataSize() == Layer.DataSize.NIBBLE) {
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        boolean set;
                        if (this.filter == null) {
                            set = true;
                        } else {
                            float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                            boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                        }
                        if (!set) continue;
                        tile.setLayerValue(layer, x, y, 15 - tile.getLayerValue(layer, x, y));
                    }
                }
            }, progressReceiver);
        } else if (layer.getDataSize() == Layer.DataSize.BIT) {
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        boolean set;
                        if (this.filter == null) {
                            set = true;
                        } else {
                            float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                            boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                        }
                        if (!set) continue;
                        tile.setBitLayerValue(layer, x, y, !tile.getBitLayerValue(layer, x, y));
                    }
                }
            }, progressReceiver);
        } else if (layer.getDataSize() == Layer.DataSize.BIT_PER_CHUNK) {
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; x += 16) {
                    for (int y = 0; y < 128; y += 16) {
                        boolean set;
                        if (this.filter == null) {
                            set = true;
                        } else {
                            float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                            boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                        }
                        if (!set) continue;
                        tile.setBitLayerValue(layer, x, y, !tile.getBitLayerValue(layer, x, y));
                    }
                }
            }, progressReceiver);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void fillWithBiome(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        int biome = (Integer)this.comboBoxBiome.getSelectedItem();
        this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
            int worldTileX = tile.getX() << 7;
            int worldTileY = tile.getY() << 7;
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    boolean set;
                    if (this.filter == null) {
                        set = true;
                    } else {
                        float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                        boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                    }
                    if (!set) continue;
                    tile.setLayerValue((Layer)Biome.INSTANCE, x, y, biome);
                }
            }
        }, progressReceiver);
    }

    private void resetBiomes(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        if (this.filter == null) {
            this.dimension.clearLayerData((Layer)Biome.INSTANCE);
        } else {
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                        if (!(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                        tile.setLayerValue((Layer)Biome.INSTANCE, x, y, 255);
                    }
                }
            }, progressReceiver);
        }
    }

    private void makeAutoBiomesPermanent(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
            if (this.filter == null) {
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        if (tile.getLayerValue((Layer)Biome.INSTANCE, x, y) != 255) continue;
                        tile.setLayerValue((Layer)Biome.INSTANCE, x, y, this.dimension.getAutoBiome(tile, x, y, 1));
                    }
                }
            } else {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                        if (!(strength > 0.95f) && !(Math.random() < (double)strength) || tile.getLayerValue((Layer)Biome.INSTANCE, x, y) != 255) continue;
                        tile.setLayerValue((Layer)Biome.INSTANCE, x, y, this.dimension.getAutoBiome(tile, x, y, 1));
                    }
                }
            }
        }, progressReceiver);
    }

    private void resetWater(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled, UnsupportedOperationException {
        TileFactory tileFactory = this.dimension.getTileFactory();
        if (!(tileFactory instanceof HeightMapTileFactory)) {
            throw new UnsupportedOperationException("Tile factory type " + tileFactory.getClass() + " not supported");
        }
        int waterLevel = ((HeightMapTileFactory)tileFactory).getWaterHeight();
        boolean floodWithLava = ((HeightMapTileFactory)tileFactory).isFloodWithLava();
        this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
            int worldTileX = tile.getX() << 7;
            int worldTileY = tile.getY() << 7;
            if (floodWithLava) {
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        boolean set;
                        if (this.filter == null) {
                            set = true;
                        } else {
                            float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                            boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                        }
                        if (!set) continue;
                        tile.setWaterLevel(x, y, waterLevel);
                        tile.setBitLayerValue((Layer)FloodWithLava.INSTANCE, x, y, true);
                    }
                }
            } else {
                if (this.filter == null) {
                    tile.clearLayerData((Layer)FloodWithLava.INSTANCE);
                }
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        boolean set;
                        if (this.filter == null) {
                            set = true;
                        } else {
                            float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                            boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                        }
                        if (!set) continue;
                        tile.setWaterLevel(x, y, waterLevel);
                        if (this.filter == null) continue;
                        tile.setBitLayerValue((Layer)FloodWithLava.INSTANCE, x, y, false);
                    }
                }
            }
        }, progressReceiver);
    }

    private void resetTerrain(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
            int worldTileX = tile.getX() << 7;
            int worldTileY = tile.getY() << 7;
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    boolean set;
                    if (this.filter == null) {
                        set = true;
                    } else {
                        float strength = this.filter.modifyStrength(worldTileX | x, worldTileY | y, 1.0f);
                        boolean bl = set = strength > 0.95f || Math.random() < (double)strength;
                    }
                    if (!set) continue;
                    this.dimension.applyTheme(worldTileX | x, worldTileY | y);
                }
            }
        }, progressReceiver);
    }

    private void addToSelection(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        boolean[][] blocksSet = new boolean[16][16];
        this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
            boolean tileHasChunkSelection = tile.hasLayer((Layer)SelectionChunk.INSTANCE);
            if (this.filter == null) {
                tile.clearLayerData((Layer)SelectionBlock.INSTANCE);
                for (int chunkX = 0; chunkX < 128; chunkX += 16) {
                    for (int chunkY = 0; chunkY < 128; chunkY += 16) {
                        if (tileHasChunkSelection && tile.getBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY)) continue;
                        tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, true);
                    }
                }
            } else {
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                boolean tileHasBlockSelection = tile.hasLayer((Layer)SelectionBlock.INSTANCE);
                for (int chunkX = 0; chunkX < 128; chunkX += 16) {
                    for (int chunkY = 0; !(chunkY >= 128 || tileHasChunkSelection && tile.getBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY)); chunkY += 16) {
                        int yInChunk;
                        int xInChunk;
                        boolean chunkEntirelySelected = true;
                        boolean noSelection = true;
                        for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                            for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                boolean select;
                                float strength = this.filter.modifyStrength(worldTileX | chunkX | xInChunk, worldTileY | chunkY | yInChunk, 1.0f);
                                blocksSet[xInChunk][yInChunk] = select = strength > 0.95f || Math.random() < (double)strength;
                                if (!select) {
                                    chunkEntirelySelected = false;
                                    continue;
                                }
                                noSelection = false;
                            }
                        }
                        if (noSelection) continue;
                        if (chunkEntirelySelected) {
                            tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, true);
                            if (!tileHasBlockSelection) continue;
                            for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                                for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                    tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX | xInChunk, chunkY | yInChunk, false);
                                }
                            }
                            continue;
                        }
                        for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                            for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                if (!blocksSet[xInChunk][yInChunk]) continue;
                                tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX | xInChunk, chunkY | yInChunk, true);
                            }
                        }
                    }
                }
            }
        }, progressReceiver);
    }

    private void removeFromSelection(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        boolean[][] blocksDeselected = new boolean[16][16];
        if (this.filter == null) {
            this.dimension.clearLayerData((Layer)SelectionChunk.INSTANCE);
            this.dimension.clearLayerData((Layer)SelectionBlock.INSTANCE);
        } else {
            this.dimension.visitTilesForEditing().forFilter(this.filter).andDo(tile -> {
                boolean tileHasChunkSelection = tile.hasLayer((Layer)SelectionChunk.INSTANCE);
                boolean tileHasBlockSelection = tile.hasLayer((Layer)SelectionBlock.INSTANCE);
                if (!tileHasChunkSelection && !tileHasBlockSelection) {
                    return;
                }
                int worldTileX = tile.getX() << 7;
                int worldTileY = tile.getY() << 7;
                for (int chunkX = 0; chunkX < 128; chunkX += 16) {
                    for (int chunkY = 0; chunkY < 128; chunkY += 16) {
                        int yInChunk;
                        int xInChunk;
                        boolean chunkEntirelyDeselected = true;
                        boolean noDeselection = true;
                        for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                            for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                boolean deselect;
                                float strength = this.filter.modifyStrength(worldTileX | chunkX | xInChunk, worldTileY | chunkY | yInChunk, 1.0f);
                                blocksDeselected[xInChunk][yInChunk] = deselect = strength > 0.95f || Math.random() < (double)strength;
                                if (!deselect) {
                                    chunkEntirelyDeselected = false;
                                    continue;
                                }
                                noDeselection = false;
                            }
                        }
                        if (noDeselection) continue;
                        if (chunkEntirelyDeselected) {
                            if (tileHasChunkSelection) {
                                tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, false);
                            }
                            if (!tileHasBlockSelection) continue;
                            for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                                for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                    tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX | xInChunk, chunkY | yInChunk, false);
                                }
                            }
                            continue;
                        }
                        if (tileHasChunkSelection && tile.getBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY)) {
                            tile.setBitLayerValue((Layer)SelectionChunk.INSTANCE, chunkX, chunkY, false);
                            for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                                for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                    if (blocksDeselected[xInChunk][yInChunk]) continue;
                                    tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX | xInChunk, chunkY | yInChunk, true);
                                }
                            }
                            continue;
                        }
                        for (xInChunk = 0; xInChunk < 16; ++xInChunk) {
                            for (yInChunk = 0; yInChunk < 16; ++yInChunk) {
                                if (!blocksDeselected[xInChunk][yInChunk]) continue;
                                tile.setBitLayerValue((Layer)SelectionBlock.INSTANCE, chunkX | xInChunk, chunkY | yInChunk, false);
                            }
                        }
                    }
                }
            }, progressReceiver);
        }
    }

    private void selectOnMap(final JComboBox<?> comboBox, Eyedropper.PaintType ... paintTypes) {
        this.selectFromMap(EnumSet.copyOf(Arrays.asList(paintTypes)), new Eyedropper.SelectionListener(){

            @Override
            public void terrainSelected(Terrain terrain) {
                comboBox.setSelectedItem(terrain);
            }

            @Override
            public void layerSelected(Layer layer, int value) {
                if (comboBox == FillDialog.this.comboBoxBiome) {
                    comboBox.setSelectedItem(value);
                } else {
                    comboBox.setSelectedItem(layer);
                }
            }

            @Override
            public void selectionCancelled(boolean byUser) {
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonFill = new JButton();
        this.jSeparator1 = new JSeparator();
        this.brushOptions1 = new BrushOptions();
        this.jPanel1 = new JPanel();
        this.sliderLayerValue = new JSlider();
        this.comboBoxBiome = new JComboBox();
        this.radioButtonSetLayer = new JRadioButton();
        this.radioButtonResetBiomes = new JRadioButton();
        this.radioButtonClearLayer = new JRadioButton();
        this.radioButtonResetTerrain = new JRadioButton();
        this.radioButtonTerrain = new JRadioButton();
        this.comboBoxClearLayer = new JComboBox();
        this.radioButtonResetWater = new JRadioButton();
        this.comboBoxSetLayer = new JComboBox();
        this.comboBoxInvertLayer = new JComboBox();
        this.comboBoxTerrain = new JComboBox();
        this.radioButtonInvertLayer = new JRadioButton();
        this.radioButtonBiome = new JRadioButton();
        this.radioButtonMakeBiomesPermanent = new JRadioButton();
        this.radioButtonAddToSelection = new JRadioButton();
        this.radioButtonRemoveFromSelection = new JRadioButton();
        this.buttonFillTerrainSelectOnMap = new JButton();
        this.buttonFillLayerSelectOnMap = new JButton();
        this.buttonRemoveLayerSelectOnMap = new JButton();
        this.buttonInvertLayerSelectOnMap = new JButton();
        this.buttonFillBiomeSelectOnMap = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel2 = new JLabel();
        this.checkBoxKeepOpen = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Global Operations");
        this.jLabel1.setText("Perform a global operation:");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonFill.setText("Go");
        this.buttonFill.setEnabled(false);
        this.buttonFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.buttonFillActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.sliderLayerValue.setMajorTickSpacing(7);
        this.sliderLayerValue.setMinimum(2);
        this.sliderLayerValue.setPaintTicks(true);
        this.sliderLayerValue.setSnapToTicks(true);
        this.sliderLayerValue.setEnabled(false);
        this.comboBoxBiome.setEnabled(false);
        this.buttonGroup1.add(this.radioButtonSetLayer);
        this.radioButtonSetLayer.setText("fill with layer:");
        this.radioButtonSetLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonSetLayerActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonResetBiomes);
        this.radioButtonResetBiomes.setText("reset biomes to automatic");
        this.radioButtonResetBiomes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonResetBiomesActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonClearLayer);
        this.radioButtonClearLayer.setText("remove a layer:");
        this.radioButtonClearLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonClearLayerActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonResetTerrain);
        this.radioButtonResetTerrain.setText("reset terrain and layers to theme");
        this.radioButtonResetTerrain.setToolTipText("Reset the terrain type of the entire map to the altitude-dependent default");
        this.radioButtonResetTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonResetTerrainActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonTerrain);
        this.radioButtonTerrain.setText("fill with terrain type:");
        this.radioButtonTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonTerrainActionPerformed(evt);
            }
        });
        this.comboBoxClearLayer.setEnabled(false);
        this.buttonGroup1.add(this.radioButtonResetWater);
        this.radioButtonResetWater.setText("reset all water or lava");
        this.radioButtonResetWater.setToolTipText("This resets the fluid level and type (water or lava) to the default everywhere");
        this.radioButtonResetWater.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonResetWaterActionPerformed(evt);
            }
        });
        this.comboBoxSetLayer.setEnabled(false);
        this.comboBoxSetLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.comboBoxSetLayerActionPerformed(evt);
            }
        });
        this.comboBoxInvertLayer.setEnabled(false);
        this.comboBoxTerrain.setModel(new DefaultComboBoxModel<Terrain>(Terrain.getConfiguredValues()));
        this.comboBoxTerrain.setEnabled(false);
        this.comboBoxTerrain.setRenderer(new TerrainListCellRenderer(this.colourScheme));
        this.buttonGroup1.add(this.radioButtonInvertLayer);
        this.radioButtonInvertLayer.setText("invert a layer:");
        this.radioButtonInvertLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonInvertLayerActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonBiome);
        this.radioButtonBiome.setText("fill with biome:");
        this.radioButtonBiome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonBiomeActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonMakeBiomesPermanent);
        this.radioButtonMakeBiomesPermanent.setText("make automatic biomes permanent");
        this.radioButtonMakeBiomesPermanent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonMakeBiomesPermanentActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonAddToSelection);
        this.radioButtonAddToSelection.setText("add to selection");
        this.radioButtonAddToSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonAddToSelectionActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonRemoveFromSelection);
        this.radioButtonRemoveFromSelection.setText("remove from selection");
        this.radioButtonRemoveFromSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.radioButtonRemoveFromSelectionActionPerformed(evt);
            }
        });
        this.buttonFillTerrainSelectOnMap.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/eyedropper.png")));
        this.buttonFillTerrainSelectOnMap.setToolTipText("Select a terrain type from the map.");
        this.buttonFillTerrainSelectOnMap.setEnabled(false);
        this.buttonFillTerrainSelectOnMap.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFillTerrainSelectOnMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.buttonFillTerrainSelectOnMapActionPerformed(evt);
            }
        });
        this.buttonFillLayerSelectOnMap.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/eyedropper.png")));
        this.buttonFillLayerSelectOnMap.setToolTipText("Select a layer from the map.");
        this.buttonFillLayerSelectOnMap.setEnabled(false);
        this.buttonFillLayerSelectOnMap.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFillLayerSelectOnMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.buttonFillLayerSelectOnMapActionPerformed(evt);
            }
        });
        this.buttonRemoveLayerSelectOnMap.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/eyedropper.png")));
        this.buttonRemoveLayerSelectOnMap.setToolTipText("Select a layer from the map.");
        this.buttonRemoveLayerSelectOnMap.setEnabled(false);
        this.buttonRemoveLayerSelectOnMap.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveLayerSelectOnMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.buttonRemoveLayerSelectOnMapActionPerformed(evt);
            }
        });
        this.buttonInvertLayerSelectOnMap.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/eyedropper.png")));
        this.buttonInvertLayerSelectOnMap.setToolTipText("Select a layer from the map.");
        this.buttonInvertLayerSelectOnMap.setEnabled(false);
        this.buttonInvertLayerSelectOnMap.setMargin(new Insets(2, 2, 2, 2));
        this.buttonInvertLayerSelectOnMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.buttonInvertLayerSelectOnMapActionPerformed(evt);
            }
        });
        this.buttonFillBiomeSelectOnMap.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/eyedropper.png")));
        this.buttonFillBiomeSelectOnMap.setToolTipText("Select a biome from the map.");
        this.buttonFillBiomeSelectOnMap.setEnabled(false);
        this.buttonFillBiomeSelectOnMap.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFillBiomeSelectOnMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillDialog.this.buttonFillBiomeSelectOnMapActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioButtonSetLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxSetLayer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonFillLayerSelectOnMap)).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.sliderLayerValue, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioButtonClearLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxClearLayer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveLayerSelectOnMap)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioButtonBiome).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxBiome, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonFillBiomeSelectOnMap)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioButtonInvertLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxInvertLayer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonInvertLayerSelectOnMap)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioButtonTerrain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxTerrain, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonFillTerrainSelectOnMap)).addComponent(this.radioButtonResetTerrain).addComponent(this.radioButtonResetBiomes).addComponent(this.radioButtonMakeBiomesPermanent).addComponent(this.radioButtonAddToSelection).addComponent(this.radioButtonRemoveFromSelection).addComponent(this.radioButtonResetWater)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonTerrain).addComponent(this.comboBoxTerrain, -2, -1, -2).addComponent(this.buttonFillTerrainSelectOnMap)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonResetTerrain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonResetWater).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonSetLayer).addComponent(this.comboBoxSetLayer, -2, -1, -2)).addComponent(this.buttonFillLayerSelectOnMap)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderLayerValue, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonClearLayer).addComponent(this.comboBoxClearLayer, -2, -1, -2))).addComponent(this.buttonRemoveLayerSelectOnMap)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonInvertLayer).addComponent(this.comboBoxInvertLayer, -2, -1, -2))).addComponent(this.buttonInvertLayerSelectOnMap)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonBiome).addComponent(this.comboBoxBiome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonMakeBiomesPermanent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonResetBiomes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonAddToSelection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonRemoveFromSelection)).addComponent(this.buttonFillBiomeSelectOnMap)).addContainerGap()));
        this.jLabel3.setForeground(new Color(0, 0, 255));
        this.jLabel3.setText("<html><u>Change height...</u></html>");
        this.jLabel3.setToolTipText("Raise or lower the entire dimension");
        this.jLabel3.setCursor(new Cursor(12));
        this.jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FillDialog.this.jLabel3MouseClicked(evt);
            }
        });
        this.jLabel4.setText("-");
        this.jLabel5.setForeground(new Color(0, 0, 255));
        this.jLabel5.setText("<html><u>Rotate...</u></html>");
        this.jLabel5.setToolTipText("Rotate the entire dimension in 90 degree steps");
        this.jLabel5.setCursor(new Cursor(12));
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FillDialog.this.jLabel5MouseClicked(evt);
            }
        });
        this.jLabel6.setText("-");
        this.jLabel7.setForeground(new Color(0, 0, 255));
        this.jLabel7.setText("<html><u>Shift...</u></html>");
        this.jLabel7.setToolTipText("Shift the entire dimension horizontally in 128 block steps");
        this.jLabel7.setCursor(new Cursor(12));
        this.jLabel7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FillDialog.this.jLabel7MouseClicked(evt);
            }
        });
        this.jLabel2.setText("Other global tools:");
        this.checkBoxKeepOpen.setText("keep this window open");
        this.checkBoxKeepOpen.setHorizontalTextPosition(10);
        this.jLabel8.setText("-");
        this.jLabel9.setForeground(new Color(0, 0, 255));
        this.jLabel9.setText("<html><u>Scale...</u></html>");
        this.jLabel9.setToolTipText("Scale the entire dimension up or down by an arbitrary amount");
        this.jLabel9.setCursor(new Cursor(12));
        this.jLabel9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FillDialog.this.jLabel9MouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.brushOptions1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.checkBoxKeepOpen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonFill).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING).addComponent(this.brushOptions1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGap(6, 6, 6).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jLabel9, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonFill).addComponent(this.checkBoxKeepOpen)).addContainerGap()));
        this.pack();
    }

    private void buttonFillActionPerformed(ActionEvent evt) {
        this.fill();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void radioButtonMakeBiomesPermanentActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonBiomeActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonInvertLayerActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void comboBoxSetLayerActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonResetWaterActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonTerrainActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonResetTerrainActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonClearLayerActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonResetBiomesActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonSetLayerActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonAddToSelectionActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonRemoveFromSelectionActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void jLabel3MouseClicked(MouseEvent evt) {
        this.app.changeWorldHeight(this);
    }

    private void jLabel5MouseClicked(MouseEvent evt) {
        this.app.rotateWorld(this);
    }

    private void jLabel7MouseClicked(MouseEvent evt) {
        this.app.shiftWorld(this);
    }

    private void jLabel9MouseClicked(MouseEvent evt) {
        this.app.scaleWorld(this);
    }

    private void buttonFillTerrainSelectOnMapActionPerformed(ActionEvent evt) {
        this.selectOnMap(this.comboBoxTerrain, Eyedropper.PaintType.TERRAIN);
    }

    private void buttonFillLayerSelectOnMapActionPerformed(ActionEvent evt) {
        this.selectOnMap(this.comboBoxSetLayer, Eyedropper.PaintType.LAYER);
    }

    private void buttonRemoveLayerSelectOnMapActionPerformed(ActionEvent evt) {
        this.selectOnMap(this.comboBoxClearLayer, Eyedropper.PaintType.LAYER, Eyedropper.PaintType.ANNOTATION);
    }

    private void buttonInvertLayerSelectOnMapActionPerformed(ActionEvent evt) {
        this.selectOnMap(this.comboBoxInvertLayer, Eyedropper.PaintType.LAYER);
    }

    private void buttonFillBiomeSelectOnMapActionPerformed(ActionEvent evt) {
        this.selectOnMap(this.comboBoxBiome, Eyedropper.PaintType.BIOME);
    }
}

