/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft;

import com.twelvemonkeys.image.ResampleOp;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;

public class TestResizeMethods {
    private static final String[] TYPE_NAMES = new String[]{"CUSTOM", "INT_RGB", "INT_ARGB", "INT_ARGB_PRE", "INT_BGR", "3BYTE_BGR", "4BYTE_ABGR", "4BYTE_ABGR_PRE", "USHORT_565_RGB", "USHORT_555_RGB", "BYTE_GRAY", "USHORT_GRAY", "BYTE_BINARY", "BYTE_INDEXED"};
    private static final String[] TRANSPARENCY_NAMES = new String[]{null, "OPAQUE", "BITMASK", "TRANSLUCENT"};

    public static void main(String[] args) throws IOException {
        block0: while (true) {
            String[] stringArray = args;
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                String arg = stringArray[n2];
                BufferedImage image = ImageIO.read(new File(arg));
                System.out.printf("%s (%dx%d; %s)%n", arg, image.getWidth(), image.getHeight(), image);
                TestResizeMethods.doTest(image, 2.0f, 10, 0, false);
                TestResizeMethods.doTest(image, 2.0f, 10, 0, true);
                TestResizeMethods.doTest(image, 2.0f, 10, 1, false);
                TestResizeMethods.doTest(image, 2.0f, 10, 1, true);
                TestResizeMethods.doTest(image, 2.0f, 10, 2, false);
                TestResizeMethods.doTest(image, 2.0f, 10, 2, true);
                TestResizeMethods.doTest(image, 2.0f, 10, 3, false);
                TestResizeMethods.doTest(image, 2.0f, 10, 3, true);
                TestResizeMethods.doTest(image, 2.0f, 10, 4, false);
                TestResizeMethods.doTest(image, 2.0f, 10, 4, true);
                TestResizeMethods.doTest(image, 1.333333f, 10, 0, false);
                TestResizeMethods.doTest(image, 1.333333f, 10, 0, true);
                TestResizeMethods.doTest(image, 1.333333f, 10, 1, false);
                TestResizeMethods.doTest(image, 1.333333f, 10, 1, true);
                TestResizeMethods.doTest(image, 1.333333f, 10, 2, false);
                TestResizeMethods.doTest(image, 1.333333f, 10, 2, true);
                TestResizeMethods.doTest(image, 1.333333f, 10, 3, false);
                TestResizeMethods.doTest(image, 1.333333f, 10, 3, true);
                TestResizeMethods.doTest(image, 1.333333f, 10, 4, false);
                TestResizeMethods.doTest(image, 1.333333f, 10, 4, true);
                ++n2;
            }
            break;
        }
    }

    public static void main1(String[] args) throws IOException {
        for (String arg : args) {
            File file = new File(arg);
            BufferedImage image = ImageIO.read(file);
            String name = file.getName();
            System.out.printf("%s (%dx%d; %s)%n", arg, image.getWidth(), image.getHeight(), image);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 2.0f, 1, 0, false), 2.0f, name, 0, false);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 2.0f, 1, 0, true), 2.0f, name, 0, true);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 2.0f, 1, 1, false), 2.0f, name, 1, false);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 2.0f, 1, 1, true), 2.0f, name, 1, true);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 2.0f, 1, 2, false), 2.0f, name, 2, false);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 2.0f, 1, 2, true), 2.0f, name, 2, true);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 2.0f, 1, 3, false), 2.0f, name, 3, false);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 2.0f, 1, 3, true), 2.0f, name, 3, true);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 2.0f, 1, 4, false), 2.0f, name, 4, false);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 2.0f, 1, 4, true), 2.0f, name, 4, true);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 1.333333f, 1, 0, false), 1.333333f, name, 0, false);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 1.333333f, 1, 0, true), 1.333333f, name, 0, true);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 1.333333f, 1, 1, false), 1.333333f, name, 1, false);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 1.333333f, 1, 1, true), 1.333333f, name, 1, true);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 1.333333f, 1, 2, false), 1.333333f, name, 2, false);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 1.333333f, 1, 2, true), 1.333333f, name, 2, true);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 1.333333f, 1, 3, false), 1.333333f, name, 3, false);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 1.333333f, 1, 3, true), 1.333333f, name, 3, true);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 1.333333f, 1, 4, false), 1.333333f, name, 4, false);
            TestResizeMethods.dump(TestResizeMethods.doTest(image, 1.333333f, 1, 4, true), 1.333333f, name, 4, true);
        }
    }

    private static BufferedImage doTest(BufferedImage image, float scale, int count, int method, boolean smooth) {
        try {
            long start = System.currentTimeMillis();
            BufferedImage result = null;
            for (int i = 0; i < count; ++i) {
                switch (method) {
                    case 0: {
                        result = TestResizeMethods.resizeWithGraphics1(image, scale, smooth);
                        break;
                    }
                    case 1: {
                        result = TestResizeMethods.resizeWithGraphics2(image, scale, smooth);
                        break;
                    }
                    case 2: {
                        result = TestResizeMethods.resizeWithGraphics3(image, scale, smooth);
                        break;
                    }
                    case 3: {
                        result = TestResizeMethods.resizeWithAffineTransform(image, scale, smooth);
                        break;
                    }
                    case 4: {
                        result = TestResizeMethods.resizeWithResample(image, scale, smooth);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                if (result.getType() != image.getType()) {
                    int type = result.getType();
                    int type1 = image.getType();
                    System.err.println("Type changed from " + TYPE_NAMES[type1] + " to " + TYPE_NAMES[type]);
                }
                if (result.getTransparency() != image.getTransparency()) {
                    int transparency = result.getTransparency();
                    int transparency1 = image.getTransparency();
                    System.err.println("Transparency changed from " + TRANSPARENCY_NAMES[transparency1] + " to " + TRANSPARENCY_NAMES[transparency]);
                }
                if (Math.round((float)result.getWidth() / scale) != image.getWidth()) {
                    System.err.println("Scaled width " + result.getWidth() + " is not " + scale + " times " + image.getWidth());
                }
                if (Math.round((float)result.getHeight() / scale) != image.getHeight()) {
                    System.err.println("Scaled height " + result.getHeight() + " is not " + scale + " times " + image.getHeight());
                }
                if (result.getSampleModel().getNumBands() != image.getSampleModel().getNumBands()) {
                    System.err.println("Number of bands changed from " + image.getSampleModel().getNumBands() + " to " + result.getSampleModel().getNumBands());
                }
                for (int j = 0; j < image.getSampleModel().getNumBands(); ++j) {
                    if (result.getSampleModel().getSampleSize(j) == image.getSampleModel().getSampleSize(j)) continue;
                    System.err.println("Sample size of band " + j + " changed from " + image.getSampleModel().getSampleSize(j) + " to " + result.getSampleModel().getSampleSize(j));
                }
            }
            long duration = System.currentTimeMillis() - start;
            System.out.printf("Scaling %d images %f times with method %d (smooth: %b) took %d ms (%d ms per image)%n", count, Float.valueOf(scale), method, smooth, duration, duration / (long)count);
            System.out.printf("Adjusted for scale: %f ms per image%n", Float.valueOf((float)duration / (float)count / (scale * scale)));
            return result;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage resizeWithGraphics1(BufferedImage image, float scale, boolean smooth) {
        int scaledWidth = Math.round((float)image.getWidth() * scale);
        int scaledHeight = Math.round((float)image.getHeight() * scale);
        BufferedImage scaledImage = ImageTypeSpecifier.createFromRenderedImage(image).createBufferedImage(scaledWidth, scaledHeight);
        Graphics2D g2 = scaledImage.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, smooth ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2.drawImage(image, 0, 0, scaledWidth, scaledHeight, null);
        }
        finally {
            g2.dispose();
        }
        return scaledImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage resizeWithGraphics2(BufferedImage image, float scale, boolean smooth) {
        int scaledWidth = Math.round((float)image.getWidth() * scale);
        int scaledHeight = Math.round((float)image.getHeight() * scale);
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), smooth ? 3 : 1);
        BufferedImage scaledImage = ImageTypeSpecifier.createFromRenderedImage(image).createBufferedImage(scaledWidth, scaledHeight);
        Graphics2D g2 = scaledImage.createGraphics();
        try {
            g2.drawImage(image, op, 0, 0);
        }
        finally {
            g2.dispose();
        }
        return scaledImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage resizeWithGraphics3(BufferedImage image, float scale, boolean smooth) {
        int scaledWidth = Math.round((float)image.getWidth() * scale);
        int scaledHeight = Math.round((float)image.getHeight() * scale);
        AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
        BufferedImage scaledImage = ImageTypeSpecifier.createFromRenderedImage(image).createBufferedImage(scaledWidth, scaledHeight);
        Graphics2D g2 = scaledImage.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, smooth ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2.drawImage(image, transform, null);
        }
        finally {
            g2.dispose();
        }
        return scaledImage;
    }

    private static BufferedImage resizeWithAffineTransform(BufferedImage image, float scale, boolean smooth) {
        return new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), smooth ? 3 : 1).filter(image, null);
    }

    private static BufferedImage resizeWithResample(BufferedImage image, float scale, boolean smooth) {
        return new ResampleOp(Math.round((float)image.getWidth() * scale), Math.round((float)image.getHeight() * scale), smooth ? 9 : 1).filter(image, null);
    }

    private static void dump(BufferedImage image, float scale, String name, int method, boolean smooth) throws IOException {
        if (image == null) {
            return;
        }
        ImageIO.write((RenderedImage)image, "PNG", new File(name + "-" + method + "-" + scale + (smooth ? "-smooth" : "") + ".png"));
    }
}

