/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.tonic;

import com.digitprop.tonic.SliderUI;
import com.jidesoft.swing.RangeSlider;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class TonicRangeSliderUI
extends SliderUI {
    protected static final int MOUSE_HANDLE_NONE = 0;
    protected static final int MOUSE_HANDLE_MIN = 1;
    protected static final int MOUSE_HANDLE_MAX = 2;
    protected static final int MOUSE_HANDLE_MIDDLE = 4;
    protected static final int MOUSE_HANDLE_LOWER = 5;
    protected static final int MOUSE_HANDLE_UPPER = 6;
    protected boolean hover;
    protected boolean second;
    protected boolean rollover1;
    protected boolean pressed1;
    protected boolean rollover2;
    protected boolean pressed2;

    public static ComponentUI createUI(JComponent jComponent) {
        return new TonicRangeSliderUI();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.second = false;
        super.paint(graphics, jComponent);
        Rectangle rectangle = graphics.getClipBounds();
        this.second = true;
        Point point = this.adjustThumbForHighValue();
        if (rectangle.intersects(this.thumbRect)) {
            this.paintThumb(graphics);
        }
        this.restoreThumbForLowValue(point);
        this.second = false;
    }

    protected void restoreThumbForLowValue(Point point) {
        this.thumbRect.x = point.x;
        this.thumbRect.y = point.y;
    }

    protected Point adjustThumbForHighValue() {
        Point point = this.thumbRect.getLocation();
        if (this.slider.getOrientation() == 0) {
            int n = this.xPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.x = n - this.thumbRect.width / 2;
        } else {
            int n = this.yPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.y = n - this.thumbRect.height / 2;
        }
        return point;
    }

    protected void adjustSnapHighValue() {
        int n;
        int n2 = n = ((RangeSlider)this.slider).getHighValue();
        int n3 = this.slider.getMajorTickSpacing();
        int n4 = this.slider.getMinorTickSpacing();
        int n5 = 0;
        if (n4 > 0) {
            n5 = n4;
        } else if (n3 > 0) {
            n5 = n3;
        }
        if (n5 != 0) {
            if ((n - this.slider.getMinimum()) % n5 != 0) {
                float f = (float)(n - this.slider.getMinimum()) / (float)n5;
                int n6 = Math.round(f);
                n2 = this.slider.getMinimum() + n6 * n5;
            }
            if (n2 != n) {
                ((RangeSlider)this.slider).setHighValue(n2);
            }
        }
    }

    protected void calculateThumbLocation() {
        if (this.slider.getSnapToTicks()) {
            this.adjustSnapHighValue();
        }
        super.calculateThumbLocation();
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new RangeTrackListener(super.createTrackListener(jSlider));
    }

    protected int getMouseHandle(int n, int n2) {
        int n3;
        Rectangle rectangle = this.trackRect;
        this.slider.putClientProperty("RangeSlider.mousePosition", null);
        if (this.thumbRect.contains(n, n2)) {
            return 1;
        }
        Point point = this.adjustThumbForHighValue();
        if (this.thumbRect.contains(n, n2)) {
            this.restoreThumbForLowValue(point);
            return 2;
        }
        this.restoreThumbForLowValue(point);
        if (this.slider.getOrientation() == 1) {
            int n4;
            int n5 = this.yPositionForValue(((RangeSlider)this.slider).getLowValue());
            Rectangle rectangle2 = new Rectangle(rectangle.x, Math.min(n5, n4 = this.yPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.height / 2, rectangle.width, Math.abs(n4 - n5) - this.thumbRect.height);
            if (rectangle2.contains(n, n2)) {
                return 4;
            }
            int n6 = rectangle.y + Math.max(n5, n4) + this.thumbRect.height / 2;
            Rectangle rectangle3 = new Rectangle(rectangle.x, n6, rectangle.width, rectangle.y + rectangle.height - n6);
            if (rectangle3.contains(n, n2)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", true);
                return 5;
            }
            Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, Math.min(n4, n5) - this.thumbRect.height / 2);
            if (rectangle4.contains(n, n2)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", false);
                return 6;
            }
            return 0;
        }
        int n7 = this.xPositionForValue(((RangeSlider)this.slider).getLowValue());
        Rectangle rectangle5 = new Rectangle(Math.min(n7, n3 = this.xPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.width / 2, rectangle.y, Math.abs(n3 - n7) - this.thumbRect.width, rectangle.height);
        if (rectangle5.contains(n, n2)) {
            return 4;
        }
        Rectangle rectangle6 = new Rectangle(rectangle.x, rectangle.y, Math.min(n7, n3) - this.thumbRect.width / 2 - rectangle.x, rectangle.height);
        if (rectangle6.contains(n, n2)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", true);
            return 5;
        }
        int n8 = rectangle.x + Math.abs(n3 - n7) + this.thumbRect.width / 2;
        Rectangle rectangle7 = new Rectangle(n8, rectangle.y, rectangle.width - n8, rectangle.height);
        if (rectangle7.contains(n, n2)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", false);
            return 6;
        }
        return 0;
    }

    public void paintThumb(Graphics graphics) {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("rollover");
            field.setAccessible(true);
            field.set((Object)this, this.second ? this.rollover2 : this.rollover1);
            field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("pressed");
            field.setAccessible(true);
            field.set((Object)this, this.second ? this.pressed2 : this.pressed1);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        super.paintThumb(graphics);
    }

    protected void setMouseRollover(int n) {
        switch (n) {
            case 1: {
                this.rollover1 = true;
                this.rollover2 = false;
                break;
            }
            case 2: {
                this.rollover2 = true;
                this.rollover1 = false;
                break;
            }
            case 4: {
                this.rollover1 = true;
                this.rollover2 = true;
                break;
            }
            case 0: {
                this.rollover1 = false;
                this.rollover2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point point = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(point);
    }

    protected void setMousePressed(int n) {
        switch (n) {
            case 1: {
                this.pressed1 = true;
                this.pressed2 = false;
                break;
            }
            case 2: {
                this.pressed2 = true;
                this.pressed1 = false;
                break;
            }
            case 4: {
                this.pressed1 = true;
                this.pressed2 = true;
                break;
            }
            case 0: {
                this.pressed1 = false;
                this.pressed2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point point = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(point);
    }

    protected void setMouseReleased(int n) {
        this.pressed1 = false;
        this.pressed2 = false;
        this.slider.repaint(this.thumbRect);
        Point point = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object object = this.slider.getClientProperty("RangeSlider.mousePosition");
            int n2 = object == null ? this.slider.getValue() : (Boolean.TRUE.equals(object) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int n3 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n3 <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                n3 = 1;
            }
            int n4 = n3 * (n > 0 ? 1 : -1);
            this.slider.putClientProperty("RangeSlider.adjustAction", "scrollByBlock");
            if (object == null) {
                this.slider.setValue(Math.max(Math.min(n2 + n4, this.slider.getMaximum()), this.slider.getMinimum()));
            } else if (Boolean.TRUE.equals(object)) {
                ((RangeSlider)this.slider).setLowValue(Math.max(Math.min(n2 + n4, this.slider.getMaximum()), this.slider.getMinimum()));
            } else {
                ((RangeSlider)this.slider).setHighValue(Math.max(Math.min(n2 + n4, this.slider.getMaximum()), this.slider.getMinimum()));
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object object = this.slider.getClientProperty("RangeSlider.mousePosition");
            int n2 = object == null ? this.slider.getValue() : (Boolean.TRUE.equals(object) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int n3 = 1 * (n > 0 ? 1 : -1);
            this.slider.putClientProperty("RangeSlider.adjustAction", "scrollByUnit");
            if (object == null) {
                this.slider.setValue(Math.max(Math.min(n2 + n3, this.slider.getMaximum()), this.slider.getMinimum()));
            } else if (Boolean.TRUE.equals(object)) {
                ((RangeSlider)this.slider).setLowValue(Math.max(Math.min(n2 + n3, this.slider.getMaximum()), this.slider.getMinimum()));
            } else {
                ((RangeSlider)this.slider).setHighValue(Math.max(Math.min(n2 + n3, this.slider.getMaximum()), this.slider.getMinimum()));
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", null);
        }
    }

    protected class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        int handle;
        int handleOffset;
        int mouseStartLocation;
        BasicSliderUI.TrackListener _listener;

        public RangeTrackListener(BasicSliderUI.TrackListener trackListener) {
            super((BasicSliderUI)((Object)TonicRangeSliderUI.this));
            this._listener = trackListener;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!TonicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (TonicRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                TonicRangeSliderUI.this.slider.requestFocus();
            }
            this.handle = TonicRangeSliderUI.this.getMouseHandle(mouseEvent.getX(), mouseEvent.getY());
            TonicRangeSliderUI.this.setMousePressed(this.handle);
            if (this.handle == 2 || this.handle == 1 || this.handle == 4) {
                this.handleOffset = TonicRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() - TonicRangeSliderUI.this.yPositionForValue(((RangeSlider)TonicRangeSliderUI.this.slider).getLowValue()) : mouseEvent.getX() - TonicRangeSliderUI.this.xPositionForValue(((RangeSlider)TonicRangeSliderUI.this.slider).getLowValue());
                this.mouseStartLocation = TonicRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() : mouseEvent.getX();
                TonicRangeSliderUI.this.slider.getModel().setValueIsAdjusting(true);
            } else if (this.handle == 5 || this.handle == 6) {
                this._listener.mousePressed(mouseEvent);
                TonicRangeSliderUI.this.slider.putClientProperty("RangeSlider.mousePosition", null);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            if (!TonicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int n2 = TonicRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() : mouseEvent.getX();
            int n3 = n = TonicRangeSliderUI.this.slider.getOrientation() == 1 ? TonicRangeSliderUI.this.valueForYPosition(n2) : TonicRangeSliderUI.this.valueForXPosition(n2);
            if (n < TonicRangeSliderUI.this.slider.getModel().getMinimum()) {
                n = TonicRangeSliderUI.this.slider.getModel().getMinimum();
            }
            if (n > TonicRangeSliderUI.this.slider.getModel().getMaximum()) {
                n = TonicRangeSliderUI.this.slider.getModel().getMaximum();
            }
            if (this.handle == 3) {
                if (n2 - this.mouseStartLocation > 2) {
                    this.handle = 2;
                } else if (n2 - this.mouseStartLocation < -2) {
                    this.handle = 1;
                } else {
                    return;
                }
            }
            RangeSlider rangeSlider = (RangeSlider)TonicRangeSliderUI.this.slider;
            switch (this.handle) {
                case 1: {
                    rangeSlider.setLowValue(Math.min(n, rangeSlider.getHighValue()));
                    break;
                }
                case 2: {
                    rangeSlider.setHighValue(Math.max(rangeSlider.getLowValue(), n));
                    break;
                }
                case 4: {
                    int n4;
                    if (!((RangeSlider)TonicRangeSliderUI.this.slider).isRangeDraggable()) break;
                    int n5 = n4 = TonicRangeSliderUI.this.slider.getOrientation() == 1 ? TonicRangeSliderUI.this.valueForYPosition(n2 - this.handleOffset) - rangeSlider.getLowValue() : TonicRangeSliderUI.this.valueForXPosition(n2 - this.handleOffset) - rangeSlider.getLowValue();
                    if (n4 < 0 && rangeSlider.getLowValue() + n4 < rangeSlider.getMinimum()) {
                        n4 = rangeSlider.getMinimum() - rangeSlider.getLowValue();
                    }
                    if (n4 > 0 && rangeSlider.getHighValue() + n4 > rangeSlider.getMaximum()) {
                        n4 = rangeSlider.getMaximum() - rangeSlider.getHighValue();
                    }
                    if (n4 == 0) break;
                    rangeSlider.setLowValue(rangeSlider.getLowValue() + n4);
                    rangeSlider.setHighValue(rangeSlider.getHighValue() + n4);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TonicRangeSliderUI.this.slider.getModel().setValueIsAdjusting(false);
            TonicRangeSliderUI.this.setMouseReleased(this.handle);
            this._listener.mouseReleased(mouseEvent);
        }

        private void setCursor(int n) {
            Cursor cursor = Cursor.getPredefinedCursor(n);
            if (TonicRangeSliderUI.this.slider.getCursor() != cursor) {
                TonicRangeSliderUI.this.slider.setCursor(cursor);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!TonicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int n = TonicRangeSliderUI.this.getMouseHandle(mouseEvent.getX(), mouseEvent.getY());
            TonicRangeSliderUI.this.setMouseRollover(n);
            switch (n) {
                case 1: {
                    this.setCursor(0);
                    break;
                }
                case 2: {
                    this.setCursor(0);
                    break;
                }
                case 4: {
                    if (TonicRangeSliderUI.this.slider instanceof RangeSlider && ((RangeSlider)TonicRangeSliderUI.this.slider).isRangeDraggable()) {
                        this.setCursor(13);
                        break;
                    }
                    this.setCursor(0);
                    break;
                }
                default: {
                    this.setCursor(0);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                TonicRangeSliderUI.this.slider.getModel().setValue(TonicRangeSliderUI.this.slider.getModel().getMinimum());
                TonicRangeSliderUI.this.slider.getModel().setExtent(TonicRangeSliderUI.this.slider.getModel().getMaximum() - TonicRangeSliderUI.this.slider.getModel().getMinimum());
                TonicRangeSliderUI.this.slider.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            TonicRangeSliderUI.this.hover = true;
            TonicRangeSliderUI.this.slider.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TonicRangeSliderUI.this.hover = false;
            TonicRangeSliderUI.this.slider.repaint();
            this.setCursor(0);
        }
    }
}

