/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Taskbar;
import java.awt.Window;
import java.util.Map;
import java.util.WeakHashMap;
import org.pepsoft.util.ProgressHelper;

class ProgressHelperJava9
extends ProgressHelper {
    private final boolean enabled;
    private final Map<Window, Boolean> errorStates = new WeakHashMap<Window, Boolean>();

    ProgressHelperJava9() {
        this.enabled = Taskbar.isTaskbarSupported() && Taskbar.getTaskbar().isSupported(Taskbar.Feature.PROGRESS_VALUE_WINDOW) && Taskbar.getTaskbar().isSupported(Taskbar.Feature.PROGRESS_STATE_WINDOW);
    }

    void setProgress(Window window, int percentage) {
        if (!this.enabled) {
            return;
        }
        if (this.errorStates.getOrDefault(window, false).booleanValue()) {
            return;
        }
        Taskbar.getTaskbar().setWindowProgressValue(window, percentage);
    }

    void setProgressDone(Window window) {
        if (!this.enabled) {
            return;
        }
        Taskbar.getTaskbar().setWindowProgressState(window, Taskbar.State.OFF);
        this.errorStates.remove(window);
    }

    void setProgressError(Window window) {
        if (!this.enabled) {
            return;
        }
        if (this.errorStates.getOrDefault(window, false).booleanValue()) {
            return;
        }
        this.errorStates.put(window, true);
        Taskbar.getTaskbar().setWindowProgressState(window, Taskbar.State.ERROR);
    }
}

