/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.wintab;

import java.awt.AWTEvent;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpen.PLevel;
import jpen.PenManager;
import jpen.PenProvider;
import jpen.internal.BuildInfo;
import jpen.internal.Range;
import jpen.provider.AbstractPenProvider;
import jpen.provider.NativeLibraryLoader;
import jpen.provider.VirtualScreenBounds;
import jpen.provider.wintab.WintabAccess;
import jpen.provider.wintab.WintabDevice;

public class WintabProvider
extends AbstractPenProvider {
    private static final Logger L = Logger.getLogger(WintabProvider.class.getName());
    private static final NativeLibraryLoader LIB_LOADER = new NativeLibraryLoader(new String[]{""}, new String[]{"64"}, Integer.valueOf(BuildInfo.getProperties().getString("jpen.provider.wintab.nativeVersion")));
    public static final String WAIT_AWT_ACTIVITY_SYSTEM_PROPERTY = "jpen.provider.wintab.waitAwtActivity";
    private static final boolean WAIT_AWT_ACTIVITY = Boolean.valueOf(System.getProperty("jpen.provider.wintab.waitAwtActivity"));
    public static final String PERIOD_SYSTEM_PROPERTY = "jpen.provider.wintab.period";
    public static final int PERIOD;
    public final WintabAccess wintabAccess;
    private final Map<Integer, WintabDevice> cursorToDevice = new HashMap<Integer, WintabDevice>();
    private final Range[] levelRanges = new Range[PLevel.Type.VALUES.size()];
    final VirtualScreenBounds screenBounds = VirtualScreenBounds.getInstance();
    private final Thread thread;
    private volatile boolean paused = true;
    private boolean systemCursorEnabled = true;

    static void loadLibrary() {
        LIB_LOADER.load();
    }

    private WintabProvider(Constructor constructor, WintabAccess wintabAccess) {
        super(constructor);
        L.fine("start");
        this.wintabAccess = wintabAccess;
        int i = PLevel.Type.VALUES.size();
        while (--i >= 0) {
            PLevel.Type levelType = PLevel.Type.VALUES.get(i);
            this.levelRanges[levelType.ordinal()] = wintabAccess.getLevelRange(levelType);
        }
        this.thread = new MyThread();
        this.thread.start();
        L.fine("end");
    }

    Range getLevelRange(PLevel.Type type) {
        return this.levelRanges[type.ordinal()];
    }

    private void processQueuedEvents() {
        while (this.wintabAccess.nextPacket() && !this.paused) {
            WintabDevice device = this.getDevice(this.wintabAccess.getCursor());
            if (L.isLoggable(Level.FINE)) {
                L.finer("device: ");
                L.finer(device.getName());
            }
            device.scheduleEvents();
        }
    }

    private WintabDevice getDevice(int cursor) {
        WintabDevice wintabDevice = this.cursorToDevice.get(cursor);
        if (wintabDevice == null) {
            wintabDevice = new WintabDevice(this, cursor);
            this.cursorToDevice.put(cursor, wintabDevice);
            this.devices.clear();
            this.devices.addAll(this.cursorToDevice.values());
            this.getPenManager().firePenDeviceAdded(this.getConstructor(), wintabDevice);
        }
        return wintabDevice;
    }

    public void penManagerPaused(boolean paused) {
        this.setPaused(paused);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setPaused(boolean paused) {
        L.fine("start");
        if (paused == this.paused) {
            return;
        }
        this.paused = paused;
        if (!paused) {
            L.fine("false paused value");
            this.screenBounds.reset();
            Thread thread = this.thread;
            synchronized (thread) {
                L.fine("going to notify all...");
                this.thread.notifyAll();
                L.fine("done notifying ");
            }
            this.wintabAccess.enable(true);
        }
        L.fine("end");
    }

    public boolean getUseRelativeLocationFilter() {
        return this.systemCursorEnabled;
    }

    public synchronized void setSystemCursorEnabled(boolean systemCursorEnabled) {
        if (this.systemCursorEnabled == systemCursorEnabled) {
            return;
        }
        this.systemCursorEnabled = systemCursorEnabled;
        this.wintabAccess.setSystemCursorEnabled(systemCursorEnabled);
    }

    public synchronized boolean getSystemCursorEnabled() {
        return this.systemCursorEnabled;
    }

    static {
        if (WAIT_AWT_ACTIVITY) {
            L.info("WAIT_AWT_ACTIVITY set to true");
        }
        String periodString = System.getProperty(PERIOD_SYSTEM_PROPERTY, null);
        int periodValue = 10;
        if (periodString != null) {
            try {
                periodValue = Integer.valueOf(periodString);
                if (periodValue <= 0) {
                    L.severe("ignored illegal PERIOD value " + periodValue + ", period value must be >= 0");
                    periodValue = 10;
                } else {
                    L.info("PERIOD set to " + periodValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        PERIOD = periodValue;
    }

    class MyThread
    extends Thread
    implements AWTEventListener {
        private long scheduleTime;
        private long awtEventTime;
        private boolean waitingAwtEvent;
        private int inputEventModifiers;
        private boolean awtSleep;
        private final Object awtLock = new Object();

        MyThread() {
            this.setName("jpen-WintabProvider");
            this.setDaemon(true);
            this.setPriority(10);
            if (WAIT_AWT_ACTIVITY) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, -1L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                boolean waited = true;
                while (true) {
                    long processingTime = waited ? System.currentTimeMillis() : this.scheduleTime;
                    this.schedule();
                    processingTime = this.scheduleTime - processingTime;
                    long correctPeriod = (long)PERIOD - processingTime;
                    waited = false;
                    MyThread myThread = this;
                    synchronized (myThread) {
                        if (correctPeriod > 0L) {
                            this.wait(correctPeriod);
                            waited = true;
                        }
                        if (WAIT_AWT_ACTIVITY) {
                            boolean bl = this.waitingAwtEvent = this.scheduleTime - this.awtEventTime > 1000L && (this.inputEventModifiers == 0 || keyboardFocusManager.getActiveWindow() == null);
                            if (this.waitingAwtEvent) {
                                this.wait(500L);
                                waited = true;
                            }
                        }
                        while (WintabProvider.this.paused) {
                            L.fine("going to wait...");
                            this.wait();
                            L.fine("notified");
                            waited = true;
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        private void schedule() {
            WintabProvider.this.processQueuedEvents();
            this.scheduleTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void eventDispatched(AWTEvent ev) {
            InputEvent inputEvent = ev instanceof InputEvent ? (InputEvent)ev : null;
            MyThread myThread = this;
            synchronized (myThread) {
                this.awtEventTime = System.currentTimeMillis();
                if (inputEvent != null) {
                    this.inputEventModifiers = inputEvent.getModifiersEx();
                }
                if (!WintabProvider.this.paused && this.waitingAwtEvent) {
                    this.notify();
                }
            }
        }
    }

    public static class Constructor
    extends AbstractPenProvider.AbstractConstructor {
        public String getName() {
            return "Wintab";
        }

        public boolean constructable(PenManager penManager) {
            return System.getProperty("os.name").toLowerCase().contains("windows");
        }

        public PenProvider constructProvider() throws Throwable {
            WintabProvider.loadLibrary();
            WintabAccess wintabAccess = new WintabAccess();
            return new WintabProvider(this, wintabAccess);
        }

        public int getNativeVersion() {
            return LIB_LOADER.nativeVersion;
        }

        public int getNativeBuild() {
            WintabProvider.loadLibrary();
            return WintabAccess.getNativeBuild();
        }

        public int getExpectedNativeBuild() {
            return Integer.valueOf(BuildInfo.getProperties().getString("jpen.provider.wintab.nativeBuild"));
        }
    }
}

