/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UnixConfigFile {
    private final List<Group> groups = new ArrayList<Group>();

    @Nullable
    protected abstract Group getMainGroup();

    protected abstract boolean isUniqueKeys();

    protected void add(@NotNull String groupName, @NotNull String key, @Nullable String value) {
        if (value != null && !value.isEmpty()) {
            this.getOrAddGroup(groupName).add(key + "=" + value, true);
        }
    }

    public void addContent(@NotNull List<String> lines) {
        Group group = this.getMainGroup();
        for (String line : lines) {
            String newGroupName = UnixConfigFile.getGroupName(line);
            if (newGroupName != null) {
                group = this.getOrAddGroup(newGroupName);
                continue;
            }
            if (group == null) {
                throw new IllegalArgumentException("no group defined for " + lines);
            }
            group.add(line, false);
        }
    }

    public void addContent(String content) {
        if (content != null && !content.trim().isEmpty()) {
            this.addContent(Arrays.asList(content.replaceAll("\\r", "").split("\\n")));
        }
    }

    @NotNull
    protected final Group getOrAddGroup(@NotNull String groupName) {
        for (Group group : this.groups) {
            if (!group.name.equals(groupName)) continue;
            return group;
        }
        Group group = new Group(groupName);
        this.groups.add(group);
        return group;
    }

    public void print(PrintWriter pw) {
        boolean lastLineWasEmpty = true;
        for (Group group : this.groups) {
            if (!lastLineWasEmpty) {
                pw.println();
            }
            pw.println("[" + group.name + "]");
            lastLineWasEmpty = false;
            for (Line line : group.lines) {
                pw.println(line.value);
                lastLineWasEmpty = "".equals(line.value);
            }
        }
    }

    public List<String> getAsAdditional() {
        Group mainGroup = this.getMainGroup();
        ArrayList<String> ret = new ArrayList<String>();
        for (Group group : this.groups) {
            if (group != mainGroup) {
                ret.add("[" + group.name + "]");
            }
            for (Line line : group.lines) {
                ret.add(line.value);
            }
        }
        return ret;
    }

    @Nullable
    private static String getKey(@NotNull String line) {
        int equalPos = line.indexOf(61);
        if (equalPos == -1) {
            return null;
        }
        return line.substring(0, equalPos).trim();
    }

    @Nullable
    private static String getValue(@NotNull String line) {
        int equalPos = line.indexOf(61);
        if (equalPos == -1) {
            return null;
        }
        return line.substring(equalPos + 1).trim();
    }

    private static boolean isComment(@NotNull String line) {
        return line.startsWith("#") || line.trim().isEmpty();
    }

    @Nullable
    private static String getGroupName(@NotNull String line) {
        if ((line = line.trim()).startsWith("[") && line.endsWith("]")) {
            return line.substring(1, line.length() - 1);
        }
        return null;
    }

    public class Group {
        private final String name;
        private final List<Line> lines = new ArrayList<Line>();

        public Group(String name) {
            this.name = name;
        }

        public void add(@NotNull String newLine, boolean isDefault) {
            String newKey;
            if (!UnixConfigFile.isComment(newLine) && (newKey = UnixConfigFile.getKey(newLine)) != null) {
                String value = UnixConfigFile.getValue(newLine);
                for (int i = 0; i < this.lines.size(); ++i) {
                    Line previous = this.lines.get(i);
                    if (!Objects.equals(UnixConfigFile.getKey(previous.value), newKey) || !UnixConfigFile.this.isUniqueKeys() && !previous.isDefault) continue;
                    if (value == null || value.isEmpty()) {
                        this.lines.remove(i);
                    } else {
                        this.lines.set(i, new Line(newLine, isDefault));
                    }
                    return;
                }
            }
            this.lines.add(new Line(newLine, isDefault));
        }
    }

    public static class Line {
        private final String value;
        private final boolean isDefault;

        public Line(String value, boolean isDefault) {
            this.value = value;
            this.isDefault = isDefault;
        }
    }
}

