/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.painting;

import java.awt.image.BufferedImage;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.layers.CombinedLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.painting.BitLayerPaint;
import org.pepsoft.worldpainter.painting.CombinedLayerPaint;
import org.pepsoft.worldpainter.painting.DiscreteLayerPaint;
import org.pepsoft.worldpainter.painting.NibbleLayerPaint;
import org.pepsoft.worldpainter.painting.Paint;
import org.pepsoft.worldpainter.painting.TerrainPaint;

public final class PaintFactory {
    public static final Paint NULL_PAINT = new NullPaint();

    private PaintFactory() {
    }

    public static Paint createLayerPaint(Layer layer) {
        if (layer instanceof CombinedLayer) {
            return new CombinedLayerPaint((CombinedLayer)layer);
        }
        switch (layer.getDataSize()) {
            case BIT: 
            case BIT_PER_CHUNK: {
                return new BitLayerPaint(layer);
            }
            case NIBBLE: {
                return new NibbleLayerPaint(layer);
            }
        }
        throw new UnsupportedOperationException("Data size " + layer.getDataSize() + " not supported");
    }

    public static Paint createDiscreteLayerPaint(Layer layer, int value) {
        switch (layer.getDataSize()) {
            case NIBBLE: 
            case BYTE: {
                return new DiscreteLayerPaint(layer, value);
            }
        }
        throw new UnsupportedOperationException("Data size " + layer.getDataSize() + " not supported");
    }

    public static String createTerrainPaintId(Terrain terrain) {
        return "Terrain/" + terrain.ordinal();
    }

    public static String createLayerPaintId(Layer layer) {
        return "Layer/" + layer.getId();
    }

    public static String createDiscreteLayerPaintId(Layer layer, int value) {
        return PaintFactory.createLayerPaintId(layer) + '/' + value;
    }

    public static Paint createTerrainPaint(Terrain terrain) {
        return new TerrainPaint(terrain);
    }

    public static class NullPaint
    implements Paint {
        @Override
        public String getId() {
            return "null";
        }

        @Override
        public Brush getBrush() {
            return null;
        }

        @Override
        public void setBrush(Brush brush) {
        }

        @Override
        public Filter getFilter() {
            return null;
        }

        @Override
        public void setFilter(Filter filter) {
        }

        @Override
        public boolean isDither() {
            return false;
        }

        @Override
        public void setDither(boolean dither) {
        }

        @Override
        public void apply(Dimension dimension, int x, int y, float dynamicLevel) {
        }

        @Override
        public void remove(Dimension dimension, int x, int y, float dynamicLevel) {
        }

        @Override
        public void applyPixel(Dimension dimension, int x, int y) {
        }

        @Override
        public void removePixel(Dimension dimension, int x, int y) {
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return null;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "null";
        }
    }
}

