/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.util.Arrays;
import javax.swing.JPanel;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MapDragControl;
import org.pepsoft.worldpainter.RadiusControl;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.operations.RadiusOperation;
import org.pepsoft.worldpainter.operations.TerrainShapingOptions;
import org.pepsoft.worldpainter.operations.TerrainShapingOptionsPanel;

public class Smooth
extends RadiusOperation {
    private final TerrainShapingOptions<Smooth> options = new TerrainShapingOptions();
    private final TerrainShapingOptionsPanel optionsPanel = new TerrainShapingOptionsPanel("Smooth", "<p>Click to smooth the terrain out", this.options);
    private float[][] totals;
    private float[][] currentHeights;
    private int[][] sampleCounts;

    public Smooth(WorldPainter view, RadiusControl radiusControl, MapDragControl mapDragControl) {
        super("Smooth", "Smooth the terrain out", (WorldPainterView)view, radiusControl, mapDragControl, 100, "operation.smooth");
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        int radius = this.getEffectiveRadius();
        int diameter = radius * 2 + 1;
        if (this.totals == null || this.totals.length < diameter + 10) {
            this.totals = new float[diameter + 10][diameter + 10];
            this.currentHeights = new float[diameter + 10][diameter + 10];
            this.sampleCounts = new int[diameter + 10][diameter + 10];
        } else {
            for (int i = 0; i < diameter + 10; ++i) {
                Arrays.fill(this.totals[i], 0.0f);
                Arrays.fill(this.currentHeights[i], 0.0f);
                Arrays.fill(this.sampleCounts[i], 0);
            }
        }
        boolean applyTheme = this.options.isApplyTheme();
        dimension.setEventsInhibited(true);
        try {
            for (int x = 0; x < diameter + 10; ++x) {
                int y;
                for (y = 0; y < diameter + 10; ++y) {
                    float currentHeight = dimension.getHeightAt(centreX - radius + x - 5, centreY - radius + y - 5);
                    if (currentHeight == -3.4028235E38f) continue;
                    this.currentHeights[x][y] = currentHeight;
                    int dxFrom = Math.max(x - 5, 0);
                    int dxTo = Math.min(x + 5, diameter + 9);
                    int dyFrom = Math.max(y - 5, 0);
                    int dyTo = Math.min(y + 5, diameter + 9);
                    for (int dx = dxFrom; dx <= dxTo; ++dx) {
                        int dy = dyFrom;
                        while (dy <= dyTo) {
                            float[] fArray = this.totals[dx];
                            int n = dy;
                            fArray[n] = fArray[n] + currentHeight;
                            int[] nArray = this.sampleCounts[dx];
                            int n2 = dy++;
                            nArray[n2] = nArray[n2] + 1;
                        }
                    }
                }
                if (x < 10) continue;
                for (y = 5; y < diameter + 5; ++y) {
                    float strength = dynamicLevel * this.getStrength(centreX, centreY, centreX + x - radius - 10, centreY + y - radius - 5);
                    if (!(strength > 0.0f)) continue;
                    float newHeight = strength * (this.totals[x - 5][y] / (float)this.sampleCounts[x - 5][y]) + (1.0f - strength) * this.currentHeights[x - 5][y];
                    dimension.setHeightAt(x + centreX - radius - 10, y + centreY - radius - 5, newHeight);
                    if (!applyTheme) continue;
                    dimension.applyTheme(x + centreX - radius - 10, y + centreY - radius - 5);
                }
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }
}

