/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MapDragControl;
import org.pepsoft.worldpainter.RadiusControl;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.operations.RadiusOperation;

public class RiverPaint
extends RadiusOperation {
    private float depth;
    private int previousWaterLevel;
    private boolean lava;
    private static final double DOUBLE_PI = Math.PI * 2;
    private static final double HALF_PI = 1.5707963267948966;

    public RiverPaint(WorldPainterView view, RadiusControl radiusControl, MapDragControl mapDragControl) {
        super("RiverPaint", "Paint a river of water or lava", view, radiusControl, mapDragControl, 100, "operation.riverPaint", "river");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        int y;
        int x;
        Dimension dim = this.getDimension();
        if (dim == null) {
            return;
        }
        if (first) {
            this.previousWaterLevel = dim.getWaterLevelAt(centreX, centreY);
            this.depth = ((float)this.previousWaterLevel - dim.getHeightAt(centreX, centreY)) / this.getFullStrength(centreX, centreY, centreX, centreY);
            this.lava = dim.getBitLayerValueAt((Layer)FloodWithLava.INSTANCE, centreX, centreY);
        }
        if (this.depth < 0.0f) {
            return;
        }
        int r = this.getEffectiveRadius();
        int waterLevel = Integer.MAX_VALUE;
        for (x = centreX - r; x <= centreX + r; ++x) {
            for (y = centreY - r; y <= centreY + r; ++y) {
                if (this.shouldFlood(centreX, centreY, x, y, r)) continue;
                int height = dim.getIntHeightAt(x, y);
                if (dim.getWaterLevelAt(x, y) >= height || height >= waterLevel || !this.shouldFlood(centreX, centreY, x - 1, y, r) && !this.shouldFlood(centreX, centreY, x, y - 1, r) && !this.shouldFlood(centreX, centreY, x + 1, y, r) && !this.shouldFlood(centreX, centreY, x, y + 1, r)) continue;
                waterLevel = height;
            }
        }
        if (waterLevel > this.previousWaterLevel) {
            waterLevel = this.previousWaterLevel;
        } else {
            this.previousWaterLevel = waterLevel;
        }
        dim.setEventsInhibited(true);
        try {
            for (x = centreX - r; x <= centreX + r; ++x) {
                for (y = centreY - r; y <= centreY + r; ++y) {
                    float strength = this.getFullStrength(centreX, centreY, x, y);
                    if (this.shouldFlood(centreX, centreY, x, y, r)) {
                        float requiredHeight = (float)waterLevel - strength / 0.75f * this.depth;
                        if (dim.getHeightAt(x, y) > requiredHeight) {
                            dim.setHeightAt(x, y, requiredHeight);
                        }
                        dim.setWaterLevelAt(x, y, waterLevel);
                        dim.setBitLayerValueAt((Layer)FloodWithLava.INSTANCE, x, y, this.lava);
                        if (this.lava) continue;
                        dim.setTerrainAt(x, y, Terrain.BEACHES);
                        continue;
                    }
                    if (!(strength > 0.0f)) continue;
                    float maximumHeight = (float)waterLevel + (float)(Math.tan((double)(-strength) * (Math.PI * 2) + 1.5707963267948966) / (Math.PI * 2));
                    if (dim.getHeightAt(x, y) > maximumHeight) {
                        dim.setHeightAt(x, y, maximumHeight);
                    }
                    if (this.lava || !(maximumHeight - (float)waterLevel < 2.0f)) continue;
                    dim.setTerrainAt(x, y, Terrain.BEACHES);
                }
            }
        }
        finally {
            dim.setEventsInhibited(false);
        }
    }

    private boolean shouldFlood(int centreX, int centreY, int x, int y, int r) {
        int dx = Math.abs(x - centreX);
        int dy = Math.abs(y - centreY);
        return dx <= r && dy <= r && this.getFullStrength(centreX, centreY, x, y) > 0.25f;
    }
}

