/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.operations.AbstractBrushOperation;
import org.pepsoft.worldpainter.operations.PaintOperation;
import org.pepsoft.worldpainter.operations.StandardOptionsPanel;
import org.pepsoft.worldpainter.painting.DimensionPainter;
import org.pepsoft.worldpainter.painting.Paint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fill
extends AbstractBrushOperation
implements PaintOperation {
    private final DimensionPainter painter = new DimensionPainter();
    private boolean alreadyFilling;
    private static final JPanel OPTIONS_PANEL = new StandardOptionsPanel("Fill", "<ul><li>Left-click on a location to fill the area with the currently selected paint where the value of the currently selected paint type is the same as at the indicated location\n<li>Right-click with a Layer selected to remove the layer from the area where its value is the same as at the indicated location\n<li>Right-click with a Terrain selected to reset to the current theme where the terrain is set to the same value as at the indicated location\n<li>Right-click with a Biome selected to reset to Auto Biome where the biome is set to the same value as at the indicated location</ul>");
    private static final Logger logger = LoggerFactory.getLogger(Fill.class);

    public Fill(WorldPainterView view) {
        super("Fill", "Flood fill an area of the world with any kind of layer or terrain", view, "operation.fill");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        if (this.alreadyFilling) {
            logger.debug("Fill operation already in progress; ignoring repeated invocation");
            return;
        }
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        if (!dimension.isTilePresent(centreX >> 7, centreY >> 7)) {
            return;
        }
        this.alreadyFilling = true;
        try {
            this.painter.setUndo(inverse);
            Dimension dimension2 = dimension;
            synchronized (dimension2) {
                dimension.setEventsInhibited(true);
            }
            try {
                if (!this.painter.fill(dimension, centreX, centreY, SwingUtilities.getWindowAncestor((Component)this.getView()))) {
                    MessageUtils.showWarning((Component)this.getView(), (String)"The area to be filled was too large and may not have been completely filled.", (String)"Area Too Large");
                }
            }
            catch (IndexOutOfBoundsException e) {
                Dimension dimension3 = dimension;
                synchronized (dimension3) {
                    if (dimension.undoChanges()) {
                        dimension.clearRedo();
                        dimension.armSavePoint();
                    }
                }
                JOptionPane.showMessageDialog((Component)this.getView(), "The area to be filled is too large or complex; please retry with a smaller area", "Area Too Large", 0);
            }
            finally {
                Dimension dimension4 = dimension;
                synchronized (dimension4) {
                    dimension.setEventsInhibited(false);
                }
            }
        }
        finally {
            this.alreadyFilling = false;
        }
    }

    @Override
    public Paint getPaint() {
        return this.painter.getPaint();
    }

    @Override
    public void setPaint(Paint paint) {
        if (this.getBrush() != null) {
            paint.setBrush(this.getBrush());
        }
        this.painter.setPaint(paint);
    }

    @Override
    public JPanel getOptionsPanel() {
        return OPTIONS_PANEL;
    }

    @Override
    protected void brushChanged(Brush newBrush) {
        if (this.painter.getPaint() != null) {
            this.painter.getPaint().setBrush(newBrush);
        }
    }
}

