/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.tunnel;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.CollectionUtils;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.BetterJPopupMenu;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.BiomeListCellRenderer;
import org.pepsoft.worldpainter.ColourEditor;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialChooser;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.NoiseSettingsDialog;
import org.pepsoft.worldpainter.NoiseSettingsEditor;
import org.pepsoft.worldpainter.NoiseSettingsTableCellRenderer;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.exporting.IncidentalLayerExporter;
import org.pepsoft.worldpainter.heightMaps.ConstantHeightMap;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.layers.AbstractEditLayerDialog;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Bo2Layer;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.EditLayerDialog;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerManager;
import org.pepsoft.worldpainter.layers.LayerTableCellRenderer;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayer;
import org.pepsoft.worldpainter.layers.plants.PlantLayer;
import org.pepsoft.worldpainter.layers.tunnel.FloorDimensionSettingsDialog;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerExporter;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayersTableModel;
import org.pepsoft.worldpainter.themes.Filter;
import org.pepsoft.worldpainter.themes.JSpinnerTableCellEditor;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.Theme;
import org.pepsoft.worldpainter.util.BiomeUtils;

public class TunnelLayerDialog
extends AbstractEditLayerDialog<TunnelLayer>
implements ChangeListener,
ListSelectionListener {
    private JButton buttonAddFloorLayer;
    private JButton buttonAddRoofLayer;
    private JButton buttonCancel;
    private JButton buttonEditFloorLayer;
    private JButton buttonEditRoofLayer;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup3;
    private JButton buttonNewFloorLayer;
    private JButton buttonNewRoofLayer;
    private JButton buttonOK;
    private JButton buttonRemoveFloorLayer;
    private JButton buttonRemoveRoofLayer;
    private JButton buttonReset;
    private JCheckBox checkBoxFlood;
    private JCheckBox checkBoxFloodWithLava;
    private JCheckBox checkBoxRemoveWater;
    private ColourEditor colourEditor1;
    private JComboBox<Integer> comboBoxBiome;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JLabel labelPreview;
    private MixedMaterialChooser mixedMaterialChooserFloor;
    private MixedMaterialChooser mixedMaterialChooserRoof;
    private MixedMaterialChooser mixedMaterialChooserWall;
    private NoiseSettingsEditor noiseSettingsEditorFloor;
    private NoiseSettingsEditor noiseSettingsEditorRoof;
    private JRadioButton radioButtonFloorCustomDimension;
    private JRadioButton radioButtonFloorFixedDepth;
    private JRadioButton radioButtonFloorFixedLevel;
    private JRadioButton radioButtonFloorInverse;
    private JRadioButton radioButtonRoofFixedDepth;
    private JRadioButton radioButtonRoofFixedHeight;
    private JRadioButton radioButtonRoofFixedLevel;
    private JRadioButton radioButtonRoofInverse;
    private JSpinner spinnerFloodLevel;
    private JSpinner spinnerFloorLevel;
    private JSpinner spinnerFloorMax;
    private JSpinner spinnerFloorMin;
    private JSpinner spinnerRoofLevel;
    private JSpinner spinnerRoofMax;
    private JSpinner spinnerRoofMin;
    private JSpinner spinnerWallFloorDepth;
    private JSpinner spinnerWallRoofDepth;
    private JTable tableFloorLayers;
    private JTable tableRoofLayers;
    private JTextField textFieldName;
    private final Platform platform;
    private final TunnelLayer layer;
    private final Dimension dimension;
    private final int waterLevel;
    private final int baseHeight;
    private final int minHeight;
    private final int maxHeight;
    private final ColourScheme colourScheme;
    private final CustomBiomeManager customBiomeManager;
    private TunnelLayersTableModel floorLayersTableModel;
    private TunnelLayersTableModel roofLayersTableModel;
    private boolean programmaticChange;
    private static final String PAINT_TUNNEL_LAYER_KEY = "org.pepsoft.worldpainter.TunnelLayer.paintLayer";
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelLayerDialog(Window parent, Platform platform, TunnelLayer layer, Dimension dimension, boolean extendedBlockIds, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, int minHeight, int maxHeight, int baseHeight, int waterLevel) {
        super(parent);
        this.platform = platform;
        this.layer = layer;
        this.dimension = dimension;
        this.colourScheme = colourScheme;
        this.customBiomeManager = customBiomeManager;
        this.baseHeight = baseHeight;
        this.waterLevel = waterLevel;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.initComponents();
        this.programmaticChange = true;
        try {
            this.tableFloorLayers.getSelectionModel().addListSelectionListener(this);
            this.tableRoofLayers.getSelectionModel().addListSelectionListener(this);
            this.mixedMaterialChooserFloor.setPlatform(platform);
            this.mixedMaterialChooserFloor.setExtendedBlockIds(extendedBlockIds);
            this.mixedMaterialChooserFloor.setColourScheme(colourScheme);
            this.mixedMaterialChooserRoof.setPlatform(platform);
            this.mixedMaterialChooserRoof.setExtendedBlockIds(extendedBlockIds);
            this.mixedMaterialChooserRoof.setColourScheme(colourScheme);
            this.mixedMaterialChooserWall.setPlatform(platform);
            this.mixedMaterialChooserWall.setExtendedBlockIds(extendedBlockIds);
            this.mixedMaterialChooserWall.setColourScheme(colourScheme);
            this.labelPreview.setPreferredSize(new java.awt.Dimension(128, 0));
            ((SpinnerNumberModel)this.spinnerFloorLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerFloorLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            ((SpinnerNumberModel)this.spinnerRoofLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerRoofLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            ((SpinnerNumberModel)this.spinnerFloorMin.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerFloorMin.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            ((SpinnerNumberModel)this.spinnerFloorMax.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerFloorMax.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            ((SpinnerNumberModel)this.spinnerRoofMin.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerRoofMin.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            ((SpinnerNumberModel)this.spinnerRoofMax.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerRoofMax.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            ((SpinnerNumberModel)this.spinnerFloodLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerFloodLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
            this.comboBoxBiome.setRenderer(new BiomeListCellRenderer(colourScheme, customBiomeManager, "None", platform));
            if (platform.capabilities.contains(Platform.Capability.BIOMES_3D) || platform.capabilities.contains(Platform.Capability.NAMED_BIOMES)) {
                this.comboBoxBiome.setModel(new DefaultComboBoxModel<Integer>(CollectionUtils.listOf((List[])new List[]{Collections.singletonList(null), BiomeUtils.getAllBiomes((Platform)platform, (CustomBiomeManager)customBiomeManager)}).toArray(new Integer[0])));
            } else {
                this.comboBoxBiome.setModel(new DefaultComboBoxModel<Integer>(new Integer[]{null}));
                this.comboBoxBiome.setEnabled(false);
            }
            this.radioButtonFloorCustomDimension.setEnabled(dimension.getAnchor().role == Dimension.Role.DETAIL);
        }
        finally {
            this.programmaticChange = false;
        }
        this.loadSettings();
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.noiseSettingsEditorFloor.addChangeListener(this);
        this.noiseSettingsEditorRoof.addChangeListener(this);
        this.scaleToUI();
        this.pack();
        this.scaleWindowToUI();
        this.setLocationRelativeTo(parent);
        AwtUtils.doLaterOnEventThread(this::updatePreview);
    }

    @Override
    public TunnelLayer getLayer() {
        return this.layer;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.setControlStates();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.generatePreview();
    }

    @Override
    protected void ok() {
        if (this.tableFloorLayers.isEditing()) {
            this.tableFloorLayers.getCellEditor().stopCellEditing();
        }
        if (this.tableRoofLayers.isEditing()) {
            this.tableRoofLayers.getCellEditor().stopCellEditing();
        }
        if (!this.radioButtonFloorCustomDimension.isSelected() && this.layer.getFloorDimensionId() != null) {
            DesktopUtils.beep();
            if (JOptionPane.showConfirmDialog(this, "The floor dimension will be deleted.\nThis cannot be undone! Proceed?", "Confirm Floor Deletion", 0, 2) != 0) {
                return;
            }
            App app = App.getInstance();
            Dimension currentDimension = app.getDimension();
            int dim = currentDimension.getAnchor().dim;
            World2 world = app.getWorld();
            world.removeDimension(new Dimension.Anchor(dim, Dimension.Role.CAVE_FLOOR, false, this.layer.getFloorDimensionId().intValue()));
            this.layer.setFloorDimensionId(null);
        } else if (this.radioButtonFloorCustomDimension.isSelected() && this.layer.getFloorDimensionId() == null) {
            Dimension floorDimension = this.createFloorDimension();
            if (floorDimension != null) {
                this.layer.setFloorDimensionId(Integer.valueOf(floorDimension.getAnchor().id));
                Configuration config = Configuration.getInstance();
                if (!config.isMessageDisplayedCountAtLeast(PAINT_TUNNEL_LAYER_KEY, 3)) {
                    AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog(App.getInstance(), "Use the paint tools to paint the Custom Cave/Tunnel Layer in the desired shape.\nThen right-click on the [" + this.layer.getName() + "] button on the [" + this.layer.getPalette() + "] panel\nand select \"Edit floor dimension\" to paint on, and vertically shape, the cave floor."));
                    config.setMessageDisplayed(PAINT_TUNNEL_LAYER_KEY);
                }
            } else {
                return;
            }
        }
        this.saveSettingsTo(this.layer, true);
        super.ok();
    }

    private void updatePreview() {
        this.generatePreview();
    }

    private void generatePreview() {
        TunnelLayer layer = new TunnelLayer("tmp", 0);
        this.saveSettingsTo(layer, false);
        Insets insets = this.labelPreview.getInsets();
        int width = this.labelPreview.getWidth() - insets.left - insets.right;
        int height = this.labelPreview.getHeight() - insets.top - insets.bottom;
        if (width > 0 && height > 0) {
            BufferedImage preview = TunnelLayerExporter.generatePreview((TunnelLayer)layer, (int)width, (int)height, (int)this.waterLevel, (int)this.minHeight, (int)this.baseHeight, (int)Math.min(this.maxHeight - this.baseHeight, height - this.baseHeight + this.minHeight));
            this.labelPreview.setIcon(new ImageIcon(preview));
        } else {
            this.labelPreview.setIcon(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        this.programmaticChange = true;
        try {
            this.spinnerFloorLevel.setValue(this.layer.getFloorLevel());
            this.spinnerFloorMin.setValue(Math.max(this.layer.getFloorMin(), this.minHeight));
            this.spinnerFloorMax.setValue(Math.min(this.layer.getFloorMax(), this.maxHeight - 1));
            this.mixedMaterialChooserFloor.setMaterial(this.layer.getFloorMaterial());
            switch (this.layer.getFloorMode()) {
                case CONSTANT_DEPTH: {
                    this.radioButtonFloorFixedDepth.setSelected(true);
                    break;
                }
                case FIXED_HEIGHT: {
                    this.radioButtonFloorFixedLevel.setSelected(true);
                    break;
                }
                case INVERTED_DEPTH: {
                    this.radioButtonFloorInverse.setSelected(true);
                    break;
                }
                case CUSTOM_DIMENSION: {
                    this.radioButtonFloorCustomDimension.setSelected(true);
                }
            }
            NoiseSettings floorNoise = this.layer.getFloorNoise();
            if (floorNoise == null) {
                floorNoise = new NoiseSettings();
            }
            this.noiseSettingsEditorFloor.setNoiseSettings(floorNoise);
            this.spinnerRoofLevel.setValue(this.layer.getRoofLevel());
            this.spinnerRoofMin.setValue(Math.max(this.layer.getRoofMin(), this.minHeight));
            this.spinnerRoofMax.setValue(Math.min(this.layer.getRoofMax(), this.maxHeight - 1));
            this.mixedMaterialChooserRoof.setMaterial(this.layer.getRoofMaterial());
            switch (this.layer.getRoofMode()) {
                case CONSTANT_DEPTH: {
                    this.radioButtonRoofFixedDepth.setSelected(true);
                    break;
                }
                case FIXED_HEIGHT: {
                    this.radioButtonRoofFixedLevel.setSelected(true);
                    break;
                }
                case INVERTED_DEPTH: {
                    this.radioButtonRoofInverse.setSelected(true);
                    break;
                }
                case FIXED_HEIGHT_ABOVE_FLOOR: {
                    this.radioButtonRoofFixedHeight.setSelected(true);
                }
            }
            NoiseSettings roofNoise = this.layer.getRoofNoise();
            if (roofNoise == null) {
                roofNoise = new NoiseSettings();
            }
            this.noiseSettingsEditorRoof.setNoiseSettings(roofNoise);
            this.spinnerWallFloorDepth.setValue(this.layer.getFloorWallDepth());
            this.spinnerWallRoofDepth.setValue(this.layer.getRoofWallDepth());
            this.mixedMaterialChooserWall.setMaterial(this.layer.getWallMaterial());
            this.textFieldName.setText(this.layer.getName());
            this.colourEditor1.setColour(this.layer.getColour());
            this.checkBoxRemoveWater.setSelected(this.layer.isRemoveWater());
            this.checkBoxFlood.setSelected(this.layer.getFloodLevel() != Integer.MIN_VALUE);
            this.spinnerFloodLevel.setValue(this.layer.getFloodLevel() != Integer.MIN_VALUE ? this.layer.getFloodLevel() : this.waterLevel);
            this.checkBoxFloodWithLava.setSelected(this.layer.isFloodWithLava());
            List floorLayers = this.layer.getFloorLayers();
            this.floorLayersTableModel = new TunnelLayersTableModel(floorLayers, this.minHeight, this.maxHeight);
            this.tableFloorLayers.setModel(this.floorLayersTableModel);
            this.tableFloorLayers.getColumnModel().getColumn(0).setCellRenderer(new LayerTableCellRenderer());
            SpinnerNumberModel spinnerModel = new SpinnerNumberModel(50, 0, 100, 1);
            this.tableFloorLayers.getColumnModel().getColumn(1).setCellEditor(new JSpinnerTableCellEditor(spinnerModel));
            this.tableFloorLayers.getColumnModel().getColumn(2).setCellRenderer(new NoiseSettingsTableCellRenderer());
            spinnerModel = new SpinnerNumberModel(this.minHeight, this.minHeight, this.maxHeight - 1, 1);
            this.tableFloorLayers.getColumnModel().getColumn(3).setCellEditor(new JSpinnerTableCellEditor(spinnerModel));
            spinnerModel = new SpinnerNumberModel(this.maxHeight - 1, this.minHeight, this.maxHeight - 1, 1);
            this.tableFloorLayers.getColumnModel().getColumn(4).setCellEditor(new JSpinnerTableCellEditor(spinnerModel));
            List roofLayers = this.layer.getRoofLayers();
            this.roofLayersTableModel = new TunnelLayersTableModel(roofLayers, this.minHeight, this.maxHeight);
            this.tableRoofLayers.setModel(this.roofLayersTableModel);
            this.tableRoofLayers.getColumnModel().getColumn(0).setCellRenderer(new LayerTableCellRenderer());
            spinnerModel = new SpinnerNumberModel(50, 0, 100, 1);
            this.tableRoofLayers.getColumnModel().getColumn(1).setCellEditor(new JSpinnerTableCellEditor(spinnerModel));
            this.tableRoofLayers.getColumnModel().getColumn(2).setCellRenderer(new NoiseSettingsTableCellRenderer());
            spinnerModel = new SpinnerNumberModel(this.minHeight, this.minHeight, this.maxHeight - 1, 1);
            this.tableRoofLayers.getColumnModel().getColumn(3).setCellEditor(new JSpinnerTableCellEditor(spinnerModel));
            spinnerModel = new SpinnerNumberModel(this.maxHeight - 1, this.minHeight, this.maxHeight - 1, 1);
            this.tableRoofLayers.getColumnModel().getColumn(4).setCellEditor(new JSpinnerTableCellEditor(spinnerModel));
            if (this.platform.capabilities.contains(Platform.Capability.BIOMES_3D) || this.platform.capabilities.contains(Platform.Capability.NAMED_BIOMES)) {
                this.comboBoxBiome.setSelectedItem(this.layer.getTunnelBiome());
            }
        }
        finally {
            this.programmaticChange = false;
        }
        this.setControlStates();
    }

    private void saveSettingsTo(TunnelLayer layer, boolean registerMaterials) {
        List<TunnelLayer.LayerSettings> floorLayers;
        layer.setFloorLevel(((Integer)this.spinnerFloorLevel.getValue()).intValue());
        layer.setFloorMin((Integer)this.spinnerFloorMin.getValue() <= this.minHeight ? Integer.MIN_VALUE : (Integer)this.spinnerFloorMin.getValue());
        layer.setFloorMax((Integer)this.spinnerFloorMax.getValue() >= this.maxHeight - 1 ? Integer.MAX_VALUE : (Integer)this.spinnerFloorMax.getValue());
        MixedMaterial floorMaterial = this.mixedMaterialChooserFloor.getMaterial();
        if (floorMaterial != null && registerMaterials) {
            floorMaterial = MixedMaterialManager.getInstance().register(floorMaterial);
        }
        layer.setFloorMaterial(floorMaterial);
        if (this.radioButtonFloorFixedDepth.isSelected()) {
            layer.setFloorMode(TunnelLayer.Mode.CONSTANT_DEPTH);
        } else if (this.radioButtonFloorFixedLevel.isSelected()) {
            layer.setFloorMode(TunnelLayer.Mode.FIXED_HEIGHT);
        } else if (this.radioButtonFloorCustomDimension.isSelected()) {
            layer.setFloorMode(TunnelLayer.Mode.CUSTOM_DIMENSION);
        } else {
            layer.setFloorMode(TunnelLayer.Mode.INVERTED_DEPTH);
        }
        NoiseSettings floorNoiseSettings = this.noiseSettingsEditorFloor.getNoiseSettings();
        if (floorNoiseSettings.getRange() == 0) {
            layer.setFloorNoise(null);
        } else {
            layer.setFloorNoise(floorNoiseSettings);
        }
        layer.setRoofLevel(((Integer)this.spinnerRoofLevel.getValue()).intValue());
        layer.setRoofMin((Integer)this.spinnerRoofMin.getValue() <= this.minHeight ? Integer.MIN_VALUE : (Integer)this.spinnerRoofMin.getValue());
        layer.setRoofMax((Integer)this.spinnerRoofMax.getValue() >= this.maxHeight - 1 ? Integer.MAX_VALUE : (Integer)this.spinnerRoofMax.getValue());
        MixedMaterial roofMaterial = this.mixedMaterialChooserRoof.getMaterial();
        if (roofMaterial != null && registerMaterials) {
            roofMaterial = MixedMaterialManager.getInstance().register(roofMaterial);
        }
        layer.setRoofMaterial(roofMaterial);
        if (this.radioButtonRoofFixedDepth.isSelected()) {
            layer.setRoofMode(TunnelLayer.Mode.CONSTANT_DEPTH);
        } else if (this.radioButtonRoofFixedLevel.isSelected()) {
            layer.setRoofMode(TunnelLayer.Mode.FIXED_HEIGHT);
        } else if (this.radioButtonRoofFixedHeight.isSelected()) {
            layer.setRoofMode(TunnelLayer.Mode.FIXED_HEIGHT_ABOVE_FLOOR);
        } else {
            layer.setRoofMode(TunnelLayer.Mode.INVERTED_DEPTH);
        }
        NoiseSettings roofNoiseSettings = this.noiseSettingsEditorRoof.getNoiseSettings();
        if (roofNoiseSettings.getRange() == 0) {
            layer.setRoofNoise(null);
        } else {
            layer.setRoofNoise(roofNoiseSettings);
        }
        layer.setFloorWallDepth(((Integer)this.spinnerWallFloorDepth.getValue()).intValue());
        layer.setRoofWallDepth(((Integer)this.spinnerWallRoofDepth.getValue()).intValue());
        MixedMaterial wallMaterial = this.mixedMaterialChooserWall.getMaterial();
        if (wallMaterial != null && registerMaterials) {
            wallMaterial = MixedMaterialManager.getInstance().register(wallMaterial);
        }
        layer.setWallMaterial(wallMaterial);
        layer.setName(this.textFieldName.getText().trim());
        layer.setColour(this.colourEditor1.getColour());
        layer.setRemoveWater(this.checkBoxRemoveWater.isSelected());
        layer.setFloodLevel(this.checkBoxFlood.isSelected() ? (Integer)this.spinnerFloodLevel.getValue() : Integer.MIN_VALUE);
        layer.setFloodWithLava(this.checkBoxFloodWithLava.isSelected());
        if (this.platform.capabilities.contains(Platform.Capability.BIOMES_3D) || this.platform.capabilities.contains(Platform.Capability.NAMED_BIOMES)) {
            layer.setTunnelBiome((Integer)this.comboBoxBiome.getSelectedItem());
        }
        layer.setFloorLayers((floorLayers = this.floorLayersTableModel.getLayers()) != null && !floorLayers.isEmpty() ? floorLayers : null);
        List<TunnelLayer.LayerSettings> roofLayers = this.roofLayersTableModel.getLayers();
        layer.setRoofLayers(roofLayers != null && !roofLayers.isEmpty() ? roofLayers : null);
    }

    private void setControlStates() {
        this.spinnerFloorLevel.setEnabled(!this.radioButtonFloorCustomDimension.isSelected());
        this.spinnerFloorMin.setEnabled(!this.radioButtonFloorFixedLevel.isSelected() && !this.radioButtonFloorCustomDimension.isSelected());
        this.spinnerFloorMax.setEnabled(!this.radioButtonFloorFixedLevel.isSelected() && !this.radioButtonFloorCustomDimension.isSelected());
        this.noiseSettingsEditorFloor.setEnabled(!this.radioButtonFloorCustomDimension.isSelected());
        this.mixedMaterialChooserFloor.setEnabled(!this.radioButtonFloorCustomDimension.isSelected());
        this.jTabbedPane1.setEnabledAt(1, !this.radioButtonFloorCustomDimension.isSelected());
        this.spinnerRoofMin.setEnabled(!this.radioButtonRoofFixedLevel.isSelected());
        this.spinnerRoofMax.setEnabled(!this.radioButtonRoofFixedLevel.isSelected());
        this.checkBoxFlood.setEnabled(!this.radioButtonFloorCustomDimension.isSelected());
        this.checkBoxFloodWithLava.setEnabled(this.checkBoxFlood.isSelected() && !this.radioButtonFloorCustomDimension.isSelected());
        this.spinnerFloodLevel.setEnabled(this.checkBoxFlood.isSelected() && !this.radioButtonFloorCustomDimension.isSelected());
        int selectedFloorRowCount = this.tableFloorLayers.getSelectedRowCount();
        this.buttonRemoveFloorLayer.setEnabled(selectedFloorRowCount > 0);
        this.buttonEditFloorLayer.setEnabled(selectedFloorRowCount == 1 && this.floorLayersTableModel.getLayer(this.tableFloorLayers.getSelectedRow()) instanceof CustomLayer);
        int selectedRoofRowCount = this.tableRoofLayers.getSelectedRowCount();
        this.buttonRemoveRoofLayer.setEnabled(selectedRoofRowCount > 0);
        this.buttonEditRoofLayer.setEnabled(selectedRoofRowCount == 1 && this.roofLayersTableModel.getLayer(this.tableRoofLayers.getSelectedRow()) instanceof CustomLayer);
    }

    private void removeFloorLayers() {
        if (this.tableFloorLayers.isEditing()) {
            this.tableFloorLayers.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.tableFloorLayers.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.floorLayersTableModel.removeLayer(selectedRows[i]);
        }
    }

    private void removeRoofLayers() {
        if (this.tableRoofLayers.isEditing()) {
            this.tableRoofLayers.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.tableRoofLayers.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.roofLayersTableModel.removeLayer(selectedRows[i]);
        }
    }

    private void editFloorLayer() {
        this.editLayer(this.tableFloorLayers, this.floorLayersTableModel);
    }

    private void editRoofLayer() {
        this.editLayer(this.tableRoofLayers, this.roofLayersTableModel);
    }

    private void editLayer(JTable table, TunnelLayersTableModel tableModel) {
        Layer layer;
        int selectedRow = table.getSelectedRow();
        if (selectedRow != -1 && (layer = tableModel.getLayer(selectedRow)) instanceof CustomLayer) {
            EditLayerDialog<Layer> dialog = new EditLayerDialog<Layer>((Window)this, this.platform, layer);
            dialog.setVisible(() -> tableModel.layerChanged(selectedRow));
        }
    }

    private void addFloorLayer() {
        this.addLayer(this.buttonAddFloorLayer, this.floorLayersTableModel);
    }

    private void addRoofLayer() {
        this.addLayer(this.buttonAddRoofLayer, this.roofLayersTableModel);
    }

    private void addLayer(Component button, TunnelLayersTableModel tableModel) {
        BetterJPopupMenu popupMenu = new BetterJPopupMenu();
        LayerManager.getInstance().getLayers().stream().filter(l -> l.getExporterType() != null && IncidentalLayerExporter.class.isAssignableFrom(l.getExporterType())).forEach(arg_0 -> TunnelLayerDialog.lambda$addLayer$4(tableModel, (JPopupMenu)popupMenu, arg_0));
        App app = App.getInstance();
        Set<CustomLayer> customLayers = app.getCustomLayers().stream().filter(l -> IncidentalLayerExporter.class.isAssignableFrom(l.getExporterType())).collect(Collectors.toSet());
        if (customLayers.size() > 15) {
            app.getCustomLayersByPalette().entrySet().stream().map(entry -> {
                String palette = (String)entry.getKey();
                JMenu paletteMenu = new JMenu(palette != null ? palette : "Hidden Layers");
                ((Collection)entry.getValue()).stream().filter(l -> IncidentalLayerExporter.class.isAssignableFrom(l.getExporterType())).forEach(l -> {
                    JMenuItem menuItem = new JMenuItem(l.getName(), new ImageIcon(l.getIcon()));
                    menuItem.addActionListener(e -> tableModel.addLayer((Layer)l));
                    paletteMenu.add(menuItem);
                });
                return paletteMenu;
            }).filter(paletteMenu -> paletteMenu.getItemCount() > 0).forEach(((JPopupMenu)popupMenu)::add);
        } else {
            customLayers.forEach(arg_0 -> TunnelLayerDialog.lambda$addLayer$12(tableModel, (JPopupMenu)popupMenu, arg_0));
        }
        popupMenu.show(button, button.getWidth(), 0);
    }

    private void newFloorLayer() {
        this.newLayer(this.buttonNewFloorLayer, this.floorLayersTableModel);
    }

    private void newRoofLayer() {
        this.newLayer(this.buttonNewRoofLayer, this.roofLayersTableModel);
    }

    private void newLayer(Component button, TunnelLayersTableModel tableModel) {
        BetterJPopupMenu popupMenu = new BetterJPopupMenu();
        JMenuItem item = new JMenuItem("Custom Objects Layer");
        item.addActionListener(e -> {
            EditLayerDialog<Class<Bo2Layer>> dialog = new EditLayerDialog<Class<Bo2Layer>>((Window)this, this.platform, Bo2Layer.class);
            dialog.setVisible(() -> {
                Bo2Layer newLayer = (Bo2Layer)dialog.getLayer();
                newLayer.setHide(true);
                tableModel.addLayer((Layer)newLayer);
            });
        });
        popupMenu.add(item);
        item = new JMenuItem("Custom Ground Cover Layer");
        item.addActionListener(e -> {
            EditLayerDialog<Class<GroundCoverLayer>> dialog = new EditLayerDialog<Class<GroundCoverLayer>>((Window)this, this.platform, GroundCoverLayer.class);
            dialog.setVisible(() -> {
                GroundCoverLayer newLayer = (GroundCoverLayer)dialog.getLayer();
                newLayer.setHide(true);
                tableModel.addLayer((Layer)newLayer);
            });
        });
        popupMenu.add(item);
        item = new JMenuItem("Custom Plants Layer");
        item.addActionListener(e -> {
            EditLayerDialog<Class<PlantLayer>> dialog = new EditLayerDialog<Class<PlantLayer>>((Window)this, this.platform, PlantLayer.class);
            dialog.setVisible(() -> {
                PlantLayer newLayer = (PlantLayer)dialog.getLayer();
                newLayer.setHide(true);
                tableModel.addLayer((Layer)newLayer);
            });
        });
        popupMenu.add(item);
        popupMenu.show(button, button.getWidth(), 0);
    }

    private void editFloorLayerVariation() {
        this.editLayerVariation(this.tableFloorLayers, this.floorLayersTableModel);
    }

    private void editRoofLayerVariation() {
        this.editLayerVariation(this.tableRoofLayers, this.roofLayersTableModel);
    }

    private void editLayerVariation(JTable table, TunnelLayersTableModel tableModel) {
        int selectedRow = table.getSelectedRow();
        if (selectedRow != -1) {
            NoiseSettings noiseSettings = (NoiseSettings)tableModel.getValueAt(selectedRow, 2);
            NoiseSettingsDialog noiseSettingsDialog = new NoiseSettingsDialog((Window)this, noiseSettings != null ? noiseSettings : new NoiseSettings(), (Integer)tableModel.getValueAt(selectedRow, 1));
            noiseSettingsDialog.setVisible(true);
            if (!noiseSettingsDialog.isCancelled()) {
                noiseSettings = noiseSettingsDialog.getNoiseSettings();
                if (noiseSettings.getRange() == 0) {
                    tableModel.setValueAt(null, selectedRow, 2);
                } else {
                    tableModel.setValueAt(noiseSettings, selectedRow, 2);
                }
                tableModel.layerChanged(selectedRow);
            }
        }
    }

    private Dimension createFloorDimension() {
        int minHeight = this.dimension.getMinHeight();
        int maxHeight = this.dimension.getMaxHeight();
        FloorDimensionSettingsDialog dialog = new FloorDimensionSettingsDialog(this, this.colourScheme, this.platform, minHeight, maxHeight, (Integer)this.spinnerFloorLevel.getValue(), this.noiseSettingsEditorFloor.getNoiseSettings(), this.checkBoxFlood.isSelected() ? (Integer)this.spinnerFloodLevel.getValue() : minHeight, this.checkBoxFloodWithLava.isSelected(), this.dimension.getSubsurfaceMaterial());
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            int dim = this.dimension.getAnchor().dim;
            boolean invert = this.dimension.getAnchor().invert;
            World2 world = this.dimension.getWorld();
            int id = this.findNextId(world, dim, Dimension.Role.CAVE_FLOOR, invert);
            this.layer.setFloorDimensionId(Integer.valueOf(id));
            long seed = this.dimension.getSeed() + (long)id;
            ConstantHeightMap heightMap = new ConstantHeightMap((double)dialog.getLevel());
            if (dialog.getVariation().getRange() != 0) {
                heightMap = heightMap.minus((double)dialog.getVariation().getRange()).plus((HeightMap)new NoiseHeightMap(dialog.getVariation()));
            }
            SimpleTheme theme = SimpleTheme.createSingleTerrain((Terrain)dialog.getTerrain(), (int)minHeight, (int)maxHeight, (int)dialog.getWaterLevel());
            if (dialog.getBiome() != null) {
                theme.setLayerMap(Collections.singletonMap(Filter.EVERYWHERE, Biome.INSTANCE));
                theme.setDiscreteValues(Collections.singletonMap(Biome.INSTANCE, dialog.getBiome()));
            }
            HeightMapTileFactory tileFactory = new HeightMapTileFactory(seed, (HeightMap)heightMap, minHeight, maxHeight, dialog.isFloodWithLava(), (Theme)theme);
            Dimension floorDimension = new Dimension(world, null, seed, (TileFactory)tileFactory, new Dimension.Anchor(dim, Dimension.Role.CAVE_FLOOR, invert, id));
            world.addDimension(floorDimension);
            this.layer.updateFloorDimension(this.dimension, this.textFieldName.getText() + " Floor");
            this.layer.setFloorLevel(dialog.getLevel());
            this.layer.setFloorNoise(dialog.getVariation());
            this.layer.setFloodLevel(dialog.getWaterLevel());
            this.layer.setFloodWithLava(dialog.isFloodWithLava());
            this.layer.setBiome(dialog.getBiome() != null ? dialog.getBiome() : -1);
            return floorDimension;
        }
        return null;
    }

    private int findNextId(World2 world, int dim, Dimension.Role role, boolean invert) {
        int layer = 0;
        for (Dimension dimension : world.getDimensions()) {
            Dimension.Anchor anchor = dimension.getAnchor();
            if (anchor.dim != dim || anchor.role != role || anchor.invert != invert) continue;
            layer = Math.max(layer, anchor.id + 1);
        }
        return layer;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.buttonReset = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.textFieldName = new JTextField();
        this.jLabel11 = new JLabel();
        this.colourEditor1 = new ColourEditor();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.radioButtonFloorFixedLevel = new JRadioButton();
        this.spinnerRoofLevel = new JSpinner();
        this.jLabel12 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel9 = new JLabel();
        this.spinnerFloorLevel = new JSpinner();
        this.jLabel20 = new JLabel();
        this.radioButtonRoofFixedDepth = new JRadioButton();
        this.spinnerFloorMin = new JSpinner();
        this.noiseSettingsEditorFloor = new NoiseSettingsEditor();
        this.jLabel17 = new JLabel();
        this.spinnerRoofMin = new JSpinner();
        this.jLabel18 = new JLabel();
        this.jLabel2 = new JLabel();
        this.spinnerFloodLevel = new JSpinner();
        this.radioButtonFloorFixedDepth = new JRadioButton();
        this.jLabel14 = new JLabel();
        this.checkBoxFloodWithLava = new JCheckBox();
        this.spinnerRoofMax = new JSpinner();
        this.jLabel13 = new JLabel();
        this.noiseSettingsEditorRoof = new NoiseSettingsEditor();
        this.jLabel8 = new JLabel();
        this.jLabel16 = new JLabel();
        this.spinnerWallRoofDepth = new JSpinner();
        this.spinnerWallFloorDepth = new JSpinner();
        this.checkBoxRemoveWater = new JCheckBox();
        this.spinnerFloorMax = new JSpinner();
        this.jLabel19 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.radioButtonFloorInverse = new JRadioButton();
        this.checkBoxFlood = new JCheckBox();
        this.radioButtonRoofFixedLevel = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.radioButtonRoofInverse = new JRadioButton();
        this.jLabel15 = new JLabel();
        this.jLabel10 = new JLabel();
        this.labelPreview = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel23 = new JLabel();
        this.comboBoxBiome = new JComboBox();
        this.radioButtonFloorCustomDimension = new JRadioButton();
        this.radioButtonRoofFixedHeight = new JRadioButton();
        this.mixedMaterialChooserRoof = new MixedMaterialChooser(true);
        this.mixedMaterialChooserFloor = new MixedMaterialChooser(true);
        this.mixedMaterialChooserWall = new MixedMaterialChooser(true);
        this.jPanel2 = new JPanel();
        this.jLabel22 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableFloorLayers = new JTable();
        this.buttonNewFloorLayer = new JButton();
        this.buttonAddFloorLayer = new JButton();
        this.buttonEditFloorLayer = new JButton();
        this.buttonRemoveFloorLayer = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel24 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tableRoofLayers = new JTable();
        this.buttonNewRoofLayer = new JButton();
        this.buttonAddRoofLayer = new JButton();
        this.buttonEditRoofLayer = new JButton();
        this.buttonRemoveRoofLayer = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Configure Cave/Tunnel Layer");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.buttonReset.setText("Reset");
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonResetActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Create underground tunnels and caves with the following properties:");
        this.jLabel4.setText("Name:");
        this.textFieldName.setColumns(20);
        this.textFieldName.setText("jTextField1");
        this.jLabel11.setText("Colour:");
        this.buttonGroup1.add(this.radioButtonFloorFixedLevel);
        this.radioButtonFloorFixedLevel.setSelected(true);
        this.radioButtonFloorFixedLevel.setText("fixed level");
        this.radioButtonFloorFixedLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.radioButtonFloorFixedLevelActionPerformed(evt);
            }
        });
        this.spinnerRoofLevel.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.spinnerRoofLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TunnelLayerDialog.this.spinnerRoofLevelStateChanged(evt);
            }
        });
        this.jLabel12.setText("Walls:");
        this.jLabel5.setText("Variation:");
        this.jLabel9.setText("Variation:");
        this.spinnerFloorLevel.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.spinnerFloorLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TunnelLayerDialog.this.spinnerFloorLevelStateChanged(evt);
            }
        });
        this.jLabel20.setText("Options:");
        this.buttonGroup3.add(this.radioButtonRoofFixedDepth);
        this.radioButtonRoofFixedDepth.setText("fixed depth");
        this.radioButtonRoofFixedDepth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.radioButtonRoofFixedDepthActionPerformed(evt);
            }
        });
        this.spinnerFloorMin.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.spinnerFloorMin.setEnabled(false);
        this.spinnerFloorMin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TunnelLayerDialog.this.spinnerFloorMinStateChanged(evt);
            }
        });
        this.jLabel17.setText(", max:");
        this.spinnerRoofMin.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.spinnerRoofMin.setEnabled(false);
        this.spinnerRoofMin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TunnelLayerDialog.this.spinnerRoofMinStateChanged(evt);
            }
        });
        this.jLabel18.setText("Absolute min:");
        this.jLabel2.setText("Floor:");
        this.spinnerFloodLevel.setModel(new SpinnerNumberModel(1, 1, 255, 1));
        this.spinnerFloodLevel.setEnabled(false);
        this.spinnerFloodLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TunnelLayerDialog.this.spinnerFloodLevelStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonFloorFixedDepth);
        this.radioButtonFloorFixedDepth.setText("fixed depth");
        this.radioButtonFloorFixedDepth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.radioButtonFloorFixedDepthActionPerformed(evt);
            }
        });
        this.jLabel14.setText("Material:");
        this.checkBoxFloodWithLava.setText("Flood with lava:");
        this.checkBoxFloodWithLava.setEnabled(false);
        this.checkBoxFloodWithLava.setHorizontalTextPosition(10);
        this.checkBoxFloodWithLava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.checkBoxFloodWithLavaActionPerformed(evt);
            }
        });
        this.spinnerRoofMax.setModel(new SpinnerNumberModel(255, 0, 255, 1));
        this.spinnerRoofMax.setEnabled(false);
        this.spinnerRoofMax.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TunnelLayerDialog.this.spinnerRoofMaxStateChanged(evt);
            }
        });
        this.jLabel13.setText("Bottom width:");
        this.jLabel8.setText("Level:");
        this.jLabel16.setText("Absolute min:");
        this.spinnerWallRoofDepth.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.spinnerWallRoofDepth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TunnelLayerDialog.this.spinnerWallRoofDepthStateChanged(evt);
            }
        });
        this.spinnerWallFloorDepth.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.spinnerWallFloorDepth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TunnelLayerDialog.this.spinnerWallFloorDepthStateChanged(evt);
            }
        });
        this.checkBoxRemoveWater.setText("Remove water or lava:");
        this.checkBoxRemoveWater.setHorizontalTextPosition(10);
        this.checkBoxRemoveWater.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.checkBoxRemoveWaterActionPerformed(evt);
            }
        });
        this.spinnerFloorMax.setModel(new SpinnerNumberModel(255, 0, 255, 1));
        this.spinnerFloorMax.setEnabled(false);
        this.spinnerFloorMax.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TunnelLayerDialog.this.spinnerFloorMaxStateChanged(evt);
            }
        });
        this.jLabel19.setText(", max:");
        this.jLabel7.setText("Material:");
        this.jLabel6.setText("Ceiling:");
        this.buttonGroup1.add(this.radioButtonFloorInverse);
        this.radioButtonFloorInverse.setText("opposite of terrain");
        this.radioButtonFloorInverse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.radioButtonFloorInverseActionPerformed(evt);
            }
        });
        this.checkBoxFlood.setText("Flood the caves/tunnels:");
        this.checkBoxFlood.setHorizontalTextPosition(10);
        this.checkBoxFlood.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.checkBoxFloodActionPerformed(evt);
            }
        });
        this.buttonGroup3.add(this.radioButtonRoofFixedLevel);
        this.radioButtonRoofFixedLevel.setText("fixed level");
        this.radioButtonRoofFixedLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.radioButtonRoofFixedLevelActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Level:");
        this.buttonGroup3.add(this.radioButtonRoofInverse);
        this.radioButtonRoofInverse.setText("opposite of terrain");
        this.radioButtonRoofInverse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.radioButtonRoofInverseActionPerformed(evt);
            }
        });
        this.jLabel15.setText("Top width:");
        this.jLabel10.setText("Material:");
        this.labelPreview.setBorder(BorderFactory.createBevelBorder(1));
        this.jLabel21.setLabelFor(this.spinnerFloodLevel);
        this.jLabel21.setText("Level:");
        this.jLabel23.setText("Biome:");
        this.buttonGroup1.add(this.radioButtonFloorCustomDimension);
        this.radioButtonFloorCustomDimension.setText("custom dimension [ALPHA]");
        this.radioButtonFloorCustomDimension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.radioButtonFloorCustomDimensionActionPerformed(evt);
            }
        });
        this.buttonGroup3.add(this.radioButtonRoofFixedHeight);
        this.radioButtonRoofFixedHeight.setSelected(true);
        this.radioButtonRoofFixedHeight.setText("fixed height above floor");
        this.radioButtonRoofFixedHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.radioButtonRoofFixedHeightActionPerformed(evt);
            }
        });
        this.mixedMaterialChooserRoof.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TunnelLayerDialog.this.mixedMaterialChooserRoofPropertyChange(evt);
            }
        });
        this.mixedMaterialChooserFloor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TunnelLayerDialog.this.mixedMaterialChooserFloorPropertyChange(evt);
            }
        });
        this.mixedMaterialChooserWall.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TunnelLayerDialog.this.mixedMaterialChooserWallPropertyChange(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12).addComponent(this.jLabel6).addComponent(this.jLabel2).addComponent(this.jLabel20).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerWallFloorDepth, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerWallRoofDepth, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mixedMaterialChooserWall, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioButtonRoofFixedHeight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonRoofFixedLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonRoofFixedDepth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonRoofInverse)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerRoofLevel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerRoofMin, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerRoofMax, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerFloorLevel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerFloorMin, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerFloorMax, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.checkBoxFlood).addGap(18, 18, 18).addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerFloodLevel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkBoxFloodWithLava)).addComponent(this.checkBoxRemoveWater).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxBiome, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioButtonFloorFixedLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonFloorFixedDepth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonFloorInverse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonFloorCustomDimension)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mixedMaterialChooserRoof, -2, -1, -2).addComponent(this.noiseSettingsEditorRoof, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mixedMaterialChooserFloor, -2, -1, -2).addComponent(this.noiseSettingsEditorFloor, -2, -1, -2)))))).addGap(18, 18, 18).addComponent(this.labelPreview, -1, 142, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonRoofFixedLevel).addComponent(this.radioButtonRoofFixedDepth).addComponent(this.radioButtonRoofInverse).addComponent(this.radioButtonRoofFixedHeight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.spinnerRoofLevel, -2, -1, -2).addComponent(this.jLabel16).addComponent(this.spinnerRoofMin, -2, -1, -2).addComponent(this.jLabel17).addComponent(this.spinnerRoofMax, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.noiseSettingsEditorRoof, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.mixedMaterialChooserRoof, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonFloorFixedLevel).addComponent(this.radioButtonFloorFixedDepth).addComponent(this.radioButtonFloorInverse).addComponent(this.radioButtonFloorCustomDimension)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.spinnerFloorMin, -2, -1, -2).addComponent(this.jLabel19).addComponent(this.spinnerFloorMax, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.spinnerFloorLevel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.noiseSettingsEditorFloor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.mixedMaterialChooserFloor, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.spinnerWallFloorDepth, -2, -1, -2).addComponent(this.jLabel15).addComponent(this.spinnerWallRoofDepth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.mixedMaterialChooserWall, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel23).addComponent(this.comboBoxBiome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxRemoveWater).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxFlood).addComponent(this.jLabel21).addComponent(this.spinnerFloodLevel, -2, -1, -2).addComponent(this.checkBoxFloodWithLava))).addComponent(this.labelPreview, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Caves/Tunnels Settings", this.jPanel1);
        this.jLabel22.setText("You can add custom layers here which will be rendered on the cave/tunnel floors:");
        this.tableFloorLayers.setSelectionMode(2);
        this.tableFloorLayers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TunnelLayerDialog.this.tableFloorLayersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tableFloorLayers);
        this.buttonNewFloorLayer.setText("Create New");
        this.buttonNewFloorLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonNewFloorLayerActionPerformed(evt);
            }
        });
        this.buttonAddFloorLayer.setText("Copy Existing");
        this.buttonAddFloorLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonAddFloorLayerActionPerformed(evt);
            }
        });
        this.buttonEditFloorLayer.setText("Edit");
        this.buttonEditFloorLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonEditFloorLayerActionPerformed(evt);
            }
        });
        this.buttonRemoveFloorLayer.setText("Remove");
        this.buttonRemoveFloorLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonRemoveFloorLayerActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel22).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 524, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonAddFloorLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonNewFloorLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonEditFloorLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonRemoveFloorLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 470, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.buttonNewFloorLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAddFloorLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEditFloorLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveFloorLayer))).addContainerGap()));
        this.jTabbedPane1.addTab("Floor Layers", this.jPanel2);
        this.jLabel24.setText("<html>You can add custom layers here which will be rendered on the cave/tunnel roofs:<br>\n<strong>Note:</strong> these layers will be inverted! This includes Custom Objects.<br>\nA later release will make this optional.</html>");
        this.tableRoofLayers.setSelectionMode(2);
        this.tableRoofLayers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TunnelLayerDialog.this.tableRoofLayersMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tableRoofLayers);
        this.buttonNewRoofLayer.setText("Create New");
        this.buttonNewRoofLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonNewRoofLayerActionPerformed(evt);
            }
        });
        this.buttonAddRoofLayer.setText("Copy Existing");
        this.buttonAddRoofLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonAddRoofLayerActionPerformed(evt);
            }
        });
        this.buttonEditRoofLayer.setText("Edit");
        this.buttonEditRoofLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonEditRoofLayerActionPerformed(evt);
            }
        });
        this.buttonRemoveRoofLayer.setText("Remove");
        this.buttonRemoveRoofLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TunnelLayerDialog.this.buttonRemoveRoofLayerActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel24, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 524, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonAddRoofLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonNewRoofLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonEditRoofLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.buttonRemoveRoofLayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel24, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 438, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.buttonNewRoofLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAddRoofLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEditRoofLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRoofLayer))).addContainerGap()));
        this.jTabbedPane1.addTab("Roof Layers", this.jPanel3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonReset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel).addGap(11, 11, 11)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colourEditor1, -2, -1, -2)).addComponent(this.jTabbedPane1)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.textFieldName, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.colourEditor1, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK).addComponent(this.buttonReset)).addContainerGap()));
        this.pack();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonResetActionPerformed(ActionEvent evt) {
        this.loadSettings();
        this.updatePreview();
    }

    private void radioButtonRoofInverseActionPerformed(ActionEvent evt) {
        this.updatePreview();
        this.setControlStates();
    }

    private void radioButtonRoofFixedLevelActionPerformed(ActionEvent evt) {
        this.updatePreview();
        this.setControlStates();
    }

    private void checkBoxFloodActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.updatePreview();
    }

    private void radioButtonFloorInverseActionPerformed(ActionEvent evt) {
        this.updatePreview();
        this.setControlStates();
    }

    private void spinnerFloorMaxStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            if ((Integer)this.spinnerFloorMax.getValue() < (Integer)this.spinnerFloorMin.getValue()) {
                this.spinnerFloorMin.setValue(this.spinnerFloorMax.getValue());
            }
            this.updatePreview();
        }
    }

    private void checkBoxRemoveWaterActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void spinnerWallFloorDepthStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void spinnerWallRoofDepthStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void spinnerRoofMaxStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            if ((Integer)this.spinnerRoofMax.getValue() < (Integer)this.spinnerRoofMin.getValue()) {
                this.spinnerRoofMin.setValue(this.spinnerRoofMax.getValue());
            }
            this.updatePreview();
        }
    }

    private void checkBoxFloodWithLavaActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void radioButtonFloorFixedDepthActionPerformed(ActionEvent evt) {
        if (this.radioButtonFloorFixedDepth.isSelected() && (Integer)this.spinnerFloorLevel.getValue() < 0) {
            this.spinnerFloorLevel.setValue(0);
        }
        this.updatePreview();
        this.setControlStates();
    }

    private void spinnerFloodLevelStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void spinnerRoofMinStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            if ((Integer)this.spinnerRoofMax.getValue() < (Integer)this.spinnerRoofMin.getValue()) {
                this.spinnerRoofMax.setValue(this.spinnerRoofMin.getValue());
            }
            this.updatePreview();
        }
    }

    private void spinnerFloorMinStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            if ((Integer)this.spinnerFloorMax.getValue() < (Integer)this.spinnerFloorMin.getValue()) {
                this.spinnerFloorMax.setValue(this.spinnerFloorMin.getValue());
            }
            this.updatePreview();
        }
    }

    private void radioButtonRoofFixedDepthActionPerformed(ActionEvent evt) {
        if (this.radioButtonRoofFixedDepth.isSelected() && (Integer)this.spinnerRoofLevel.getValue() < 0) {
            this.spinnerRoofLevel.setValue(0);
        }
        this.updatePreview();
        this.setControlStates();
    }

    private void spinnerFloorLevelStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void spinnerRoofLevelStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.updatePreview();
        }
    }

    private void radioButtonFloorFixedLevelActionPerformed(ActionEvent evt) {
        this.updatePreview();
        this.setControlStates();
    }

    private void buttonNewFloorLayerActionPerformed(ActionEvent evt) {
        this.newFloorLayer();
    }

    private void buttonAddFloorLayerActionPerformed(ActionEvent evt) {
        this.addFloorLayer();
    }

    private void buttonEditFloorLayerActionPerformed(ActionEvent evt) {
        this.editFloorLayer();
    }

    private void buttonRemoveFloorLayerActionPerformed(ActionEvent evt) {
        this.removeFloorLayers();
    }

    private void tableFloorLayersMouseClicked(MouseEvent evt) {
        if (!evt.isPopupTrigger() && evt.getClickCount() == 2) {
            int column = this.tableFloorLayers.columnAtPoint(evt.getPoint());
            if (column == 0) {
                this.editFloorLayer();
            } else if (column == 2) {
                this.editFloorLayerVariation();
            }
        }
    }

    private void tableRoofLayersMouseClicked(MouseEvent evt) {
        if (!evt.isPopupTrigger() && evt.getClickCount() == 2) {
            int column = this.tableRoofLayers.columnAtPoint(evt.getPoint());
            if (column == 0) {
                this.editRoofLayer();
            } else if (column == 2) {
                this.editRoofLayerVariation();
            }
        }
    }

    private void buttonNewRoofLayerActionPerformed(ActionEvent evt) {
        this.newRoofLayer();
    }

    private void buttonAddRoofLayerActionPerformed(ActionEvent evt) {
        this.addRoofLayer();
    }

    private void buttonEditRoofLayerActionPerformed(ActionEvent evt) {
        this.editRoofLayer();
    }

    private void buttonRemoveRoofLayerActionPerformed(ActionEvent evt) {
        this.removeRoofLayers();
    }

    private void radioButtonFloorCustomDimensionActionPerformed(ActionEvent evt) {
        this.updatePreview();
        this.setControlStates();
    }

    private void radioButtonRoofFixedHeightActionPerformed(ActionEvent evt) {
        this.updatePreview();
        this.setControlStates();
    }

    private void mixedMaterialChooserRoofPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("material")) {
            this.mixedMaterialChooserFloor.refresh();
            this.mixedMaterialChooserWall.refresh();
        }
    }

    private void mixedMaterialChooserFloorPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("material")) {
            this.mixedMaterialChooserRoof.refresh();
            this.mixedMaterialChooserWall.refresh();
        }
    }

    private void mixedMaterialChooserWallPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("material")) {
            this.mixedMaterialChooserRoof.refresh();
            this.mixedMaterialChooserFloor.refresh();
        }
    }

    private static /* synthetic */ void lambda$addLayer$12(TunnelLayersTableModel tableModel, JPopupMenu popupMenu, CustomLayer l) {
        JMenuItem menuItem = new JMenuItem(l.getName(), new ImageIcon(l.getIcon()));
        menuItem.addActionListener(e -> tableModel.addLayer((Layer)l));
        popupMenu.add(menuItem);
    }

    private static /* synthetic */ void lambda$addLayer$4(TunnelLayersTableModel tableModel, JPopupMenu popupMenu, Layer l) {
        JMenuItem menuItem = new JMenuItem(l.getName(), new ImageIcon(l.getIcon()));
        menuItem.addActionListener(e -> tableModel.addLayer(l));
        popupMenu.add(menuItem);
    }
}

