/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.pockets;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialChooser;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.layers.AbstractEditLayerDialog;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsLayer;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsLayerExporter;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;

public class UndergroundPocketsDialog
extends AbstractEditLayerDialog<UndergroundPocketsLayer>
implements PropertyChangeListener {
    private JButton buttonCancel;
    private ButtonGroup buttonGroup1;
    private JButton buttonOK;
    private JButton buttonPickColour;
    private JComboBox comboBoxTerrain;
    private JTextField fieldName;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JLabel labelPreview;
    private MixedMaterialChooser mixedMaterialChooser;
    private JRadioButton radioButtonCustomMaterial;
    private JRadioButton radioButtonTerrain;
    private JSpinner spinnerMaxLevel;
    private JSpinner spinnerMinLevel;
    private JSpinner spinnerOccurrence;
    private JSpinner spinnerScale;
    private final ColourScheme colourScheme;
    private UndergroundPocketsLayer layer;
    private int selectedColour = Color.ORANGE.getRGB();
    private Timer previewUpdateTimer;
    private static final long serialVersionUID = 1L;

    public UndergroundPocketsDialog(Window parent, Platform platform, MixedMaterial material, ColourScheme colourScheme, int minHeight, int maxHeight, boolean extendedBlockIds) {
        this(parent, platform, material, null, colourScheme, minHeight, maxHeight, extendedBlockIds);
    }

    public UndergroundPocketsDialog(Window parent, Platform platform, UndergroundPocketsLayer existingLayer, ColourScheme colourScheme, int minHeight, int maxHeight, boolean extendedBlockIds) {
        this(parent, platform, null, existingLayer, colourScheme, minHeight, maxHeight, extendedBlockIds);
    }

    private UndergroundPocketsDialog(Window parent, Platform platform, MixedMaterial material, UndergroundPocketsLayer existingLayer, ColourScheme colourScheme, int minHeight, int maxHeight, boolean extendedBlockIds) {
        super(parent);
        this.colourScheme = colourScheme;
        this.initComponents();
        this.mixedMaterialChooser.setPlatform(platform);
        this.mixedMaterialChooser.setExtendedBlockIds(extendedBlockIds);
        this.mixedMaterialChooser.setColourScheme(colourScheme);
        this.mixedMaterialChooser.addPropertyChangeListener("material", this);
        if (existingLayer != null) {
            this.layer = existingLayer;
            this.fieldName.setText(existingLayer.getName());
            this.selectedColour = existingLayer.getColour();
            if (existingLayer.getMaterial() != null) {
                this.mixedMaterialChooser.setMaterial(existingLayer.getMaterial());
            } else {
                this.radioButtonTerrain.setSelected(true);
                this.comboBoxTerrain.setSelectedItem(existingLayer.getTerrain());
            }
            this.spinnerMinLevel.setValue(existingLayer.getMinLevel());
            this.spinnerMaxLevel.setValue(existingLayer.getMaxLevel());
            this.spinnerOccurrence.setValue(existingLayer.getFrequency());
            this.spinnerScale.setValue(existingLayer.getScale());
        } else {
            this.mixedMaterialChooser.setMaterial(material);
            this.spinnerMinLevel.setValue(minHeight);
            this.spinnerMaxLevel.setValue(maxHeight - 1);
        }
        ((SpinnerNumberModel)this.spinnerMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        ((SpinnerNumberModel)this.spinnerMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        this.spinnerOccurrence.setEditor(new JSpinner.NumberEditor(this.spinnerOccurrence, "0"));
        JSpinner.NumberEditor scaleEditor = new JSpinner.NumberEditor(this.spinnerScale, "0");
        scaleEditor.getTextField().setColumns(3);
        this.spinnerScale.setEditor(scaleEditor);
        this.spinnerMinLevel.setEditor(new JSpinner.NumberEditor(this.spinnerMinLevel, "0"));
        this.spinnerMaxLevel.setEditor(new JSpinner.NumberEditor(this.spinnerMaxLevel, "0"));
        this.setLabelColour();
        this.setControlStates();
        this.rootPane.setDefaultButton(this.buttonOK);
        this.scaleToUI();
        this.pack();
        this.scaleWindowToUI();
        this.setLocationRelativeTo(parent);
    }

    @Override
    public UndergroundPocketsLayer getLayer() {
        return this.layer;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("material") && evt.getSource() == this.mixedMaterialChooser) {
            this.updateNameAndColour();
            this.setControlStates();
        }
    }

    @Override
    protected void ok() {
        MixedMaterial material;
        String name = this.fieldName.getText();
        MixedMaterial mixedMaterial = material = this.radioButtonCustomMaterial.isSelected() ? this.mixedMaterialChooser.getMaterial() : null;
        if (material != null) {
            material = MixedMaterialManager.getInstance().register(material);
        }
        Terrain terrain = this.radioButtonTerrain.isSelected() ? (Terrain)this.comboBoxTerrain.getSelectedItem() : null;
        int occurrence = (Integer)this.spinnerOccurrence.getValue();
        int scale = (Integer)this.spinnerScale.getValue();
        int minLevel = (Integer)this.spinnerMinLevel.getValue();
        int maxLevel = (Integer)this.spinnerMaxLevel.getValue();
        if (this.layer == null) {
            this.layer = new UndergroundPocketsLayer(name, material, terrain, occurrence, minLevel, maxLevel, scale, this.selectedColour);
        } else {
            this.layer.setName(name);
            this.layer.setColour(this.selectedColour);
            this.layer.setMaterial(material);
            this.layer.setTerrain(terrain);
            this.layer.setFrequency(occurrence);
            this.layer.setMinLevel(minLevel);
            this.layer.setMaxLevel(maxLevel);
            this.layer.setScale(scale);
        }
        super.ok();
    }

    private void pickColour() {
        Color pick = JColorChooser.showDialog(this, "Select Colour", new Color(this.selectedColour));
        if (pick != null) {
            this.selectedColour = pick.getRGB();
            this.setLabelColour();
        }
    }

    private void setLabelColour() {
        this.jLabel5.setBackground(new Color(this.selectedColour));
    }

    private void updateNameAndColour() {
        if (this.fieldName.isEnabled()) {
            if (this.radioButtonCustomMaterial.isSelected()) {
                MixedMaterial material = this.mixedMaterialChooser.getMaterial();
                if (material != null) {
                    this.fieldName.setText(material.toString());
                    if (material.getColour() != null) {
                        this.selectedColour = material.getColour();
                        this.setLabelColour();
                    }
                }
            } else {
                Terrain terrain = (Terrain)this.comboBoxTerrain.getSelectedItem();
                if (terrain != null) {
                    this.fieldName.setText(terrain.getName());
                }
            }
        }
    }

    private void setControlStates() {
        this.mixedMaterialChooser.setEnabled(this.radioButtonCustomMaterial.isSelected());
        this.comboBoxTerrain.setEnabled(this.radioButtonTerrain.isSelected());
        this.buttonOK.setEnabled(this.radioButtonCustomMaterial.isSelected() && this.mixedMaterialChooser.getMaterial() != null || this.radioButtonTerrain.isSelected() && this.comboBoxTerrain.getSelectedItem() != null);
    }

    private void schedulePreviewUpdate() {
        if (this.previewUpdateTimer == null) {
            this.previewUpdateTimer = new Timer(250, e -> this.updatePreview());
            this.previewUpdateTimer.setRepeats(false);
        }
        this.previewUpdateTimer.restart();
    }

    private void updatePreview() {
        Terrain terrain;
        if (this.previewUpdateTimer != null) {
            this.previewUpdateTimer.stop();
            this.previewUpdateTimer = null;
        }
        MixedMaterial material = this.radioButtonCustomMaterial.isSelected() ? this.mixedMaterialChooser.getMaterial() : null;
        Terrain terrain2 = terrain = this.radioButtonTerrain.isSelected() ? (Terrain)this.comboBoxTerrain.getSelectedItem() : null;
        if (material == null && terrain == null) {
            return;
        }
        int occurrence = (Integer)this.spinnerOccurrence.getValue();
        int scale = (Integer)this.spinnerScale.getValue();
        int minLevel = (Integer)this.spinnerMinLevel.getValue();
        int maxLevel = (Integer)this.spinnerMaxLevel.getValue();
        UndergroundPocketsLayer tmpLayer = new UndergroundPocketsLayer("tmp", material, terrain, occurrence, minLevel, maxLevel, scale, 0);
        this.labelPreview.setIcon(new ImageIcon(UndergroundPocketsLayerExporter.createPreview((UndergroundPocketsLayer)tmpLayer, (int)this.labelPreview.getWidth(), (int)this.labelPreview.getHeight())));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.jLabel6 = new JLabel();
        this.fieldName = new JTextField();
        this.jLabel5 = new JLabel();
        this.buttonPickColour = new JButton();
        this.jLabel7 = new JLabel();
        this.spinnerOccurrence = new JSpinner();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.spinnerScale = new JSpinner();
        this.spinnerMaxLevel = new JSpinner();
        this.jLabel11 = new JLabel();
        this.spinnerMinLevel = new JSpinner();
        this.jLabel12 = new JLabel();
        this.radioButtonCustomMaterial = new JRadioButton();
        this.radioButtonTerrain = new JRadioButton();
        this.comboBoxTerrain = new JComboBox();
        this.jPanel1 = new JPanel();
        this.labelPreview = new JLabel();
        this.mixedMaterialChooser = new MixedMaterialChooser();
        this.setDefaultCloseOperation(2);
        this.setTitle("Configure Underground Pockets Layer");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                UndergroundPocketsDialog.this.formComponentResized(evt);
            }
        });
        this.jLabel1.setText("Select your custom material or terrain type:");
        this.jLabel4.setText("Colour:");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(this::buttonCancelActionPerformed);
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(this::buttonOKActionPerformed);
        this.jLabel6.setText("Name:");
        this.fieldName.setColumns(10);
        this.jLabel5.setBackground(Color.orange);
        this.jLabel5.setText("                 ");
        this.jLabel5.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel5.setOpaque(true);
        this.buttonPickColour.setText("...");
        this.buttonPickColour.addActionListener(this::buttonPickColourActionPerformed);
        this.jLabel7.setText("Occurrence:");
        this.spinnerOccurrence.setModel(new SpinnerNumberModel(10, 1, 1000, 1));
        this.spinnerOccurrence.addChangeListener(this::spinnerOccurrenceStateChanged);
        this.jLabel8.setText("Scale:");
        this.jLabel9.setText("Levels:");
        this.jLabel10.setText("\u2030");
        this.spinnerScale.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(1), null, (Number)1));
        this.spinnerScale.addChangeListener(this::spinnerScaleStateChanged);
        this.spinnerMaxLevel.setModel(new SpinnerNumberModel(255, 0, 255, 1));
        this.spinnerMaxLevel.addChangeListener(this::spinnerMaxLevelStateChanged);
        this.jLabel11.setText("%");
        this.spinnerMinLevel.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.spinnerMinLevel.addChangeListener(this::spinnerMinLevelStateChanged);
        this.jLabel12.setText("-");
        this.buttonGroup1.add(this.radioButtonCustomMaterial);
        this.radioButtonCustomMaterial.setSelected(true);
        this.radioButtonCustomMaterial.setText("custom material:");
        this.radioButtonCustomMaterial.addActionListener(this::radioButtonCustomMaterialActionPerformed);
        this.buttonGroup1.add(this.radioButtonTerrain);
        this.radioButtonTerrain.setText("terrain:");
        this.radioButtonTerrain.addActionListener(this::radioButtonTerrainActionPerformed);
        this.comboBoxTerrain.setModel(new DefaultComboBoxModel<Terrain>(Terrain.VALUES));
        this.comboBoxTerrain.setEnabled(false);
        this.comboBoxTerrain.setRenderer(new TerrainListCellRenderer(this.colourScheme));
        this.comboBoxTerrain.addActionListener(this::comboBoxTerrainActionPerformed);
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
        this.labelPreview.setHorizontalAlignment(0);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelPreview, -1, 128, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelPreview, -1, -1, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel).addGap(11, 11, 11)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel7).addComponent(this.jLabel6).addComponent(this.jLabel8).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.spinnerMinLevel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel12).addGap(0, 0, 0).addComponent(this.spinnerMaxLevel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.spinnerScale, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel11)).addComponent(this.fieldName, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.spinnerOccurrence, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel10)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPickColour)))).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonTerrain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxTerrain, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonCustomMaterial).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mixedMaterialChooser, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonCustomMaterial).addComponent(this.mixedMaterialChooser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonTerrain).addComponent(this.comboBoxTerrain, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.fieldName, -2, -1, -2)).addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.buttonPickColour)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.spinnerOccurrence, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.spinnerScale, -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.spinnerMaxLevel, -2, -1, -2).addComponent(this.spinnerMinLevel, -2, -1, -2).addComponent(this.jLabel12))).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonPickColourActionPerformed(ActionEvent evt) {
        this.pickColour();
    }

    private void spinnerMinLevelStateChanged(ChangeEvent evt) {
        int currentMaxValue;
        int newMinValue = (Integer)this.spinnerMinLevel.getValue();
        if (newMinValue > (currentMaxValue = ((Integer)this.spinnerMaxLevel.getValue()).intValue())) {
            this.spinnerMaxLevel.setValue(newMinValue);
        }
    }

    private void spinnerMaxLevelStateChanged(ChangeEvent evt) {
        int currentMinValue;
        int newMaxValue = (Integer)this.spinnerMaxLevel.getValue();
        if (newMaxValue < (currentMinValue = ((Integer)this.spinnerMinLevel.getValue()).intValue())) {
            this.spinnerMinLevel.setValue(newMaxValue);
        }
    }

    private void radioButtonCustomMaterialActionPerformed(ActionEvent evt) {
        this.updateNameAndColour();
        this.setControlStates();
    }

    private void radioButtonTerrainActionPerformed(ActionEvent evt) {
        this.updateNameAndColour();
        this.setControlStates();
    }

    private void comboBoxTerrainActionPerformed(ActionEvent evt) {
        this.updateNameAndColour();
        this.setControlStates();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.schedulePreviewUpdate();
    }

    private void spinnerOccurrenceStateChanged(ChangeEvent evt) {
        this.schedulePreviewUpdate();
    }

    private void spinnerScaleStateChanged(ChangeEvent evt) {
        this.schedulePreviewUpdate();
    }
}

