/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.constant.Constable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.layers.bo2.OffsetEditor;
import org.pepsoft.worldpainter.layers.bo2.WPObjectPreviewer;
import org.pepsoft.worldpainter.objects.WPObject;
import org.pepsoft.worldpainter.util.TristateCheckBox;

public class EditObjectAttributes
extends WorldPainterDialog {
    private JButton buttonCancel;
    private ButtonGroup buttonGroup1;
    private JButton buttonOK;
    private JButton buttonOffsetAuto;
    private JButton buttonOffsetReset;
    private TristateCheckBox checkBoxCollideWithFloor;
    private TristateCheckBox checkBoxExtendFoundation;
    private JCheckBox checkBoxFrequencyActive;
    private TristateCheckBox checkBoxOnAir;
    private TristateCheckBox checkBoxOnLava;
    private TristateCheckBox checkBoxOnSolidLand;
    private TristateCheckBox checkBoxOnWater;
    private TristateCheckBox checkBoxRandomMirroring;
    private TristateCheckBox checkBoxRandomRotation;
    private JCheckBox checkBoxRandomVariationActive;
    private JCheckBox checkBoxReplace;
    private TristateCheckBox checkBoxUnderLava;
    private TristateCheckBox checkBoxUnderWater;
    private JComboBox comboBoxCollisionMode;
    private JComboBox comboBoxLeafDecayMode;
    private JComboBox<Material> comboBoxReplacedMaterial;
    private JComboBox comboBoxUndergroundMode;
    private JTextField fieldName;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JLabel labelFile;
    private JLabel labelOffset;
    private JLabel labelVerticalOffset;
    private JRadioButton radioButtonPlaceAtFixedHeight;
    private JRadioButton radioButtonPlaceOnTerrain;
    private JSpinner spinnerFrequency;
    private JSpinner spinnerRandomVariation;
    private JSpinner spinnerVerticalOffset;
    private final Collection<WPObject> objects;
    private final File file;
    private final Map<WPObject, Point3i> offsets = new HashMap<WPObject, Point3i>();
    private final ColourScheme colourScheme;
    private static final long serialVersionUID = 1L;

    public EditObjectAttributes(Window parent, WPObject object, ColourScheme colourScheme) {
        this(parent, Collections.singleton(object), colourScheme);
    }

    public EditObjectAttributes(Window parent, Collection<WPObject> objects, ColourScheme colourScheme) {
        super(parent);
        this.objects = objects;
        this.colourScheme = colourScheme;
        if (objects.isEmpty()) {
            throw new IllegalArgumentException("Collection of objects may not be empty");
        }
        this.initComponents();
        this.spinnerFrequency.setEditor(new JSpinner.NumberEditor(this.spinnerFrequency, "0"));
        if (objects.size() == 1) {
            WPObject object = objects.iterator().next();
            this.fieldName.setText(object.getName());
            this.file = (File)object.getAttribute(WPObject.ATTRIBUTE_FILE);
            if (this.file != null) {
                this.labelFile.setText(this.file.getAbsolutePath());
                if (!this.file.exists()) {
                    this.labelFile.setForeground(Color.RED);
                }
            } else {
                this.labelFile.setText("<html><i>unknown</i></html>");
            }
            Point3i offset = object.getOffset();
            this.offsets.put(object, offset);
            String offsetStr = "<html><u>" + offset.x + ", " + offset.y + ", " + offset.z + "</u></html>";
            this.labelOffset.setText(offsetStr);
            this.checkBoxRandomRotation.setSelected((Boolean)object.getAttribute(WPObject.ATTRIBUTE_RANDOM_ROTATION) != false || (Boolean)object.getAttribute(WPObject.ATTRIBUTE_RANDOM_ROTATION_ONLY) != false);
            this.checkBoxRandomRotation.setTristateMode(false);
            this.checkBoxRandomMirroring.setSelected((Boolean)object.getAttribute(WPObject.ATTRIBUTE_RANDOM_ROTATION) != false || (Boolean)object.getAttribute(WPObject.ATTRIBUTE_RANDOM_MIRRORING_ONLY) != false);
            this.checkBoxRandomMirroring.setTristateMode(false);
            this.checkBoxOnAir.setSelected((Boolean)object.getAttribute(WPObject.ATTRIBUTE_NEEDS_FOUNDATION) == false);
            this.checkBoxOnAir.setTristateMode(false);
            this.checkBoxUnderLava.setSelected((Boolean)object.getAttribute(WPObject.ATTRIBUTE_SPAWN_IN_LAVA));
            this.checkBoxUnderLava.setTristateMode(false);
            this.checkBoxUnderWater.setSelected((Boolean)object.getAttribute(WPObject.ATTRIBUTE_SPAWN_IN_WATER));
            this.checkBoxUnderWater.setTristateMode(false);
            this.checkBoxOnSolidLand.setSelected((Boolean)object.getAttribute(WPObject.ATTRIBUTE_SPAWN_ON_LAND));
            this.checkBoxOnSolidLand.setTristateMode(false);
            this.checkBoxOnWater.setSelected((Boolean)object.getAttribute(WPObject.ATTRIBUTE_SPAWN_ON_WATER));
            this.checkBoxOnWater.setTristateMode(false);
            this.checkBoxOnLava.setSelected((Boolean)object.getAttribute(WPObject.ATTRIBUTE_SPAWN_ON_LAVA));
            this.checkBoxOnLava.setTristateMode(false);
            this.checkBoxCollideWithFloor.setSelected((Boolean)object.getAttribute(WPObject.ATTRIBUTE_SPAWN_ON_WATER_NO_COLLIDE) == false);
            this.checkBoxCollideWithFloor.setTristateMode(false);
            ((DefaultComboBoxModel)this.comboBoxCollisionMode.getModel()).removeElementAt(0);
            ((DefaultComboBoxModel)this.comboBoxUndergroundMode.getModel()).removeElementAt(0);
            ((DefaultComboBoxModel)this.comboBoxLeafDecayMode.getModel()).removeElementAt(0);
            this.comboBoxCollisionMode.setSelectedIndex((Integer)object.getAttribute(WPObject.ATTRIBUTE_COLLISION_MODE) - 1);
            this.comboBoxUndergroundMode.setSelectedIndex((Integer)object.getAttribute(WPObject.ATTRIBUTE_UNDERGROUND_MODE) - 1);
            this.comboBoxLeafDecayMode.setSelectedIndex((Integer)object.getAttribute(WPObject.ATTRIBUTE_LEAF_DECAY_MODE) - 1);
            this.spinnerFrequency.setValue(object.getAttribute(WPObject.ATTRIBUTE_FREQUENCY));
            if ((Integer)object.getAttribute(WPObject.ATTRIBUTE_HEIGHT_MODE) == 1) {
                this.radioButtonPlaceOnTerrain.setSelected(true);
            } else {
                this.radioButtonPlaceAtFixedHeight.setSelected(true);
            }
            this.spinnerVerticalOffset.setValue(object.getAttribute(WPObject.ATTRIBUTE_VERTICAL_OFFSET));
            this.spinnerRandomVariation.setValue(object.getAttribute(WPObject.ATTRIBUTE_Y_VARIATION));
            TreeSet<Material> materials = new TreeSet<Material>(Comparator.comparing(Material::toString));
            object.visitBlocks((o, x, y, z, m) -> {
                if (m != Material.AIR) {
                    materials.add(m);
                }
                return true;
            });
            if (!materials.isEmpty()) {
                this.comboBoxReplacedMaterial.setModel(new DefaultComboBoxModel<Material>(materials.toArray(new Material[materials.size()])));
                if (object.hasAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR)) {
                    int[] replaceWithBlock = (int[])object.getAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR);
                    this.checkBoxReplace.setSelected(true);
                    this.comboBoxReplacedMaterial.setSelectedItem(Material.get((int)replaceWithBlock[0], (int)replaceWithBlock[1]));
                } else if (object.hasAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR_MATERIAL)) {
                    Material replaceWithMaterial = (Material)object.getAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR_MATERIAL);
                    this.checkBoxReplace.setSelected(true);
                    this.comboBoxReplacedMaterial.setSelectedItem(replaceWithMaterial);
                }
            } else {
                this.checkBoxReplace.setEnabled(false);
            }
            this.checkBoxExtendFoundation.setSelected((Boolean)object.getAttribute(WPObject.ATTRIBUTE_EXTEND_FOUNDATION));
            this.checkBoxExtendFoundation.setTristateMode(false);
            WPObjectPreviewer previewer = new WPObjectPreviewer();
            previewer.setDimension(App.getInstance().getDimension());
            previewer.setObject(object);
            this.jPanel1.add((Component)previewer, "Center");
        } else {
            this.labelFile.setText(objects.size() + " objects selected");
            this.fieldName.setText("multiple");
            this.fieldName.setEnabled(false);
            this.file = null;
            long frequencyTotal = 0L;
            long variationTotal = 0L;
            long verticalOffsetTotal = 0L;
            int firstFrequency = -1;
            int firstVariation = -1;
            boolean allFrequenciesIdentical = true;
            boolean allVariationsIdentical = true;
            Point3i origin = new Point3i();
            for (WPObject object : objects) {
                if (!object.getOffset().equals((Object)origin)) {
                    this.offsets.put(object, object.getOffset());
                }
                int frequency = (Integer)object.getAttribute(WPObject.ATTRIBUTE_FREQUENCY);
                frequencyTotal += (long)frequency;
                if (firstFrequency == -1) {
                    firstFrequency = frequency;
                } else if (frequency != firstFrequency) {
                    allFrequenciesIdentical = false;
                }
                int variation = (Integer)object.getAttribute(WPObject.ATTRIBUTE_Y_VARIATION);
                variationTotal += (long)variation;
                if (firstVariation == -1) {
                    firstVariation = variation;
                } else if (variation != firstVariation) {
                    allVariationsIdentical = false;
                }
                int verticalOffset = (Integer)object.getAttribute(WPObject.ATTRIBUTE_VERTICAL_OFFSET);
                verticalOffsetTotal += (long)verticalOffset;
            }
            this.labelOffset.setText("multiple");
            this.checkBoxRandomRotation.setMixed(true);
            this.checkBoxRandomMirroring.setMixed(true);
            this.checkBoxOnAir.setMixed(true);
            this.checkBoxUnderLava.setMixed(true);
            this.checkBoxUnderWater.setMixed(true);
            this.checkBoxOnSolidLand.setMixed(true);
            this.checkBoxOnWater.setMixed(true);
            this.checkBoxOnLava.setMixed(true);
            this.checkBoxCollideWithFloor.setMixed(true);
            this.labelOffset.setCursor(null);
            this.labelOffset.setForeground(null);
            int averageFrequency = (int)(frequencyTotal / (long)objects.size());
            this.spinnerFrequency.setValue(averageFrequency);
            if (!allFrequenciesIdentical) {
                this.checkBoxFrequencyActive.setSelected(false);
                this.checkBoxFrequencyActive.setToolTipText("<html>The relative frequencies of the selected objects are not all the same.<br>Check the checkbox if you want to set them all to the same value.</html>");
                this.checkBoxFrequencyActive.setEnabled(true);
                this.spinnerFrequency.setEnabled(false);
            }
            this.checkBoxReplace.setEnabled(false);
            this.checkBoxExtendFoundation.setMixed(true);
            this.spinnerVerticalOffset.setValue((int)(verticalOffsetTotal / (long)objects.size()));
            int averageVariation = (int)(variationTotal / (long)objects.size());
            this.spinnerRandomVariation.setValue(averageVariation);
            if (!allVariationsIdentical) {
                this.checkBoxRandomVariationActive.setSelected(false);
                this.checkBoxRandomVariationActive.setToolTipText("<html>The random variations of the selected objects are not all the same.<br>Check the checkbox if you want to set them all to the same value.</html>");
                this.checkBoxRandomVariationActive.setEnabled(true);
                this.spinnerRandomVariation.setEnabled(false);
            }
        }
        this.scaleToUI();
        this.pack();
        ActionMap actionMap = this.rootPane.getActionMap();
        actionMap.put("cancel", new AbstractAction("cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EditObjectAttributes.this.dispose();
            }
        });
        InputMap inputMap = this.rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.setLocationRelativeTo(parent);
        this.setControlStates();
    }

    private void editOffset() {
        if (this.objects.size() > 1) {
            return;
        }
        WPObject object = this.objects.iterator().next();
        Point3i offset = this.offsets.get(object);
        OffsetEditor dialog = new OffsetEditor((Window)this, offset != null ? offset : new Point3i(), object, this.colourScheme);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            offset = dialog.getOffset();
            this.offsets.put(object, offset);
            String offsetStr = "<html><u>" + offset.x + ", " + offset.y + ", " + offset.z + "</u></html>";
            this.labelOffset.setText(offsetStr);
        }
    }

    @Override
    protected void ok() {
        boolean singleSelection = this.objects.size() == 1;
        for (WPObject object : this.objects) {
            Point3i offset;
            HashMap<String, Constable> attributes;
            if (singleSelection && !this.fieldName.getText().trim().isEmpty()) {
                object.setName(this.fieldName.getText().trim());
            }
            if ((attributes = object.getAttributes()) == null) {
                attributes = new HashMap<String, Constable>();
            }
            if (this.checkBoxFrequencyActive.isSelected()) {
                int frequency = (Integer)this.spinnerFrequency.getValue();
                if (frequency != 100) {
                    attributes.put(WPObject.ATTRIBUTE_FREQUENCY.key, Integer.valueOf(frequency));
                } else {
                    attributes.remove(WPObject.ATTRIBUTE_FREQUENCY.key);
                }
            }
            if ((offset = this.offsets.get(object)) != null && (offset.x != 0 || offset.y != 0 || offset.z != 0)) {
                attributes.put(WPObject.ATTRIBUTE_OFFSET.key, (Constable)offset);
            } else {
                attributes.remove(WPObject.ATTRIBUTE_OFFSET.key);
            }
            if (!this.checkBoxRandomRotation.isMixed() || !this.checkBoxRandomMirroring.isMixed()) {
                if (((Boolean)WPObject.ATTRIBUTE_RANDOM_ROTATION.get(attributes)).booleanValue()) {
                    attributes.put(WPObject.ATTRIBUTE_RANDOM_ROTATION.key, Boolean.valueOf(false));
                    attributes.put(WPObject.ATTRIBUTE_RANDOM_ROTATION_ONLY.key, Boolean.valueOf(true));
                    attributes.put(WPObject.ATTRIBUTE_RANDOM_MIRRORING_ONLY.key, Boolean.valueOf(true));
                }
                if (!this.checkBoxRandomRotation.isMixed()) {
                    attributes.put(WPObject.ATTRIBUTE_RANDOM_ROTATION_ONLY.key, Boolean.valueOf(this.checkBoxRandomRotation.isSelected()));
                }
                if (!this.checkBoxRandomMirroring.isMixed()) {
                    attributes.put(WPObject.ATTRIBUTE_RANDOM_MIRRORING_ONLY.key, Boolean.valueOf(this.checkBoxRandomMirroring.isSelected()));
                }
            }
            if (!this.checkBoxOnAir.isMixed()) {
                attributes.put(WPObject.ATTRIBUTE_NEEDS_FOUNDATION.key, Boolean.valueOf(!this.checkBoxOnAir.isSelected()));
            }
            if (!this.checkBoxUnderLava.isMixed()) {
                attributes.put(WPObject.ATTRIBUTE_SPAWN_IN_LAVA.key, Boolean.valueOf(this.checkBoxUnderLava.isSelected()));
            }
            if (!this.checkBoxUnderWater.isMixed()) {
                attributes.put(WPObject.ATTRIBUTE_SPAWN_IN_WATER.key, Boolean.valueOf(this.checkBoxUnderWater.isSelected()));
            }
            if (!this.checkBoxOnSolidLand.isMixed()) {
                attributes.put(WPObject.ATTRIBUTE_SPAWN_ON_LAND.key, Boolean.valueOf(this.checkBoxOnSolidLand.isSelected()));
            }
            if (!this.checkBoxOnWater.isMixed()) {
                attributes.put(WPObject.ATTRIBUTE_SPAWN_ON_WATER.key, Boolean.valueOf(this.checkBoxOnWater.isSelected()));
            }
            if (!this.checkBoxCollideWithFloor.isMixed()) {
                attributes.put(WPObject.ATTRIBUTE_SPAWN_ON_WATER_NO_COLLIDE.key, Boolean.valueOf(!this.checkBoxCollideWithFloor.isSelected()));
            }
            if (!this.checkBoxOnLava.isMixed()) {
                attributes.put(WPObject.ATTRIBUTE_SPAWN_ON_LAVA.key, Boolean.valueOf(this.checkBoxOnLava.isSelected()));
            }
            if (singleSelection || this.comboBoxCollisionMode.getSelectedIndex() > 0) {
                attributes.put(WPObject.ATTRIBUTE_COLLISION_MODE.key, Integer.valueOf(this.comboBoxCollisionMode.getSelectedIndex() + (singleSelection ? 1 : 0)));
            }
            if (singleSelection || this.comboBoxUndergroundMode.getSelectedIndex() > 0) {
                attributes.put(WPObject.ATTRIBUTE_UNDERGROUND_MODE.key, Integer.valueOf(this.comboBoxUndergroundMode.getSelectedIndex() + (singleSelection ? 1 : 0)));
            }
            if (singleSelection || this.comboBoxLeafDecayMode.getSelectedIndex() > 0) {
                attributes.put(WPObject.ATTRIBUTE_LEAF_DECAY_MODE.key, Integer.valueOf(this.comboBoxLeafDecayMode.getSelectedIndex() + (singleSelection ? 1 : 0)));
            }
            if (singleSelection) {
                attributes.remove(WPObject.ATTRIBUTE_REPLACE_WITH_AIR.key);
                if (this.checkBoxReplace.isSelected()) {
                    attributes.put(WPObject.ATTRIBUTE_REPLACE_WITH_AIR_MATERIAL.key, (Constable)((Material)this.comboBoxReplacedMaterial.getSelectedItem()));
                } else {
                    attributes.remove(WPObject.ATTRIBUTE_REPLACE_WITH_AIR_MATERIAL.key);
                }
            }
            if (!this.checkBoxExtendFoundation.isMixed()) {
                attributes.put(WPObject.ATTRIBUTE_EXTEND_FOUNDATION.key, Boolean.valueOf(this.checkBoxExtendFoundation.isSelected()));
            }
            if (this.radioButtonPlaceOnTerrain.isSelected() || this.radioButtonPlaceAtFixedHeight.isSelected()) {
                int verticalOffset = (Integer)this.spinnerVerticalOffset.getValue();
                if (verticalOffset != 0) {
                    attributes.put(WPObject.ATTRIBUTE_VERTICAL_OFFSET.key, Integer.valueOf(verticalOffset));
                } else {
                    attributes.remove(WPObject.ATTRIBUTE_VERTICAL_OFFSET.key);
                }
            }
            if (this.radioButtonPlaceOnTerrain.isSelected()) {
                attributes.remove(WPObject.ATTRIBUTE_HEIGHT_MODE.key);
            } else if (this.radioButtonPlaceAtFixedHeight.isSelected()) {
                attributes.put(WPObject.ATTRIBUTE_HEIGHT_MODE.key, Integer.valueOf(2));
            }
            if (this.checkBoxRandomVariationActive.isSelected()) {
                int variation = (Integer)this.spinnerRandomVariation.getValue();
                if (variation > 0) {
                    attributes.put(WPObject.ATTRIBUTE_Y_VARIATION.key, Integer.valueOf(variation));
                } else {
                    attributes.remove(WPObject.ATTRIBUTE_Y_VARIATION.key);
                }
            }
            if (!attributes.isEmpty()) {
                object.setAttributes(attributes);
                continue;
            }
            object.setAttributes(null);
        }
        super.ok();
    }

    private void autoOffset() {
        boolean singleSelection = this.objects.size() == 1;
        for (WPObject object : this.objects) {
            Point3i offset = object.guestimateOffset();
            if (offset == null) {
                this.offsets.clear();
                if (!singleSelection) continue;
                this.labelOffset.setText("<html><u>0, 0, 0</u></html>");
                continue;
            }
            this.offsets.put(object, offset);
            if (!singleSelection) continue;
            String offsetStr = "<html><u>" + offset.x + ", " + offset.y + ", " + offset.z + "</u></html>";
            this.labelOffset.setText(offsetStr);
        }
        if (!singleSelection) {
            JOptionPane.showMessageDialog(this, this.objects.size() + " offsets autoset");
        }
    }

    private void resetOffset() {
        boolean singleSelection;
        this.offsets.clear();
        boolean bl = singleSelection = this.objects.size() == 1;
        if (singleSelection) {
            this.labelOffset.setText("<html><u>0, 0, 0</u></html>");
        } else {
            JOptionPane.showMessageDialog(this, this.objects.size() + " offsets reset");
        }
    }

    private void setControlStates() {
        this.comboBoxReplacedMaterial.setEnabled(this.checkBoxReplace.isSelected());
        this.checkBoxCollideWithFloor.setEnabled(this.checkBoxOnWater.isSelected() || this.checkBoxOnWater.isTristateMode());
        this.spinnerVerticalOffset.setEnabled(this.radioButtonPlaceAtFixedHeight.isSelected());
        if (this.radioButtonPlaceOnTerrain.isSelected()) {
            this.labelVerticalOffset.setText("Height above terrain:");
        } else if (this.radioButtonPlaceAtFixedHeight.isSelected()) {
            this.labelVerticalOffset.setText("Absolute height:");
        }
        this.spinnerVerticalOffset.setEnabled(this.radioButtonPlaceOnTerrain.isSelected() || this.radioButtonPlaceAtFixedHeight.isSelected());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.labelFile = new JLabel();
        this.jLabel3 = new JLabel();
        this.labelOffset = new JLabel();
        this.buttonOffsetAuto = new JButton();
        this.buttonOffsetReset = new JButton();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.fieldName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.spinnerFrequency = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.comboBoxCollisionMode = new JComboBox();
        this.jLabel7 = new JLabel();
        this.comboBoxUndergroundMode = new JComboBox();
        this.jLabel8 = new JLabel();
        this.checkBoxRandomRotation = new TristateCheckBox();
        this.checkBoxOnSolidLand = new TristateCheckBox();
        this.checkBoxOnAir = new TristateCheckBox();
        this.checkBoxOnWater = new TristateCheckBox();
        this.checkBoxUnderWater = new TristateCheckBox();
        this.checkBoxUnderLava = new TristateCheckBox();
        this.checkBoxOnLava = new TristateCheckBox();
        this.checkBoxFrequencyActive = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.comboBoxLeafDecayMode = new JComboBox();
        this.checkBoxReplace = new JCheckBox();
        this.checkBoxExtendFoundation = new TristateCheckBox();
        this.comboBoxReplacedMaterial = new JComboBox();
        this.checkBoxCollideWithFloor = new TristateCheckBox();
        this.checkBoxRandomMirroring = new TristateCheckBox();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.radioButtonPlaceOnTerrain = new JRadioButton();
        this.radioButtonPlaceAtFixedHeight = new JRadioButton();
        this.spinnerVerticalOffset = new JSpinner();
        this.jLabel12 = new JLabel();
        this.spinnerRandomVariation = new JSpinner();
        this.jLabel13 = new JLabel();
        this.checkBoxRandomVariationActive = new JCheckBox();
        this.labelVerticalOffset = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Object Attributes");
        this.jLabel1.setText("Name:");
        this.jLabel2.setText("File:");
        this.labelFile.setText("jLabel3");
        this.jLabel3.setText("Offset:");
        this.labelOffset.setForeground(new Color(0, 0, 255));
        this.labelOffset.setText("<html><u>offset</u></html>");
        this.labelOffset.setToolTipText("Click to edit the offset.");
        this.labelOffset.setCursor(new Cursor(12));
        this.labelOffset.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EditObjectAttributes.this.labelOffsetMouseClicked(evt);
            }
        });
        this.buttonOffsetAuto.setText("Auto");
        this.buttonOffsetAuto.setToolTipText("This will try to set the offset to the base of the object.");
        this.buttonOffsetAuto.setHorizontalTextPosition(10);
        this.buttonOffsetAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectAttributes.this.buttonOffsetAutoActionPerformed(evt);
            }
        });
        this.buttonOffsetReset.setText("Zero");
        this.buttonOffsetReset.setToolTipText("This will set the offset to all zeroes.");
        this.buttonOffsetReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectAttributes.this.buttonOffsetResetActionPerformed(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectAttributes.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectAttributes.this.buttonOKActionPerformed(evt);
            }
        });
        this.fieldName.setColumns(20);
        this.fieldName.setText("jTextField1");
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel4.setText("Relative frequency:");
        this.jLabel4.setToolTipText("The frequency of this object relative to the other objects in the layer.");
        this.spinnerFrequency.setModel(new SpinnerNumberModel(100, 1, 9999, 1));
        this.spinnerFrequency.setToolTipText("The frequency of this object relative to the other objects in the layer.");
        this.jLabel5.setText("%");
        this.jLabel6.setLabelFor(this.comboBoxCollisionMode);
        this.jLabel6.setText("Collide with:");
        this.jLabel6.setToolTipText("<html>Determines which existing blocks an object will collide with (and therefore not be rendered).<br>\n<strong>Note</strong> that only above ground blocks are considered!</html>");
        this.comboBoxCollisionMode.setModel(new DefaultComboBoxModel<String>(new String[]{"no change", "any blocks", "solid blocks", "nothing"}));
        this.comboBoxCollisionMode.setToolTipText("<html>Determines which existing blocks an object will collide with (and therefore not be rendered).<br>\n<strong>Note</strong> that only above ground blocks are considered!</html>");
        this.jLabel7.setLabelFor(this.comboBoxUndergroundMode);
        this.jLabel7.setText("Replace underground blocks:");
        this.jLabel7.setToolTipText("Determines whether existing underground blocks should be replaced by blocks from the object.");
        this.comboBoxUndergroundMode.setModel(new DefaultComboBoxModel<String>(new String[]{"no change", "always", "if object block is solid", "if existing block is air"}));
        this.comboBoxUndergroundMode.setToolTipText("Determines whether existing underground blocks should be replaced by blocks from the object.");
        this.jLabel8.setText("Spawn:");
        this.checkBoxRandomRotation.setText("random rotation");
        this.checkBoxOnSolidLand.setText("on solid land");
        this.checkBoxOnAir.setText("on air");
        this.checkBoxOnWater.setText("on water");
        this.checkBoxOnWater.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectAttributes.this.checkBoxOnWaterActionPerformed(evt);
            }
        });
        this.checkBoxUnderWater.setText("under water");
        this.checkBoxUnderLava.setText("under lava");
        this.checkBoxOnLava.setText("on lava");
        this.checkBoxFrequencyActive.setSelected(true);
        this.checkBoxFrequencyActive.setText(" ");
        this.checkBoxFrequencyActive.setEnabled(false);
        this.checkBoxFrequencyActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectAttributes.this.checkBoxFrequencyActiveActionPerformed(evt);
            }
        });
        this.jLabel9.setLabelFor(this.comboBoxLeafDecayMode);
        this.jLabel9.setText("Leaf blocks should:");
        this.comboBoxLeafDecayMode.setModel(new DefaultComboBoxModel<String>(new String[]{"no change", "behave as exported", "decay", "not decay"}));
        this.checkBoxReplace.setText("replace with air:");
        this.checkBoxReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectAttributes.this.checkBoxReplaceActionPerformed(evt);
            }
        });
        this.checkBoxExtendFoundation.setText("extend foundation to ground");
        this.comboBoxReplacedMaterial.setEnabled(false);
        this.checkBoxCollideWithFloor.setSelected(true);
        this.checkBoxCollideWithFloor.setText("collide with floor");
        this.checkBoxCollideWithFloor.setEnabled(false);
        this.checkBoxRandomMirroring.setText("random mirroring");
        this.jLabel10.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/information.png")));
        this.jLabel10.setLabelFor((Component)((Object)this.checkBoxRandomMirroring));
        this.jLabel10.setText(" ");
        this.jLabel10.setToolTipText("<html>Mirroring works by rotating blocks 180 degrees.<br>\nIt does not work for asymmetric mod blocks of which<br>\nthe rotated versions are not mirrors of the originals.</html>");
        this.jLabel11.setText("Placement:");
        this.buttonGroup1.add(this.radioButtonPlaceOnTerrain);
        this.radioButtonPlaceOnTerrain.setText("relative to terrain");
        this.radioButtonPlaceOnTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectAttributes.this.radioButtonPlaceOnTerrainActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonPlaceAtFixedHeight);
        this.radioButtonPlaceAtFixedHeight.setText("fixed height");
        this.radioButtonPlaceAtFixedHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectAttributes.this.radioButtonPlaceAtFixedHeightActionPerformed(evt);
            }
        });
        this.spinnerVerticalOffset.setModel(new SpinnerNumberModel(0, -383, 383, 1));
        this.spinnerVerticalOffset.setEnabled(false);
        this.jLabel12.setLabelFor(this.spinnerRandomVariation);
        this.jLabel12.setText("Random y variation:");
        this.spinnerRandomVariation.setModel(new SpinnerNumberModel(0, 0, 383, 1));
        this.jLabel13.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/information.png")));
        this.jLabel13.setText(" ");
        this.jLabel13.setToolTipText("Distributed equally above and below the initial height.");
        this.checkBoxRandomVariationActive.setSelected(true);
        this.checkBoxRandomVariationActive.setText(" ");
        this.checkBoxRandomVariationActive.setEnabled(false);
        this.checkBoxRandomVariationActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditObjectAttributes.this.checkBoxRandomVariationActiveActionPerformed(evt);
            }
        });
        this.labelVerticalOffset.setLabelFor(this.spinnerVerticalOffset);
        this.labelVerticalOffset.setText("Height above terrain:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldName, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelOffset, -2, -1, -2).addGap(18, 18, 18).addComponent(this.buttonOffsetAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOffsetReset)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxFrequencyActive).addGap(0, 0, 0).addComponent(this.spinnerFrequency, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxCollisionMode, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxUndergroundMode, -2, -1, -2)).addComponent((Component)((Object)this.checkBoxRandomRotation), -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)this.checkBoxOnSolidLand), -2, -1, -2).addComponent((Component)((Object)this.checkBoxUnderWater), -2, -1, -2).addComponent((Component)((Object)this.checkBoxUnderLava), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)this.checkBoxOnAir), -2, -1, -2).addComponent((Component)((Object)this.checkBoxOnWater), -2, -1, -2).addComponent((Component)((Object)this.checkBoxOnLava), -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent((Component)((Object)this.checkBoxCollideWithFloor), -2, 121, -2)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxLeafDecayMode, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxReplace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxReplacedMaterial, -2, -1, -2)).addComponent((Component)((Object)this.checkBoxExtendFoundation), -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent((Component)((Object)this.checkBoxRandomMirroring), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10)).addComponent(this.jLabel11).addGroup(layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxRandomVariationActive).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerRandomVariation, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13)).addGroup(layout.createSequentialGroup().addComponent(this.labelVerticalOffset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerVerticalOffset, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.jPanel1, -1, 256, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelFile)).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonPlaceOnTerrain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonPlaceAtFixedHeight))).addGap(0, 371, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.labelFile)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fieldName, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.labelOffset, -2, -1, -2).addComponent(this.buttonOffsetAuto).addComponent(this.buttonOffsetReset)).addGap(18, 18, 18).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonPlaceOnTerrain).addComponent(this.radioButtonPlaceAtFixedHeight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinnerVerticalOffset, -2, -1, -2).addComponent(this.labelVerticalOffset)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.spinnerRandomVariation, -2, -1, -2).addComponent(this.jLabel13).addComponent(this.checkBoxRandomVariationActive)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.spinnerFrequency, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.checkBoxFrequencyActive)).addGap(18, 18, 18).addComponent((Component)((Object)this.checkBoxRandomRotation), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)((Object)this.checkBoxRandomMirroring), -2, -1, -2).addComponent(this.jLabel10)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent((Component)((Object)this.checkBoxOnSolidLand), -2, -1, -2).addComponent((Component)((Object)this.checkBoxOnAir), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)((Object)this.checkBoxUnderWater), -2, -1, -2).addComponent((Component)((Object)this.checkBoxOnWater), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)((Object)this.checkBoxCollideWithFloor), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)((Object)this.checkBoxUnderLava), -2, -1, -2).addComponent((Component)((Object)this.checkBoxOnLava), -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.comboBoxCollisionMode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.comboBoxUndergroundMode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.comboBoxLeafDecayMode, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxReplace).addComponent(this.comboBoxReplacedMaterial, -2, -1, -2)).addGap(18, 18, 18).addComponent((Component)((Object)this.checkBoxExtendFoundation), -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void labelOffsetMouseClicked(MouseEvent evt) {
        this.editOffset();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOffsetAutoActionPerformed(ActionEvent evt) {
        this.autoOffset();
    }

    private void buttonOffsetResetActionPerformed(ActionEvent evt) {
        this.resetOffset();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void checkBoxFrequencyActiveActionPerformed(ActionEvent evt) {
        this.spinnerFrequency.setEnabled(this.checkBoxFrequencyActive.isSelected());
    }

    private void checkBoxReplaceActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxOnWaterActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonPlaceOnTerrainActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonPlaceAtFixedHeightActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxRandomVariationActiveActionPerformed(ActionEvent evt) {
        this.spinnerRandomVariation.setEnabled(this.checkBoxRandomVariationActive.isSelected());
    }
}

