/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.swing.BetterJPopupMenu;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.biomeschemes.BiomeHelper;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeDialog;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_17Biomes;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_19Biomes;
import org.pepsoft.worldpainter.biomeschemes.StaticBiomeInfo;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.painting.PaintFactory;

public class BiomesPanel
extends JPanel
implements CustomBiomeManager.CustomBiomeListener {
    private final JPanel grid = new JPanel(new GridLayout(0, 5));
    private final JPanel optionsPanel = new JPanel();
    private final ButtonGroup buttonGroup;
    private final JLabel label1 = new JLabel("Selected biome: 1");
    private final JLabel label2 = new JLabel("Plains");
    private final CustomBiomeManager customBiomeManager;
    private final Listener listener;
    private BiomeHelper biomeHelper;
    private BiomesSet biomesSet;
    private int selectedBiome = 1;
    private int selectedBaseBiome = 1;
    private boolean showIds;
    private static final int[] MC_117_BIOME_ORDER = new int[]{1, 4, 6, 21, 168, 27, 29, 5, 32, 160, 3, 14, 2, 35, 37, 12, 140, 0, 7, 16, 25, 174, 175, 9, 127, 8, 170, 171, 172, 173};
    private static final int[] MC_119_BIOME_ORDER = new int[]{1, 4, 6, 21, 168, 27, 29, 247, 32, 160, 3, 2, 35, 37, 5, 12, 140, 0, 7, 16, 174, 252, 254, 251, 25, 175, 14, 253, 250, 249, 248, 127, -1, -1, -1, 9, 43, 42, 41, 40, 8, 170, 171, 172, 173};
    private static final String KEY_BIOME = BiomesPanel.class.getName() + ".biome";
    private static final String KEY_BIOME_OPTION = BiomesPanel.class.getName() + ".biomeOption";
    private static final String KEY_ADD_BUTTON = BiomesPanel.class.getName() + ".addButton";
    private static final String KEY_CUSTOM_BIOME = BiomesPanel.class.getName() + ".customBiome";
    private static final Set<BiomeDescriptor> MC_117_DESCRIPTORS = ImmutableSet.of((Object)new BiomeDescriptor(0), (Object)new BiomeDescriptor(1), (Object)new BiomeDescriptor(2), (Object)new BiomeDescriptor(3), (Object)new BiomeDescriptor(4), (Object)new BiomeDescriptor(5), (Object[])new BiomeDescriptor[]{new BiomeDescriptor(6), new BiomeDescriptor(7), new BiomeDescriptor(8), new BiomeDescriptor(9), new BiomeDescriptor(10, 0, BiomeOption.FROZEN), new BiomeDescriptor(11, 7, BiomeOption.FROZEN), new BiomeDescriptor(12), new BiomeDescriptor(13, 3, BiomeOption.SNOWY), new BiomeDescriptor(14), new BiomeDescriptor(15, 14, BiomeOption.SHORE), new BiomeDescriptor(16), new BiomeDescriptor(17, 2, BiomeOption.HILLS), new BiomeDescriptor(18, 4, BiomeOption.HILLS), new BiomeDescriptor(19, 5, BiomeOption.HILLS), new BiomeDescriptor(20, 3, BiomeOption.EDGE), new BiomeDescriptor(21), new BiomeDescriptor(22, 21, BiomeOption.HILLS), new BiomeDescriptor(23, 21, BiomeOption.EDGE), new BiomeDescriptor(24, 0, BiomeOption.DEEP), new BiomeDescriptor(25), new BiomeDescriptor(26, 16, BiomeOption.SNOWY), new BiomeDescriptor(27), new BiomeDescriptor(28, 27, BiomeOption.HILLS), new BiomeDescriptor(29), new BiomeDescriptor(30, 5, BiomeOption.SNOWY), new BiomeDescriptor(31, 5, BiomeOption.SNOWY, BiomeOption.HILLS), new BiomeDescriptor(32), new BiomeDescriptor(33, 32, BiomeOption.HILLS), new BiomeDescriptor(34, 3, BiomeOption.WOODED), new BiomeDescriptor(35), new BiomeDescriptor(36, 35, BiomeOption.PLATEAU), new BiomeDescriptor(37), new BiomeDescriptor(38, 37, BiomeOption.WOODED, BiomeOption.PLATEAU), new BiomeDescriptor(39, 37, BiomeOption.PLATEAU), new BiomeDescriptor(40, 9, BiomeOption.SMALL_ISLANDS), new BiomeDescriptor(41, 9, BiomeOption.MIDLANDS), new BiomeDescriptor(42, 9, BiomeOption.HIGHLANDS), new BiomeDescriptor(43, 9, BiomeOption.BARRENS), new BiomeDescriptor(44, 0, BiomeOption.WARM), new BiomeDescriptor(45, 0, BiomeOption.LUKEWARM), new BiomeDescriptor(46, 0, BiomeOption.COLD), new BiomeDescriptor(47, 0, BiomeOption.DEEP, BiomeOption.WARM), new BiomeDescriptor(48, 0, BiomeOption.DEEP, BiomeOption.LUKEWARM), new BiomeDescriptor(49, 0, BiomeOption.DEEP, BiomeOption.COLD), new BiomeDescriptor(50, 0, BiomeOption.DEEP, BiomeOption.FROZEN), new BiomeDescriptor(127), new BiomeDescriptor(129, 1, BiomeOption.FLOWERS), new BiomeDescriptor(130, 2, BiomeOption.LAKES), new BiomeDescriptor(131, 3, BiomeOption.GRAVELLY), new BiomeDescriptor(132, 4, BiomeOption.FLOWERS), new BiomeDescriptor(133, 5, BiomeOption.MOUNTAINOUS), new BiomeDescriptor(134, 6, BiomeOption.HILLS), new BiomeDescriptor(140), new BiomeDescriptor(149, 21, BiomeOption.MODIFIED), new BiomeDescriptor(151, 21, BiomeOption.MODIFIED, BiomeOption.EDGE), new BiomeDescriptor(155, 27, BiomeOption.TALL), new BiomeDescriptor(156, 27, BiomeOption.HILLS, BiomeOption.TALL), new BiomeDescriptor(157, 29, BiomeOption.HILLS), new BiomeDescriptor(158, 5, BiomeOption.SNOWY, BiomeOption.MOUNTAINOUS), new BiomeDescriptor(160), new BiomeDescriptor(161, 160, BiomeOption.HILLS), new BiomeDescriptor(162, 3, BiomeOption.GRAVELLY, BiomeOption.VARIANT), new BiomeDescriptor(163, 35, BiomeOption.SHATTERED), new BiomeDescriptor(164, 35, BiomeOption.SHATTERED, BiomeOption.PLATEAU), new BiomeDescriptor(165, 37, BiomeOption.ERODED), new BiomeDescriptor(166, 37, BiomeOption.MODIFIED, BiomeOption.WOODED, BiomeOption.PLATEAU), new BiomeDescriptor(167, 37, BiomeOption.MODIFIED, BiomeOption.PLATEAU), new BiomeDescriptor(168), new BiomeDescriptor(169, 168, BiomeOption.HILLS), new BiomeDescriptor(170), new BiomeDescriptor(171), new BiomeDescriptor(172), new BiomeDescriptor(173), new BiomeDescriptor(174), new BiomeDescriptor(175)});
    private static final Set<BiomeDescriptor> MC_119_DESCRIPTORS = ImmutableSet.of((Object)new BiomeDescriptor(1), (Object)new BiomeDescriptor(129, 1, BiomeOption.FLOWERS), (Object)new BiomeDescriptor(4), (Object)new BiomeDescriptor(132, 4, BiomeOption.FLOWERS), (Object)new BiomeDescriptor(34, 4, BiomeOption.WINDSWEPT), (Object)new BiomeDescriptor(6), (Object[])new BiomeDescriptor[]{new BiomeDescriptor(21), new BiomeDescriptor(23, 21, BiomeOption.SPARSE), new BiomeDescriptor(168), new BiomeDescriptor(27), new BiomeDescriptor(155, 27, BiomeOption.OLD_GROWTH), new BiomeDescriptor(29), new BiomeDescriptor(5), new BiomeDescriptor(30, 5, BiomeOption.SNOWY), new BiomeDescriptor(32), new BiomeDescriptor(160), new BiomeDescriptor(3), new BiomeDescriptor(131, 3, BiomeOption.GRAVELLY), new BiomeDescriptor(14), new BiomeDescriptor(2), new BiomeDescriptor(35), new BiomeDescriptor(36, 35, BiomeOption.PLATEAU), new BiomeDescriptor(163, 35, BiomeOption.WINDSWEPT), new BiomeDescriptor(37), new BiomeDescriptor(165, 37, BiomeOption.ERODED), new BiomeDescriptor(38, 37, BiomeOption.WOODED), new BiomeDescriptor(12), new BiomeDescriptor(140), new BiomeDescriptor(0), new BiomeDescriptor(46, 0, BiomeOption.COLD), new BiomeDescriptor(49, 0, BiomeOption.DEEP, BiomeOption.COLD), new BiomeDescriptor(50, 0, BiomeOption.DEEP, BiomeOption.FROZEN), new BiomeDescriptor(48, 0, BiomeOption.DEEP, BiomeOption.LUKEWARM), new BiomeDescriptor(24, 0, BiomeOption.DEEP), new BiomeDescriptor(10, 0, BiomeOption.FROZEN), new BiomeDescriptor(45, 0, BiomeOption.LUKEWARM), new BiomeDescriptor(44, 0, BiomeOption.WARM), new BiomeDescriptor(7), new BiomeDescriptor(11, 7, BiomeOption.FROZEN), new BiomeDescriptor(16), new BiomeDescriptor(26, 16, BiomeOption.SNOWY), new BiomeDescriptor(174), new BiomeDescriptor(252), new BiomeDescriptor(254), new BiomeDescriptor(251), new BiomeDescriptor(25), new BiomeDescriptor(175), new BiomeDescriptor(253), new BiomeDescriptor(250), new BiomeDescriptor(249), new BiomeDescriptor(9), new BiomeDescriptor(43), new BiomeDescriptor(42), new BiomeDescriptor(41), new BiomeDescriptor(40), new BiomeDescriptor(127), new BiomeDescriptor(8), new BiomeDescriptor(170), new BiomeDescriptor(171), new BiomeDescriptor(172), new BiomeDescriptor(173), new BiomeDescriptor(247), new BiomeDescriptor(248)});
    private static final BiomesSet MINECRAFT_1_17_BIOMES = new BiomesSet(MC_117_BIOME_ORDER, MC_117_DESCRIPTORS, Minecraft1_17Biomes.BIOME_NAMES);
    private static final BiomesSet MINECRAFT_1_19_BIOMES = new BiomesSet(MC_119_BIOME_ORDER, MC_119_DESCRIPTORS, Minecraft1_19Biomes.BIOME_NAMES);

    public BiomesPanel(CustomBiomeManager customBiomeManager, Listener listener, ButtonGroup buttonGroup) {
        this.customBiomeManager = customBiomeManager;
        this.listener = listener;
        this.buttonGroup = buttonGroup;
        this.initComponents();
        customBiomeManager.addListener((CustomBiomeManager.CustomBiomeListener)this);
    }

    public void loadBiomes(Platform platform, ColourScheme colourScheme) {
        BiomesSet desiredSet;
        this.biomeHelper = new BiomeHelper(colourScheme, this.customBiomeManager, platform);
        if (platform.capabilities.contains(Platform.Capability.NAMED_BIOMES)) {
            desiredSet = MINECRAFT_1_19_BIOMES;
            this.showIds = false;
        } else if (platform.capabilities.contains(Platform.Capability.BIOMES) || platform.capabilities.contains(Platform.Capability.BIOMES_3D)) {
            desiredSet = MINECRAFT_1_17_BIOMES;
            this.showIds = true;
        } else {
            desiredSet = null;
        }
        if (this.biomesSet != desiredSet) {
            this.loadBiomes(desiredSet, colourScheme);
        }
    }

    public void selectBiome(int biomeId) {
        if (this.selectedBiome == biomeId) {
            this.selectCurrentBaseBiomeButton();
            this.notifyListener();
        } else {
            BiomeDescriptor descriptor = this.findBiomeDescriptor(biomeId);
            if (descriptor.baseId == this.selectedBaseBiome) {
                this.selectCurrentBaseBiomeButton();
                for (Component component : this.optionsPanel.getComponents()) {
                    JCheckBox checkBox = (JCheckBox)component;
                    if (descriptor.options.contains(checkBox.getClientProperty(KEY_BIOME_OPTION))) {
                        if (checkBox.isSelected()) continue;
                        checkBox.setSelected(true);
                        continue;
                    }
                    if (!checkBox.isSelected()) continue;
                    checkBox.setSelected(false);
                }
                this.updateOptions();
                this.updateLabels();
            } else {
                this.selectedBaseBiome = descriptor.baseId;
                this.selectCurrentBaseBiomeButton();
                this.resetOptions();
                for (Component component : this.optionsPanel.getComponents()) {
                    JCheckBox checkBox = (JCheckBox)component;
                    if (!descriptor.options.contains(checkBox.getClientProperty(KEY_BIOME_OPTION))) continue;
                    checkBox.setSelected(true);
                }
                this.updateOptions();
                this.updateLabels();
            }
            this.notifyListener();
        }
    }

    public void customBiomeAdded(CustomBiome customBiome) {
        this.addButton(customBiome);
    }

    public void customBiomeChanged(CustomBiome customBiome) {
        for (Component component : this.grid.getComponents()) {
            if (!(component instanceof JToggleButton) || ((Integer)((JToggleButton)component).getClientProperty(KEY_BIOME)).intValue() != customBiome.getId()) continue;
            JToggleButton button = (JToggleButton)component;
            button.setIcon(IconUtils.createScaledColourIcon((int)customBiome.getColour()));
            button.setToolTipText(customBiome.getName());
            return;
        }
    }

    public void customBiomeRemoved(CustomBiome customBiome) {
        for (Component component : this.grid.getComponents()) {
            if (!(component instanceof JToggleButton) || ((Integer)((JToggleButton)component).getClientProperty(KEY_BIOME)).intValue() != customBiome.getId()) continue;
            JToggleButton button = (JToggleButton)component;
            if (button.isSelected()) {
                button.setSelected(false);
                this.selectedBiome = 1;
                this.notifyListener();
            }
            this.grid.remove(component);
            this.forceRepaint();
            return;
        }
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.label1.setHorizontalTextPosition(10);
        this.label1.setAlignmentX(0.0f);
        this.add(this.label1);
        this.label2.setAlignmentX(0.0f);
        this.add(this.label2);
        JButton addCustomBiomeButton = new JButton(IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/plus.png"));
        addCustomBiomeButton.putClientProperty(KEY_ADD_BUTTON, Boolean.TRUE);
        addCustomBiomeButton.setMargin(App.BUTTON_INSETS);
        addCustomBiomeButton.setToolTipText("Add a custom biome");
        addCustomBiomeButton.addActionListener(e -> {
            World2 world = App.getInstance().getWorld();
            if (world == null) {
                DesktopUtils.beep();
                return;
            }
            Window parent = SwingUtilities.getWindowAncestor(this);
            int id = this.customBiomeManager.getNextId();
            if (id == -1) {
                JOptionPane.showMessageDialog(parent, "Maximum number of custom biomes reached", "Maximum Reached", 0);
                return;
            }
            Platform platform = world.getPlatform();
            CustomBiome customBiome = new CustomBiome(platform.capabilities.contains(Platform.Capability.NAMED_BIOMES) ? "namespace:biome" : "Custom", id, Color.ORANGE.getRGB());
            CustomBiomeDialog dialog = new CustomBiomeDialog(parent, customBiome, true, platform);
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                this.customBiomeManager.addCustomBiome(parent, customBiome);
            }
        });
        this.grid.add(addCustomBiomeButton);
        this.grid.setAlignmentX(0.0f);
        this.add(this.grid);
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 3));
        this.add(this.optionsPanel);
    }

    private void loadBiomes(BiomesSet biomesSet, ColourScheme colourScheme) {
        if (this.biomesSet != null) {
            while (((JComponent)this.grid.getComponent(0)).getClientProperty(KEY_ADD_BUTTON) == null && ((JComponent)this.grid.getComponent(0)).getClientProperty(KEY_CUSTOM_BIOME) == null) {
                this.grid.remove(0);
            }
        }
        this.biomesSet = biomesSet;
        if (biomesSet != null) {
            int index = 0;
            for (int biome : biomesSet.biomeOrder) {
                if (biome != -1) {
                    JToggleButton button = new JToggleButton(new ImageIcon(BiomeSchemeManager.createImage((BiomeScheme)StaticBiomeInfo.INSTANCE, (int)biome, (ColourScheme)colourScheme)));
                    button.putClientProperty(KEY_BIOME, biome);
                    button.setMargin(App.BUTTON_INSETS);
                    StringBuilder tooltip = new StringBuilder();
                    tooltip.append(biomesSet.displayNames[biome]);
                    if (this.showIds) {
                        tooltip.append(" (");
                        List<Integer> variantIds = this.findVariants(biome);
                        tooltip.append(variantIds.stream().map(i -> Integer.toString(i)).collect(Collectors.joining(", ")));
                        tooltip.append(')');
                    } else {
                        Set<BiomeOption> options = this.findVariantOptions(biome);
                        if (!options.isEmpty()) {
                            tooltip.append(" (options: ");
                            tooltip.append(options.stream().map(this::createOptionName).collect(Collectors.joining(", ")));
                            tooltip.append(')');
                        }
                    }
                    button.setToolTipText(tooltip.toString());
                    this.buttonGroup.add(button);
                    if (biome == this.selectedBiome) {
                        button.setSelected(true);
                    }
                    button.addActionListener(e -> {
                        if (button.isSelected()) {
                            this.selectBaseBiome(biome);
                        }
                    });
                    this.grid.add((Component)button, index++);
                    continue;
                }
                this.grid.add(Box.createGlue(), index++);
            }
        }
        this.resetOptions();
        this.forceRepaint();
    }

    private void selectBaseBiome(int biome) {
        this.selectedBaseBiome = biome;
        this.selectedBiome = biome;
        this.notifyListener();
        this.resetOptions();
        this.updateLabels();
    }

    private void selectCurrentBaseBiomeButton() {
        for (Component component : this.grid.getComponents()) {
            JToggleButton button;
            if (!(component instanceof JToggleButton) || (Integer)(button = (JToggleButton)component).getClientProperty(KEY_BIOME) != this.selectedBaseBiome) continue;
            button.setSelected(true);
            return;
        }
        throw new IllegalArgumentException("No button found for currently selected base biome ID " + this.selectedBaseBiome);
    }

    private void resetOptions() {
        Set<BiomeOption> availableOptions = this.findAvailableOptions(this.selectedBaseBiome);
        this.optionsPanel.removeAll();
        for (BiomeOption option : availableOptions) {
            JCheckBox checkBox = new JCheckBox(this.createOptionName(option));
            checkBox.addActionListener(event -> this.updateOptions());
            checkBox.putClientProperty(KEY_BIOME_OPTION, (Object)option);
            checkBox.setEnabled(this.findBiome(this.selectedBaseBiome, EnumSet.of(option)) != -1);
            this.optionsPanel.add(checkBox);
        }
    }

    private String createOptionName(BiomeOption option) {
        return Arrays.stream(option.name().split("_")).map(s -> s.charAt(0) + s.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    private void updateOptions() {
        Set<BiomeOption> selectedOptions = this.getSelectedOptions();
        this.selectedBiome = this.findBiome(this.selectedBaseBiome, selectedOptions);
        if (this.selectedBiome == -1) {
            for (Component component : this.optionsPanel.getComponents()) {
                if (!((JCheckBox)component).isSelected()) continue;
                ((JCheckBox)component).setSelected(false);
            }
            selectedOptions = EnumSet.noneOf(BiomeOption.class);
            this.selectedBiome = this.selectedBaseBiome;
        }
        this.notifyListener();
        for (Component component : this.optionsPanel.getComponents()) {
            JCheckBox checkBox = (JCheckBox)component;
            BiomeOption biomeOption = (BiomeOption)((Object)checkBox.getClientProperty(KEY_BIOME_OPTION));
            if (selectedOptions.contains((Object)biomeOption)) {
                checkBox.setEnabled(true);
                continue;
            }
            EnumSet<BiomeOption> optionsCopy = EnumSet.copyOf(selectedOptions);
            optionsCopy.add(biomeOption);
            checkBox.setEnabled(this.findBiome(this.selectedBaseBiome, optionsCopy) != -1);
        }
        this.updateLabels();
    }

    private Set<BiomeOption> getSelectedOptions() {
        EnumSet<BiomeOption> selectedOptions = EnumSet.noneOf(BiomeOption.class);
        for (Component component : this.optionsPanel.getComponents()) {
            JCheckBox checkBox = (JCheckBox)component;
            if (!checkBox.isSelected()) continue;
            selectedOptions.add((BiomeOption)((Object)checkBox.getClientProperty(KEY_BIOME_OPTION)));
        }
        return selectedOptions;
    }

    private int findBiome(int baseId, Set<BiomeOption> options) {
        for (BiomeDescriptor descriptor : this.biomesSet.descriptors) {
            if (descriptor.getBaseId() != baseId || !descriptor.getOptions().equals(options)) continue;
            return descriptor.getId();
        }
        return -1;
    }

    private void updateLabels() {
        this.label1.setText("Selected biome: " + (this.showIds ? Integer.valueOf(this.selectedBiome) : ""));
        this.label1.setIcon(this.biomeHelper.getBiomeIcon(this.selectedBiome));
        this.label2.setText(this.biomeHelper.getBiomeNameWithoutId(this.selectedBiome));
    }

    private void addButton(final CustomBiome customBiome) {
        int biome = customBiome.getId();
        final JToggleButton button = new JToggleButton(IconUtils.createScaledColourIcon((int)customBiome.getColour()));
        button.putClientProperty(KEY_BIOME, biome);
        button.putClientProperty("org.pepsoft.worldpainter.paint.id", PaintFactory.createDiscreteLayerPaintId((Layer)Biome.INSTANCE, biome));
        button.putClientProperty(KEY_CUSTOM_BIOME, Boolean.TRUE);
        button.setMargin(App.BUTTON_INSETS);
        button.setToolTipText(customBiome.getName() + " (" + biome + "); right-click for options");
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            private void showPopupMenu(MouseEvent e) {
                BetterJPopupMenu popup = new BetterJPopupMenu();
                JMenuItem item = new JMenuItem("Edit...");
                item.addActionListener(actionEvent -> {
                    CustomBiomeDialog dialog = new CustomBiomeDialog(SwingUtilities.getWindowAncestor(button), customBiome, false, App.getInstance().getWorld().getPlatform());
                    dialog.setVisible(true);
                    if (!dialog.isCancelled()) {
                        BiomesPanel.this.customBiomeManager.editCustomBiome(customBiome);
                    }
                });
                popup.add(item);
                item = new JMenuItem("Remove...");
                item.addActionListener(actionEvent -> {
                    if (JOptionPane.showConfirmDialog(button, "Are you sure you want to remove custom biome \"" + customBiome.getName() + "\" (ID: " + customBiome.getId() + ")?\nAny occurrences will be replaced with Automatic Biomes", "Confirm Removal", 0) == 0) {
                        BiomesPanel.this.customBiomeManager.removeCustomBiome(customBiome);
                    }
                });
                popup.add(item);
                popup.show(button, e.getX(), e.getY());
            }
        });
        this.buttonGroup.add(button);
        button.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.selectBaseBiome(biome);
            }
        });
        this.grid.add((Component)button, this.grid.getComponentCount() - 1);
        this.forceRepaint();
    }

    private void forceRepaint() {
        Window parent = SwingUtilities.getWindowAncestor(this);
        if (parent != null) {
            parent.validate();
        }
    }

    private Set<BiomeOption> findAvailableOptions(int baseId) {
        if (this.biomesSet != null && baseId < this.biomesSet.displayNames.length && this.biomesSet.displayNames[baseId] != null) {
            EnumSet<BiomeOption> availableOptions = EnumSet.noneOf(BiomeOption.class);
            for (BiomeDescriptor descriptor : this.biomesSet.descriptors) {
                if (descriptor.getBaseId() != baseId) continue;
                availableOptions.addAll(descriptor.getOptions());
            }
            return availableOptions;
        }
        return Collections.emptySet();
    }

    private List<Integer> findVariants(int baseId) {
        ArrayList<Integer> variants = new ArrayList<Integer>();
        for (BiomeDescriptor descriptor : this.biomesSet.descriptors) {
            if (descriptor.getBaseId() != baseId) continue;
            variants.add(descriptor.getId());
        }
        return variants;
    }

    private Set<BiomeOption> findVariantOptions(int baseId) {
        EnumSet<BiomeOption> options = EnumSet.noneOf(BiomeOption.class);
        for (BiomeDescriptor descriptor : this.biomesSet.descriptors) {
            if (descriptor.getBaseId() != baseId) continue;
            options.addAll(descriptor.getOptions());
        }
        return options;
    }

    private BiomeDescriptor findBiomeDescriptor(int biomeId) {
        for (BiomeDescriptor descriptor : this.biomesSet.descriptors) {
            if (descriptor.id != biomeId) continue;
            return descriptor;
        }
        throw new IllegalArgumentException("Biome ID not found in current biomes set: " + biomeId);
    }

    private void notifyListener() {
        this.listener.biomeSelected(this.selectedBiome);
    }

    static class BiomesSet {
        final int[] biomeOrder;
        final Set<BiomeDescriptor> descriptors;
        final String[] displayNames;

        BiomesSet(int[] biomeOrder, Set<BiomeDescriptor> descriptors, String[] displayNames) {
            this.biomeOrder = biomeOrder;
            this.descriptors = descriptors;
            this.displayNames = displayNames;
        }
    }

    public static interface Listener {
        public void biomeSelected(int var1);
    }

    public static class BiomeDescriptor {
        private final int id;
        private final int baseId;
        private final Set<BiomeOption> options;

        public BiomeDescriptor(int id) {
            this(id, id, new BiomeOption[0]);
        }

        public BiomeDescriptor(int id, int baseId, BiomeOption ... options) {
            this.id = id;
            this.baseId = baseId;
            this.options = options != null && options.length > 0 ? EnumSet.copyOf(Arrays.asList(options)) : Collections.emptySet();
        }

        public int getId() {
            return this.id;
        }

        public int getBaseId() {
            return this.baseId;
        }

        public Set<BiomeOption> getOptions() {
            return this.options;
        }
    }

    public static enum BiomeOption {
        HILLS,
        SHORE,
        EDGE,
        PLATEAU,
        MOUNTAINOUS,
        VARIANT,
        FROZEN,
        SNOWY,
        DEEP,
        WOODED,
        WARM,
        LUKEWARM,
        COLD,
        TALL,
        FLOWERS,
        LAKES,
        GRAVELLY,
        SHATTERED,
        SMALL_ISLANDS,
        MIDLANDS,
        HIGHLANDS,
        BARRENS,
        MODIFIED,
        ERODED,
        WINDSWEPT,
        SPARSE,
        OLD_GROWTH;

    }
}

