/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.importing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.util.CollectionUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.swing.ProgressDialog;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.LayerListCellRenderer;
import org.pepsoft.worldpainter.LayerValueListCellRenderer;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.importing.Mapping;
import org.pepsoft.worldpainter.importing.MaskImporter;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;
import org.pepsoft.worldpainter.util.BiomeUtils;
import org.pepsoft.worldpainter.util.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportMaskDialog
extends WorldPainterDialog
implements DocumentListener {
    private JButton buttonCancel;
    private ButtonGroup buttonGroup1;
    private JButton buttonOk;
    private JButton buttonSelectFile;
    private JCheckBox checkBoxRemoveExisting;
    private JComboBox<Integer> comboBoxApplyToLayerValue;
    private JComboBox<Terrain> comboBoxApplyToTerrain;
    private JComboBox<Layer> comboBoxLayer;
    private JComboBox<Mapping> comboBoxMapping;
    private JTextField fieldFilename;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel labelImageDimensions;
    private JLabel labelMaskRange;
    private JLabel labelReason;
    private JLabel labelWorldDimensions;
    private JRadioButton radioButtonLayer;
    private JRadioButton radioButtonTerrain;
    private JSpinner spinnerOffsetX;
    private JSpinner spinnerOffsetY;
    private JSpinner spinnerScale;
    private JSpinner spinnerThreshold;
    private final Dimension dimension;
    private final ColourScheme colourScheme;
    private final List<Layer> allLayers;
    private final CustomBiomeManager customBiomeManager;
    private File selectedFile;
    private File masksDir;
    private volatile BufferedImage image;
    private MaskImporter maskImporter;
    private static final Icon ICON_WARNING = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/error.png");
    private static final Logger logger = LoggerFactory.getLogger(ImportMaskDialog.class);
    private static final long serialVersionUID = 1L;

    public ImportMaskDialog(Window parent, Dimension dimension, ColourScheme colourScheme, List<Layer> allLayers, CustomBiomeManager customBiomeManager, final File preselectedFile) {
        super(parent);
        this.dimension = dimension;
        this.colourScheme = colourScheme;
        this.allLayers = allLayers;
        this.customBiomeManager = customBiomeManager;
        this.initComponents();
        this.fieldFilename.getDocument().addDocumentListener(this);
        allLayers.sort(Comparator.comparing(layer -> layer instanceof CustomLayer).thenComparing(layer -> ((Layer)layer).getName()));
        this.comboBoxLayer.setModel(new DefaultComboBoxModel<Layer>(allLayers.toArray(new Layer[allLayers.size()])));
        this.comboBoxLayer.setRenderer(new LayerListCellRenderer());
        this.comboBoxApplyToTerrain.setModel(new DefaultComboBoxModel<Terrain>(CollectionUtils.nullAnd(Arrays.asList(Terrain.getConfiguredValues())).toArray(new Terrain[0])));
        this.comboBoxApplyToTerrain.setRenderer(new TerrainListCellRenderer(colourScheme, "-all-"));
        this.fieldFilename.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImportMaskDialog.this.loadFile();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImportMaskDialog.this.loadFile();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImportMaskDialog.this.loadFile();
            }
        });
        this.comboBoxMapping.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((Mapping)value).getDescription());
                }
                return this;
            }
        });
        this.labelMaskRange.setVisible(false);
        this.rootPane.setDefaultButton(this.buttonOk);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setControlStates();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (preselectedFile != null && preselectedFile.isFile()) {
                    ImportMaskDialog.this.fieldFilename.setText(preselectedFile.getAbsolutePath());
                } else {
                    ImportMaskDialog.this.selectFile();
                }
            }
        });
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setControlStates();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setControlStates();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setControlStates();
    }

    private void loadFile() {
        File file = new File(this.fieldFilename.getText());
        if (file.isFile() && !file.equals(this.selectedFile)) {
            this.selectedFile = file;
            this.loadImage();
        } else {
            this.selectedFile = null;
        }
        this.setControlStates();
    }

    private void updatePossibleMappings() {
        boolean targetSelected;
        boolean fileSelected = this.selectedFile != null && this.selectedFile.isFile();
        boolean bl = targetSelected = this.radioButtonLayer.isSelected() && this.comboBoxLayer.getSelectedItem() != null || this.radioButtonTerrain.isSelected();
        if (fileSelected && targetSelected) {
            MaskImporter.PossibleMappingsResult possibleMappings = this.maskImporter.getPossibleMappings();
            if (!possibleMappings.mappings.isEmpty()) {
                this.comboBoxMapping.setModel(new DefaultComboBoxModel<Mapping>(possibleMappings.mappings.toArray(new Mapping[possibleMappings.mappings.size()])));
                this.pack();
            } else {
                this.comboBoxMapping.setModel(new DefaultComboBoxModel());
            }
            this.labelReason.setText(possibleMappings.reason != null ? possibleMappings.reason + " " : null);
        }
    }

    private void setControlStates() {
        boolean fileSelected = this.selectedFile != null && this.selectedFile.isFile();
        this.radioButtonTerrain.setEnabled(fileSelected);
        this.comboBoxApplyToTerrain.setEnabled(this.radioButtonTerrain.isSelected());
        this.radioButtonLayer.setEnabled(fileSelected);
        this.comboBoxLayer.setEnabled(fileSelected && this.radioButtonLayer.isSelected());
        this.comboBoxApplyToLayerValue.setEnabled(this.radioButtonLayer.isSelected() && this.comboBoxLayer.getSelectedItem() != null && this.comboBoxApplyToLayerValue.getItemCount() > 1);
        this.checkBoxRemoveExisting.setEnabled(fileSelected && this.radioButtonLayer.isSelected());
        boolean targetSelected = this.radioButtonLayer.isSelected() && this.comboBoxLayer.getSelectedItem() != null || this.radioButtonTerrain.isSelected();
        this.comboBoxMapping.setEnabled(fileSelected && targetSelected);
        this.spinnerThreshold.setEnabled(fileSelected && targetSelected && this.comboBoxMapping.getSelectedItem() != null && ((Mapping)this.comboBoxMapping.getSelectedItem()).isThreshold());
        boolean mappingSelected = this.comboBoxMapping.getSelectedItem() != null;
        this.buttonOk.setEnabled(fileSelected && targetSelected && mappingSelected);
    }

    private void loadLayerValues() {
        Vector<Integer> values;
        Platform platform = this.dimension.getWorld().getPlatform();
        Layer layer = (Layer)this.comboBoxLayer.getSelectedItem();
        Integer defaultValue = (Integer)this.comboBoxApplyToLayerValue.getSelectedItem();
        if (layer instanceof Biome) {
            values = new Vector<Integer>(256);
            values.add(null);
            BiomeScheme biomeScheme = BiomeUtils.getBiomeScheme((Platform)platform);
            for (int value = 0; value < 256; ++value) {
                if (biomeScheme.isBiomePresent(value)) {
                    values.add(value);
                    continue;
                }
                int finalValue = value;
                if (!this.customBiomeManager.getCustomBiomes().stream().anyMatch(customBiome -> customBiome.getId() == finalValue)) continue;
                values.add(value);
            }
        } else {
            Layer.DataSize dataSize = layer.getDataSize();
            switch (dataSize) {
                case BIT: 
                case BIT_PER_CHUNK: {
                    defaultValue = this.maskImporter.getInputType() == MaskImporter.InputType.ONE_BIT_GREY_SCALE ? Integer.valueOf(1) : null;
                    values = new Vector(1);
                    values.add(defaultValue);
                    break;
                }
                case NIBBLE: {
                    values = new Vector(17);
                    values.add(null);
                    for (int value = 0; value < 16; ++value) {
                        if (value == layer.getDefaultValue()) continue;
                        values.add(value);
                    }
                    if (defaultValue == null && this.maskImporter.getInputType() == MaskImporter.InputType.ONE_BIT_GREY_SCALE) {
                        defaultValue = 8;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Layer " + layer + " of type " + layer.getClass().getSimpleName() + " with data size " + dataSize + " not supported");
                }
            }
        }
        this.comboBoxApplyToLayerValue.setModel(new DefaultComboBoxModel(values));
        this.comboBoxApplyToLayerValue.setRenderer(new LayerValueListCellRenderer(layer, platform, this.colourScheme, this.customBiomeManager, "-full range-"));
        this.comboBoxApplyToLayerValue.setSelectedItem(defaultValue);
        this.pack();
    }

    private void loadImage() {
        try {
            this.image = null;
            this.image = ImageIO.read(this.selectedFile);
            if (this.image == null) {
                this.labelImageDimensions.setForeground(Color.RED);
                this.labelImageDimensions.setText("Not an image file, or damaged file!");
                this.selectedFile = null;
            } else if (this.image.isAlphaPremultiplied()) {
                this.labelImageDimensions.setForeground(Color.RED);
                this.labelImageDimensions.setText("Premultiplied alpha not supported! Please convert to non-premultiplied.");
                this.selectedFile = null;
            } else {
                this.maskImporter = new MaskImporter(this.dimension, this.selectedFile, this.image);
                if (!this.maskImporter.isSupported()) {
                    this.labelImageDimensions.setForeground(Color.RED);
                    this.labelImageDimensions.setText(this.maskImporter.getUnsupportedReason());
                    this.selectedFile = null;
                    return;
                }
                this.labelImageDimensions.setForeground(null);
                int width = this.image.getWidth();
                int height = this.image.getHeight();
                this.maskImporter.setRemoveExistingLayer(this.checkBoxRemoveExisting.isSelected());
                MaskImporter.InputType inputType = this.maskImporter.getInputType();
                if (inputType == MaskImporter.InputType.EIGHT_BIT_GREY_SCALE || inputType == MaskImporter.InputType.SIXTEEN_BIT_GREY_SCALE || inputType == MaskImporter.InputType.THIRTY_TWO_BIT_GREY_SCALE || inputType == MaskImporter.InputType.FLOAT_GREY_SCALE || inputType == MaskImporter.InputType.DOUBLE_GREY_SCALE) {
                    double range;
                    SpinnerNumberModel thresholdModel = (SpinnerNumberModel)this.spinnerThreshold.getModel();
                    thresholdModel.setMinimum(Double.valueOf(this.maskImporter.getImageLowValue()));
                    thresholdModel.setMaximum(Double.valueOf(this.maskImporter.getImageHighValue()));
                    thresholdModel.setValue((this.maskImporter.getImageLowValue() + this.maskImporter.getImageHighValue()) / 2.0);
                    double stepSize = inputType == MaskImporter.InputType.FLOAT_GREY_SCALE || inputType == MaskImporter.InputType.DOUBLE_GREY_SCALE ? ((range = this.maskImporter.getImageHighValue() - this.maskImporter.getImageLowValue()) <= 1.0 ? 0.001 : (range <= 10.0 ? 0.01 : (range <= 100.0 ? 0.1 : 1.0))) : 1.0;
                    thresholdModel.setStepSize(stepSize);
                }
                this.comboBoxApplyToTerrain.setSelectedItem(null);
                if (inputType == MaskImporter.InputType.COLOUR) {
                    this.radioButtonLayer.setSelected(true);
                    this.comboBoxLayer.setSelectedItem(Annotations.INSTANCE);
                    this.comboBoxApplyToLayerValue.setSelectedItem(null);
                } else {
                    this.buttonGroup1.clearSelection();
                    this.comboBoxLayer.setSelectedIndex(0);
                }
                this.labelReason.setText(null);
                String scalingNotSupportedReason = this.maskImporter.getScalingNotSupportedReason();
                if (scalingNotSupportedReason != null) {
                    this.spinnerScale.setValue(Float.valueOf(100.0f));
                    this.spinnerScale.setEnabled(false);
                    this.spinnerScale.setToolTipText(scalingNotSupportedReason);
                    this.labelImageDimensions.setIcon(ICON_WARNING);
                    this.labelImageDimensions.setText(scalingNotSupportedReason);
                } else {
                    this.spinnerScale.setEnabled(true);
                    this.spinnerScale.setToolTipText(null);
                    this.labelImageDimensions.setIcon(null);
                    if (inputType == MaskImporter.InputType.COLOUR) {
                        this.labelImageDimensions.setText(String.format("Image size: %,d x %,d, colour, %d bits", width, height, this.image.getSampleModel().getSampleSize(0)));
                    } else if (inputType == MaskImporter.InputType.ONE_BIT_GREY_SCALE) {
                        this.labelImageDimensions.setText(String.format("Image size: %,d x %,d, black and white", width, height));
                    } else if (inputType == MaskImporter.InputType.FLOAT_GREY_SCALE || inputType == MaskImporter.InputType.DOUBLE_GREY_SCALE) {
                        this.labelImageDimensions.setText(String.format("<html>Image size: %,d x %,d, grey scale, %d bits floating point<br>Lowest value: %,f, highest value: %,f</html>", width, height, this.image.getSampleModel().getSampleSize(0), this.maskImporter.getImageLowValue(), this.maskImporter.getImageHighValue()));
                    } else {
                        this.labelImageDimensions.setText(String.format("<html>Image size: %,d x %,d, grey scale, %d bits integer<br>Lowest value: %,d, highest value: %,d</html>", width, height, this.image.getSampleModel().getSampleSize(0), Math.round(this.maskImporter.getImageLowValue()), Math.round(this.maskImporter.getImageHighValue())));
                    }
                }
                if (inputType == MaskImporter.InputType.FLOAT_GREY_SCALE || inputType == MaskImporter.InputType.DOUBLE_GREY_SCALE) {
                    this.labelMaskRange.setText(String.format("Actual mask range: %,f - %,f", this.maskImporter.getImageLowValue(), this.maskImporter.getImageHighValue()));
                    this.labelMaskRange.setVisible(true);
                } else if (inputType != MaskImporter.InputType.ONE_BIT_GREY_SCALE && inputType != MaskImporter.InputType.COLOUR && inputType != MaskImporter.InputType.UNSUPPORTED) {
                    this.labelMaskRange.setText(String.format("Actual mask range: %,d - %,d", (long)this.maskImporter.getImageLowValue(), (long)this.maskImporter.getImageHighValue()));
                    this.labelMaskRange.setVisible(true);
                } else {
                    this.labelMaskRange.setVisible(false);
                }
                this.updateWorldDimensions();
            }
        }
        catch (IOException e) {
            logger.error("I/O error loading image " + this.selectedFile, (Throwable)e);
            this.labelImageDimensions.setForeground(Color.RED);
            this.labelImageDimensions.setText(String.format("I/O error loading image (message: %s)!", e.getMessage()));
            this.selectedFile = null;
        }
        catch (IllegalArgumentException e) {
            logger.error("IllegalArgumentException loading image " + this.selectedFile, (Throwable)e);
            this.labelImageDimensions.setForeground(Color.RED);
            if (e.getMessage().equals("Invalid scanline stride")) {
                this.labelImageDimensions.setText("Image data too large to load; try reducing dimensions or bit depth");
            } else {
                this.labelImageDimensions.setText("Error in image data: " + e.getMessage());
            }
            this.selectedFile = null;
        }
    }

    private void updateWorldDimensions() {
        float scale = ((Float)this.spinnerScale.getValue()).floatValue();
        this.labelWorldDimensions.setText(String.format("Scaled size: %,d x %,d blocks", Math.round((float)this.image.getWidth() * (scale / 100.0f)), Math.round((float)this.image.getHeight() * (scale / 100.0f))));
    }

    @Override
    protected void ok() {
        this.maskImporter.setThreshold((Double)this.spinnerThreshold.getValue());
        this.maskImporter.setMapping((Mapping)this.comboBoxMapping.getSelectedItem());
        this.maskImporter.setRemoveExistingLayer(this.radioButtonLayer.isSelected() && this.checkBoxRemoveExisting.isSelected());
        this.maskImporter.setScale(((Float)this.spinnerScale.getValue()).floatValue() / 100.0f);
        this.maskImporter.setxOffset((Integer)this.spinnerOffsetX.getValue());
        this.maskImporter.setyOffset((Integer)this.spinnerOffsetY.getValue());
        ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Void>(){

            public String getName() {
                return "Importing mask";
            }

            public Void execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                ImportMaskDialog.this.maskImporter.doImport(progressReceiver);
                return null;
            }
        }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
        Configuration.getInstance().setMasksDirectory(this.selectedFile.getParentFile());
        this.dimension.armSavePoint();
        super.ok();
    }

    private void selectFile() {
        File file;
        File myHeightMapDir = this.masksDir;
        if (myHeightMapDir == null) {
            myHeightMapDir = Configuration.getInstance().getMasksDirectory();
        }
        if (myHeightMapDir == null) {
            myHeightMapDir = Configuration.getInstance().getHeightMapsDirectory();
        }
        if ((file = ImageUtils.selectImageForOpen(this, "a mask image file", myHeightMapDir)) != null) {
            this.masksDir = file.getParentFile();
            this.fieldFilename.setText(file.getAbsolutePath());
        }
    }

    private void initComponents() {
        this.jLabel14 = new JLabel();
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.fieldFilename = new JTextField();
        this.buttonSelectFile = new JButton();
        this.labelImageDimensions = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.jLabel2 = new JLabel();
        this.radioButtonTerrain = new JRadioButton();
        this.radioButtonLayer = new JRadioButton();
        this.comboBoxLayer = new JComboBox();
        this.jLabel3 = new JLabel();
        this.spinnerThreshold = new JSpinner();
        this.jLabel4 = new JLabel();
        this.spinnerScale = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jLabel11 = new JLabel();
        this.spinnerOffsetX = new JSpinner();
        this.spinnerOffsetY = new JSpinner();
        this.jLabel12 = new JLabel();
        this.labelWorldDimensions = new JLabel();
        this.checkBoxRemoveExisting = new JCheckBox();
        this.comboBoxApplyToTerrain = new JComboBox();
        this.jLabel10 = new JLabel();
        this.comboBoxApplyToLayerValue = new JComboBox();
        this.labelReason = new JLabel();
        this.comboBoxMapping = new JComboBox();
        this.jLabel6 = new JLabel();
        this.labelMaskRange = new JLabel();
        this.jLabel14.setText("jLabel14");
        this.setDefaultCloseOperation(2);
        this.setTitle("Import Mask");
        this.jLabel1.setText("Select the image to import as a mask:");
        this.buttonSelectFile.setText("...");
        this.buttonSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportMaskDialog.this.buttonSelectFileActionPerformed(evt);
            }
        });
        this.labelImageDimensions.setText("<html>Image size: ? x ?, bit depth: ?<br>\nLowest value: ?, highest value: ?</html>");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportMaskDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOk.setText("OK");
        this.buttonOk.setEnabled(false);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportMaskDialog.this.buttonOkActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Apply to:");
        this.buttonGroup1.add(this.radioButtonTerrain);
        this.radioButtonTerrain.setText("terrain:");
        this.radioButtonTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportMaskDialog.this.radioButtonTerrainActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonLayer);
        this.radioButtonLayer.setText("layer");
        this.radioButtonLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportMaskDialog.this.radioButtonLayerActionPerformed(evt);
            }
        });
        this.comboBoxLayer.setEnabled(false);
        this.comboBoxLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportMaskDialog.this.comboBoxLayerActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Select the mapping:");
        this.spinnerThreshold.setModel(new SpinnerNumberModel(0.0, 0.0, 255.0, 1.0));
        this.spinnerThreshold.setEnabled(false);
        this.jLabel4.setText("Scale:");
        this.spinnerScale.setModel(new SpinnerNumberModel(Float.valueOf(100.0f), Float.valueOf(0.01f), Float.valueOf(999.99f), Float.valueOf(0.1f)));
        this.spinnerScale.setEditor(new JSpinner.NumberEditor(this.spinnerScale, "0.00"));
        this.spinnerScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportMaskDialog.this.spinnerScaleStateChanged(evt);
            }
        });
        this.jLabel5.setText("%");
        this.jLabel11.setText("Offset:");
        this.jLabel11.setToolTipText("The origin of the height map will be at these coordinates in the map");
        this.spinnerOffsetX.setModel(new SpinnerNumberModel(0, -999999, 999999, 1));
        this.spinnerOffsetX.setToolTipText("The origin of the height map will be at these coordinates in the map");
        this.spinnerOffsetX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportMaskDialog.this.spinnerOffsetXStateChanged(evt);
            }
        });
        this.spinnerOffsetY.setModel(new SpinnerNumberModel(0, -999999, 999999, 1));
        this.spinnerOffsetY.setToolTipText("The origin of the height map will be at these coordinates in the map");
        this.spinnerOffsetY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportMaskDialog.this.spinnerOffsetYStateChanged(evt);
            }
        });
        this.jLabel12.setText(",");
        this.jLabel12.setToolTipText("The origin of the height map will be at these coordinates in the map");
        this.labelWorldDimensions.setText("Scaled size: ? x ? blocks");
        this.checkBoxRemoveExisting.setText("remove existing layer");
        this.checkBoxRemoveExisting.setEnabled(false);
        this.comboBoxApplyToTerrain.setEnabled(false);
        this.comboBoxApplyToTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportMaskDialog.this.comboBoxApplyToTerrainActionPerformed(evt);
            }
        });
        this.jLabel10.setText(": ");
        this.comboBoxApplyToLayerValue.setEnabled(false);
        this.comboBoxApplyToLayerValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportMaskDialog.this.comboBoxApplyToLayerValueActionPerformed(evt);
            }
        });
        this.labelReason.setFont(this.labelReason.getFont().deriveFont(this.labelReason.getFont().getStyle() | 2));
        this.comboBoxMapping.setEnabled(false);
        this.comboBoxMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportMaskDialog.this.comboBoxMappingActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Threshold:");
        this.labelMaskRange.setText("Actual mask range: -999,999 - 999,999");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerThreshold, -2, -1, -2).addGap(18, 18, 18).addComponent(this.labelMaskRange).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.fieldFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectFile)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.labelReason).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.labelImageDimensions, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerScale, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel5).addGap(18, 18, 18).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerOffsetX, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerOffsetY, -2, -1, -2)).addComponent(this.labelWorldDimensions).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonTerrain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxApplyToTerrain, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonLayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxLayer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxApplyToLayerValue, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkBoxRemoveExisting)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxMapping, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fieldFilename, -2, -1, -2).addComponent(this.buttonSelectFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelImageDimensions, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.spinnerScale, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.jLabel11).addComponent(this.spinnerOffsetX, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.spinnerOffsetY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelWorldDimensions).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.radioButtonTerrain).addComponent(this.comboBoxApplyToTerrain, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonLayer).addComponent(this.comboBoxLayer, -2, -1, -2).addComponent(this.checkBoxRemoveExisting).addComponent(this.jLabel10).addComponent(this.comboBoxApplyToLayerValue, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboBoxMapping, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.spinnerThreshold, -2, -1, -2).addComponent(this.labelMaskRange)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOk).addComponent(this.labelReason)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonSelectFileActionPerformed(ActionEvent evt) {
        this.selectFile();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void spinnerScaleStateChanged(ChangeEvent evt) {
        if (this.image != null) {
            this.updateWorldDimensions();
        }
    }

    private void spinnerOffsetXStateChanged(ChangeEvent evt) {
        if (this.image != null) {
            this.updateWorldDimensions();
        }
    }

    private void spinnerOffsetYStateChanged(ChangeEvent evt) {
        if (this.image != null) {
            this.updateWorldDimensions();
        }
    }

    private void radioButtonTerrainActionPerformed(ActionEvent evt) {
        if (this.radioButtonTerrain.isSelected()) {
            this.maskImporter.setApplyToTerrain(true);
            this.comboBoxApplyToLayerValue.setModel(new DefaultComboBoxModel());
            this.comboBoxApplyToLayerValue.setSelectedItem(null);
        }
        this.updatePossibleMappings();
        this.setControlStates();
    }

    private void radioButtonLayerActionPerformed(ActionEvent evt) {
        if (this.radioButtonLayer.isSelected()) {
            this.maskImporter.setApplyToLayer((Layer)this.comboBoxLayer.getSelectedItem());
            this.loadLayerValues();
        }
        this.updatePossibleMappings();
        this.setControlStates();
    }

    private void comboBoxLayerActionPerformed(ActionEvent evt) {
        this.maskImporter.setApplyToLayer((Layer)this.comboBoxLayer.getSelectedItem());
        this.loadLayerValues();
        this.updatePossibleMappings();
        this.setControlStates();
    }

    private void comboBoxApplyToTerrainActionPerformed(ActionEvent evt) {
        this.maskImporter.setApplyToTerrainType((Terrain)this.comboBoxApplyToTerrain.getSelectedItem());
        this.updatePossibleMappings();
        this.setControlStates();
    }

    private void comboBoxApplyToLayerValueActionPerformed(ActionEvent evt) {
        this.maskImporter.setApplyToLayerValue((Integer)this.comboBoxApplyToLayerValue.getSelectedItem());
        this.updatePossibleMappings();
        this.setControlStates();
    }

    private void comboBoxMappingActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }
}

