/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.google.common.collect.Sets;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.MemoryUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.WPBorderTileProvider;
import org.pepsoft.worldpainter.WPTileProvider;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.brushes.BrushShape;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.ramps.ColourRamp;
import org.pepsoft.worldpainter.tools.BiomesTileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldPainter
extends WorldPainterView
implements MouseMotionListener,
PropertyChangeListener,
Dimension.Listener {
    private HashSet<Layer> hiddenLayers = new HashSet();
    private final CustomBiomeManager customBiomeManager;
    private Dimension dimension;
    private Dimension backgroundDimension;
    private int mouseX;
    private int mouseY;
    private int radius;
    private int effectiveRadius;
    private int contourSeparation;
    private int brushRotation;
    private int backgroundDimensionZoom;
    private int viewDistance;
    private boolean drawBrush;
    private boolean drawOverlays;
    private boolean drawContours;
    private boolean drawViewDistance;
    private boolean drawWalkingDistance;
    private boolean drawMinecraftBorder = true;
    private boolean drawBorders = true;
    private boolean drawBiomes = true;
    private BrushShape brushShape;
    private ColourScheme colourScheme;
    private TileRenderer.LightOrigin lightOrigin = TileRenderer.LightOrigin.NORTHWEST;
    private WPTileProvider tileProvider;
    private WPTileProvider backgroundTileProvider;
    private Shape customBrushShape;
    private Configuration.OverlayType overlayType;
    private ColourRamp colourRamp;
    private Timer repaintTimer;
    private static final int FIVE_MINUTE_WALK_DISTANCE_RADIUS = 1280;
    private static final int DAY_WALK_DISTANCE_RADIUS = 3328;
    private static final int DAY_NIGHT_WALK_DISTANCE_RADIUS = 5120;
    private static final Font NORMAL_FONT = new Font("SansSerif", 0, 10);
    private static final Logger logger = LoggerFactory.getLogger(WorldPainter.class);
    private static final long serialVersionUID = 1L;
    private static final int LAYER_BIOMES = -3;
    private static final int LAYER_BORDER = -2;
    private static final int LAYER_BACKGROUND = -1;
    private static final int LAYER_DETAILS = 0;

    public WorldPainter(ColourScheme colourScheme, CustomBiomeManager customBiomeManager) {
        super(false, false);
        this.colourScheme = colourScheme;
        this.customBiomeManager = customBiomeManager;
        this.setOpaque(true);
        this.addMouseMotionListener(this);
        this.enableInputMethods(false);
    }

    public WorldPainter(Dimension dimension, ColourScheme colourScheme, CustomBiomeManager customBiomeManager) {
        this(colourScheme, customBiomeManager);
        this.setDimension(dimension);
    }

    public final Dimension getDimension() {
        return this.dimension;
    }

    public final void setDimension(Dimension dimension) {
        this.setDimension(dimension, true);
    }

    final void setDimension(Dimension dimension, boolean refreshTiles) {
        Dimension oldDimension = this.dimension;
        if (oldDimension != null) {
            oldDimension.removePropertyChangeListener((PropertyChangeListener)this);
            if (oldDimension.getAnchor().dim == 0) {
                oldDimension.getWorld().removePropertyChangeListener("spawnPoint", (PropertyChangeListener)this);
            }
            oldDimension.removeDimensionListener((Dimension.Listener)this);
            for (Overlay overlay : oldDimension.getOverlays()) {
                overlay.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
        this.dimension = dimension;
        if (dimension != null) {
            this.drawContours = dimension.isContoursEnabled();
            this.contourSeparation = dimension.getContourSeparation();
            dimension.addPropertyChangeListener((PropertyChangeListener)this);
            if (dimension.getAnchor().dim == 0) {
                dimension.getWorld().addPropertyChangeListener("spawnPoint", (PropertyChangeListener)this);
            }
            dimension.addDimensionListener((Dimension.Listener)this);
            for (Overlay overlay : dimension.getOverlays()) {
                overlay.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.setGridSize(dimension.getGridSize());
            this.setPaintGrid(dimension.isGridEnabled());
            this.setLabelScale((int)dimension.getScale());
            this.overlayType = Configuration.getInstance().getOverlayType();
            this.drawOverlays = dimension.isOverlaysEnabled();
            this.setMarkerCoords(dimension.getAnchor().dim == 0 ? dimension.getWorld().getSpawnPoint() : null);
        } else {
            this.drawOverlays = false;
            this.setMarkerCoords(null);
        }
        this.firePropertyChange("dimension", oldDimension, dimension);
        if (refreshTiles) {
            this.refreshTiles();
        }
    }

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    public void setColourScheme(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
        this.refreshTiles();
    }

    public boolean isDrawBrush() {
        return this.drawBrush;
    }

    public void setDrawBrush(boolean drawBrush) {
        if (drawBrush != this.drawBrush) {
            this.drawBrush = drawBrush;
            this.firePropertyChange("drawBrush", !drawBrush, drawBrush);
            this.repaintWorld(this.getBrushBounds());
        }
    }

    public boolean isDrawViewDistance() {
        return this.drawViewDistance;
    }

    public void setDrawViewDistance(boolean drawViewDistance) {
        if (drawViewDistance != this.drawViewDistance) {
            this.drawViewDistance = drawViewDistance;
            this.firePropertyChange("drawViewDistance", !drawViewDistance, drawViewDistance);
            int scaledRadius = this.dimension != null ? (int)Math.ceil((float)this.viewDistance / this.dimension.getScale()) : this.viewDistance;
            this.repaintWorld(this.mouseX - scaledRadius, this.mouseY - scaledRadius, 2 * scaledRadius + 1, 2 * scaledRadius + 1);
        }
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public void setViewDistance(int viewDistance) {
        if (viewDistance != this.viewDistance) {
            int oldViewDistance = this.viewDistance;
            this.viewDistance = viewDistance;
            this.firePropertyChange("viewDistance", oldViewDistance, viewDistance);
            if (this.drawViewDistance) {
                int largestDistance = Math.max(oldViewDistance, viewDistance);
                int scaledRadius = this.dimension != null ? (int)Math.ceil((float)largestDistance / this.dimension.getScale()) : largestDistance;
                this.repaintWorld(this.mouseX - scaledRadius, this.mouseY - scaledRadius, 2 * scaledRadius + 1, 2 * scaledRadius + 1);
            }
        }
    }

    public boolean isDrawWalkingDistance() {
        return this.drawWalkingDistance;
    }

    public void setDrawWalkingDistance(boolean drawWalkingDistance) {
        if (drawWalkingDistance != this.drawWalkingDistance) {
            this.drawWalkingDistance = drawWalkingDistance;
            this.firePropertyChange("drawWalkingDistance", !drawWalkingDistance, drawWalkingDistance);
            int scaledRadius = this.dimension != null ? (int)Math.ceil(5120.0f / this.dimension.getScale()) : 5120;
            this.repaintWorld(this.mouseX - scaledRadius, this.mouseY - scaledRadius, 2 * scaledRadius + 1, 2 * scaledRadius + 1);
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        int oldRadius = this.radius;
        int oldEffectiveRadius = this.effectiveRadius;
        this.radius = radius;
        if (this.brushShape == BrushShape.CIRCLE || this.brushRotation % 90 == 0) {
            this.effectiveRadius = radius;
        } else {
            double a = (double)this.brushRotation / 180.0 * Math.PI;
            this.effectiveRadius = (int)Math.ceil(Math.abs(Math.sin(a)) * (double)radius + Math.abs(Math.cos(a)) * (double)radius);
        }
        this.firePropertyChange("radius", oldRadius, radius);
        if (this.drawBrush && this.brushShape != BrushShape.CUSTOM) {
            int largestRadius = Math.max(oldEffectiveRadius, this.effectiveRadius);
            int diameter = largestRadius * 2 + 1;
            this.repaintWorld(this.mouseX - largestRadius, this.mouseY - largestRadius, diameter, diameter);
        }
    }

    public BrushShape getBrushShape() {
        return this.brushShape;
    }

    public void setBrushShape(BrushShape brushShape) {
        if (brushShape != this.brushShape) {
            BrushShape oldBrushShape = this.brushShape;
            Rectangle oldBounds = this.getBrushBounds();
            this.brushShape = brushShape;
            if (brushShape == BrushShape.CIRCLE || brushShape == BrushShape.CUSTOM || this.brushRotation % 90 == 0) {
                this.effectiveRadius = this.radius;
            } else {
                double a = (double)this.brushRotation / 180.0 * Math.PI;
                this.effectiveRadius = (int)Math.ceil(Math.abs(Math.sin(a)) * (double)this.radius + Math.abs(Math.cos(a)) * (double)this.radius);
            }
            this.firePropertyChange("brushShape", oldBrushShape, brushShape);
            if (this.drawBrush) {
                this.repaintWorld(this.getBrushBounds().union(oldBounds));
            }
        }
    }

    public Shape getCustomBrushShape() {
        return this.customBrushShape;
    }

    public void setCustomBrushShape(Shape customBrushShape) {
        Shape oldCustomBrushShape = this.customBrushShape;
        Rectangle oldBrushBounds = this.getBrushBounds();
        this.customBrushShape = customBrushShape;
        if (this.drawBrush && this.brushShape == BrushShape.CUSTOM) {
            this.repaintWorld(this.getBrushBounds().union(oldBrushBounds));
        }
        this.firePropertyChange("customBrushShape", oldCustomBrushShape, customBrushShape);
    }

    public int getContourSeparation() {
        return this.contourSeparation;
    }

    public void setContourSeparation(int contourSeparation) {
        if (contourSeparation != this.contourSeparation) {
            int oldContourSeparation = this.contourSeparation;
            this.contourSeparation = contourSeparation;
            this.refreshTiles();
            this.firePropertyChange("contourSeparation", oldContourSeparation, contourSeparation);
        }
    }

    public boolean isDrawContours() {
        return this.drawContours;
    }

    public void setDrawContours(boolean drawContours) {
        if (drawContours != this.drawContours) {
            this.drawContours = drawContours;
            this.refreshTiles();
            this.firePropertyChange("drawContours", !drawContours, drawContours);
        }
    }

    public ColourRamp getColourRamp() {
        return this.colourRamp;
    }

    public boolean setColourRamp(ColourRamp colourRamp) {
        if (!Objects.equals(colourRamp, this.colourRamp)) {
            ColourRamp oldColourRamp = this.colourRamp;
            this.colourRamp = colourRamp;
            if (this.hiddenLayers != null && this.hiddenLayers.contains(TileRenderer.TERRAIN_AS_LAYER)) {
                this.refreshTiles();
            }
            this.firePropertyChange("colourRamp", oldColourRamp, colourRamp);
        }
        return this.hiddenLayers != null && this.hiddenLayers.contains(TileRenderer.TERRAIN_AS_LAYER);
    }

    public void refreshBrush() {
        Point mousePos = this.getMousePosition();
        if (mousePos != null) {
            this.mouseMoved(new MouseEvent((Component)((Object)this), 503, System.currentTimeMillis(), 0, mousePos.x, mousePos.y, 0, false));
        }
    }

    public void setHiddenLayers(Set<Layer> hiddenLayers) {
        Sets.SetView difference;
        HashSet<Layer> oldHiddenLayers = new HashSet<Layer>(this.hiddenLayers);
        this.hiddenLayers.clear();
        if (hiddenLayers != null) {
            this.hiddenLayers.addAll(hiddenLayers);
        }
        if (!(difference = Sets.symmetricDifference(oldHiddenLayers, this.hiddenLayers)).isEmpty()) {
            if (this.dimension != null) {
                this.tileProvider.setHiddenLayers(this.hiddenLayers);
                if (difference.contains(TileRenderer.TERRAIN_AS_LAYER) || difference.contains(TileRenderer.FLUIDS_AS_LAYER)) {
                    this.refreshTiles();
                } else if (!difference.isEmpty()) {
                    this.refreshTilesForLayers((Set<Layer>)difference, true);
                }
            }
            this.firePropertyChange("hiddenLayers", oldHiddenLayers, hiddenLayers);
        }
    }

    public Set<Layer> getHiddenLayers() {
        return Collections.unmodifiableSet(this.hiddenLayers);
    }

    public void refreshTiles() {
        if (this.dimension != null) {
            World2 world;
            int biomeAlgorithm = -1;
            long minecraftSeed = -1L;
            Dimension.Anchor anchor = this.dimension.getAnchor();
            if (this.drawBiomes && anchor.equals((Object)Dimension.Anchor.NORMAL_DETAIL) && (this.dimension.getBorder() == null || !this.dimension.getBorder().isEndless()) && (world = this.dimension.getWorld()) != null) {
                Platform platform = world.getPlatform();
                if (platform == DefaultPlugin.JAVA_MCREGION) {
                    biomeAlgorithm = 4;
                    minecraftSeed = this.dimension.getMinecraftSeed();
                } else if (platform == DefaultPlugin.JAVA_ANVIL) {
                    minecraftSeed = this.dimension.getMinecraftSeed();
                    MapGenerator generator = this.dimension.getGenerator();
                    if (generator.getType() == Generator.DEFAULT) {
                        biomeAlgorithm = 9;
                    } else if (generator.getType() == Generator.LARGE_BIOMES) {
                        biomeAlgorithm = 10;
                    }
                }
            }
            if (biomeAlgorithm != -1) {
                BiomesTileProvider biomesTileProvider = new BiomesTileProvider(biomeAlgorithm, minecraftSeed, this.colourScheme, 0, true);
                this.setTileProvider(-3, biomesTileProvider);
            } else {
                this.removeTileProvider(-3);
            }
            this.tileProvider = new WPTileProvider((TileProvider)this.dimension, this.colourScheme, this.customBiomeManager, this.hiddenLayers, this.drawContours, this.contourSeparation, this.lightOrigin, true, null, this.backgroundDimension == null, this.colourRamp);
            this.setTileProvider(0, (org.pepsoft.util.swing.TileProvider)this.tileProvider);
            if (this.backgroundDimension != null) {
                this.backgroundTileProvider = new WPTileProvider((TileProvider)this.backgroundDimension, this.colourScheme, this.customBiomeManager, this.hiddenLayers, false, this.contourSeparation, this.lightOrigin, false, WPTileProvider.Effect.FADE_TO_FIFTY_PERCENT, true, this.colourRamp);
                this.setTileProvider(-1, (org.pepsoft.util.swing.TileProvider)this.backgroundTileProvider);
                this.setTileProviderZoom((org.pepsoft.util.swing.TileProvider)this.backgroundTileProvider, this.backgroundDimensionZoom);
            } else {
                this.removeTileProvider(-1);
            }
            if (this.drawBorders && this.dimension.getBorder() != null) {
                this.setTileProvider(-2, (org.pepsoft.util.swing.TileProvider)new WPBorderTileProvider(this.dimension, this.colourScheme));
            } else {
                this.removeTileProvider(-2);
            }
        } else {
            if (this.getTileProviderCount() > 0) {
                this.removeAllTileProviders();
            }
            this.tileProvider = null;
        }
    }

    public void refreshTilesForLayer(Layer layer, boolean evenIfHidden) {
        this.refreshTilesForLayers(Collections.singleton(layer), evenIfHidden);
    }

    public void refreshTilesForLayers(Set<Layer> layers, boolean evenIfHidden) {
        if (this.hiddenLayers.containsAll(layers) && !evenIfHidden || this.dimension == null) {
            return;
        }
        long start = System.currentTimeMillis();
        HashSet<Point> coords = new HashSet<Point>();
        if (this.getZoom() < 0) {
            int shift = -this.getZoom();
            block0: for (Tile tile : this.dimension.getTiles()) {
                for (Layer layer : layers) {
                    if (!tile.hasLayer(layer)) continue;
                    coords.add(new Point(tile.getX() >> shift, tile.getY() >> shift));
                    continue block0;
                }
            }
        } else {
            block2: for (Tile tile : this.dimension.getTiles()) {
                for (Layer layer : layers) {
                    if (!tile.hasLayer(layer)) continue;
                    coords.add(new Point(tile.getX(), tile.getY()));
                    continue block2;
                }
            }
        }
        if (!coords.isEmpty()) {
            this.refresh((org.pepsoft.util.swing.TileProvider)this.tileProvider, coords);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Refreshing {} tiles for layers {} took {} ms", new Object[]{coords.size(), layers, System.currentTimeMillis() - start});
        }
    }

    public void updateStatusBar(int x, int y) {
        App.getInstance().updateStatusBar(x, y);
    }

    public BufferedImage getImage() {
        if (this.dimension == null) {
            return null;
        }
        TileRenderer tileRenderer = new TileRenderer((TileProvider)this.dimension, this.colourScheme, this.customBiomeManager, 0, true, this.colourRamp);
        tileRenderer.setContourLines(this.drawContours);
        tileRenderer.setContourSeparation(this.contourSeparation);
        tileRenderer.setHiddenLayers(this.hiddenLayers);
        tileRenderer.setLightOrigin(this.lightOrigin);
        int xOffset = this.dimension.getLowestX();
        int yOffset = this.dimension.getLowestY();
        BufferedImage image = new BufferedImage(this.dimension.getWidth() << 7, this.dimension.getHeight() << 7, 2);
        for (Tile tile : this.dimension.getTiles()) {
            tileRenderer.renderTile(tile, (Image)image, tile.getX() - xOffset << 7, tile.getY() - yOffset << 7);
        }
        return image;
    }

    public void rotateLightLeft() {
        this.lightOrigin = this.lightOrigin.left();
        this.refreshTiles();
    }

    public void rotateLightRight() {
        this.lightOrigin = this.lightOrigin.right();
        this.refreshTiles();
    }

    public TileRenderer.LightOrigin getLightOrigin() {
        return this.lightOrigin;
    }

    public void setLightOrigin(TileRenderer.LightOrigin lightOrigin) {
        if (lightOrigin == null) {
            throw new NullPointerException();
        }
        if (lightOrigin != this.lightOrigin) {
            this.lightOrigin = lightOrigin;
            this.refreshTiles();
        }
    }

    public void moveToSpawn() {
        if (this.dimension != null && this.dimension.getAnchor().dim == 0) {
            this.moveToMarker();
        }
    }

    public Point getViewCentreInWorldCoords() {
        return new Point(this.getViewX(), this.getViewY());
    }

    public int getBrushRotation() {
        return this.brushRotation;
    }

    public void setBrushRotation(int brushRotation) {
        int oldBrushRotation = this.brushRotation;
        int oldEffectiveRadius = this.effectiveRadius;
        this.brushRotation = brushRotation;
        if (this.brushShape == BrushShape.CIRCLE || brushRotation % 90 == 0) {
            this.effectiveRadius = this.radius;
        } else {
            double a = (double)brushRotation / 180.0 * Math.PI;
            this.effectiveRadius = (int)Math.ceil(Math.abs(Math.sin(a)) * (double)this.radius + Math.abs(Math.cos(a)) * (double)this.radius);
        }
        this.firePropertyChange("brushRotation", oldBrushRotation, brushRotation);
        if (this.drawBrush && this.brushShape != BrushShape.CIRCLE) {
            int largestRadius = Math.max(oldEffectiveRadius, this.effectiveRadius);
            int diameter = largestRadius * 2 + 1;
            this.repaintWorld(this.mouseX - largestRadius, this.mouseY - largestRadius, diameter, diameter);
        }
    }

    public void minecraftSeedChanged(Dimension dimension, long newSeed) {
        if (!this.isInhibitUpdates() && !this.hiddenLayers.contains(Biome.INSTANCE)) {
            this.refreshTiles();
        }
    }

    public boolean isDrawMinecraftBorder() {
        return this.drawMinecraftBorder;
    }

    public void setDrawMinecraftBorder(boolean drawMinecraftBorder) {
        if (drawMinecraftBorder != this.drawMinecraftBorder) {
            this.drawMinecraftBorder = drawMinecraftBorder;
            this.firePropertyChange("drawMinecraftBorder", !drawMinecraftBorder, drawMinecraftBorder);
            this.repaint();
        }
    }

    public boolean isDrawBorders() {
        return this.drawBorders;
    }

    public void setDrawBorders(boolean drawBorders) {
        if (drawBorders != this.drawBorders) {
            this.drawBorders = drawBorders;
            this.firePropertyChange("drawBorders", !drawBorders, drawBorders);
            this.refreshTiles();
        }
    }

    public boolean isDrawBiomes() {
        return this.drawBiomes;
    }

    public void setDrawBiomes(boolean drawBiomes) {
        if (drawBiomes != this.drawBiomes) {
            this.drawBiomes = drawBiomes;
            if (this.dimension != null && this.dimension.getAnchor().dim == 0) {
                this.refreshTiles();
            }
            this.firePropertyChange("drawBiomes", !drawBiomes, drawBiomes);
        }
    }

    public Point getMousePosition() throws HeadlessException {
        Point translation = new Point(0, 0);
        for (Object component = this; component != null; component = ((Component)component).getParent()) {
            Point mousePosition;
            Point point = mousePosition = component == this ? super.getMousePosition() : ((Component)component).getMousePosition();
            if (mousePosition != null) {
                mousePosition.translate(-translation.x, -translation.y);
                return mousePosition;
            }
            translation.translate(((Component)component).getX(), ((Component)component).getY());
        }
        return null;
    }

    public Dimension getBackgroundDimension() {
        return this.backgroundDimension;
    }

    public void setBackgroundDimension(Dimension backgroundDimension, int zoomLevel, WPTileProvider.Effect effect) {
        this.backgroundDimension = backgroundDimension;
        this.backgroundDimensionZoom = zoomLevel;
        this.refreshTiles();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int oldMouseX = this.mouseX;
        int oldMouseY = this.mouseY;
        Point mouseInWorld = this.viewToWorld(e.getPoint());
        this.mouseX = mouseInWorld.x;
        this.mouseY = mouseInWorld.y;
        if (this.mouseX == oldMouseX && this.mouseY == oldMouseY) {
            return;
        }
        Rectangle repaintArea = null;
        if (this.drawBrush) {
            repaintArea = this.brushShape != BrushShape.CUSTOM ? new Rectangle(-this.effectiveRadius, -this.effectiveRadius, this.effectiveRadius * 2 + 1, this.effectiveRadius * 2 + 1) : this.customBrushShape.getBounds();
        }
        if (this.dimension != null) {
            int scaledRadius;
            if (this.drawViewDistance) {
                scaledRadius = (int)Math.ceil((float)this.viewDistance / this.dimension.getScale());
                Rectangle viewDistanceArea = new Rectangle(-scaledRadius, -scaledRadius, scaledRadius * 2, scaledRadius * 2);
                repaintArea = repaintArea != null ? repaintArea.union(viewDistanceArea) : viewDistanceArea;
            }
            if (this.drawWalkingDistance) {
                scaledRadius = (int)Math.ceil((float)this.viewDistance / this.dimension.getScale());
                Rectangle walkingDistanceArea = new Rectangle(-scaledRadius, -scaledRadius, scaledRadius * 2, scaledRadius * 2);
                repaintArea = repaintArea != null ? repaintArea.union(walkingDistanceArea) : walkingDistanceArea;
            }
        }
        if (repaintArea != null) {
            Rectangle oldRectangle = new Rectangle(oldMouseX + repaintArea.x, oldMouseY + repaintArea.y, repaintArea.width, repaintArea.height);
            Rectangle newRectangle = new Rectangle(this.mouseX + repaintArea.x, this.mouseY + repaintArea.y, repaintArea.width, repaintArea.height);
            if (oldRectangle.intersects(newRectangle)) {
                this.repaintWorld(oldRectangle.union(newRectangle));
            } else {
                this.repaintWorld(oldRectangle);
                SwingUtilities.invokeLater(() -> this.repaintWorld(newRectangle));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseDragged(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.dimension.getWorld() && evt.getPropertyName().equals("spawnPoint")) {
            this.setMarkerCoords((Point)evt.getNewValue());
        } else if (evt.getSource() == this.dimension) {
            if ("overlaysEnabled".equals(evt.getPropertyName())) {
                this.drawOverlays = (Boolean)evt.getNewValue();
                this.repaint();
            }
        } else if (evt.getSource() instanceof Overlay && !evt.getPropertyName().equals("image")) {
            if (evt.getPropertyName().equals("scale") && Configuration.getInstance().getOverlayType() == Configuration.OverlayType.SCALE_ON_LOAD) {
                ((Overlay)evt.getSource()).setImage(null);
                if (this.drawOverlays) {
                    this.scheduleRepaint(250);
                }
            } else if (this.drawOverlays) {
                this.repaint();
            }
        }
    }

    public void tilesAdded(Dimension dimension, Set<Tile> tiles) {
    }

    public void tilesRemoved(Dimension dimension, Set<Tile> tiles) {
    }

    public void overlayAdded(Dimension dimension, int index, Overlay overlay) {
        overlay.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.drawOverlays) {
            this.repaint();
        }
    }

    public void overlayRemoved(Dimension dimension, int index, Overlay overlay) {
        overlay.removePropertyChangeListener((PropertyChangeListener)this);
        if (this.drawOverlays) {
            this.repaint();
        }
    }

    long getOverlayImageSize() {
        long total = 0L;
        if (this.dimension != null) {
            for (Overlay overlay : this.dimension.getOverlays()) {
                total += overlay.getImage() != null ? MemoryUtils.getSize((Object)overlay.getImage(), Collections.emptySet()) : 0L;
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.dimension != null) {
            Graphics2D g2 = (Graphics2D)g;
            Color savedColour = g2.getColor();
            Object savedAAValue = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            Stroke savedStroke = g2.getStroke();
            AffineTransform savedTransform = g2.getTransform();
            Font savedFont = g2.getFont();
            try {
                if (this.drawMinecraftBorder && this.dimension.getWorld() != null) {
                    this.drawMinecraftBorderIfNecessary(g2, this.dimension.getWorld().getBorderSettings());
                }
                float scale = this.transformGraphics(g2);
                if (this.drawOverlays) {
                    this.drawOverlays(g2);
                }
                if (this.drawBrush || this.drawViewDistance || this.drawWalkingDistance) {
                    g2.setColor(Color.BLACK);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    this.drawBrushEtc(g2, scale, false);
                    g2.setColor(Color.WHITE);
                    this.drawBrushEtc(g2, scale, true);
                }
            }
            finally {
                g2.setColor(savedColour);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedAAValue);
                g2.setStroke(savedStroke);
                g2.setTransform(savedTransform);
                g2.setFont(savedFont);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawBrushEtc(Graphics2D g2, float scale, boolean dashed) {
        int scaledRadius;
        float onePixel = 1.0f / scale;
        if (!dashed) {
            g2.setStroke(new BasicStroke(onePixel));
        }
        if (this.drawBrush) {
            if (dashed) {
                g2.setStroke(new BasicStroke(onePixel, 2, 0, 10.0f, new float[]{4.0f * onePixel, 6.0f * onePixel}, 0.0f));
            }
            int diameter = this.radius * 2 + 1;
            switch (this.brushShape) {
                case CIRCLE: {
                    g2.drawOval(this.mouseX - this.radius, this.mouseY - this.radius, diameter, diameter);
                    break;
                }
                case SQUARE: {
                    if (this.brushRotation % 90 == 0) {
                        g2.drawRect(this.mouseX - this.radius, this.mouseY - this.radius, diameter, diameter);
                        break;
                    }
                    AffineTransform existingTransform = g2.getTransform();
                    try {
                        if (scale > 1.0f) {
                            g2.rotate((double)this.brushRotation / 180.0 * Math.PI, (double)this.mouseX + 0.5, (double)this.mouseY + 0.5);
                        } else {
                            g2.rotate((double)this.brushRotation / 180.0 * Math.PI, this.mouseX, this.mouseY);
                        }
                        g2.drawRect(this.mouseX - this.radius, this.mouseY - this.radius, diameter, diameter);
                        break;
                    }
                    finally {
                        g2.setTransform(existingTransform);
                    }
                }
                case BITMAP: {
                    int arrowSize = this.radius / 2;
                    if (this.brushRotation == 0) {
                        g2.drawRect(this.mouseX - this.radius, this.mouseY - this.radius, diameter, diameter);
                        if (arrowSize <= 0) break;
                        g2.drawLine(this.mouseX, this.mouseY - this.radius, this.mouseX - arrowSize, this.mouseY - this.radius + arrowSize);
                        g2.drawLine(this.mouseX - arrowSize, this.mouseY - this.radius + arrowSize, this.mouseX + arrowSize + 1, this.mouseY - this.radius + arrowSize);
                        g2.drawLine(this.mouseX + arrowSize + 1, this.mouseY - this.radius + arrowSize, this.mouseX + 1, this.mouseY - this.radius);
                        break;
                    }
                    AffineTransform existingTransform = g2.getTransform();
                    try {
                        if (scale > 1.0f) {
                            g2.rotate((double)this.brushRotation / 180.0 * Math.PI, (double)this.mouseX + 0.5, (double)this.mouseY + 0.5);
                        } else {
                            g2.rotate((double)this.brushRotation / 180.0 * Math.PI, this.mouseX, this.mouseY);
                        }
                        g2.drawRect(this.mouseX - this.radius, this.mouseY - this.radius, diameter, diameter);
                        if (arrowSize <= 0) break;
                        g2.drawLine(this.mouseX, this.mouseY - this.radius, this.mouseX - arrowSize, this.mouseY - this.radius + arrowSize);
                        g2.drawLine(this.mouseX - arrowSize, this.mouseY - this.radius + arrowSize, this.mouseX + arrowSize + 1, this.mouseY - this.radius + arrowSize);
                        g2.drawLine(this.mouseX + arrowSize + 1, this.mouseY - this.radius + arrowSize, this.mouseX + 1, this.mouseY - this.radius);
                        break;
                    }
                    finally {
                        g2.setTransform(existingTransform);
                    }
                }
                case CUSTOM: {
                    AffineTransform existingTransform = g2.getTransform();
                    try {
                        g2.translate(this.mouseX, this.mouseY);
                        g2.draw(this.customBrushShape);
                        break;
                    }
                    finally {
                        g2.setTransform(existingTransform);
                    }
                }
            }
        }
        if (this.drawViewDistance) {
            if (dashed) {
                g2.setStroke(new BasicStroke(onePixel, 2, 0, 10.0f, new float[]{9.0f * onePixel, 11.0f * onePixel}, 0.0f));
            }
            scaledRadius = (int)Math.ceil((float)this.viewDistance / this.dimension.getScale());
            g2.drawOval(this.mouseX - scaledRadius, this.mouseY - scaledRadius, scaledRadius * 2, scaledRadius * 2);
        }
        if (this.drawWalkingDistance) {
            if (dashed) {
                g2.setStroke(new BasicStroke(onePixel, 2, 0, 10.0f, new float[]{19.0f * onePixel, 21.0f * onePixel}, 0.0f));
            }
            scaledRadius = (int)Math.ceil(5120.0f / this.dimension.getScale());
            g2.drawOval(this.mouseX - scaledRadius, this.mouseY - scaledRadius, scaledRadius * 2, scaledRadius * 2);
            this.setFont(NORMAL_FONT.deriveFont(10.0f * onePixel));
            g2.drawString("day + night", (float)(this.mouseX - scaledRadius) + onePixel * 3.0f, (float)this.mouseY);
            scaledRadius = (int)Math.ceil(3328.0f / this.dimension.getScale());
            g2.drawOval(this.mouseX - scaledRadius, this.mouseY - scaledRadius, scaledRadius * 2, scaledRadius * 2);
            g2.drawString("1 day", (float)(this.mouseX - scaledRadius) + onePixel * 3.0f, (float)this.mouseY);
            scaledRadius = (int)Math.ceil(1280.0f / this.dimension.getScale());
            g2.drawOval(this.mouseX - scaledRadius, this.mouseY - scaledRadius, scaledRadius * 2, scaledRadius * 2);
            g2.drawString("5 min.", (float)(this.mouseX - scaledRadius) + onePixel * 3.0f, (float)this.mouseY);
        }
    }

    private Rectangle getBrushBounds() {
        if (this.brushShape == BrushShape.CUSTOM) {
            Rectangle bounds = this.customBrushShape.getBounds();
            bounds.translate(this.mouseX, this.mouseY);
            return bounds;
        }
        return new Rectangle(this.mouseX - this.effectiveRadius, this.mouseY - this.effectiveRadius, this.effectiveRadius * 2 + 1, this.effectiveRadius * 2 + 1);
    }

    private void loadOverlay(Overlay overlay) {
        File file = overlay.getFile();
        if (file != null && file.isFile()) {
            if (file.canRead()) {
                BufferedImage overlayImage;
                logger.info("Loading image");
                try {
                    overlayImage = ImageIO.read(file);
                }
                catch (IOException e) {
                    logger.error("I/O error while loading image " + file, (Throwable)e);
                    AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog((Component)((Object)this), "An error occurred while loading the overlay image.\nIt may not be a valid or supported image file, or the file may be corrupted.", "Error Loading Image", 0));
                    overlay.setEnabled(false);
                    return;
                }
                catch (Error | RuntimeException e) {
                    logger.error(e.getClass().getSimpleName() + " while loading image " + file, e);
                    AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog((Component)((Object)this), "An error occurred while loading the overlay image.\nThere may not be enough available memory, or the image may be too large.", "Error Loading Image", 0));
                    overlay.setEnabled(false);
                    return;
                }
                if (overlayImage != null) {
                    switch (this.overlayType) {
                        case OPTIMISE_ON_LOAD: {
                            overlayImage = this.scaleImage(overlayImage, this.getGraphicsConfiguration(), 1.0f);
                            break;
                        }
                        case SCALE_ON_LOAD: {
                            overlayImage = this.scaleImage(overlayImage, this.getGraphicsConfiguration(), overlay.getScale());
                        }
                    }
                } else {
                    logger.error("Image overlay file " + file + " did not contain a recognisable image");
                    AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog((Component)((Object)this), "Image overlay file did not contain a recognisable image. It may have been corrupted.\n" + file, "Error Loading Image", 0));
                }
                if (overlayImage != null) {
                    overlay.setImage(overlayImage);
                } else {
                    overlay.setEnabled(false);
                }
            } else {
                AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog((Component)((Object)this), "Access denied to overlay image\n" + file, "Error Enabling Overlay", 0));
                overlay.setEnabled(false);
            }
        } else {
            AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog((Component)((Object)this), "Overlay image file not found\n" + file, "Error Enabling Overlay", 0));
            overlay.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage scaleImage(BufferedImage image, GraphicsConfiguration graphicsConfiguration, float scale) {
        try {
            boolean alpha = image.getColorModel().hasAlpha();
            if (scale == 1.0f) {
                logger.info("Optimising image");
                BufferedImage optimumImage = graphicsConfiguration.createCompatibleImage(image.getWidth(), image.getHeight(), alpha ? 3 : 1);
                Graphics2D g2 = optimumImage.createGraphics();
                try {
                    g2.drawImage((Image)image, 0, 0, null);
                }
                finally {
                    g2.dispose();
                }
                return optimumImage;
            }
            logger.info("Scaling image");
            int width = Math.round((float)image.getWidth() * scale);
            int height = Math.round((float)image.getHeight() * scale);
            BufferedImage optimumImage = graphicsConfiguration.createCompatibleImage(width, height, alpha ? 3 : 1);
            Graphics2D g2 = optimumImage.createGraphics();
            try {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2.drawImage(image, 0, 0, width, height, null);
            }
            finally {
                g2.dispose();
            }
            return optimumImage;
        }
        catch (Error | RuntimeException e) {
            logger.error(e.getClass().getSimpleName() + " while scaling image of size " + image.getWidth() + "x" + image.getHeight() + " and type " + image.getType() + " to " + scale + "%", e);
            AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog(null, "An error occurred while " + (scale == 100.0f ? "optimising" : "scaling") + " the overlay image.\nThere may not be enough available memory, or the image may be too large.", "Error " + (scale == 100.0f ? "Optimising" : "Scaling") + " Image", 0));
            return null;
        }
    }

    private void drawMinecraftBorderIfNecessary(Graphics2D g2, World2.BorderSettings borderSettings) {
        int size = borderSettings.getSize();
        int radius = size / 2;
        Rectangle border = this.worldToView(borderSettings.getCentreX() - radius, borderSettings.getCentreY() - radius, size, size);
        Rectangle clip = g2.getClipBounds();
        if (border.x >= clip.x || border.y >= clip.y || border.x + border.width < clip.x + clip.width || border.y + border.height < clip.y + clip.height) {
            g2.setColor(Color.RED);
            g2.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f));
            if (border.width < 5000 && border.height < 5000) {
                g2.drawRect(border.x, border.y, border.width, border.height);
            } else if (clip.intersects(border)) {
                g2.drawLine(border.x, Math.max(border.y, clip.y), border.x, Math.min(border.y + border.height, clip.y + clip.height));
                g2.drawLine(Math.max(border.x, clip.x), border.y + border.height, Math.min(border.x + border.width, clip.x + clip.width), border.y + border.height);
                g2.drawLine(border.x + border.width, Math.min(border.y + border.height, clip.y + clip.height), border.x + border.width, Math.max(border.y, clip.y));
                g2.drawLine(Math.min(border.x + border.width, clip.x + clip.width), border.y, Math.max(border.x, clip.x), border.y);
            }
        }
    }

    private void repaintWorld(int x, int y, int width, int height) {
        Rectangle area = this.worldToView(x, y, width, height);
        this.repaint(area.x - 2, area.y - 2, area.width + 4, area.height + 4);
    }

    private void repaintWorld(Rectangle area) {
        area = this.worldToView(area);
        this.repaint(area.x - 2, area.y - 2, area.width + 4, area.height + 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawOverlays(Graphics2D g2) {
        if (this.dimension.getOverlays().isEmpty()) {
            return;
        }
        Composite savedComposite = g2.getComposite();
        try {
            for (Overlay overlay : this.dimension.getOverlays()) {
                BufferedImage overlayImage;
                float overlayTransparency = overlay.getTransparency();
                if (!overlay.isEnabled() || overlay.getTransparency() == 1.0f) continue;
                if (overlay.getImage() == null) {
                    this.loadOverlay(overlay);
                }
                if ((overlayImage = overlay.getImage()) == null) continue;
                if (overlayTransparency > 0.0f) {
                    g2.setComposite(AlphaComposite.getInstance(3, 1.0f - overlayTransparency));
                }
                float overlayScale = overlay.getScale();
                int overlayOffsetX = overlay.getOffsetX();
                int overlayOffsetY = overlay.getOffsetY();
                if (this.overlayType == Configuration.OverlayType.SCALE_ON_LOAD || overlayScale == 1.0f) {
                    g2.drawImage((Image)overlayImage, overlayOffsetX, overlayOffsetY, null);
                    continue;
                }
                int width = Math.round((float)overlayImage.getWidth() * overlayScale);
                int height = Math.round((float)overlayImage.getHeight() * overlayScale);
                Object savedInterpolation = g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                try {
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2.drawImage(overlayImage, overlayOffsetX, overlayOffsetY, width, height, null);
                }
                finally {
                    if (savedInterpolation == null) continue;
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, savedInterpolation);
                }
            }
        }
        finally {
            g2.setComposite(savedComposite);
        }
    }

    private void scheduleRepaint(int delay) {
        AwtUtils.doOnEventThread(() -> {
            if (this.repaintTimer != null) {
                this.repaintTimer.stop();
            }
            this.repaintTimer = new Timer(delay, event -> {
                this.repaint();
                this.repaintTimer = null;
            });
            this.repaintTimer.setRepeats(false);
            this.repaintTimer.start();
        });
    }
}

