/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Platform;

public class MaterialTableCellRenderer
extends DefaultTableCellRenderer {
    private final boolean nameBased;

    public MaterialTableCellRenderer(Platform platform) {
        this.nameBased = platform.capabilities.contains(Platform.Capability.NAME_BASED);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Material) {
            if (!isSelected) {
                this.setForeground(Color.BLUE);
            }
            if (this.nameBased) {
                this.setText("<html><u>" + value + "</u></html>");
            } else {
                this.setText("<html><u>" + ((Material)value).toLegacyString() + "</u></html>");
            }
        }
        return this;
    }
}

