/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.mapexplorer;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pepsoft.minecraft.mapexplorer.FileSystemNode;
import org.pepsoft.minecraft.mapexplorer.RootNode;
import org.pepsoft.worldpainter.mapexplorer.AbstractNode;
import org.pepsoft.worldpainter.mapexplorer.Node;

public class MapTreeModel
implements TreeModel {
    private final RootNode rootNode = new RootNode();
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

    public TreePath getPath(File dir) {
        LinkedList<File> components = new LinkedList<File>();
        while (dir != null) {
            components.add(0, dir);
            dir = dir.getParentFile();
        }
        Object[] path = new Object[components.size() + 1];
        path[0] = this.rootNode;
        RootNode node = this.rootNode;
        int index = 1;
        block1: for (File component : components) {
            String componentName = FileSystemNode.getName((File)component);
            for (Node childNode : node.getChildren()) {
                if (!childNode.getName().equals(componentName)) continue;
                path[index++] = childNode;
                node = childNode;
                continue block1;
            }
        }
        return new TreePath(path);
    }

    public void refresh(TreePath path) {
        TreeModelEvent event = new TreeModelEvent((Object)this, path);
        this.listeners.forEach(listener -> listener.treeStructureChanged(event));
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((AbstractNode)parent).getChildren()[index];
    }

    @Override
    public int getChildCount(Object parent) {
        return ((AbstractNode)parent).getChildren().length;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((AbstractNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        Node[] children = ((Node)parent).getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }
}

