/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.install4j.api.launcher.ApplicationLauncher;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.Main;
import org.pepsoft.worldpainter.PrivateContext;
import org.pepsoft.worldpainter.browser.WPTrustManager;
import org.pepsoft.worldpainter.vo.UsageVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateContextImpl
implements PrivateContext {
    private static final Logger logger = LoggerFactory.getLogger(PrivateContextImpl.class);

    public void checkForUpdates() {
        if (!"true".equals(System.getProperty("org.pepsoft.worldpainter.devMode")) && Configuration.getInstance().isCheckForUpdates() && !"true".equals(System.getProperty("org.pepsoft.worldpainter.disableUpdateCheck"))) {
            logger.info("Checking for updates");
            ApplicationLauncher.launchApplicationInProcess((String)"217", null, (ApplicationLauncher.Callback)new ApplicationLauncher.Callback(){

                public void exited(int exitValue) {
                }

                public void prepareShutdown() {
                }
            }, (ApplicationLauncher.WindowMode)ApplicationLauncher.WindowMode.FRAME, null);
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ExceptionHandler());
        } else {
            logger.info("Update check disabled in preferences or by system property");
        }
    }

    public void submitUsageData(final UsageVO usageData, boolean blocking) {
        block36: {
            if (blocking) {
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate trustedCert = (X509Certificate)certificateFactory.generateCertificate(Main.class.getResourceAsStream("/wproot.pem"));
                    WPTrustManager trustManager = new WPTrustManager(trustedCert);
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
                    URL url = new URL("https://bo.worldpainter.net:1443/ping");
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    if (connection instanceof HttpsURLConnection) {
                        ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
                    }
                    connection.setDoOutput(true);
                    connection.setRequestMethod("POST");
                    connection.setAllowUserInteraction(false);
                    connection.setRequestProperty("Content-Type", "application/octet-stream");
                    try (ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(connection.getOutputStream()));){
                        out.writeObject(usageData);
                    }
                    if (connection.getResponseCode() != 200) {
                        throw new MDCCapturingRuntimeException("Server returned response code " + connection.getResponseCode() + " (message: " + connection.getResponseMessage() + ") when trying to submit usage data");
                    }
                    var10_15 = null;
                    try (InputStreamReader in = new InputStreamReader(connection.getInputStream(), StandardCharsets.US_ASCII);){
                        char[] buffer = new char[2];
                        for (int bytesToRead = buffer.length; bytesToRead > 0; bytesToRead -= in.read(buffer, buffer.length - bytesToRead, bytesToRead)) {
                        }
                        if (buffer[0] != 'O' || buffer[1] != 'K') {
                            throw new MDCCapturingRuntimeException("Server returned response other than \"OK\" when trying to submit usage data");
                        }
                        Configuration.getInstance().removeEvents((Collection)usageData.getEvents());
                        logger.info("Submitted usage data to WorldPainter HQ");
                        break block36;
                    }
                    catch (Throwable throwable) {
                        var10_15 = throwable;
                        throw throwable;
                    }
                }
                catch (MalformedURLException e) {
                    throw new MDCCapturingRuntimeException("Malformed URL while trying to submit usage data", (Throwable)e);
                }
                catch (IOException e) {
                    throw new MDCCapturingRuntimeException("I/O error while trying to submit usage data", (Throwable)e);
                }
                catch (CertificateException e) {
                    throw new MDCCapturingRuntimeException("Certificate exception while loading trusted root certificate", (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new MDCCapturingRuntimeException("No such algorithm exception while loading trusted root certificate", (Throwable)e);
                }
                catch (KeyManagementException e) {
                    throw new MDCCapturingRuntimeException("Key management exception while loading trusted root certificate", (Throwable)e);
                }
            }
            new Thread("Pinger"){

                @Override
                public void run() {
                    try {
                        PrivateContextImpl.this.submitUsageData(usageData, true);
                    }
                    catch (RuntimeException e) {
                        logger.error("{} while trying to submit usage data (message: {})", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
                    }
                }
            }.start();
        }
    }
}

