/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.web;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.dynmap.DynmapCore;
import org.dynmap.Log;

public class BanIPFilter
implements Filter {
    private DynmapCore core;
    private Set<String> banned_ips = null;
    private HashSet<String> banned_ips_notified = new HashSet();
    private long last_loaded = 0L;
    private static final long BANNED_RELOAD_INTERVAL = 15000L;

    public BanIPFilter(DynmapCore core) {
        this.core = core;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse resp = (HttpServletResponse)response;
        String ipaddr = request.getRemoteAddr();
        if (this.isIpBanned(ipaddr)) {
            Log.info("Rejected connection by banned IP address - " + ipaddr);
            resp.sendError(403);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void loadBannedIPs() {
        this.banned_ips_notified.clear();
        this.banned_ips = this.core.getIPBans();
    }

    public boolean isIpBanned(String ipaddr) {
        long t = System.currentTimeMillis();
        if (t < this.last_loaded || t - this.last_loaded > 15000L) {
            this.loadBannedIPs();
            this.last_loaded = t;
        }
        if (this.banned_ips.contains(ipaddr)) {
            if (!this.banned_ips_notified.contains(ipaddr)) {
                this.banned_ips_notified.add(ipaddr);
            }
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

