/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.servlet;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;

public class FileResourceHandler
extends ResourceHandler {
    private static String getNormalizedPath(String p) {
        int i;
        p = p.replace('\\', '/');
        String[] tok = p.split("/");
        int j = 0;
        for (i = 0; i < tok.length; ++i) {
            if (tok[i] == null || tok[i].length() == 0 || tok[i].equals(".")) {
                tok[i] = null;
                continue;
            }
            if (tok[i].equals("..")) {
                if (j > 0) {
                    tok[--j] = null;
                }
                tok[i] = null;
                continue;
            }
            tok[j] = tok[i];
            ++j;
        }
        String path = "";
        for (i = 0; i < j; ++i) {
            if (tok[i] == null) continue;
            path = path + "/" + tok[i];
        }
        if (path.length() == 0) {
            path = "/";
        }
        return path;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String normalizedTarget = FileResourceHandler.getNormalizedPath(target);
        Resource resource = this.getResource(normalizedTarget);
        if (resource == null) {
            return;
        }
        File file = resource.getFile();
        if (file == null) {
            return;
        }
        if (!target.equals(normalizedTarget)) {
            baseRequest.setURIPathQuery(normalizedTarget);
            baseRequest.setPathInfo(normalizedTarget);
            try {
                Class<?> requestClass = request.getClass();
                Field field = requestClass.getDeclaredField("_pathInfo");
                field.setAccessible(true);
                field.set(request, normalizedTarget);
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
                return;
            }
        }
        super.handle(normalizedTarget, baseRequest, request, response);
    }
}

