/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.util.ArrayList;
import org.dynmap.modsupport.CustomTextureFile;
import org.dynmap.modsupport.TextureFileType;
import org.dynmap.modsupport.impl.TextureFileImpl;

public class CustomTextureFileImpl
extends TextureFileImpl
implements CustomTextureFile {
    private ArrayList<CustomPatch> patches = new ArrayList();

    public CustomTextureFileImpl(String id, String filename, int xcount, int ycount) {
        super(id, filename, TextureFileType.GRID, xcount, ycount);
    }

    private void padList(int patchID) {
        while (this.patches.size() <= patchID) {
            this.patches.add(new CustomPatch());
        }
    }

    public boolean setCustomPatch(int patchID, int xpos, int ypos, int xdim, int ydim, int xdest, int ydest) {
        this.padList(patchID);
        CustomPatch cp = this.patches.get(patchID);
        cp.xpos = xpos;
        cp.ypos = ypos;
        cp.xdim = xdim;
        cp.ydim = ydim;
        cp.xdest = xdest;
        cp.ydest = ydest;
        return true;
    }

    public boolean setCustomPatch(int patchID, int xpos, int ypos, int xdim, int ydim) {
        return this.setCustomPatch(patchID, xpos, ypos, xdim, ydim, 0, 0);
    }

    @Override
    public String getLine() {
        String s = super.getLine();
        s = s + ",format=CUSTOM";
        for (int i = 0; i < this.patches.size(); ++i) {
            CustomPatch cp = this.patches.get(i);
            if (cp == null) continue;
            s = s + "tile" + i + "=" + cp.xpos + ":" + cp.ypos + "/" + cp.xdim + ":" + cp.ydim;
            if (cp.xdest == 0 && cp.ydest == 0) continue;
            s = s + "/" + cp.xdest + ":" + cp.ydest;
        }
        return s;
    }

    private static class CustomPatch {
        int xpos;
        int ypos;
        int xdim;
        int ydim;
        int xdest;
        int ydest;

        private CustomPatch() {
        }
    }
}

