/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.modsupport.CopyBlockTextureRecord;
import org.dynmap.modsupport.TransparencyMode;

public class CopyBlockTextureRecordImpl
implements CopyBlockTextureRecord {
    private int[] ids = new int[0];
    private String[] names = new String[0];
    private BitSet meta = null;
    private List<Map<String, String>> blockstates = null;
    private final int srcid;
    private final String srcname;
    private final int srcmeta;
    private final Map<String, String> srcstatemap;
    private TransparencyMode mode = null;

    private int isNumber(String v) {
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return -1;
        }
        return Integer.parseInt(v);
    }

    public CopyBlockTextureRecordImpl(int blkid, int srcid, int srcmeta) {
        this.addBlockID(blkid);
        this.srcid = srcid;
        this.srcname = null;
        this.srcmeta = srcmeta;
        this.srcstatemap = null;
    }

    public CopyBlockTextureRecordImpl(String blkname, String srcname, int srcmeta) {
        this.addBlockName(blkname);
        int id = this.isNumber(srcname);
        if (id < 0) {
            this.srcname = srcname;
            this.srcid = 0;
        } else {
            this.srcname = null;
            this.srcid = id;
        }
        this.srcmeta = srcmeta;
        this.srcstatemap = null;
    }

    public CopyBlockTextureRecordImpl(String blkname, String srcname, Map<String, String> srcstatemap) {
        this.addBlockName(blkname);
        int id = this.isNumber(srcname);
        if (id < 0) {
            this.srcname = srcname;
            this.srcid = 0;
        } else {
            this.srcname = null;
            this.srcid = id;
        }
        this.srcmeta = -1;
        this.srcstatemap = new HashMap<String, String>();
        this.srcstatemap.putAll(srcstatemap);
    }

    public void addBlockID(int blockID) {
        if (blockID > 0) {
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] != blockID) continue;
                return;
            }
            this.ids = Arrays.copyOf(this.ids, this.ids.length + 1);
            this.ids[this.ids.length - 1] = blockID;
        }
    }

    public void addBlockName(String blockname) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(blockname)) continue;
            return;
        }
        this.names = Arrays.copyOf(this.names, this.names.length + 1);
        this.names[this.names.length - 1] = blockname;
    }

    public int[] getBlockIDs() {
        return this.ids;
    }

    public String[] getBlockNames() {
        return this.names;
    }

    @Deprecated
    public void setMetaValue(int data) {
        if (this.meta == null) {
            this.meta = new BitSet();
        }
        this.meta.set(data);
    }

    @Deprecated
    public int getMetaValueMask() {
        if (this.meta == null) {
            return -1;
        }
        return (int)this.meta.toLongArray()[0];
    }

    public void setBlockStateMapping(Map<String, String> statemap) {
        if (this.blockstates == null) {
            this.blockstates = new ArrayList<Map<String, String>>();
        }
        HashMap<String, String> nmap = new HashMap<String, String>();
        nmap.putAll(statemap);
        this.blockstates.add(nmap);
    }

    public List<Map<String, String>> getBlockStateMappings() {
        return this.blockstates;
    }

    public String getLine() {
        int i;
        if (this.ids.length == 0 && this.names.length == 0) {
            return null;
        }
        String s = "copyblock:";
        int idcnt = 0;
        for (i = 0; i < this.ids.length; ++i) {
            s = i == 0 ? s + "id=" + this.ids[i] : s + ",id=" + this.ids[i];
            ++idcnt;
        }
        for (i = 0; i < this.names.length; ++i) {
            if (idcnt > 0) {
                s = s + ",";
            }
            s = s + "id=%" + this.names[i];
            ++idcnt;
        }
        if (this.blockstates != null) {
            for (Map<String, String> rec : this.blockstates) {
                if (rec.size() == 0) continue;
                s = s + ",state=";
                boolean first = true;
                for (Map.Entry<String, String> r : rec.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        s = s + '/';
                    }
                    s = s + r.getKey() + ":" + r.getValue();
                }
            }
        }
        if (this.meta != null) {
            int i2 = this.meta.nextSetBit(0);
            while (i2 != -1) {
                s = s + ",data=" + i2;
                i2 = this.meta.nextSetBit(i2 + 1);
            }
        }
        if (this.meta == null && this.blockstates == null) {
            s = s + ",state=*";
        }
        s = this.srcname != null ? s + ",srcid=%" + this.srcname : s + ",srcid=" + this.srcid;
        if (this.srcstatemap != null) {
            s = s + ",srcstate=";
            boolean first = true;
            for (Map.Entry<String, String> r : this.srcstatemap.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    s = s + '/';
                }
                s = s + r.getKey() + ":" + r.getValue();
            }
        } else {
            s = s + ",srcmeta=" + this.srcmeta;
        }
        switch (this.mode) {
            case TRANSPARENT: {
                s = s + ",transparency=TRANSPARENT";
                break;
            }
            case SEMITRANSPARENT: {
                s = s + ",transparency=SEMITRANSPARENT";
                break;
            }
        }
        return s;
    }

    @Deprecated
    public int getSourceBlockID() {
        return this.srcid;
    }

    @Deprecated
    public int getSourceMeta() {
        return this.srcmeta;
    }

    public Map<String, String> getSourceBlockStateMapping() {
        return this.srcstatemap;
    }

    public void setTransparencyMode(TransparencyMode mode) {
        this.mode = mode;
    }

    public TransparencyMode getTransparencyMode() {
        return this.mode;
    }

    public String getSourceBlockName() {
        return this.srcname;
    }
}

