/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class VineStateRenderer
extends CustomRenderer {
    protected RenderPatch[][] meshes = new RenderPatch[32][];

    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        this.buildPatches(rpf);
        return true;
    }

    private void buildPatches(RenderPatchFactory rpf) {
        RenderPatch Top = rpf.getPatch(0.0, 0.95, 0.0, 1.0, 0.95, 0.0, 0.0, 0.95, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch West = rpf.getPatch(0.05, 0.0, 0.0, 0.05, 0.0, 1.0, 0.05, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch East = rpf.getPatch(0.95, 0.0, 0.0, 0.95, 0.0, 1.0, 0.95, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch North = rpf.getPatch(0.0, 0.0, 0.05, 1.0, 0.0, 0.05, 0.0, 1.0, 0.05, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch South = rpf.getPatch(0.0, 0.0, 0.95, 1.0, 0.0, 0.95, 0.0, 1.0, 0.95, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int i = 0; i < 32; ++i) {
            list.clear();
            if ((i & 0x10) == 0) {
                list.add(East);
            }
            if ((i & 8) == 0) {
                list.add(North);
            }
            if ((i & 4) == 0) {
                list.add(South);
            }
            if ((i & 2) == 0) {
                list.add(Top);
            }
            if ((i & 1) == 0) {
                list.add(West);
            }
            this.meshes[i] = list.toArray(new RenderPatch[list.size()]);
        }
    }

    public int getMaximumTextureCount() {
        return 2;
    }

    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        return this.meshes[ctx.getBlockType().stateIndex];
    }

    public boolean isOnlyBlockStateSensitive() {
        return true;
    }
}

