/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.BitSet;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class PlantRenderer
extends CustomRenderer {
    private RenderPatch[][] meshes;
    private boolean metaFromBelow = false;
    private int metaCnt = 16;

    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        String maxmeta;
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        String idxsrc = custparm.get("metasrc");
        if (idxsrc != null && idxsrc.equals("below")) {
            this.metaFromBelow = true;
        }
        if ((maxmeta = custparm.get("metacnt")) != null) {
            this.metaCnt = Integer.parseInt(maxmeta, 10);
            if (this.metaCnt > 16) {
                this.metaCnt = 16;
            }
        }
        this.buildPatches(rpf);
        return true;
    }

    private void buildPatches(RenderPatchFactory rpf) {
        this.meshes = new RenderPatch[this.metaCnt][];
        for (int txtid = 0; txtid < this.metaCnt; ++txtid) {
            RenderPatch VertX1Z0ToX0Z1 = rpf.getPatch(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.FLIP, txtid);
            RenderPatch VertX1Z0ToX0Z1_90 = rpf.getRotatedPatch(VertX1Z0ToX0Z1, 0, 90, 0, txtid);
            this.meshes[txtid] = new RenderPatch[]{VertX1Z0ToX0Z1, VertX1Z0ToX0Z1_90};
        }
    }

    public int getMaximumTextureCount() {
        return this.metaCnt;
    }

    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int idx = 0;
        idx = this.metaFromBelow ? ctx.getBlockTypeAt((int)0, (int)-1, (int)0).stateIndex : ctx.getBlockType().stateIndex;
        if (idx >= this.metaCnt) {
            idx = 0;
        }
        return this.meshes[idx];
    }
}

