/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.hdmap.TexturePackHDShader;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class TexturePackHDUnderwaterShader
extends TexturePackHDShader {
    private boolean hide_land = true;

    public TexturePackHDUnderwaterShader(DynmapCore core, ConfigurationNode configuration) {
        super(core, configuration);
        this.hide_land = configuration.getBoolean("hide-land", true);
    }

    @Override
    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        return new UnderwaterShaderState(mapiter, map, cache, scale);
    }

    class UnderwaterShaderState
    extends TexturePackHDShader.ShaderState {
        private boolean ready;
        private DynmapBlockState full_water;

        protected UnderwaterShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache, int scale) {
            super(mapiter, map, cache, scale);
            this.full_water = DynmapBlockState.getBaseStateByName((String)DynmapBlockState.WATER_BLOCK);
        }

        @Override
        public void reset(HDPerspectiveState ps) {
            super.reset(ps);
            this.ready = !TexturePackHDUnderwaterShader.this.hide_land;
        }

        @Override
        public boolean processBlock(HDPerspectiveState ps) {
            DynmapBlockState bs = ps.getBlockState();
            if (bs.isWater() || bs.isWaterlogged()) {
                this.ready = true;
                this.lastblk = this.full_water;
                this.lastblkhit = this.full_water;
            }
            return this.ready ? super.processBlock(ps) : false;
        }
    }
}

