/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.common.BiomeMap;
import org.dynmap.debug.Debug;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.hdmap.TexturePackLoader;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.MapIterator;

public class CTMTexturePack {
    private String[] ctpfiles;
    private TexturePackLoader tpl;
    private CTMProps[][] bytilelist;
    private CTMProps[][] bybaseblockstatelist;
    private BitSet mappedtiles;
    private BitSet mappedblocks;
    private String[] biomenames;
    private String vanillatextures;
    static final int BOTTOM_FACE = 0;
    static final int TOP_FACE = 1;
    static final int NORTH_FACE = 2;
    static final int SOUTH_FACE = 3;
    static final int WEST_FACE = 4;
    static final int EAST_FACE = 5;
    private static final int META_MASK = 65535;
    private static final int ORIENTATION_U_D = 0;
    private static final int ORIENTATION_E_W = 65536;
    private static final int ORIENTATION_N_S = 131072;
    private static final int ORIENTATION_E_W_2 = 196608;
    private static final int ORIENTATION_N_S_2 = 262144;
    private static final int[][] ROTATE_UV_MAP = new int[][]{{4, 5, 2, 3, 1, 0, 2, -2, 2, -2, 0, 0}, {2, 3, 1, 0, 4, 5, 0, 0, 0, 0, -2, 2}, {4, 5, 2, 3, 1, 0, 2, -2, -2, -2, 0, 0}, {2, 3, 1, 0, 4, 5, 0, 0, 0, 0, -2, -2}};
    private static final int[] GO_DOWN = new int[]{0, -1, 0};
    private static final int[] GO_UP = new int[]{0, 1, 0};
    private static final int[] GO_NORTH = new int[]{0, 0, -1};
    private static final int[] GO_SOUTH = new int[]{0, 0, 1};
    private static final int[] GO_WEST = new int[]{-1, 0, 0};
    private static final int[] GO_EAST = new int[]{1, 0, 0};
    protected static final int[][][] NEIGHBOR_OFFSET = new int[][][]{new int[][]{GO_WEST, CTMTexturePack.add(GO_WEST, GO_SOUTH), GO_SOUTH, CTMTexturePack.add(GO_EAST, GO_SOUTH), GO_EAST, CTMTexturePack.add(GO_EAST, GO_NORTH), GO_NORTH, CTMTexturePack.add(GO_WEST, GO_NORTH)}, new int[][]{GO_WEST, CTMTexturePack.add(GO_WEST, GO_SOUTH), GO_SOUTH, CTMTexturePack.add(GO_EAST, GO_SOUTH), GO_EAST, CTMTexturePack.add(GO_EAST, GO_NORTH), GO_NORTH, CTMTexturePack.add(GO_WEST, GO_NORTH)}, new int[][]{GO_EAST, CTMTexturePack.add(GO_EAST, GO_DOWN), GO_DOWN, CTMTexturePack.add(GO_WEST, GO_DOWN), GO_WEST, CTMTexturePack.add(GO_WEST, GO_UP), GO_UP, CTMTexturePack.add(GO_EAST, GO_UP)}, new int[][]{GO_WEST, CTMTexturePack.add(GO_WEST, GO_DOWN), GO_DOWN, CTMTexturePack.add(GO_EAST, GO_DOWN), GO_EAST, CTMTexturePack.add(GO_EAST, GO_UP), GO_UP, CTMTexturePack.add(GO_WEST, GO_UP)}, new int[][]{GO_NORTH, CTMTexturePack.add(GO_NORTH, GO_DOWN), GO_DOWN, CTMTexturePack.add(GO_SOUTH, GO_DOWN), GO_SOUTH, CTMTexturePack.add(GO_SOUTH, GO_UP), GO_UP, CTMTexturePack.add(GO_NORTH, GO_UP)}, new int[][]{GO_SOUTH, CTMTexturePack.add(GO_SOUTH, GO_DOWN), GO_DOWN, CTMTexturePack.add(GO_NORTH, GO_DOWN), GO_NORTH, CTMTexturePack.add(GO_NORTH, GO_UP), GO_UP, CTMTexturePack.add(GO_SOUTH, GO_UP)}};
    public static final int FACE_BOTTOM = 1;
    public static final int FACE_TOP = 2;
    public static final int FACE_NORTH = 4;
    public static final int FACE_SOUTH = 8;
    public static final int FACE_WEST = 16;
    public static final int FACE_EAST = 32;
    public static final int FACE_SIDES = 60;
    public static final int FACE_ALL = 63;
    public static final int FACE_UNKNOWN = 128;
    static final int REL_L = 0;
    static final int REL_DL = 1;
    static final int REL_D = 2;
    static final int REL_DR = 3;
    static final int REL_R = 4;
    static final int REL_UR = 5;
    static final int REL_U = 6;
    static final int REL_UL = 7;
    private static final int[] neighborMapCtm = new int[]{0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 36, 17, 36, 17, 24, 19, 24, 43, 36, 17, 36, 17, 24, 19, 24, 43, 16, 18, 16, 18, 6, 46, 6, 21, 16, 18, 16, 18, 28, 9, 28, 22, 36, 17, 36, 17, 24, 19, 24, 43, 36, 17, 36, 17, 24, 19, 24, 43, 37, 40, 37, 40, 30, 8, 30, 34, 37, 40, 37, 40, 25, 23, 25, 45, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 36, 39, 36, 39, 24, 41, 24, 27, 36, 39, 36, 39, 24, 41, 24, 27, 16, 42, 16, 42, 6, 20, 6, 10, 16, 42, 16, 42, 28, 35, 28, 44, 36, 39, 36, 39, 24, 41, 24, 27, 36, 39, 36, 39, 24, 41, 24, 27, 37, 38, 37, 38, 30, 11, 30, 32, 37, 38, 37, 38, 25, 33, 25, 26};
    private static final int[] neighborMapHorizontal = new int[]{3, 2, 0, 1};
    private static final int[] neighborMapVertical = new int[]{3, 2, 0, 1};
    private static final int[] neighborMapHorizontalVertical = new int[]{3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 4, 4, 5, 4, 4, 4, 4, 4, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3};
    private static final int[] neighborMapVerticalHorizontal = new int[]{3, 6, 3, 3, 3, 6, 3, 3, 4, 5, 4, 4, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final long P1 = 31024237183253L;
    private static final long P2 = 37916421967133L;
    private static final long P3 = 247193919306661L;
    private static final long P4 = 179199247101619L;
    private static final long MULTIPLIER = 25214903917L;
    private static final long ADDEND = 11L;

    public CTMTexturePack(TexturePackLoader tpl, TexturePack tp, DynmapCore core, boolean is_rp) {
        String ctmpath2;
        String ctmpath;
        ArrayList<String> files = new ArrayList<String>();
        this.tpl = tpl;
        this.biomenames = core.getBiomeNames();
        Set<String> ent = tpl.getEntries();
        if (is_rp) {
            ctmpath = "assets/minecraft/mcpatcher/ctm/";
            ctmpath2 = "assets/minecraft/optifine/ctm/";
            this.vanillatextures = "assets/%1$s/textures/blocks/%2$s";
        } else {
            ctmpath2 = "ctm/";
            ctmpath = "ctm/";
            this.vanillatextures = "textures/blocks/%2$s";
        }
        for (String name : ent) {
            if (!name.startsWith(ctmpath) && !name.startsWith(ctmpath2) || !name.endsWith(".properties")) continue;
            files.add(name);
        }
        this.ctpfiles = files.toArray(new String[files.size()]);
        Arrays.sort(this.ctpfiles);
        this.processFiles(core);
    }

    public boolean isValid() {
        return this.ctpfiles.length > 0;
    }

    private CTMProps[][] addToList(CTMProps[][] list, BitSet set, int[] keys, CTMProps p) {
        if (keys == null) {
            return list;
        }
        for (int k : keys) {
            if (k < 0) continue;
            if (k >= list.length) {
                list = (CTMProps[][])Arrays.copyOf(list, k + 1);
            }
            if (list[k] == null) {
                list[k] = new CTMProps[]{p};
            } else {
                int end = list[k].length;
                list[k] = Arrays.copyOf(list[k], end + 1);
                list[k][end] = p;
            }
            set.set(k);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFiles(DynmapCore core) {
        this.bytilelist = new CTMProps[256][];
        this.bybaseblockstatelist = new CTMProps[256][];
        this.mappedtiles = new BitSet();
        this.mappedblocks = new BitSet();
        String[] newbiomes = new String[this.biomenames.length];
        for (int i = 0; i < this.biomenames.length; ++i) {
            if (this.biomenames[i] != null) {
                newbiomes[i] = this.biomenames[i].toLowerCase().replace(" ", "");
                continue;
            }
            this.biomenames[i] = "";
        }
        this.biomenames = newbiomes;
        for (String f : this.ctpfiles) {
            InputStream is = null;
            try {
                is = this.tpl.openTPResource(f);
                Properties p = new Properties();
                if (is == null) continue;
                p.load(is);
                CTMProps ctmp = new CTMProps(p, f, this);
                if (!ctmp.isValid(f)) continue;
                ctmp.registerTiles(this.vanillatextures, f);
                this.bytilelist = this.addToList(this.bytilelist, this.mappedtiles, ctmp.matchTileIcons, ctmp);
                this.bybaseblockstatelist = this.addToList(this.bybaseblockstatelist, this.mappedblocks, ctmp.matchBlocks, ctmp);
            }
            catch (IOException iox) {
                Log.severe("Cannot process CTM file - " + f, iox);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public int mapTexture(MapIterator mapiter, DynmapBlockState blk, BlockStep laststep, int textid, HDShaderState ss) {
        Integer val;
        int newtext = -1;
        int gidx = blk.globalStateIndex;
        if (!(this.mappedblocks.get(gidx) || textid >= 0 && this.mappedtiles.get(textid))) {
            return textid;
        }
        DynLongHashMap cache = null;
        long idx = 0L;
        if (ss != null && (val = (Integer)(cache = ss.getCTMTextureCache()).get(idx = mapiter.getBlockKey() << 8 | (long)laststep.ordinal())) != null) {
            return val;
        }
        Context ctx = new Context(mapiter, blk, laststep, textid);
        if (textid >= 0 && textid < this.bytilelist.length) {
            newtext = this.mapTextureByList(this.bytilelist[textid], ctx);
        }
        if (newtext < 0 && gidx < this.bybaseblockstatelist.length) {
            newtext = this.mapTextureByList(this.bybaseblockstatelist[gidx], ctx);
        }
        if (newtext >= 0) {
            textid = newtext;
            ctx.textid = newtext;
            if (textid >= 0 && textid < this.bytilelist.length) {
                newtext = this.mapTextureByList(this.bytilelist[textid], ctx);
            }
            if (newtext >= 0) {
                textid = newtext;
                ctx.textid = newtext;
                if (textid >= 0 && textid < this.bytilelist.length) {
                    newtext = this.mapTextureByList(this.bytilelist[textid], ctx);
                }
                if (newtext >= 0) {
                    textid = newtext;
                    ctx.textid = newtext;
                    if (textid >= 0 && textid < this.bytilelist.length) {
                        newtext = this.mapTextureByList(this.bytilelist[textid], ctx);
                    }
                    if (newtext >= 0) {
                        textid = newtext;
                    }
                }
            }
        }
        if (cache != null) {
            cache.put(idx, textid);
        }
        return textid;
    }

    private int mapTextureByList(CTMProps[] lst, Context ctx) {
        if (lst == null) {
            return -1;
        }
        for (CTMProps p : lst) {
            int newtxt;
            if (p == null || ctx.isPrevMatch(p) || (newtxt = this.mapTextureByProp(p, ctx)) < 0) continue;
            ctx.setMatch(p);
            return newtxt;
        }
        return -1;
    }

    private int mapTextureByProp(CTMProps p, Context ctx) {
        int meta;
        int face;
        if (ctx.laststep != null && p.faces != 63 && (p.faces & 1 << (face = ctx.laststep.getFaceEntered())) == 0) {
            return -1;
        }
        if (p.metadata != -1 && (p.metadata & 1 << (meta = ctx.blk.stateIndex)) == 0) {
            return -1;
        }
        int y = ctx.mapiter.getY();
        if (y < p.minY || y > p.maxY) {
            return -1;
        }
        if (p.exclude(ctx.blk, ctx.laststep.getFaceEntered(), ctx)) {
            return -1;
        }
        if (p.biomes != null) {
            int ord = -1;
            BiomeMap bio = ctx.mapiter.getBiome();
            if (bio != null) {
                ord = bio.getBiomeID();
            }
            for (int i = 0; i < p.biomes.length; ++i) {
                if (p.biomes[i] != ord) continue;
                ord = -2;
                break;
            }
            if (ord != -2) {
                return -1;
            }
        }
        switch (p.method) {
            case CTM: {
                return this.mapTextureCtm(p, ctx);
            }
            case HORIZONTAL: {
                return this.mapTextureHorizontal(p, ctx);
            }
            case TOP: {
                return this.mapTextureTop(p, ctx);
            }
            case RANDOM: {
                return this.mapTextureRandom(p, ctx);
            }
            case REPEAT: {
                return this.mapTextureRepeat(p, ctx);
            }
            case VERTICAL: {
                return this.mapTextureVertical(p, ctx);
            }
            case HORIZONTAL_VERTICAL: {
                return this.mapTextureHorizontalVertical(p, ctx);
            }
            case VERTICAL_HORIZONTAL: {
                return this.mapTextureVerticalHorizontal(p, ctx);
            }
            case FIXED: {
                return this.mapTextureFixed(p, ctx);
            }
        }
        return -1;
    }

    private int mapTextureCtm(CTMProps p, Context ctx) {
        int face = ctx.face;
        int[][] offsets = NEIGHBOR_OFFSET[face];
        int neighborBits = 0;
        for (int bit = 0; bit < 8; ++bit) {
            if (!p.shouldConnect(ctx, offsets[bit])) continue;
            neighborBits |= 1 << bit;
        }
        return p.tileIcons[neighborMapCtm[neighborBits]];
    }

    private int mapTextureHorizontal(CTMProps p, Context ctx) {
        int face = ctx.face;
        if (face < 0) {
            face = 2;
        } else if (ctx.reorient(face) <= 1) {
            return -1;
        }
        int[][] offsets = NEIGHBOR_OFFSET[face];
        int neighborBits = 0;
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(0)])) {
            neighborBits |= 1;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(4)])) {
            neighborBits |= 2;
        }
        return p.tileIcons[neighborMapHorizontal[neighborBits]];
    }

    private int mapTextureTop(CTMProps p, Context ctx) {
        int face = ctx.face;
        if (face < 0) {
            face = 2;
        } else if (ctx.reorient(face) <= 1) {
            return -1;
        }
        int[][] offsets = NEIGHBOR_OFFSET[face];
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(6)])) {
            return p.tileIcons[0];
        }
        return -1;
    }

    private int mapTextureRandom(CTMProps p, Context ctx) {
        if (p.tileIcons.length == 1) {
            return p.tileIcons[0];
        }
        int face = ctx.face;
        if (face < 0) {
            face = 0;
        }
        face = ctx.reorient(face) / p.symmetry.shift;
        int index = 0;
        if (p.weights == null) {
            index = CTMTexturePack.getRandom(ctx.x, ctx.y, ctx.z, face, p.tileIcons.length);
        } else {
            int rnd = CTMTexturePack.getRandom(ctx.x, ctx.y, ctx.z, face, p.sumAllWeights);
            int[] w = p.sumWeights;
            for (int i = 0; i < w.length; ++i) {
                if (rnd >= w[i]) continue;
                index = i;
                break;
            }
        }
        return p.tileIcons[index];
    }

    private int mapTextureRepeat(CTMProps p, Context ctx) {
        int y;
        int x;
        int face = ctx.face;
        if (face < 0) {
            face = 0;
        }
        switch (face) {
            case 0: 
            case 1: {
                if (ctx.rotateTop) {
                    x = ctx.z;
                    y = ctx.x;
                    break;
                }
                x = ctx.x;
                y = ctx.z;
                break;
            }
            case 2: {
                x = -ctx.x - 1;
                y = -ctx.y;
                break;
            }
            case 3: {
                x = ctx.x;
                y = -ctx.y;
                break;
            }
            case 4: {
                x = ctx.z;
                y = -ctx.y;
                break;
            }
            case 5: {
                x = -ctx.z - 1;
                y = -ctx.y;
                break;
            }
            default: {
                return -1;
            }
        }
        if ((x %= p.width) < 0) {
            x += p.width;
        }
        if ((y %= p.height) < 0) {
            y += p.height;
        }
        return p.tileIcons[p.width * y + x];
    }

    private int mapTextureVertical(CTMProps p, Context ctx) {
        if (ctx.reorient(ctx.face) <= 1) {
            return -1;
        }
        int[][] offsets = NEIGHBOR_OFFSET[ctx.face];
        int neighborBits = 0;
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(2)])) {
            neighborBits |= 1;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(6)])) {
            neighborBits |= 2;
        }
        return p.tileIcons[neighborMapVertical[neighborBits]];
    }

    private int mapTextureHorizontalVertical(CTMProps p, Context ctx) {
        int idx;
        int face = ctx.face;
        if (face < 0) {
            face = 2;
        } else if (ctx.reorient(face) <= 1) {
            return -1;
        }
        int[][] offsets = NEIGHBOR_OFFSET[face];
        int neighborBits = 0;
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(0)])) {
            neighborBits |= 1;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(4)])) {
            neighborBits |= 2;
        }
        if ((idx = neighborMapHorizontal[neighborBits]) != 3) {
            return p.tileIcons[idx];
        }
        neighborBits = 0;
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(1)])) {
            neighborBits |= 1;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(2)])) {
            neighborBits |= 2;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(3)])) {
            neighborBits |= 4;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(5)])) {
            neighborBits |= 8;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(6)])) {
            neighborBits |= 0x10;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(7)])) {
            neighborBits |= 0x20;
        }
        return p.tileIcons[neighborMapHorizontalVertical[neighborBits]];
    }

    private int mapTextureVerticalHorizontal(CTMProps p, Context ctx) {
        int idx;
        if (ctx.reorient(ctx.face) <= 1) {
            return -1;
        }
        int[][] offsets = NEIGHBOR_OFFSET[ctx.face];
        int neighborBits = 0;
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(2)])) {
            neighborBits |= 1;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(6)])) {
            neighborBits |= 2;
        }
        if ((idx = neighborMapVertical[neighborBits]) != 3) {
            return p.tileIcons[idx];
        }
        neighborBits = 0;
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(0)])) {
            neighborBits |= 1;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(1)])) {
            neighborBits |= 2;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(3)])) {
            neighborBits |= 4;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(4)])) {
            neighborBits |= 8;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(5)])) {
            neighborBits |= 0x10;
        }
        if (p.shouldConnect(ctx, offsets[ctx.rotateUV(7)])) {
            neighborBits |= 0x20;
        }
        return p.tileIcons[neighborMapVerticalHorizontal[neighborBits]];
    }

    private int mapTextureFixed(CTMProps p, Context ctx) {
        return p.tileIcons[0];
    }

    private static final int getRandom(int x, int y, int z, int face, int modulus) {
        long n = 31024237183253L * (long)x * ((long)x + 11L) + 37916421967133L * (long)y * ((long)y + 11L) + 247193919306661L * (long)z * ((long)z + 11L) + 179199247101619L * (long)face * ((long)face + 11L);
        n = 25214903917L * (n + (long)x + (long)y + (long)z + (long)face) + 11L;
        return (int)((n >> 32 ^ n) & Integer.MAX_VALUE) % modulus;
    }

    private static int[] add(int[] a, int[] b) {
        if (a.length != b.length) {
            throw new RuntimeException("arrays to add are not same length");
        }
        int[] c = new int[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    private static int getOrientationFromMetadata(DynmapBlockState block) {
        int orientation = 0;
        int metadata = block.stateIndex;
        int newMeta = block.stateIndex;
        if (block.isLog()) {
            newMeta = metadata & 0xFFFFFFF3;
            switch (metadata & 0xC) {
                case 4: {
                    orientation = 65536;
                    break;
                }
                case 8: {
                    orientation = 131072;
                    break;
                }
            }
        } else if (block.blockName.equals(DynmapBlockState.QUARTZ_BLOCK)) {
            switch (metadata) {
                case 3: {
                    newMeta = 2;
                    orientation = 196608;
                    break;
                }
                case 4: {
                    newMeta = 2;
                    orientation = 262144;
                    break;
                }
            }
        }
        return orientation | newMeta;
    }

    private class Context {
        final MapIterator mapiter;
        final DynmapBlockState blk;
        final BlockStep laststep;
        final int face;
        int textid;
        final int orientation;
        final int[] reorient;
        final boolean rotateTop;
        final int rotateUV;
        final int x;
        final int y;
        final int z;
        CTMProps prev1;
        CTMProps prev2;
        CTMProps prev3;

        Context(MapIterator mapiter, DynmapBlockState blk, BlockStep laststep, int textid) {
            this.mapiter = mapiter;
            this.blk = blk;
            this.laststep = laststep;
            this.face = laststep.getFaceEntered();
            this.textid = textid;
            this.orientation = CTMTexturePack.getOrientationFromMetadata(blk);
            this.x = mapiter.getX();
            this.y = mapiter.getY();
            this.z = mapiter.getZ();
            switch (this.orientation & 0xFFFF0000) {
                case 65536: {
                    this.reorient = ROTATE_UV_MAP[0];
                    this.rotateUV = ROTATE_UV_MAP[0][this.face + 6];
                    this.rotateTop = true;
                    break;
                }
                case 131072: {
                    this.reorient = ROTATE_UV_MAP[1];
                    this.rotateUV = ROTATE_UV_MAP[1][this.face + 6];
                    this.rotateTop = false;
                    break;
                }
                case 196608: {
                    this.reorient = ROTATE_UV_MAP[2];
                    this.rotateUV = ROTATE_UV_MAP[2][this.face + 6];
                    this.rotateTop = true;
                    break;
                }
                case 262144: {
                    this.reorient = ROTATE_UV_MAP[3];
                    this.rotateUV = ROTATE_UV_MAP[3][this.face + 6];
                    this.rotateTop = false;
                    break;
                }
                default: {
                    this.reorient = null;
                    this.rotateUV = 0;
                    this.rotateTop = false;
                }
            }
        }

        final int reorient(int face) {
            if (face < 0 || face > 5 || this.reorient == null) {
                return face;
            }
            return this.reorient[face];
        }

        final int rotateUV(int neighbor) {
            return neighbor + this.rotateUV & 7;
        }

        final boolean isPrevMatch(CTMProps p) {
            return p == this.prev1 || p == this.prev2 || p == this.prev3;
        }

        final void setMatch(CTMProps p) {
            if (this.prev1 == null) {
                this.prev1 = p;
            } else if (this.prev2 == null) {
                this.prev2 = p;
            } else if (this.prev3 == null) {
                this.prev3 = p;
            }
        }

        final boolean checkMaterialMatch(DynmapBlockState neighbor) {
            if (this.blk == neighbor) {
                return true;
            }
            return this.blk.material.equals(neighbor.material);
        }
    }

    public static class CTMProps {
        public String name = null;
        public String basePath = null;
        public int[] matchBlocks = null;
        public String[] matchTiles = null;
        public CTMMethod method = CTMMethod.NONE;
        public String[] tiles = null;
        public CTMConnect connect = CTMConnect.NONE;
        public int faces = 63;
        public int metadata = -1;
        public int[] biomes = null;
        public int minY = 0;
        public int maxY = 1024;
        public int renderPass = 0;
        public boolean innerSeams = false;
        public int width = 0;
        public int height = 0;
        public int[] weights = null;
        public CTMSymmetry symmetry = CTMSymmetry.NONE;
        public int[] sumWeights = null;
        public int sumAllWeights = 0;
        public int[] matchTileIcons = null;
        public int[] tileIcons = null;

        private String[] tokenize(String v, String split) {
            StringTokenizer tok = new StringTokenizer(v, split);
            ArrayList<String> rslt = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                rslt.add(tok.nextToken());
            }
            return rslt.toArray(new String[rslt.size()]);
        }

        private void getFaces(Properties p) {
            String[] tok;
            String v = p.getProperty("faces", "all").trim().toLowerCase();
            this.faces = 0;
            for (String t : tok = v.split("\\s+")) {
                if (t.equals("bottom")) {
                    this.faces |= 1;
                    continue;
                }
                if (t.equals("top")) {
                    this.faces |= 2;
                    continue;
                }
                if (t.equals("north")) {
                    this.faces |= 4;
                    continue;
                }
                if (t.equals("south")) {
                    this.faces |= 8;
                    continue;
                }
                if (t.equals("east")) {
                    this.faces |= 0x20;
                    continue;
                }
                if (t.equals("west")) {
                    this.faces |= 0x10;
                    continue;
                }
                if (t.equals("sides") || t.equals("side")) {
                    this.faces |= 0x3C;
                    continue;
                }
                if (t.equals("all")) {
                    this.faces |= 0x3F;
                    continue;
                }
                Log.info("Unknown face in CTM file: " + t);
                this.faces |= 0x80;
            }
        }

        private int parseInt(Properties p, String fld, int def) {
            String v = p.getProperty(fld);
            if (v == null) {
                return def;
            }
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException nfx) {
                Log.info("Bad integer: " + v);
                return def;
            }
        }

        private int[] parseInts(Properties p, String fld) {
            String v = p.getProperty(fld);
            if (v == null) {
                return null;
            }
            String[] tok = this.tokenize(v, ", ");
            ArrayList<Integer> rslt = new ArrayList<Integer>();
            for (String t : tok) {
                String[] vtok = this.tokenize(t = t.trim(), "-");
                if (vtok.length == 1) {
                    try {
                        rslt.add(Integer.parseInt(vtok[0]));
                    }
                    catch (NumberFormatException nfx) {
                        Log.info("Bad integer in list: " + vtok[0]);
                    }
                    continue;
                }
                if (vtok.length != 2) continue;
                try {
                    int low = Integer.parseInt(vtok[0]);
                    int high = Integer.parseInt(vtok[1]);
                    for (int i = low; i <= high; ++i) {
                        rslt.add(i);
                    }
                }
                catch (NumberFormatException nfx) {
                    Log.info("Bad integer in range: " + t);
                }
            }
            int[] out = new int[rslt.size()];
            for (int i = 0; i < out.length; ++i) {
                out[i] = (Integer)rslt.get(i);
            }
            return out;
        }

        private int parseRenderPass(Properties p, String fld, int def) {
            String v = p.getProperty(fld);
            if (v == null) {
                return def;
            }
            if (v.equalsIgnoreCase("overlay")) {
                return 3;
            }
            if (v.equalsIgnoreCase("translucent")) {
                return 1;
            }
            if (v.equalsIgnoreCase("backface")) {
                return 2;
            }
            if (v.equalsIgnoreCase("solid")) {
                return 0;
            }
            if (v.equalsIgnoreCase("cutout_mipped")) {
                return 0;
            }
            if (v.equalsIgnoreCase("cutout")) {
                return 0;
            }
            return this.parseInt(p, fld, def);
        }

        private void addBlockStateToIDSet(Set<Integer> list, DynmapBlockState bs) {
            list.add(bs.globalStateIndex);
        }

        private void addBaseBlockStateToIDSet(Set<Integer> list, DynmapBlockState bs) {
            bs = bs.baseState;
            for (int i = 0; i < bs.getStateCount(); ++i) {
                list.add(bs.getStateByIndex((int)i).globalStateIndex);
            }
        }

        private int[] getIDList(Properties properties, String key, String type) {
            Matcher m;
            HashSet<Integer> list = new HashSet<Integer>();
            String property = properties.getProperty(key, "");
            for (String token : property.split("\\s+")) {
                DynmapBlockState bs;
                if (token.equals("")) continue;
                if (token.matches("\\d+")) {
                    try {
                        int id = Integer.parseInt(token);
                        bs = DynmapBlockState.getStateByLegacyBlockID((int)id);
                        if (bs == null) {
                            Log.info("Unknown Legacy block ID in CTM: " + token);
                            continue;
                        }
                        this.addBaseBlockStateToIDSet(list, bs);
                    }
                    catch (NumberFormatException e) {
                        Log.info("Bad ID token: " + token);
                    }
                    continue;
                }
                if (token.indexOf(58) < 0) {
                    token = "minecraft:" + token;
                }
                String[] toks = token.split(":");
                boolean addbase = false;
                if (toks.length > 2) {
                    bs = DynmapBlockState.getStateByNameAndState((String)(toks[0] + ":" + toks[1]), (String)toks[2]);
                } else {
                    bs = DynmapBlockState.getBaseStateByName((String)token);
                    addbase = true;
                }
                if (bs == DynmapBlockState.AIR) {
                    Log.info("Unknown block ID in CTM: " + token);
                    continue;
                }
                if (addbase) {
                    this.addBaseBlockStateToIDSet(list, bs);
                    continue;
                }
                this.addBlockStateToIDSet(list, bs);
            }
            if (list.isEmpty() && (m = Pattern.compile(type + "(\\d+)").matcher(this.name)).find()) {
                try {
                    int id = Integer.parseInt(m.group(1));
                    DynmapBlockState bs = DynmapBlockState.getStateByLegacyBlockID((int)id);
                    if (bs == null) {
                        Log.info("Unknown Legacy block ID from filename in CTM: " + this.name);
                    } else {
                        this.addBlockStateToIDSet(list, bs);
                    }
                }
                catch (NumberFormatException e) {
                    Log.info("Bad block number: " + this.name);
                }
            }
            if (list.isEmpty()) {
                return null;
            }
            int[] rslt = new int[list.size()];
            int i = 0;
            for (Integer v : list) {
                rslt[i] = v;
                ++i;
            }
            return rslt;
        }

        private void getMethod(Properties p) {
            String v = p.getProperty("method", "default").trim().toLowerCase();
            if (v.equals("ctm") || v.equals("glass") || v.equals("default")) {
                this.method = CTMMethod.CTM;
            } else if (v.equals("horizontal") || v.equals("bookshelf")) {
                this.method = CTMMethod.HORIZONTAL;
            } else if (v.equals("vertical")) {
                this.method = CTMMethod.VERTICAL;
            } else if (v.equals("vertical+horizontal") || v.equals("v+h")) {
                this.method = CTMMethod.VERTICAL_HORIZONTAL;
            } else if (v.equals("horizontal+vertical") || v.equals("h+v")) {
                this.method = CTMMethod.HORIZONTAL_VERTICAL;
            } else if (v.equals("top") || v.equals("sandstone")) {
                this.method = CTMMethod.TOP;
            } else if (v.equals("random")) {
                this.method = CTMMethod.RANDOM;
            } else if (v.equals("repeat") || v.equals("pattern")) {
                this.method = CTMMethod.REPEAT;
            } else if (v.equals("fixed") || v.equals("static")) {
                this.method = CTMMethod.FIXED;
            } else {
                Log.info("Invalid CTM Method: " + v);
                this.method = CTMMethod.NONE;
            }
        }

        private void getConnect(Properties p) {
            String v = p.getProperty("connect", "none").toLowerCase();
            if (v.equals("none")) {
                this.connect = CTMConnect.NONE;
            } else if (v.equals("block")) {
                this.connect = CTMConnect.BLOCK;
            } else if (v.equals("tile")) {
                this.connect = CTMConnect.TILE;
            } else if (v.equals("material")) {
                this.connect = CTMConnect.MATERIAL;
            } else {
                Log.info("Invalid CTM Connect: " + v);
                this.connect = CTMConnect.UNKNOWN;
            }
        }

        private void getBiomes(Properties p, CTMTexturePack tp) {
            String v = p.getProperty("biomes", "").trim().toLowerCase();
            if (!v.equals("")) {
                ArrayList<Integer> ids = new ArrayList<Integer>();
                String[] biomenames = tp.biomenames;
                for (String s : v.split("\\s+")) {
                    for (int i = 0; i < biomenames.length; ++i) {
                        if (!s.equals(biomenames[i])) continue;
                        ids.add(i);
                        s = null;
                        break;
                    }
                    if (s == null) continue;
                    Debug.debug("CTM Biome not matched: " + s);
                }
                this.biomes = new int[ids.size()];
                for (int i = 0; i < this.biomes.length; ++i) {
                    this.biomes[i] = (Integer)ids.get(i);
                }
            } else {
                this.biomes = null;
            }
        }

        private void getSymmetry(Properties p) {
            String v = p.getProperty("symmetry", "none").trim().toLowerCase();
            if (v.equals("none")) {
                this.symmetry = CTMSymmetry.NONE;
            } else if (v.equals("opposite")) {
                this.symmetry = CTMSymmetry.OPPOSITE;
            } else if (v.equals("all")) {
                this.symmetry = CTMSymmetry.ALL;
            } else {
                Log.info("invalid CTM symmetry: " + v);
                this.symmetry = CTMSymmetry.NONE;
            }
        }

        private void getMatchTiles(Properties p) {
            String v = p.getProperty("matchTiles");
            if (v == null) {
                this.matchTiles = null;
            } else {
                String[] tok = this.tokenize(v.toLowerCase(), " ");
                for (int i = 0; i < tok.length; ++i) {
                    String t = tok[i];
                    if (t.endsWith(".png")) {
                        t = t.substring(0, t.length() - 4);
                    }
                    if (t.startsWith("/ctm/")) {
                        t = t.substring(1);
                    }
                    tok[i] = t;
                }
                this.matchTiles = tok;
            }
        }

        private String[] parseTileNames(String v) {
            String[] tok;
            if (v == null) {
                return null;
            }
            if ((v = v.trim().toLowerCase()).length() == 0) {
                return null;
            }
            ArrayList<String> lst = new ArrayList<String>();
            for (String t : tok = this.tokenize(v, " ,")) {
                if (t.indexOf(45) >= 0) {
                    String[] vtok = this.tokenize(t, "-");
                    if (vtok.length != 2) continue;
                    try {
                        int low = Integer.parseInt(vtok[0]);
                        int high = Integer.parseInt(vtok[1]);
                        for (int i = low; i <= high; ++i) {
                            lst.add(String.valueOf(i));
                        }
                        continue;
                    }
                    catch (NumberFormatException nfx) {
                        Log.info("Bad tile name range: " + t);
                        continue;
                    }
                }
                lst.add(t);
            }
            String[] out = new String[lst.size()];
            for (int i = 0; i < out.length; ++i) {
                String vv = (String)lst.get(i);
                if (!vv.startsWith("/") && !vv.startsWith("assets/")) {
                    vv = this.basePath + "/" + vv;
                }
                if (vv.endsWith(".png")) {
                    vv = vv.substring(0, vv.length() - 4);
                }
                if (vv.startsWith("/ctm/")) {
                    vv = vv.substring(1);
                }
                out[i] = vv;
            }
            return out;
        }

        private void getMatchBlocks() {
            this.matchBlocks = null;
            if (this.name.startsWith("block")) {
                DynmapBlockState bs;
                int id = -1;
                for (int i = 5; i < this.name.length(); ++i) {
                    char c = this.name.charAt(i);
                    if (!Character.isDigit(c)) continue;
                    id = id < 0 ? c - 48 : 10 * id + (c - 48);
                }
                if (id >= 0 && (bs = DynmapBlockState.getStateByLegacyBlockID((int)id)) != null) {
                    this.matchBlocks = new int[]{bs.globalStateIndex};
                }
            }
        }

        public CTMProps(Properties p, String fname, CTMTexturePack tp) {
            int last_dot;
            int last_sep = fname.lastIndexOf(47);
            this.name = fname;
            this.basePath = "";
            if (last_sep > 0) {
                this.name = fname.substring(last_sep + 1);
                this.basePath = fname.substring(0, last_sep);
            }
            if ((last_dot = this.name.lastIndexOf(46)) > 0) {
                this.name = this.name.substring(0, last_dot);
            }
            this.matchBlocks = this.getIDList(p, "matchBlocks", "block");
            this.getMatchTiles(p);
            this.getMethod(p);
            this.tiles = this.parseTileNames(p.getProperty("tiles"));
            this.getConnect(p);
            this.getFaces(p);
            this.getSymmetry(p);
            this.getBiomes(p, tp);
            int[] md = this.parseInts(p, "metadata");
            if (md != null) {
                this.metadata = 0;
                for (int m : md) {
                    this.metadata |= 1 << m;
                }
            }
            this.minY = this.parseInt(p, "minHeight", -1);
            this.maxY = this.parseInt(p, "maxHeight", Integer.MAX_VALUE);
            this.renderPass = this.parseRenderPass(p, "renderPass", -1);
            this.width = this.parseInt(p, "width", -1);
            this.height = this.parseInt(p, "height", -1);
            this.weights = this.parseInts(p, "weights");
            String v = p.getProperty("innerSeams");
            if (v != null) {
                this.innerSeams = v.equalsIgnoreCase("true");
            }
        }

        public boolean isValid(String fname) {
            if (this.name == null || this.name.length() == 0 || this.basePath == null) {
                return false;
            }
            if (this.matchBlocks == null) {
                this.getMatchBlocks();
            }
            if (this.matchBlocks == null && this.matchTiles == null) {
                this.matchTiles = new String[]{this.name};
            }
            if (this.method == CTMMethod.NONE) {
                Log.info("No matching method: " + fname);
                return false;
            }
            if (this.connect == CTMConnect.NONE) {
                this.connect = this.matchBlocks != null ? CTMConnect.BLOCK : (this.matchTiles != null ? CTMConnect.TILE : CTMConnect.UNKNOWN);
            }
            if (this.connect == CTMConnect.UNKNOWN) {
                Log.info("Bad connect: " + fname);
                return false;
            }
            if ((this.faces & 0x80) > 0) {
                Log.info("Invalid face: " + fname);
                return false;
            }
            switch (this.method) {
                case CTM: {
                    return this.isValidCtm(fname);
                }
                case HORIZONTAL: {
                    return this.isValidHorizontal(fname);
                }
                case TOP: {
                    return this.isValidTop(fname);
                }
                case RANDOM: {
                    return this.isValidRandom(fname);
                }
                case REPEAT: {
                    return this.isValidRepeat(fname);
                }
                case VERTICAL: {
                    return this.isValidVertical(fname);
                }
                case HORIZONTAL_VERTICAL: {
                    return this.isValidHorizontalVertical(fname);
                }
                case VERTICAL_HORIZONTAL: {
                    return this.isValidVerticalHorizontal(fname);
                }
                case FIXED: {
                    return this.isValidFixed(fname);
                }
            }
            Log.info("Unknoen method: " + fname);
            return false;
        }

        private boolean isValidCtm(String fname) {
            if (this.tiles == null) {
                this.tiles = this.parseTileNames("0-46");
            }
            if (this.tiles == null || this.tiles.length < 47) {
                Log.info("Not enough tiles for CTF method: " + fname);
                return false;
            }
            return true;
        }

        public final boolean exclude(DynmapBlockState block, int face, Context ctx) {
            int altMetadata;
            if ((this.faces & 1 << ctx.reorient(face)) == 0) {
                return true;
            }
            return this.metadata != -1 && block.stateIndex >= 0 && block.stateIndex < 32 && (this.metadata & (1 << block.stateIndex | 1 << (altMetadata = CTMTexturePack.getOrientationFromMetadata(block) & 0xFFFF))) == 0;
        }

        private boolean isValidHorizontal(String fname) {
            if (this.tiles == null) {
                this.tiles = this.parseTileNames("0-3");
            }
            if (this.tiles == null || this.tiles.length != 4) {
                Log.info("Incorrect tile count for Horizonal method: " + fname);
                return false;
            }
            return true;
        }

        private boolean isValidVertical(String fname) {
            if (this.tiles == null) {
                this.tiles = this.parseTileNames("0-3");
            }
            if (this.tiles == null || this.tiles.length != 4) {
                Log.info("Incorrect tile count for Vertical method: " + fname);
                return false;
            }
            return true;
        }

        private boolean isValidHorizontalVertical(String fname) {
            if (this.tiles == null) {
                this.tiles = this.parseTileNames("0-6");
            }
            if (this.tiles == null || this.tiles.length != 7) {
                Log.info("Incorrect tile count for Horizontal+Vertical method: " + fname);
                return false;
            }
            return true;
        }

        private boolean isValidVerticalHorizontal(String fname) {
            if (this.tiles == null) {
                this.tiles = this.parseTileNames("0-6");
            }
            if (this.tiles == null || this.tiles.length != 7) {
                Log.info("Incorrect tile count for Vertical+Horizontal method: " + fname);
                return false;
            }
            return true;
        }

        private boolean isValidRandom(String fname) {
            if (this.tiles != null && this.tiles.length > 0) {
                if (this.weights != null && this.weights.length != this.tiles.length) {
                    this.weights = null;
                }
                if (this.weights != null) {
                    this.sumWeights = new int[this.weights.length];
                    int sum = 0;
                    for (int i = 0; i < this.weights.length; ++i) {
                        this.sumWeights[i] = sum += this.weights[i];
                    }
                    this.sumAllWeights = sum;
                }
                return true;
            }
            Log.info("Tiles required for Random method: " + fname);
            return false;
        }

        private boolean isValidRepeat(String fname) {
            if (this.tiles == null) {
                Log.info("Tiles required for Repeat method: " + fname);
                return false;
            }
            if (this.width > 0 && this.width <= 16 && this.height > 0 && this.height <= 16) {
                if (this.tiles.length != this.width * this.height) {
                    Log.info("Number of tiles does not match repeat size: " + fname);
                    return false;
                }
                return true;
            }
            Log.info("Invalid dimensions for Repeat method: " + fname);
            return false;
        }

        private boolean isValidFixed(String fname) {
            if (this.tiles == null) {
                this.tiles = this.parseTileNames("0");
            }
            if (this.tiles == null || this.tiles.length != 1) {
                Log.info("Required 1 tile for Fixed method: " + fname);
                return false;
            }
            return true;
        }

        private boolean isValidTop(String fname) {
            if (this.tiles == null) {
                this.tiles = this.parseTileNames("0");
            }
            if (this.tiles == null || this.tiles.length != 1) {
                Log.info("Requires 1 tile for Top method: " + fname);
                return false;
            }
            return true;
        }

        private void registerTiles(String deftxtpath, String propname) {
            String proppath = propname.substring(0, propname.lastIndexOf(47));
            if (this.matchTiles != null) {
                this.matchTileIcons = this.registerTiles(this.matchTiles, deftxtpath, proppath);
            }
            if (this.tiles != null) {
                this.tileIcons = this.registerTiles(this.tiles, proppath, proppath);
            }
        }

        private int[] registerTiles(String[] tilenames, String deftxtpath, String proppath) {
            if (tilenames == null) {
                return null;
            }
            int[] rslt = new int[tilenames.length];
            for (int i = 0; i < tilenames.length; ++i) {
                String tn;
                String ftn = tn = tilenames[i];
                String modname = "minecraft";
                int colonindex = ftn.indexOf(58);
                if (colonindex > 0) {
                    modname = ftn.substring(0, colonindex);
                    ftn = ftn.substring(colonindex + 1);
                }
                if (ftn.startsWith("./")) {
                    ftn = proppath + "/" + ftn.substring(2);
                } else if (!ftn.startsWith("assets/")) {
                    ftn = colonindex > 0 ? String.format("assets/%s/textures/%s", modname, ftn) : String.format(deftxtpath, modname, ftn);
                }
                if (!ftn.endsWith(".png")) {
                    ftn = ftn + ".png";
                }
                if (modname.equals("minecraft")) {
                    modname = null;
                }
                int fid = TexturePack.findOrAddDynamicTileFile(ftn, modname, 1, 1, TexturePack.TileFileFormat.GRID, new String[0]);
                rslt[i] = TexturePack.findOrAddDynamicTile(fid, 0);
            }
            return rslt;
        }

        final boolean shouldConnect(Context ctx, int[] offset) {
            DynmapBlockState neighbor = ctx.mapiter.getBlockTypeAt(offset[0], offset[1], offset[2]);
            if (neighbor.isAir()) {
                return false;
            }
            if (this.exclude(neighbor, ctx.face, ctx)) {
                return false;
            }
            int neighborOrientation = CTMTexturePack.getOrientationFromMetadata(neighbor);
            if ((ctx.orientation & 0xFFFF0000) != (neighborOrientation & 0xFFFF0000)) {
                return false;
            }
            if (this.metadata != -1 && (ctx.orientation & 0xFFFF) != (neighborOrientation & 0xFFFF)) {
                return false;
            }
            switch (this.connect) {
                case BLOCK: {
                    return neighbor.baseState == ctx.blk.baseState;
                }
                case TILE: {
                    int txt = TexturePack.getTextureIDAt(ctx.mapiter, neighbor, ctx.laststep);
                    return txt == ctx.textid;
                }
                case MATERIAL: {
                    return ctx.checkMaterialMatch(neighbor);
                }
            }
            return false;
        }
    }

    public static enum CTMSymmetry {
        NONE(1),
        OPPOSITE(2),
        ALL(6);

        public final int shift;

        private CTMSymmetry(int sh) {
            this.shift = sh;
        }
    }

    public static enum CTMConnect {
        NONE,
        BLOCK,
        TILE,
        MATERIAL,
        UNKNOWN;

    }

    public static enum CTMMethod {
        NONE,
        CTM,
        HORIZONTAL,
        TOP,
        RANDOM,
        REPEAT,
        VERTICAL,
        FIXED,
        HORIZONTAL_VERTICAL,
        VERTICAL_HORIZONTAL;

    }
}

