/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.dynmap;

import org.dynmap.common.BiomeMap;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.MapIterator;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.dynmap.WPObjectDynmapWorld;

class WPObjectMapIterator
implements MapIterator {
    private final WPObjectDynmapWorld object;
    private int x;
    private int y;
    private int height;
    private BlockStep lastStep;
    private DynmapBlockState material;

    WPObjectMapIterator(WPObjectDynmapWorld object, int x, int y, int z) {
        this.object = object;
        this.initialize(x, y, z);
    }

    public void initialize(int x, int y, int z) {
        this.x = x;
        this.y = z;
        this.height = y;
        this.updateMaterial();
    }

    public int getBlockSkyLight() {
        return 15;
    }

    public int getBlockEmittedLight() {
        return this.object.getLightLevel(this.x, this.y, this.height);
    }

    public int getBlockLight(BlockStep blockStep) {
        return this.getBlockLight(blockStep.xoff, blockStep.yoff, blockStep.zoff);
    }

    public int getBlockLight(int xoff, int yoff, int zoff) {
        return this.object.getLightLevel(this.x + xoff, this.y + zoff, this.height + yoff) * 256 + 15;
    }

    public BiomeMap getBiome() {
        return BiomeMap.NULL;
    }

    public int getSmoothGrassColorMultiplier(int[] colormap) {
        return colormap[0];
    }

    public int getSmoothFoliageColorMultiplier(int[] colormap) {
        return colormap[0];
    }

    public int getSmoothWaterColorMultiplier() {
        return Material.WATER.colour;
    }

    public int getSmoothWaterColorMultiplier(int[] colormap) {
        return colormap[0];
    }

    public int getSmoothColorMultiplier(int[] colormap, int[] swampcolormap) {
        return colormap[0];
    }

    public void stepPosition(BlockStep step) {
        this.x += step.xoff;
        this.y += step.zoff;
        this.height += step.yoff;
        this.lastStep = step;
        this.updateMaterial();
    }

    public void unstepPosition(BlockStep step) {
        this.stepPosition(step.opposite());
    }

    public BlockStep unstepPosition() {
        this.unstepPosition(this.lastStep);
        return this.lastStep.opposite();
    }

    public void setY(int y) {
        if (y > this.height) {
            this.lastStep = BlockStep.Y_PLUS;
        } else if (y < this.height) {
            this.lastStep = BlockStep.Y_MINUS;
        }
        this.height = y;
        this.updateMaterial();
    }

    public DynmapBlockState getBlockTypeAt(BlockStep blockStep) {
        return this.getBlockTypeAt(blockStep.xoff, blockStep.yoff, blockStep.zoff);
    }

    public BlockStep getLastStep() {
        return this.lastStep;
    }

    public int getWorldHeight() {
        return this.object.bounds.getHeight();
    }

    public long getBlockKey() {
        return (long)(this.x - this.object.xOffset) * (long)this.object.bounds.getLength() * (long)this.object.bounds.getHeight() + (long)(this.y - this.object.yOffset) * (long)this.object.bounds.getHeight() + (long)this.height;
    }

    public long getInhabitedTicks() {
        return 0L;
    }

    public RenderPatchFactory getPatchFactory() {
        return HDBlockModels.getPatchDefinitionFactory();
    }

    public DynmapBlockState getBlockType() {
        return this.material;
    }

    public Object getBlockTileEntityField(String fieldId) {
        return null;
    }

    public DynmapBlockState getBlockTypeAt(int xoff, int yoff, int zoff) {
        int offsetX = this.x + xoff;
        int offsetY = this.y + zoff;
        int offsetHeight = this.height + yoff;
        if (this.object.bounds.contains(offsetX, offsetY, offsetHeight)) {
            return this.object.blockStates[offsetX - this.object.xOffset][offsetY - this.object.yOffset][offsetHeight];
        }
        return DynmapBlockState.AIR;
    }

    public Object getBlockTileEntityFieldAt(String fieldId, int xoff, int yoff, int zoff) {
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.height;
    }

    public int getZ() {
        return this.y;
    }

    private void updateMaterial() {
        this.material = this.object.bounds.contains(this.x, this.y, this.height) ? this.object.blockStates[this.x - this.object.xOffset][this.y - this.object.yOffset][this.height] : DynmapBlockState.AIR;
    }
}

