/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.dynmap;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDMapTile;
import org.pepsoft.util.Box;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.swing.TileListener;
import org.pepsoft.util.swing.TileProvider;
import org.pepsoft.worldpainter.dynmap.DynmapRenderer;

public class DynmapTileProvider
implements TileProvider {
    private final DynmapWorld dmWorld;
    private int zoom;
    private boolean caves;
    private volatile double inclination = 60.0;
    private volatile double azimuth = 135.0;
    private volatile int scale = 16;
    private volatile HDMap map;
    private volatile ThreadLocal<DynmapRenderer> rendererRef;

    public DynmapTileProvider(DynmapWorld dmWorld) {
        this.dmWorld = dmWorld;
        this.refreshMap();
    }

    public int getTileSize() {
        return 128;
    }

    public boolean isTilePresent(int x, int y) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintTile(Image image, int x, int y, int dx, int dy) {
        HDMapTile tile = new HDMapTile(this.dmWorld, this.map.getPerspective(), x, -y, 0, 0);
        BufferedImage tileImage = this.rendererRef.get().render(this.dmWorld.getChunkCache(null), tile);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        try {
            g2.drawImage((Image)tileImage, dx, dy, null);
        }
        finally {
            g2.dispose();
        }
        return true;
    }

    public int getTilePriority(int x, int y) {
        return 0;
    }

    public Rectangle getExtent() {
        return null;
    }

    public void addTileListener(TileListener tileListener) {
    }

    public void removeTileListener(TileListener tileListener) {
    }

    public boolean isZoomSupported() {
        return true;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        if (zoom != this.zoom) {
            this.zoom = zoom;
            this.scale = MathUtils.pow((int)2, (int)(4 + zoom));
            this.refreshRenderers();
        }
    }

    private void refreshRenderers() {
        this.rendererRef = new ThreadLocal<DynmapRenderer>(){

            @Override
            protected DynmapRenderer initialValue() {
                return new DynmapRenderer(DynmapTileProvider.this.map.getPerspective(), DynmapTileProvider.this.map, DynmapTileProvider.this.scale, DynmapTileProvider.this.inclination, DynmapTileProvider.this.azimuth);
            }
        };
    }

    private void refreshMap() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("name", "WorldPainter");
        config.put("image-format", "png");
        if (this.caves) {
            config.put("shader", "caves");
        }
        ConfigurationNode configNode = new ConfigurationNode(config);
        this.map = new HDMap(DynmapCore.INSTANCE, configNode);
        this.refreshRenderers();
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(double azimuth) {
        if (azimuth != this.azimuth) {
            if (azimuth == 360.0) {
                azimuth = 0.0;
            } else if (azimuth < 0.0 || azimuth >= 360.0) {
                throw new IllegalArgumentException("Azimuth must be >= 0 and < 360");
            }
            this.azimuth = azimuth;
            this.refreshRenderers();
        }
    }

    public double getInclination() {
        return this.inclination;
    }

    public void setInclination(double inclination) {
        if (inclination != this.inclination) {
            if (inclination < 30.0 || inclination > 90.0) {
                throw new IllegalArgumentException("Inclination must be >= 30 and <= 90");
            }
            this.inclination = inclination;
            this.refreshRenderers();
        }
    }

    public boolean isCaves() {
        return this.caves;
    }

    public void setCaves(boolean caves) {
        if (caves != this.caves) {
            this.caves = caves;
            this.refreshMap();
        }
    }

    public Rectangle getBounds(Box volume) {
        Rectangle rect = this.rendererRef.get().getTileCoords(volume.getX1(), volume.getZ1(), volume.getY1(), volume.getX2() + 1, volume.getZ2() + 1, volume.getY2() + 1);
        rect.setLocation(rect.x, -rect.y - rect.height);
        return rect;
    }
}

