/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.dynmap;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dynmap.renderer.DynmapBlockState;
import org.pepsoft.minecraft.Material;

public class DynmapBlockStateHelper {
    private static final Map<Material.Identity, DynmapBlockState> IDENTITY_TO_BLOCK_STATE;

    public static void initialise() {
    }

    static DynmapBlockState getDynmapBlockState(Material material) {
        return IDENTITY_TO_BLOCK_STATE.get(material.identity);
    }

    private static <K, V> Map<K, V> copyAndAdd(Map<K, V> map, K key, V value) {
        HashMap<K, V> copy = new HashMap<K, V>(map);
        copy.put(key, value);
        return copy;
    }

    private static void setFlags(DynmapBlockState blockState, Material material) {
        if (material.isNamedOneOf("minecraft:air", "minecraft:cave_air")) {
            blockState.setAir();
        }
        if (material.sustainsLeaves) {
            blockState.setLog();
        }
        if (material.leafBlock) {
            blockState.setLeaves();
        }
        if (material.solid) {
            blockState.setSolid();
        }
        if (material.containsWater()) {
            blockState.setWaterlogged();
        }
    }

    static {
        HashMap<Material.Identity, DynmapBlockState> identityToBlockState = new HashMap<Material.Identity, DynmapBlockState>();
        HashMap<String, Set> blockStatesByName = new HashMap<String, Set>();
        HashMap<String, DynmapBlockState> blockStatesBasesByName = new HashMap<String, DynmapBlockState>();
        for (String simpleName : Material.getAllSimpleNamesForNamespace((String)"minecraft")) {
            Material prototype = Material.getPrototype((String)("minecraft:" + simpleName));
            if (prototype.propertyDescriptors == null || prototype.propertyDescriptors.isEmpty()) {
                DynmapBlockState blockState = new DynmapBlockState(null, 0, prototype.name, null, prototype.simpleName, prototype.blockType);
                DynmapBlockStateHelper.setFlags(blockState, prototype);
                blockStatesBasesByName.put(prototype.name, blockState);
                blockStatesByName.computeIfAbsent(prototype.name, k -> new HashSet()).add(blockState);
                identityToBlockState.put(prototype.identity, blockState);
                continue;
            }
            ArrayList permutations = new ArrayList();
            permutations.add(new HashMap());
            for (Map.Entry entry : prototype.propertyDescriptors.entrySet()) {
                String string = (String)entry.getKey();
                Material.PropertyDescriptor descriptor = (Material.PropertyDescriptor)entry.getValue();
                ArrayList<Map> newPermutations = new ArrayList<Map>(permutations.size() * 5);
                for (Map map : permutations) {
                    switch (descriptor.type) {
                        case BOOLEAN: {
                            newPermutations.add(DynmapBlockStateHelper.copyAndAdd(map, string, "true"));
                            newPermutations.add(DynmapBlockStateHelper.copyAndAdd(map, string, "false"));
                            break;
                        }
                        case ENUM: {
                            for (String value : descriptor.enumValues) {
                                newPermutations.add(DynmapBlockStateHelper.copyAndAdd(map, string, value));
                            }
                            break;
                        }
                        case INTEGER: {
                            for (int value = descriptor.minValue; value <= descriptor.maxValue; ++value) {
                                newPermutations.add(DynmapBlockStateHelper.copyAndAdd(map, string, Integer.toString(value)));
                            }
                            break;
                        }
                    }
                    newPermutations.add(map);
                }
                permutations = newPermutations;
            }
            HashSet<Map> permutationsWithMissingProperties = new HashSet<Map>(permutations.size());
            Iterator i = permutations.iterator();
            while (i.hasNext()) {
                Map map = (Map)i.next();
                if (map.size() >= prototype.propertyDescriptors.size()) continue;
                i.remove();
                permutationsWithMissingProperties.add(map);
            }
            permutations.addAll(permutationsWithMissingProperties);
            for (Map map : permutations) {
                DynmapBlockState blockState;
                Material material = Material.get((String)prototype.name, (Map)map);
                if (identityToBlockState.containsKey(material.identity)) continue;
                String stateName = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
                if (blockStatesByName.containsKey(material.name)) {
                    blockState = new DynmapBlockState((DynmapBlockState)blockStatesBasesByName.get(material.name), ((Set)blockStatesByName.get(material.name)).size(), material.name, stateName, material.simpleName, material.blockType);
                } else {
                    blockState = new DynmapBlockState(null, 0, material.name, stateName, material.simpleName, material.blockType);
                    blockStatesBasesByName.put(material.name, blockState);
                }
                DynmapBlockStateHelper.setFlags(blockState, material);
                blockStatesByName.computeIfAbsent(material.name, k -> new HashSet()).add(blockState);
                identityToBlockState.put(material.identity, blockState);
            }
        }
        IDENTITY_TO_BLOCK_STATE = ImmutableMap.copyOf(identityToBlockState);
        DynmapBlockState.finalizeBlockStates();
    }
}

