/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.io.File;
import java.util.List;
import org.pepsoft.util.MacUtilsJava8;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;

public abstract class MacUtils {
    private static final MacUtils IMPL;

    protected MacUtils() {
    }

    public static boolean installQuitHandler(QuitHandler quitHandler) {
        return IMPL.doInstallQuitHandler(quitHandler);
    }

    public static boolean installAboutHandler(AboutHandler aboutHandler) {
        return IMPL.doInstallAboutHandler(aboutHandler);
    }

    public static boolean installOpenFilesHandler(OpenFilesHandler openFilesHandler) {
        return IMPL.doInstallOpenFilesHandler(openFilesHandler);
    }

    public static boolean installPreferencesHandler(PreferencesHandler preferencesHandler) {
        return IMPL.doInstallPreferencesHandler(preferencesHandler);
    }

    protected abstract boolean doInstallQuitHandler(QuitHandler var1);

    protected abstract boolean doInstallAboutHandler(AboutHandler var1);

    protected abstract boolean doInstallOpenFilesHandler(OpenFilesHandler var1);

    protected abstract boolean doInstallPreferencesHandler(PreferencesHandler var1);

    static {
        if (SystemUtils.JAVA_VERSION.isAtLeast(SystemUtils.JAVA_9)) {
            try {
                IMPL = (MacUtils)Class.forName("org.pepsoft.util.MacUtilsJava9").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new MDCCapturingRuntimeException(e.getClass().getSimpleName() + " while loading Mac OS X support for Java 9", (Throwable)e);
            }
        } else {
            IMPL = new MacUtilsJava8();
        }
    }

    public static interface PreferencesHandler {
        public void preferencesRequested();
    }

    public static interface OpenFilesHandler {
        public void filesOpened(List<File> var1);
    }

    public static interface AboutHandler {
        public void aboutRequested();
    }

    public static interface QuitHandler {
        public boolean quitRequested();
    }
}

